# IBM_PROLOG_BEGIN_TAG 
# This is an automatically generated prolog. 
#  
#  
#  
# Licensed Materials - Property of IBM 
#  
# (C) COPYRIGHT International Business Machines Corp. 2001,2007 
# All Rights Reserved 
#  
# US Government Users Restricted Rights - Use, duplication or 
# disclosure restricted by GSA ADP Schedule Contract with IBM Corp. 
#  
# IBM_PROLOG_END_TAG 
package CRM_cli_rc;
#"@(#)91   1.4   src/rsct/rm/ConfigRM/cli/pm/CRM_cli_rc.pm.perl, configrmcli, rsct_relgh, relghs001a 4/22/02 16:02:09"
######################################################################
#                                                                    #
# Package: CRM_cli_rc.pm                                             #
#                                                                    #
# Description:                                                       #
#   This package contains return codes used for the Configuration    #
#   Resource Manager (ConfigRM) CLI commands. Each return code can   #
#   be referenced separately, or as a whole using the 'return_codes' #
#   EXPORT_TAG.                                                      #
#                                                                    #
# Examples:                                                          #
#   use ConfigRM_cli_rc qw(CRM_CLI_BAD_OPERAND CRM_CLI_BAD_FLAG)     #
#   - exports only 2 of the return codes for use in the calling      #
#     program.                                                       #
#                                                                    #
#   use ConfigRM_cli_rc qw(:return_codes)                            #
#   - exports all return codes included in the EXPORT_TAG            #
#     return_codes. (the ':' is needed to access the tag)            #
#                                                                    #
#--------------------------------------------------------------------#
#                                                                    #
# Inputs:                                                            #
#                                                                    #
# Outputs:                                                           #
#                                                                    #
# External References:                                               #
#   Perl Modules:   constant, Exporter                               #
#                                                                    #
# Tab Settings:                                                      #
#   4 and tabs should be expanded to spaces before saving this file. #
#   in vi:  (:set ts=4  and   :%!expand -4)                          #
#                                                                    #
# Change Activity:                                                   #
#   010806 JAC 75435: Initial design and write.                      #
#   010827 JAC 75436  Update for phase 2.                            #
#   020422 JAC 82248  Changes for renaming commands.                 #
######################################################################

use Exporter ();
use constant;
@ISA = qw(Exporter);
@EXPORT_OK = qw(    CRM_CLI_SUCCESS
                    CRM_CLI_RMC_ERROR
                    CRM_CLI_ERROR
                    CRM_CLI_BAD_FLAG
                    CRM_CLI_BAD_OPERAND
                    CRM_CLI_USER_ERROR
                    CRM_CLI_NOT_FOUND
                    CRM_CLI_COMG_NOT_FOUND
);


#--------------------------------------------------------------------#
# EXPORT TAGS is used to refer to the return codes as a group        #
#--------------------------------------------------------------------#

%EXPORT_TAGS = (
return_codes => [qw(CRM_CLI_SUCCESS
                    CRM_CLI_RMC_ERROR
                    CRM_CLI_ERROR
                    CRM_CLI_BAD_FLAG
                    CRM_CLI_BAD_OPERAND
                    CRM_CLI_USER_ERROR
                    CRM_CLI_NOT_FOUND
                    CRM_CLI_COMG_NOT_FOUND
)]
); # end %EXPORT_TAGS


#--------------------------------------------------------------------#
# Return Code Definitions (constants)                                #
#--------------------------------------------------------------------#

use constant CRM_CLI_SUCCESS           => 0;
use constant CRM_CLI_RMC_ERROR         => 1;
use constant CRM_CLI_ERROR             => 2;
use constant CRM_CLI_BAD_FLAG          => 3;
use constant CRM_CLI_BAD_OPERAND       => 4;
use constant CRM_CLI_USER_ERROR        => 5;
use constant CRM_CLI_NOT_FOUND         => 6;
use constant CRM_CLI_COMG_NOT_FOUND    => 6;
