/* IBM_PROLOG_BEGIN_TAG                                                   */
/* This is an automatically generated prolog.                             */
/*                                                                        */
/*                                                                        */
/*                                                                        */
/* Licensed Materials - Property of IBM                                   */
/*                                                                        */
/* (C) COPYRIGHT International Business Machines Corp. 1998,2007          */
/* All Rights Reserved                                                    */
/*                                                                        */
/* US Government Users Restricted Rights - Use, duplication or            */
/* disclosure restricted by GSA ADP Schedule Contract with IBM Corp.      */
/*                                                                        */
/* IBM_PROLOG_END_TAG                                                     */
#ifndef _SAMPLE_SUBSCRIPTION_H
#define _SAMPLE_SUBSCRIPTION_H

static char *Sample_Subscription_sccsid = "@(#)43   1.5   src/rsct/pgs/samples/Sample_Subscription.h, gssamples, rsct_relgh, relghs001a 5/14/01 09:43:46";

#if !defined(_HAGSD_COPYRIGHT_H)
#define _HAGSD_COPYRIGHT_H
static char copyright[] = "Licensed Materials - Property of IBM\n\
(C) COPYRIGHT International Business Machines Corp. 1998,2001.\n\
All Rights Reserved.\n\
US Government Users Restricted Rights - Use, duplication or \n\
disclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n";
#endif


/*********************************************************************/
/*
 * Name:  Sample_Subscription.h
 *
 * This class represents a "subscription" to a group with Group
 * Services.  It takes as input the targeted group name and other
 * control info, sets up the subscription, and deals with the
 * notifications we receive from GS.
 *
 * See Sample_Subscribe.C for more info.
 */
 /*********************************************************************/

#include "Sample_Subscribe.h"           // Common declarations.
#include "ha_gs.h"

class   Subscription {
  public:

    // For what information can we subscribe?
    enum    SubscriptionData    {
        kNothing    = 0x00,
        kState      = HA_GS_SUBSCRIBE_STATE,
        kJoins      = HA_GS_SUBSCRIBE_DELTA_JOINS,
        kLeaves     = HA_GS_SUBSCRIBE_DELTA_LEAVES,
        kMembership = HA_GS_SUBSCRIBE_MEMBERSHIP,
        kAllMembership = kJoins|kLeaves|kMembership,
        kAll        = kState|kJoins|kLeaves|kMembership
        };

    // Type of display for right now.
    enum    providerDisplayType {
        kRaw,
        kOrdered,
        kTable
        };

    enum    specialDisplayType {
        kShort       = 0x00,
        kDeath       = HA_GS_ADAPTER_DEATH_ARRAY,
        kCurrAlias   = HA_GS_CURRENT_ADAPTER_ALIAS_ARRAY,
        kChangeAlias = HA_GS_CHANGING_ADAPTER_ALIAS_ARRAY,
        kAllSpecial  = kDeath|kCurrAlias|kChangeAlias
        };

    Subscription(char  *_targetGroup,
                 int    _subControl,
                 int    _persistent,
                 providerDisplayType    _displayType,
                 specialDisplayType     _displaySpecial,
                 ha_gs_subscription_cb_t _callback);

    virtual    ~Subscription(void);

  public:
    // Provide way to verify that control is valid.
    static      int     Valid(int _control)
       {return((0 == (~kAll & _control)) &&
               (((kAllMembership | _control)) ||
                 (kState & _control)));}

    // Is subscription currently valid?
    int         Good(void) {return(HA_GS_OK == status);}
    int         Dissolved(void) {return(0 != (HA_GS_SUBSCRIPTION_DISSOLVED & subSummary));}
    int         Bad(void)  {return(HA_GS_OK != status);}
    ha_gs_rc_t  ErrorCode(void) {return(status);}
    int         Persistent(void) {return(1 == persistence);}

    // Deal with a notification.
    int         HandleNotification(const ha_gs_subscription_notification_t *_note);

    // A delayed error.  Bad news.
    ha_gs_rc_t  HandleDelayedError(const ha_gs_delayed_error_notification_t *_note);

  private:
    // Look for the specified type of special data block being included
    // in the notification.
    ha_gs_special_block_t *FindSpecial(const unsigned int _which,
                                       ha_gs_special_data_t *_special);

  private:
    // Print out the results of the notification.
    int         PrintProviders(ha_gs_membership_t *_membership,
                               ha_gs_special_block_t *_aliasBlock = NULL,
                               ha_gs_special_block_t *_deathBlock = NULL);
    void        PrintRaw(int _count, ha_gs_provider_t *_provider,
                         ha_gs_special_block_t *_aliasBlock,
                         ha_gs_special_block_t *_deathBlock);
    void        PrintOrdered(int _count, ha_gs_provider_t *_provider,
                             ha_gs_special_block_t *_aliasBlock,
                             ha_gs_special_block_t *_deathBlock);
    void        PrintTabular(int _count, ha_gs_provider_t *_provider,
                             ha_gs_special_block_t *_aliasBlock,
                             ha_gs_special_block_t *_deathBlock);
    void        PrintState(ha_gs_state_value_t *_state);

    int         VerifySpecialEntries(const int _count,
                                     ha_gs_special_block_t **_aliasBlock,
                                     ha_gs_special_block_t **_deathBlock,
                                     int *_IPentries,
                                     int *_IPlength,
                                     unsigned int **_IPaddr,
                                     int *_deathEntries,
                                     int *_deathLength,
                                     ha_gs_adapter_death_t **_death);

    // Notification type info.
    static      void    WriteSubType(const ha_gs_subscription_type_t _subType);
    static      void    WriteSpecialControl(const ha_gs_subscription_type_t _subType,
                                            const ha_gs_special_data_t *_special);
    static      void    WriteSpecialFlag(const unsigned int _flag);

  private:
    // Data members.
    int         subControl; // Data for which we subscribed.
    char       *groupName;  // Subscribed-to group.
    int         persistence; // Stay connected after first notification?
    providerDisplayType     displayType; // How to display.
    specialDisplayType      displaySpecial; // How to display special data.

    ha_gs_proposal_info_t       info;   // The subscription proposal block.
    ha_gs_subscription_ctrl_t   subCtl; // Subscription control.
    ha_gs_token_t               subToken; // Token returned by subscribe() call.

    ha_gs_rc_t                  status; // Status of subcription request.
    ha_gs_subscription_type_t   subSummary; // Summary code from last notification.

    ha_gs_subscription_cb_t     subCallback; // Callback function for good notifications.
};

#endif /* _SAMPLE_SUBSCRIPTION_H */
