# IBM_PROLOG_BEGIN_TAG 
# This is an automatically generated prolog. 
#  
#  
#  
# Licensed Materials - Property of IBM 
#  
# (C) COPYRIGHT International Business Machines Corp. 1999,2007 
# All Rights Reserved 
#  
# US Government Users Restricted Rights - Use, duplication or 
# disclosure restricted by GSA ADP Schedule Contract with IBM Corp. 
#  
# IBM_PROLOG_END_TAG 
package MC_cli_rc;
#"@(#)48   1.9   src/rsct/rmc/cli/pm/MC_cli_rc.pm.perl, rmccli, rsct_relgh, relghs001a 11/1/05 12:56:04"
######################################################################
#                                                                    #
# Package: MC_cli_rc.pm                                              #
#                                                                    #
# Description:                                                       #
#   This package contains return codes used for the PERL             #
#   Resource Monitoring and Control (RMC) CLI commands. Each return  #
#   code can be referenced separately, or as a whole using the       #
#   'return_codes' EXPORT_TAG.                                       #
#                                                                    #
# Examples:                                                          #
#   use MC_cli_rc qw(MC_CLI_BAD_OPERAND MC_CLI_BAD_FLAG)             #
#   - exports only 2 of the return codes for use in the calling      #
#     program.                                                       #
#                                                                    #
#   use MC_cli_rc qw(:return_codes)                                  #
#   - exports all return codes included in the EXPORT_TAG            #
#     return_codes. (the ':' is needed to access the tag)            #
#                                                                    #
#--------------------------------------------------------------------#
#                                                                    #
# Inputs:                                                            #
#                                                                    #
# Outputs:                                                           #
#                                                                    #
# External References:                                               #
#   Perl Modules:   constant, Exporter                               #
#                                                                    #
# Tab Settings:                                                      #
#   4 and tabs should be expanded to spaces before saving this file. #
#   in vi:  (:set ts=4  and   :%!expand -4)                          #
#                                                                    #
# Change Activity:                                                   #
#   990528 SAB 48419: Initial design and write.                      #
#   010406 SAB 71892: Support new MC_CLI_NO_RSRC_FOUND return code.  #
#   031020 JAC 100623: Check for certain distros (hopefully temp).   #
#   031022 JAC 100769: Move the code block added above.              #
#   031103 JAC 100977: Change the KERNEL level.                      #
#   041124 JAC 115377: Change the KERNEL level again for SLES9.      #
#   050722 JAC 126161: Change the KERNEL level again for RHEL4U1.    #
#   051101 JAC 130467: Make KERNEL level change for all RHEL4 updates#
######################################################################

use Exporter ();
use constant;
@ISA = qw(Exporter);
@EXPORT_OK = qw(    MC_CLI_SUCCESS
                    MC_CLI_RMC_ERROR
                    MC_CLI_ERROR
                    MC_CLI_BAD_FLAG
                    MC_CLI_BAD_OPERAND
                    MC_CLI_USER_ERROR
                    MC_CLI_NO_RSRC_FOUND
);


# set LD_ASSUME_KERNEL if running on RHEL3 or RHEL4 Updates
my $rh_relfile = "/etc/redhat-release";
my $rh_vers = '^Red Hat Enterprise Linux .* release 3 (.*)$';
my $rh_vers4Us = '^Red Hat Enterprise Linux .* release 4 (.* Update .*)$';
if (-f $rh_relfile){
   `/bin/grep \"$rh_vers\" $rh_relfile > /dev/null 2>&1`;
   my $rhexit = $? >> 8;
   if ($rhexit == 0){
      $ENV{'LD_ASSUME_KERNEL'}="2.4.19";
   }
   # set LD_ASSUME_KERNEL if running on RHEL4U1
   else {
      `/bin/grep \"$rh_vers4Us\" $rh_relfile > /dev/null 2>&1`;
      $rhexit = $? >> 8;
      if ($rhexit == 0){
         $ENV{'LD_ASSUME_KERNEL'}="2.4.19";
      }
   }
}

# set LD_ASSUME_KERNEL if running on SLES9
my $sl_relfile = "/etc/SuSE-release";
my $sl_vers = '^SUSE LINUX Enterprise Server 9 (.*)$';
if (-f $sl_relfile){
   `/bin/grep \"$sl_vers\" $sl_relfile > /dev/null 2>&1`;
   my $slexit = $? >> 8;
   if ($slexit == 0){
      $ENV{'LD_ASSUME_KERNEL'}="2.4.19";
   }
}

#--------------------------------------------------------------------#
# EXPORT TAGS is used to refer to the return codes as a group        #
#--------------------------------------------------------------------#

%EXPORT_TAGS = (
return_codes => [qw(MC_CLI_SUCCESS
                    MC_CLI_RMC_ERROR
                    MC_CLI_ERROR
                    MC_CLI_BAD_FLAG
                    MC_CLI_BAD_OPERAND
                    MC_CLI_USER_ERROR
                    MC_CLI_NO_RSRC_FOUND
)]
); # end %EXPORT_TAGS


#--------------------------------------------------------------------#
# Return Code Definitions (constants)                                #
#--------------------------------------------------------------------#

use constant MC_CLI_SUCCESS         => 0;
use constant MC_CLI_RMC_ERROR       => 1;
use constant MC_CLI_ERROR           => 2;
use constant MC_CLI_BAD_FLAG        => 3;
use constant MC_CLI_BAD_OPERAND     => 4;
use constant MC_CLI_USER_ERROR      => 5;
use constant MC_CLI_NO_RSRC_FOUND   => 6;
