# IBM_PROLOG_BEGIN_TAG 
# This is an automatically generated prolog. 
#  
#  
#  
# Licensed Materials - Property of IBM 
#  
# (C) COPYRIGHT International Business Machines Corp. 2001,2007 
# All Rights Reserved 
#  
# US Government Users Restricted Rights - Use, duplication or 
# disclosure restricted by GSA ADP Schedule Contract with IBM Corp. 
#  
# IBM_PROLOG_END_TAG 
package CT_cli_data_type_utils;
# "@(#)86   1.3   src/rsct/cli/pm/CT_cli_data_type_utils.pm.perl, ctcli, rsct_relgh, relghs001a 8/3/01 11:41:35"
######################################################################
#                                                                    #
# Package: CT_cli_data_type_utils.pm                                 #
#                                                                    #
# Description:                                                       #
#   This package contains CT data type common utilities for the      #
#   PERL RSCT Commands.                                              #
#                                                                    #
# Subroutines Available:                                             #
#   data_type_to_string - converts ct_data_type_t to writable string.#
#     CT_UINT32  becomes "uint32"                                    #
#                                                                    #
#   string_to_data_type - converts writable string to ct_data_type_t.#
#     Must be a ct_data_type_t format.                               #
#     "int32" becomes CT_INT32                                       #
#                                                                    #
#   data_type_is_simple - checks to see if the data type passed in   #
#     is one of the valid simple types in ct_data_type_t.            #
#     Returns 1 on success. (Boolean subroutine)                     #
#                                                                    #
#   data_type_is_array  - checks to see if the data type passed in   #
#     is one of the valid array types in ct_data_type_t.             #
#     Returns 1 on success.  (Boolean subroutine)                    #
#                                                                    #
#   data_type_is_numeric - checks to see if the data type passed in  #
#     is one of 32 or 64 bit signed/unsigned integer or floating     #
#     point types defined in ct_data_type_t. Returns 1 on success,   #
#     0 on failure. (Boolean subroutine).                            #
#                                                                    #
#   array_data_type_to_simple - returns corresponding simple type of #
#     array ct_data_type_t type passed in. If the type passed to the #
#     function is not recognized as an array type, the function      #
#     simply returns type passed to it.                              #
#                                                                    #
# Examples:                                                          #
#   $display_str = data_type_to_string(CT_UINT32);                   #
#   $num = string_to_data_type("uint32");                            #
#   if (data_type_is_simple($data_type)) {  ...                      #
#   $is_array = data_type_is_array($data_type);                      #
#   if (data_type_is_numeric($data_type)) { ...                      #
#   $scalar_type = array_data_type_to_simple($array_type);           #
#--------------------------------------------------------------------#
# Inputs:                                                            #
#   None.                                                            #
#                                                                    #
# Outputs:                                                           #
#   None.                                                            #
#                                                                    #
# External References:                                               #
#   CT::CT qw(:ct_data_type_t);                                      #
#                                                                    #
# Tab Settings:                                                      #
#   4 and tabs should be expanded to spaces before saving this file. #
#   in vi:  (:set ts=4  and   :%!expand -4)                          #
#                                                                    #
# Change Activity:                                                   #
#   010202 SAB 71115: Split from CT_cli_utils.pm.                    #
#   010806 YSK 75111: Added: data_type_is_numeric,                   #
#                            array_data_type_to_simple.              #
######################################################################

use Exporter ();
@ISA = qw(Exporter);
@EXPORT_OK = qw(
    data_type_to_string
    string_to_data_type
    data_type_is_simple
    data_type_is_array
    data_type_is_numeric
    array_data_type_to_simple
);

use locale;
use lib "/usr/sbin/rsct/pm";
use CT::CT qw(:ct_data_type_t);

#--------------------------------------------------------------------#
# Global Variables                                                   #
#--------------------------------------------------------------------#

#--------------------------------------------------------------------#
# ct_data_type_t enums defined in CT::CT.pm                          #
#--------------------------------------------------------------------#
%data_types_to_string = (
    eval(CT_UNKNOWN)                => "UNKNOWN",
    eval(CT_NONE)                   => "ct_none",
    eval(CT_INT32)                  => "int32",
    eval(CT_UINT32)                 => "uint32",
    eval(CT_INT64)                  => "int64",
    eval(CT_UINT64)                 => "uint64",
    eval(CT_FLOAT32)                => "float32",
    eval(CT_FLOAT64)                => "float64",
    eval(CT_CHAR_PTR)               => "char_ptr",
    eval(CT_BINARY_PTR)             => "binary_ptr",
    eval(CT_RSRC_HANDLE_PTR)        => "rsrc_handle_ptr",
    eval(CT_SD_PTR)                 => "sd_ptr",
    eval(CT_SBS_PTR)                => "sbs_ptr",
    eval(CT_INT32_ARRAY)            => "int32_array",
    eval(CT_UINT32_ARRAY)           => "uint32_array",
    eval(CT_INT64_ARRAY)            => "int64_array",
    eval(CT_UINT64_ARRAY)           => "uint64_array",
    eval(CT_FLOAT32_ARRAY)          => "float32_array",
    eval(CT_FLOAT64_ARRAY)          => "float64_array",
    eval(CT_CHAR_PTR_ARRAY)         => "char_ptr_array",
    eval(CT_BINARY_PTR_ARRAY)       => "binary_ptr_array",
    eval(CT_RSRC_HANDLE_PTR_ARRAY)  => "rsrc_handle_ptr_array",
    eval(CT_SD_PTR_ARRAY)           => "sd_ptr_array"
);

%data_types_to_enum = (
    CT_UNKNOWN                      =>eval(CT_UNKNOWN),
    CT_NONE                         =>eval(CT_NONE),
    NONE                            =>eval(CT_NONE),
    CT_INT32                        =>eval(CT_INT32),
    INT32                           =>eval(CT_INT32),
    I32                             =>eval(CT_INT32),
    I                               =>eval(CT_INT32),
    CT_UINT32                       =>eval(CT_UINT32),
    UINT32                          =>eval(CT_UINT32),
    UI32                            =>eval(CT_UINT32),
    UI                              =>eval(CT_UINT32),
    CT_INT64                        =>eval(CT_INT64),
    INT64                           =>eval(CT_INT64),
    I64                             =>eval(CT_INT64),
    L                               =>eval(CT_INT64),
    CT_UINT64                       =>eval(CT_UINT64),
    UINT64                          =>eval(CT_UINT64),
    UI64                            =>eval(CT_UINT64),
    UL                              =>eval(CT_UINT64),
    CT_FLOAT32                      =>eval(CT_FLOAT32),
    FLOAT32                         =>eval(CT_FLOAT32),
    F32                             =>eval(CT_FLOAT32),
    F                               =>eval(CT_FLOAT32),
    CT_FLOAT64                      =>eval(CT_FLOAT64),
    FLOAT64                         =>eval(CT_FLOAT64),
    F64                             =>eval(CT_FLOAT64),
    D                               =>eval(CT_FLOAT64),
    CT_CHAR_PTR                     =>eval(CT_CHAR_PTR),
    CHAR_PTR                        =>eval(CT_CHAR_PTR),
    STRING                          =>eval(CT_CHAR_PTR),
    STR                             =>eval(CT_CHAR_PTR),
    S                               =>eval(CT_CHAR_PTR),
    CT_BINARY_PTR                   =>eval(CT_BINARY_PTR),
    BINARY_PTR                      =>eval(CT_BINARY_PTR),
    BINARY                          =>eval(CT_BINARY_PTR),
    BIN                             =>eval(CT_BINARY_PTR),
    B                               =>eval(CT_BINARY_PTR),
    CT_RSRC_HANDLE_PTR              =>eval(CT_RSRC_HANDLE_PTR),
    RSRC_HANDLE_PTR                 =>eval(CT_RSRC_HANDLE_PTR),
    RSRC_HANDLE                     =>eval(CT_RSRC_HANDLE_PTR),
    RH                              =>eval(CT_RSRC_HANDLE_PTR),
    CT_SD_PTR                       =>eval(CT_SD_PTR),
    SD_PTR                          =>eval(CT_SD_PTR),
    CT_SBS_PTR                      =>eval(CT_SBS_PTR),
    SBS_PTR                         =>eval(CT_SBS_PTR),
    CT_INT32_ARRAY                  =>eval(CT_INT32_ARRAY),
    INT32_ARRAY                     =>eval(CT_INT32_ARRAY),
    I32_ARRAY                       =>eval(CT_INT32_ARRAY),
    I_ARRAY                         =>eval(CT_INT32_ARRAY),
    CT_UINT32_ARRAY                 =>eval(CT_UINT32_ARRAY),
    UINT32_ARRAY                    =>eval(CT_UINT32_ARRAY),
    UI32_ARRAY                      =>eval(CT_UINT32_ARRAY),
    UI_ARRAY                        =>eval(CT_UINT32_ARRAY),
    CT_INT64_ARRAY                  =>eval(CT_INT64_ARRAY),
    INT64_ARRAY                     =>eval(CT_INT64_ARRAY),
    I64_ARRAY                       =>eval(CT_INT64_ARRAY),
    L_ARRAY                         =>eval(CT_INT64_ARRAY),
    eval(CT_UINT64_ARRAY)           =>eval(CT_UINT64_ARRAY),
    UINT64_ARRAY                    =>eval(CT_UINT64_ARRAY),
    UI64_ARRAY                      =>eval(CT_UINT64_ARRAY),
    UL_ARRAY                        =>eval(CT_UINT64_ARRAY),
    CT_FLOAT32_ARRAY                =>eval(CT_FLOAT32_ARRAY),
    FLOAT32_ARRAY                   =>eval(CT_FLOAT32_ARRAY),
    F32_ARRAY                       =>eval(CT_FLOAT32_ARRAY),
    F_ARRAY                         =>eval(CT_FLOAT32_ARRAY),
    CT_FLOAT64_ARRAY                =>eval(CT_FLOAT64_ARRAY),
    FLOAT64_ARRAY                   =>eval(CT_FLOAT64_ARRAY),
    F64_ARRAY                       =>eval(CT_FLOAT64_ARRAY),
    D_ARRAY                         =>eval(CT_FLOAT64_ARRAY),
    CT_CHAR_PTR_ARRAY               =>eval(CT_CHAR_PTR_ARRAY),
    CHAR_PTR_ARRAY                  =>eval(CT_CHAR_PTR_ARRAY),
    STRING_ARRAY                    =>eval(CT_CHAR_PTR_ARRAY),
    S_ARRAY                         =>eval(CT_CHAR_PTR_ARRAY),
    CT_BINARY_PTR_ARRAY             =>eval(CT_BINARY_PTR_ARRAY),
    BINARY_PTR_ARRAY                =>eval(CT_BINARY_PTR_ARRAY),
    CT_RSRC_HANDLE_PTR_ARRAY        =>eval(CT_RSRC_HANDLE_PTR_ARRAY),
    RSRC_HANDLE_PTR_ARRAY           =>eval(CT_RSRC_HANDLE_PTR_ARRAY),
    CT_SD_PTR_ARRAY                 =>eval(CT_SD_PTR_ARRAY),
    SD_PTR_ARRAY                    =>eval(CT_SD_PTR_ARRAY)
);

#--------------------------------------------------------------------#
# Exported Subroutines (with @EXPORT_OK, -> on demand).              #
#--------------------------------------------------------------------#


#--------------------------------------------------------------------#
# data_type_to_string:  convert the ct_data_type enum its string     #
#   equivalent.                                                      #
#                                                                    #
# Paramaters:                                                        #
#   $number     in   Value to be converted using the                 #
#                    $data_types_to_string hash.                     #
# Returns:                                                           #
#   $string          String representation of the ct_data_type_t.    #
#                    For example if 1 is passed in the string        #
#                                                                    #
# Global Variables:                                                  #
#   $main::Trace5 in  Print trace messages if turned on.             #
#--------------------------------------------------------------------#
sub data_type_to_string
{
my $number = shift;

$main::Trace5 && 
    print STDERR "Entered CT_cli_utils::data_type_to_string \n";

return($data_types_to_string{$number});

}   # end data_type_to_string


#--------------------------------------------------------------------#
# string_to_data_type:  convert the ct_data_type string to its       #
#   equivalent numeric representation.                               #
#                                                                    #
# Paramaters:                                                        #
#   $string     in   See the hash string_data_types for what strings #
#                    This function will convert to uppercase before  #
#                    searching the hash.                             #
# Returns:                                                           #
#   $number          Numeric representation of the ct_data_type_t    #
#                    For example if "ct_int32_t" is passed in,       #
#                      1 is passed out.                              #
#                    If the string is unrecognized 0 is passed out   #
#                    which represents CT_UNKNOWN.                    #
#                                                                    #
# Global Variables:                                                  #
#   $main::Trace5 in  Print trace messages if turned on.             #
#--------------------------------------------------------------------#
sub string_to_data_type
{
my $string = shift;
$main::Trace5 && 
    print STDERR "Entered CT_cli_utils::string_to_data_type \n";

# Convert the input string to upper case

$main::Trace5 && print STDERR "pre_converted string: $string\n";
my $converted_string = uc($string); 

$main::Trace5 && 
    print STDERR "converted string: $converted_string\n";

my $data_type = $data_types_to_enum{$converted_string};
if (!defined $data_type) {
    $data_type = 0;             # CT_UNKNOWN
}

return($data_type);

}   # end string_to_data_type


#--------------------------------------------------------------------#
# data_type_is_simple:                                               #
#   Check a data type to see if it is one of the                     #
#   simple types defined in ct_data_type_t.                          #
#                                                                    #
# Paramaters:                                                        #
#   $type       in  Int value to be evaluated against the simple     #
#                   values of the ct_data_type_t enum.               #
#   NOTE: When the enum changes, these subroutines will have to be   #
#         edited to reflect the change.                              #
#                                                                    #
# Returns:                                                           #
#   0 - if the value is a simple data type                           #
#   1 - if the value is not a simple data type                       #
#                                                                    #
# Global Variables:                                                  #
#   $main::Trace5  in  Print trace messages if turned on.            #
#--------------------------------------------------------------------#
sub data_type_is_simple 
{
my $type = shift;

$main::Trace5 &&
print STDERR "Entered CT_cli_utils::data_type_is_simple($type)\n";

# Yes, this is a glorified switch statement

return 1 if $type == CT_UNKNOWN;
return 1 if $type == CT_NONE;
return 1 if $type == CT_INT32;
return 1 if $type == CT_UINT32;
return 1 if $type == CT_INT64;
return 1 if $type == CT_UINT64;
return 1 if $type == CT_FLOAT32;
return 1 if $type == CT_FLOAT64;
return 1 if $type == CT_CHAR_PTR;
return 1 if $type == CT_BINARY_PTR;
return 1 if $type == CT_RSRC_HANDLE_PTR;
return 1 if $type == CT_SD_PTR;
return 0;

}   # end data_type_is_simple


#--------------------------------------------------------------------#
# data_type_is_array:                                                #
#   Check a data type to see if it is one of the                     #
#   array types defined in ct_data_type_t.                           #
#                                                                    #
# Paramaters:                                                        #
#   $data_type  in  Int value to be evaluated against the simple     #
#                   values of the ct_data_type_t enum.               #
#   NOTE: When the enum changes, these subroutines will have to be   #
#         edited to reflect the change.                              #
#                                                                    #
# Returns:                                                           #
#   0 - if the value is a simple data type                           #
#   1 - if the value is not a simple data type                       #
#                                                                    #
# Global Variables:                                                  #
#   $main::Trace5  in  Print trace messages if turned on.            #
#--------------------------------------------------------------------#
sub data_type_is_array
{
my $data_type = shift;

$main::Trace5 &&
print STDERR "Entered CT_cli_utils::data_type_is_array($data_type)\n";

return 1 if $data_type == CT_INT32_ARRAY;
return 1 if $data_type == CT_UINT32_ARRAY;
return 1 if $data_type == CT_INT64_ARRAY;
return 1 if $data_type == CT_UINT64_ARRAY;
return 1 if $data_type == CT_FLOAT32_ARRAY;
return 1 if $data_type == CT_FLOAT64_ARRAY;
return 1 if $data_type == CT_CHAR_PTR_ARRAY;
return 1 if $data_type == CT_BINARY_PTR_ARRAY;
return 1 if $data_type == CT_RSRC_HANDLE_PTR_ARRAY;
return 1 if $data_type == CT_SD_PTR_ARRAY;
return 0;

}   # end data_type_is_array


#--------------------------------------------------------------------#
# data_type_is_numeric:                                              #
#   Checks to see if the data type passed in                         #
#   is one of 32 or 64 bit signed/unsigned integer or floating       #
#   point types defined in ct_data_type_t. Returns 1 on success,     #
#   0 on failure.                                                    #
#                                                                    #
# Parameters:                                                        #
#   $data_type    in  one of ct_data_type_t types                    #
#   NOTE: When the enum changes, these subroutines will have to be   #
#         edited to reflect the change.                              #
#                                                                    #
# Returns:                                                           #
#   1 - if the value is a numeric data type                          #
#   0 - if the value is not a numeric data type                      #
#                                                                    #
# Global Variables:                                                  #
#   $main::Trace5  in  Print trace messages if turned on.            #
#--------------------------------------------------------------------#
sub data_type_is_numeric
{
my $data_type = shift;

$main::Trace5 &&
print STDERR "Entered CT_cli_utils::data_type_is_numeric($data_type)\n";
    
return 1 if $data_type == CT_INT32;
return 1 if $data_type == CT_UINT32;
return 1 if $data_type == CT_INT64;
return 1 if $data_type == CT_UINT64;
return 1 if $data_type == CT_FLOAT32;
return 1 if $data_type == CT_FLOAT64;
return 1 if $data_type == CT_INT32_ARRAY;
return 1 if $data_type == CT_UINT32_ARRAY;
return 1 if $data_type == CT_INT64_ARRAY;
return 1 if $data_type == CT_UINT64_ARRAY;
return 1 if $data_type == CT_FLOAT32_ARRAY;
return 1 if $data_type == CT_FLOAT64_ARRAY;
return 0;

}   # end sub data_type_is_numeric 


#--------------------------------------------------------------------#
# array_data_type_to_simple:                                         #
#   returns corresponding simple type of                             #
#   array ct_data_type_t type passed in. If the type passed to the   #
#   function is not recognized as an array type, the function        #
#   simply returns the type passed to it.                            #
#                                                                    #
# Parameters:                                                        #
#   $data_type    input   one of ct_data_type_t types                #
#   NOTE: When the enum changes, these subroutines will have to be   #
#         edited to reflect the change.                              #
#                                                                    #
# Returns:                                                           #
#   ct_data_type_t        simple version of array type passed in,    #
#                         or, if data type passed in is not one of   #
#                         the known array types, returns $data_type  #
#--------------------------------------------------------------------#
sub array_data_type_to_simple
{
my $data_type = shift;

$main::Trace5 &&
print STDERR "Entered CT_cli_utils::array_data_type_to_simple($data_type)\n";

return CT_INT32 if $data_type == CT_INT32_ARRAY;
return CT_UINT32 if $data_type == CT_UINT32_ARRAY;
return CT_INT64 if $data_type == CT_INT64_ARRAY;
return CT_UINT64 if $data_type == CT_UINT64_ARRAY;
return CT_FLOAT32 if $data_type == CT_FLOAT32_ARRAY;
return CT_FLOAT64 if $data_type == CT_FLOAT32_ARRAY;
return CT_CHAR_PTR if $data_type == CT_CHAR_PTR_ARRAY;
return CT_BINARY_PTR if $data_type == CT_BINARY_PTR_ARRAY;
return CT_RSRC_HANDLE_PTR if $data_type == CT_RSRC_HANDLE_PTR_ARRAY;
return CT_SD_PTR if $data_type == CT_SD_PTR_ARRAY;

return $data_type;

}   # end sub array_data_type_to_simple


#--------------------------------------------------------------------#
# End Exported Subroutines (with @EXPORT_OK, -> on demand).          #
#--------------------------------------------------------------------#

#--------------------------------------------------------------------#
# End File                                                           #
#--------------------------------------------------------------------#
