#!/usr/bin/perl
# IBM_PROLOG_BEGIN_TAG 
# This is an automatically generated prolog. 
#  
#  
#  
# Licensed Materials - Property of IBM 
#  
# (C) COPYRIGHT International Business Machines Corp. 2007 
# All Rights Reserved 
#  
# US Government Users Restricted Rights - Use, duplication or 
# disclosure restricted by GSA ADP Schedule Contract with IBM Corp. 
#  
# IBM_PROLOG_END_TAG 

################################################################################
# Arguments are:
#
# ARGV[0] - what action is taking place - [add|delete|activate|deactivate]
# ARGV[1] - what object are we talking about? [cec|partition]
# ARGV[2] - what specific object are we talking about? - [mt*ms|lparid*mt*ms]
#
# 
################################################################################

$me = `basename $0`; chomp $me;

if ( $#ARGV != 2 ) {
	 usage();
	 exit 1;
}




sub usage() {
	 print "\n";
	 print "purpose: Notify IBM.DMSRM about changes to status for certain CIMOM managed resources.\n";
	 print "\n";
	 print "usage: $me <action> <object type> <object specifiers>\n";
	 print "\n";
	 print "   <action> - one of [add|delete|activate|deactivate]\n";
	 print "   <object> - one of [cec|partition]\n";
	 print "   <object specifiers>:\n";
	 print "       for 'cec' objects, machine type and serial number: 'mt*sn'\n";
	 print "       for 'partition' objects, LPARid, machine type and serial number: 'lparid*mt*sn'\n";
	 print "\n";
}

$Action = $ARGV[0];
$Object = $ARGV[1];
$ObjectSpecifier = $ARGV[2];


%ValidObjects = ("cec",1,
					  "partition",1);

%ValidActions = ("add",1,
					  "delete",1,
					  "activate",1,
					  "deactivate",1);




# check that $Action is valid
if ( ! exists ( $ValidActions{$Action} ) ) {
	 print "Action '$Action' is not valid\n";
	 exit 1;
}

# check that $Object is valid
if ( ! exists ( $ValidObjects{$Object} ) ) {
	 print "Object '$Object' is not valid\n";
	 exit 1;
}

# Call the specific function to do the work.
$FunctionToCall = $Action."_".$Object;
&$FunctionToCall($ObjectSpecifier);

################################################################################
# delete a partition
#
# args must be "LPARid*MT*SN"
#
################################################################################
sub delete_partition () {

	 my $arg = shift;
	 ($LPARid, $mt, $sn) = split(/\*/, $arg);
	 # run the appropriate remove resource command.
	 $command = "rmrsrc -s 'LParID=\"$LPARid\" and HWModel=\"$mt\" and HWSerialNum=\"$sn\"' IBM.ManagedNode";
	 system($command);

	 $rc = $? >> 8;
	 if ( $rc == 6 ) {
		  logMessage("delete_partitions( $arg ) called. No resources found : $command");
	 }
	 else {
		  logMessage("delete_partitions( $arg ) called. Got rc $rc from $command");
	 }

	 exit $rc;

}

################################################################################
# delete a CEC. This means to us that all partitions on that CEC
# should have already been removed.  But, to save many calls to this
# script, when we get a CEC delete, we will remove all resources
# defined on that CEC...
#
# args must be "MT*SN"
#
################################################################################
sub delete_cec () {

	 my $arg = shift;
	 ($LPARid, $mt, $sn) = split(/\*/, $arg);
	 # run the appropriate remove resource command.
	 $command = "rmrsrc -s 'HWModel=\"$mt\" and HWSerialNum=\"$sn\"' IBM.ManagedNode";
	 system($command);

	 $rc = $? >> 8;
	 if ( $rc == 6 ) {
		  logMessage("delete_partitions( $arg ) called. No resources found : $command");
	 }
	 else {
		  logMessage("delete_partitions( $arg ) called. Got rc $rc from $command");
	 }

	 exit $rc;

}

################################################################################
# log a message to the auditlog - if that's not present, send it to the syslog
################################################################################
sub logMessage() {

	 my $message = shift;
	 $message =~ s/(['])/"/g;

	 if ( -x "/opt/csm/csmbin/clogger" ) {
		  # send to audlog - view with 'lsaudrec'. For this to work, this script needs to run as root.
		  $command="/opt/csm/csmbin/clogger -M'$message' -I999 -S1 -CIBM.DMSRM -s1 -n2 -f'abc' -t4 -c'_PAR' -l'csm_hmc.server'";
	 }
	 else {
		  # send to the syslog
		  $command = "logger -t'$me' '$message'";
	 }

	 system($command);

}

################################################################################
# called when an undefined function is called. This is needed since we
# blindly invoke functions defined by the command line args. We catch
# all the "not implemented yet" function calls here...
################################################################################
sub AUTOLOAD {
	 use vars qw ($AUTOLOAD);
	 print "Function $AUTOLOAD is not implemented\n";
	 exit 1;
}

