// @(#)98       1.18  src/hmc/LparCmdRM/CmdCl/lparCmd_RM.h, lpar, rsct_rdeb 10/10/05 17:12:29
// IBM_PROLOG_BEGIN_TAG 
// This is an automatically generated prolog. 
//  
//  
//  
// Licensed Materials - Property of IBM 
//  
// Restricted Materials of IBM 
//  
// (C) COPYRIGHT International Business Machines Corp. 2002,2007 
// All Rights Reserved 
//  
// US Government Users Restricted Rights - Use, duplication or 
// disclosure restricted by GSA ADP Schedule Contract with IBM Corp. 
//  
// IBM_PROLOG_END_TAG 
#ifndef _LPARCMD_H
#define _LPARCMD_H
#ifndef MC_VERSION
#define MC_VERSION 2
#endif


#define IBM_DLPARCMD		"IBM.LparCmd"	  // Class name


//-------------------------------------
// Common #defines for all class actions
//-------------------------------------

#define DBG_NONE		0
#define DBG_LITTLE		1
#define DBG_MORE		2
#define DBG_MOST		3
#define DBG_DEBUG		4
#define DBG_DEBUG_MAX		5

// Used for Rc. Return codes when the
// class action fails on Linux side.
//
#define RC_SUCCESS		0
#define RC_COMPLETE		1001  // In case of multiple reponses, this
				      // will be the ReturnCode for the
				      // last response.
#define MSG_COMPLETE		      "The class action completed successfully."
				      
#define RC_FAILURE		1002  // If the class action fails.
#define MSG_FAILURE		      "The invoke_class_action to partition fails rc=%d."
				      

#define RC_ERR_INVALID_INPUT	1021  // Unknown MTMS, LParID, etc
#define MSG_INVALID_INPUT             "Invalid input for the class action."
#define MSG_INVALID_CMD               "Unsupported command for the class action."
#define MSG_INVALID_LPAR              "Unknown partition for the class action. This is probably because of invalid lpar ID or the HMC does not have RMC connection to the lpar due to network setup, etc.."
#define MSG_INVALID_OPCODE            "Invalid opcode for migration command."

#define RC_ERR_RMCSESSION	1022  // Can't establish session.
				      // Session is currently inactive.
#define MSG_ERR_RMCSESSION	      "There is no active RMC session with the partition."

#define RC_ERR_RMC		1023  // Other RMC errors

#define RC_ERR_PERMISSION	1124

#define RC_ERR_MEMORY		1125  // malloc error
#define MSG_ERR_MEMORY		      "Memory allocation failure."

#define RC_ERR_UNSUPPORT	1126  //
#define MSG_ERR_UNSUPPORT	      "Unsupported function."

#define RC_UNKNOWN_ERROR	1140  // Unknown error
#define MSG_UNKNOWN_ERROR	      "Unknown error."

#define RC_DRM_ERROR		1141  // Error while talking with IBM.DRM.
				      // Normally when this occurs, either the
				      // partition crashed or IBM.DRM crashes
				      // or hung causing the communication
				      // broken or time-out.
#define MSG_DRM_ERROR		      "Network interruption occurs to RMC while waiting for the execution of the command on the partition to finish (rc/rmc_error=%x).\nEither the partition has crashed, the operation has caused CPU starvation, or IBM.DRM has crashed in the middle of the operation.\nThe operation could have completed successfully."

#define RC_ERR_ILLEGAL_INPUT	1042  // Illegal data input
#define MSG_ILLEGAL_INPUT             "The input data of the class action contains illegal characters such as ; or >."

#define RC_ERR_THREAD           1043  // Shutdown thread fail to start
#define MSG_ERR_THREAD                "The operation on lpar fails because it cannot create the thread. This could be because the system is under heavy utilization, please retry the operation later (rc=%d)."

#define RC_MIDDLE_SHUTDOWN      1045  // Lpar is in middle of a shutdown
#define MSG_MIDDLE_SHUTDOWN           "The lpar %s is in middle of a shutdown."

//-------------------------------------
// DLParCommand class action
//-------------------------------------

#define ACT_DLPAR_COMMAND	"DLParCommand"   /* class action name */

#define DLPAR_CMD_NUM_IN	5  /* MTM, MS, LparID, Cmd, DbgLevel */
#define DLPAR_CMD_NUM_OUT	6  /* rc, cmdrc, stdout, stderr, val1, val2 */

#define _DCMD_IN_MTM		0
#define _DCMD_IN_MS		1
#define _DCMD_IN_LPARID		2
#define _DCMD_IN_CMD		3
#define _DCMD_IN_DBGLVL		4

#define _DCMD_OUT_RC		0
#define _DCMD_OUT_CMDRC		1
#define _DCMD_OUT_STDOUT	2
#define _DCMD_OUT_STDERR	3
#define _DCMD_OUT_VAL1	        4
#define _DCMD_OUT_VAL2	        5


//-------------------------------------------------------
// QueryPartition class action
//-------------------------------------------------------

#define ACT_QUERY_PARTITION	"QueryPartition"   /* class action name */

#define QUERY_PART_NUM_IN	3  /* MTM, MS, LparID		*/

#define _QR_IN_MTM		0
#define _QR_IN_MS 		1
#define _QR_IN_LPARID		2

#define QUERY_PART_NUM_OUT	11 /* Rc, Hostname, IPAddr,	*/
				   /* LparID, Active, OStype	*/
				   /* OSlevel, DLparCaps, DLParInfo */
				   /* SysCmdCaps1, SysCmdCaps2	*/
#define _QR_OUT_RC		0
#define _QR_OUT_HOST		1
#define _QR_OUT_IP		2
#define _QR_OUT_LPARID		3
#define _QR_OUT_ACTIVE		4
#define _QR_OUT_OSTYPE		5
#define _QR_OUT_OSVER		6
#define _QR_OUT_DCAPS		7

//-------------------------------------------------------------------
// Bitmasks matched with IBM.DRM's defines.
//   DLPAR_PMIG, DLPAR_VIOS, DLPAR_MSP: Used by Partition Migration
//
#define DLPAR_PROCESSOR		    (1<<0)
#define DLPAR_MEMORY		    (1<<1)
#define DLPAR_IO		    (1<<2)
#define DLPAR_PCI_BRIDGE	    (1<<3)
#define SPLPAR_ENTITLED             (1<<4)
#define MULT_CPU_DRMGR              (1<<5)
#define DLPAR_PMIG                  (1<<6)    // 0x0040
#define DLPAR_VIOS                  (1<<7)    // 0x0080
#define DLPAR_MSP                   (1<<8)    // 0x0100


#define _QR_OUT_DINFO		8
#define _QR_OUT_CMDCAPS1	9


// Bitmasks for RemCmdCaps1. This must matched with
// what the IBM.DRM's defines.
//
#define CAP1_SHUTDOWN		    (1<<0)
#define CAP1_RTIME_MSG   	    (1<<1)   /* AIX's DRM_NEW_INTERFACE_CAP */
#define CAP1_MSGRETRIEVE            (1<<2)

#define _QR_OUT_CMDCAPS2	10



//-------------------------------------------------------
// RemoteCommand class action
//-------------------------------------------------------

#define ACT_REMOTE_COMMAND	"RemoteCommand"   /* class action name */

#define REM_CMD_NUM_IN		5  /* MTM, MS, LparID, ID, Args */
#define REM_CMD_NUM_OUT		3  /* rc, cmdrc, cmdmsg         */

#define _RCMD_IN_MTM		0
#define _RCMD_IN_MS		1
#define _RCMD_IN_LPARID		2
#define _RCMD_IN_CMDID		3
#define CMD_SHUTDOWN_ID		    001		// Shutdown partition
#define CMD_RESETDCAPS_ID	    002		// Reset CIMOM DLparCaps
#define CMD_CMDDEBUG_ID		    003		// Set runtime cmdDEBUG value
#define CMD_SEND_CIM_ASYNC          004 	// Send a Async to CIM
#define _RCMD_IN_CMDARGS	4

/*
 * RemoteCommand Option to use along with the CmdID field.
 * It occupies the high 16 bits while the command id will occupy the
 * lower 16 bits.
 */
#define SHUTDOWN_NOWAIT (1<<16)
#define CMDID_MASKS     0x0000ffff
#define CMDOPT_MASKS    0xffff0000

#define _RCMD_OUT_RC		0
#define _RCMD_OUT_CMDRC		1
#define _RCMD_OUT_CMDMSG	2


//-------------------------------------------------------
// PMigration class action. Used for Partition Migration
// migmover and migmgr commands.
//-------------------------------------------------------
#define DMIGRATION_NUM_IN	15
#define DMIGRATION_NUM_OUT	16
#define _PIN_UINT32_00    0            /* Opcode */
#define _PIN_STR_01    	  1
#define _PIN_STR_02    	  2
#define _PIN_STR_03    	  3
#define _PIN_STR_04    	  4
#define _PIN_STR_05    	  5
#define _PIN_UINT32_01 	  6
#define _PIN_UINT32_02 	  7
#define _PIN_UINT32_03 	  8
#define _PIN_UINT32_04 	  9
#define _PIN_STR_06       10
#define _PIN_UINT64_01 	  11
#define _PIN_UINT64_02 	  12
#define _PIN_STR_07       13
#define _PIN_STR_08       14

#define _POUT_INT32_RC    0            /* Rc */
#define _POUT_INT32_CMDRC 1            /* CmdRc */
#define _POUT_STR_01      2
#define _POUT_STR_02      3
#define _POUT_STR_03      4
#define _POUT_STR_04      5
#define _POUT_INT32_01    6
#define _POUT_INT32_02    7
#define _POUT_INT32_03    8
#define _POUT_INT32_04    9
#define _POUT_INT32_05    10
#define _POUT_INT64_01    11
#define _POUT_INT64_02    12
#define _POUT_INT64_03    13
#define _POUT_INT64_04    14
#define _POUT_STR_05      15

// Values for IN_OPCODE field
#define    OP_MIGMGR	     1
#define    OP_MIGMOVER	     2
#define    OP_DRMGR          3

// Input/Output parameter indexing for LparCmdRM's migration
// commands which include drmgr, migmover, and migmgr.
#define PIN_OPCODE              _PIN_UINT32_00
#define PIN_MMGR_MT          	_PIN_STR_01
#define PIN_MMGR_MS          	_PIN_STR_02
#define PIN_MMGR_LPARID         _PIN_STR_03
#define PIN_MMGR_CMD            _PIN_STR_04
#define PIN_MMGR_DEVDESC        _PIN_STR_05
#define PIN_MMGR_DEVDESC        _PIN_STR_05
#define PIN_MMGR_DBGLVL         _PIN_UINT32_01
#define PIN_MMGR_SUBCMD         _PIN_UINT32_02
#define PIN_MMGR_LANG           _PIN_STR_06
#define PIN_MMGR_STREAMID       _PIN_STR_07

#define POUT_RC                 _POUT_INT32_RC
#define POUT_CMDRC              _POUT_INT32_CMDRC
#define POUT_STDOUT      	_POUT_STR_01
#define POUT_STDERR      	_POUT_STR_02
#define POUT_VIOSCAPS    	_POUT_STR_03
#define POUT_DEVDESC		_POUT_STR_04
#define POUT_MINVIOSLVL	        _POUT_INT32_01
#define POUT_MAXVIOSLVL	        _POUT_INT32_02
#define POUT_VIOS_DETAIL_ERR    _POUT_STR_05

// Input/Output indexing for migmover command
#define PIN_MMOVER_MT          	_PIN_STR_01
#define PIN_MMOVER_MS          	_PIN_STR_02
#define PIN_MMOVER_LPARID       _PIN_STR_03
#define PIN_MMOVER_CMD          _PIN_STR_04
#define PIN_MMOVER_STREAMID     _PIN_STR_05
#define PIN_MMOVER_DBGLVL       _PIN_UINT32_01
#define PIN_MMOVER_SUBCMD       _PIN_UINT32_02
#define PIN_MMOVER_LANG         _PIN_STR_06

#define POUT_MV_RC              _POUT_INT32_RC
#define POUT_MV_CMDRC           _POUT_INT32_CMDRC
#define POUT_MV_STDOUT          _POUT_STR_01
#define POUT_MV_STDERR          _POUT_STR_02
#define POUT_MV_MSPCAPS         _POUT_STR_03
#define POUT_MV_MIGSTATE        _POUT_STR_04
#define POUT_MV_CMDEVENT        _POUT_INT32_01
#define POUT_MV_ACTIVE          _POUT_INT32_02
#define POUT_MV_MAXMIG          _POUT_INT32_03
#define POUT_MV_MAXPOOLS        _POUT_INT32_04
#define POUT_MV_MIGPORT         _POUT_INT32_05
#define POUT_MV_REMAIN_BYTES    _POUT_INT64_01
#define POUT_MV_TOTAL_BYTES     _POUT_INT64_02
#define POUT_MV_BYTES_SENT      _POUT_INT64_03
#define POUT_MV_BYTES_RECV      _POUT_INT64_04

#define MIGMGR_DRM_PIN_NUM      4    /* input # for DRM's migmgr */
#define MMOVER_DRM_PIN_NUM      3    /* input # for DRM's migmover */

//-------------------------------------------------------------------
// Bit values for POUT_MV_CMDEVENT field above which is a
// a bitmask to show which of the migmover events have occurs.
//
// (Taken from the AIX design note (should be in LparMig FRS):
//    CMDEVENT_MIG_ENABLED - the migration has started (at this point
//        it is "safe" to request statistics, issue suspendable, etc.)
//    CMDEVENT_MIG_ABORTED - the migration has been aborted
//    CMDEVENT_MIG_SUSPENDING - the migration has surpassed the
//        specified suspension trigger and the MSP has requested that
//        the source partition be suspended
//    CMDEVENT_MIG_SUSPENDED - the source partition has been suspended
//    CMDEVENT_MIG_RESUMED - the target partition has been resumed
//    CMDEVENT_MIG_COMPLETED - all the state has been transferred and
//        the migration has completed
//
#define CMDEVENT_STARTED        (1<<0)      // 0x000001
#define CMDEVENT_PORT_DEFINED   (1<<1)      // 0x000002
#define CMDEVENT_COMPLETE       (1<<2)      // 0x000004
#define CMDEVENT_MIG_ENABLED    (1<<3)      // 0x000008
#define CMDEVENT_MIG_ABORTED    (1<<4)      // 0x000010
#define CMDEVENT_MIG_SUSPENDING (1<<5)      // 0x000020
#define CMDEVENT_MIG_SUSPENDED	(1<<6)      // 0x000040
#define CMDEVENT_MIG_RESUMED    (1<<7)      // 0x000080
#define CMDEVENT_MIG_COMPLETED  (1<<9)      // 0x000100


//-------------------------------------------------------------------
// Migration subcommands that require special work in LparCmdRM.
// (These values are extracted from hsc/client/rmc/CmdCommand.java)
//
#define START_SRC_MIG           11
#define START_TARGET_MIG        12
#define MIG_PREPARE             31

//-------------------------------------------------------------------
// Bit values for PIN_MV_CMDDEBUG/PIN_MMGR_CMDDEBUG field above.
// This bitmask only affect DRM - not to the command itself.
//  - DEBUG: DRM will log the Cmd, command to be executed, and
//           return code, in its trace.
//  - RTR: DRM will return the command's stdout in real time fashion
//         to LparCmdRM.
//  - NO_WAIT: Used in conjuntion with RTR mask, this is a special mask
//             to tell LparCmdRM to return as soon as possible without
//             waiting for the last async.
//
#define DRM_CMDDEBUG_DEBUG      (1<<0)      // 0x00000001
#define DRM_CMDDEBUG_RTR        (1<<1)      // 0x00000002
#define PMIG_NO_WAIT            (1<<31)


//-----------------------------------------------------------
// Defines used for communication between LparCmdRM and CIM
// via socket.
//-----------------------------------------------------------


//-----------------------------------------------------------
// Async numbers. This is taken from the HMC async number in
// src/lparmgt/com/ibm/hsc/common/util/EventSubscription.java.
//
#define EVENT_RMC_MIG_STATUS      610
#define EVENT_RMC_RTIME_MSG       620


//-----------------------------------------------------------
// Tags in the data stream LparCmdRM send to CIMOM. The value
// string follows each tag. CIMOM will convert the string
// values into appropriate data types on its side.
// (These #defines must match with those defined in HMC's
// com/ibm/hsc/common/util/PIRmcConstants.java class.)
//
// Some special packages:
//
//   GOODBYE_PKG: Will be the last pkg sent using the socket.
//         CIM can close the socket down when receiving this.
//
#define GOODBYE_PKG        "###_GOODBYE_###"
#define TAG_ENDPKG         "#;=#_ENDPKG_#"
#define TAG_OPCODE         "#;=Opcode=="
#define TAG_MIGCMD         "#;=MigCmd=="
#define TAG_CMDRC          "#;=CmdRd=="
#define TAG_CECMT          "#;=CecMT=="
#define TAG_CECMS          "#;=CecMS=="
#define TAG_LPARID         "#;=LparID=="
#define TAG_TOTAL_BYTES    "#;=TotalBytes=="
#define TAG_BYTES_SENT     "#;=BytesSent=="
#define TAG_ACTIVE_MIG     "#;=ActiveMigs=="
#define TAG_MAX_MIGS       "#;=MaxMigs=="
#define TAG_REMAIN_BYTES   "#;=RemainBytes=="
#define TAG_BYTES_RECV     "#;=BytesReceived=="
#define TAG_MIG_STATE      "#;=MigState=="
#define TAG_STREAMID       "#;=StreamID=="
#define TAG_MAX_POOLS      "#;=MaxRecvPools=="
#define TAG_MIG_PORT       "#;=MigPort=="
#define TAG_CMDEVENT_MASKS "#;=cmdEventMasks=="
#define TAG_MSP_CAPS       "#;=cmdMSPCaps=="
#define TAG_MSG            "#;=CmdMsg=="


//-----------------------------------------------------------
// Sockets used by LparCmdRM
//    CIM_PORT: Locally. Only one connection allowed.
#define CIM_PORT           9267    // RMC_EVENT_PORT in HSCSocket.java

#endif // _LPARCMD_H
