# IBM_PROLOG_BEGIN_TAG 
# This is an automatically generated prolog. 
#  
#  
#  
# Licensed Materials - Property of IBM 
#  
# (C) COPYRIGHT International Business Machines Corp. 2000,2007 
# All Rights Reserved 
#  
# US Government Users Restricted Rights - Use, duplication or 
# disclosure restricted by GSA ADP Schedule Contract with IBM Corp. 
#  
# IBM_PROLOG_END_TAG 
package ERRM_cli_rc;
#"@(#)42   1.1   src/rsct/rm/ER/cli/pm/ERRM_cli_rc.pm.perl, errmcli, rsct_reneh, renehs001b 9/25/00 14:04:01"
######################################################################
#                                                                    #
# Package: ERRM_cli_rc.pm                                            #
#                                                                    #
# Description:                                                       #
#   This package contains return codes used for the Event Response   #
#   Resource Manager (ERRM) CLI commands. Each return code can be    #
#   referenced separately, or as a whole using the 'return_codes'    #
#   EXPORT_TAG.                                                      #
#                                                                    #
# Examples:                                                          #
#   use ERRM_cli_rc qw(ERRM_CLI_BAD_OPERAND ERRM_CLI_BAD_FLAG)       #
#   - exports only 2 of the return codes for use in the calling      #
#     program.                                                       #
#                                                                    #
#   use ERRM_cli_rc qw(:return_codes)                                #
#   - exports all return codes included in the EXPORT_TAG            #
#     return_codes. (the ':' is needed to access the tag)            #
#                                                                    #
#--------------------------------------------------------------------#
#                                                                    #
# Inputs:                                                            #
#                                                                    #
# Outputs:                                                           #
#                                                                    #
# External References:                                               #
#   Perl Modules:   constant, Exporter                               #
#                                                                    #
# Tab Settings:                                                      #
#   4 and tabs should be expanded to spaces before saving this file. #
#   in vi:  (:set ts=4  and   :%!expand -4)                          #
#                                                                    #
# Change Activity:                                                   #
#   000921 JAC 67664: Initial design and write.                      #
######################################################################

use Exporter ();
use constant;
@ISA = qw(Exporter);
@EXPORT_OK = qw(    ERRM_CLI_SUCCESS
                    ERRM_CLI_RMC_ERROR
                    ERRM_CLI_ERROR
                    ERRM_CLI_BAD_FLAG
                    ERRM_CLI_BAD_OPERAND
                    ERRM_CLI_USER_ERROR
);


#--------------------------------------------------------------------#
# EXPORT TAGS is used to refer to the return codes as a group        #
#--------------------------------------------------------------------#

%EXPORT_TAGS = (
return_codes => [qw(ERRM_CLI_SUCCESS
                    ERRM_CLI_RMC_ERROR
                    ERRM_CLI_ERROR
                    ERRM_CLI_BAD_FLAG
                    ERRM_CLI_BAD_OPERAND
                    ERRM_CLI_USER_ERROR
)]
); # end %EXPORT_TAGS


#--------------------------------------------------------------------#
# Return Code Definitions (constants)                                #
#--------------------------------------------------------------------#

use constant ERRM_CLI_SUCCESS         => 0;
use constant ERRM_CLI_RMC_ERROR       => 1;
use constant ERRM_CLI_ERROR           => 2;
use constant ERRM_CLI_BAD_FLAG        => 3;
use constant ERRM_CLI_BAD_OPERAND     => 4;
use constant ERRM_CLI_USER_ERROR      => 5;
