#!/bin/sh
#
# Purpose:
#   This script is used to configure the CIM environment that is common for
#   all towers.  It will be called twice - first with an argument of
#   "preregistration" before the CIMOM is started and a second time with an
#   argument of "registration" after the CIMOM is started.
#****************************************************************************

actzTrace "CIMOMRGT: -> cimregisterbase.sh(pass=$1)"

#
# Preregistration tasks
#
if [ $1 = preregistration ]; then

wbemfile="/etc/pam.d/wbem"
pamfile="/lib/security/libactzmompam.so"
sslfile="/etc/Pegasus/ssl.cnf"
gencerts="/usr/share/Pegasus/scripts/genOpenPegasusSSLCerts"

# In the build environment, CONSOLE_PATH is not defined.  In this case, set it
# to HWMCAHOME.
if [ -z "$CONSOLE_PATH" ]; then
   export CONSOLE_PATH="$HWMCAHOME/"
fi

# Create a softlink to the PAM config file
if [ -e $wbemfile ]; then
  rm -f $wbemfile
fi
actzTrace "CIMOMRGF: Linking the PAM config file: $CONSOLE_PATH/data/wbem to $wbemfile"
echo "Linking the PAM config file: $CONSOLE_PATH/data/wbem to $wbemfile"
ln -s $CONSOLE_PATH/data/wbem $wbemfile

# Create a softlink to the PAM security module
if [ -h $pamfile ]; then
  actzTrace "CIMOMRGF: Removing the PAM module link: $pamfile"
  echo "Removing the PAM module link: $pamfile"
  rm -f $pamfile
fi
if [ -e $CONSOLE_PATH/lib/framework/libactzmompam.so ]; then
  actzTrace "CIMOMRGF: Linking the PAM module: $CONSOLE_PATH/lib/framework/libactzmompam.so to $pamfile"
  echo "Linking the PAM module: $CONSOLE_PATH/lib/framework/libactzmompam.so to $pamfile"
  ln -s $CONSOLE_PATH/lib/framework/libactzmompam.so $pamfile
elif [ -e $CONSOLE_PATH/lib/libactzmompam.so ]; then
  actzTrace "CIMOMRGF: Linking the PAM module: $CONSOLE_PATH/lib/libactzmompam.so to $pamfile"
  echo "Linking the PAM module: $CONSOLE_PATH/lib/libactzmompam.so to $pamfile"
  ln -s $CONSOLE_PATH/lib/libactzmompam.so $pamfile
fi

# Generate the SSL certificates
if [ ! -e $sslfile ]; then
actzTrace "CIMOMRGF: Generating SSL certificates"
echo "Generating SSL certificates"
$gencerts
fi

fi

actzTrace "CIMOMRGT: <- cimregisterbase.sh"
