#!/bin/bash

# cdvdlabel.sh
#
# Usage: cdvdlabel.sh <device file> <label file> <log file>
#
# Error Return Codes:
# 1 - No label found
# 2 - Major failure
#
# Author: C. Schuck
#
# 03/17/2005  P. Provost  Fixed tracing
# 06/23/2005  P. Provost  Changed to use volname command to find CD-ROM label
# 06/24/2005  P. Provost  Cleanup logic of the script
# 03/28/2006  J. Kunz     When unsuccessful getting label, pump cmd data into logfile

DEVICEFILE=$1
LABELFILE=$2
LOGFILE=$3

echo "-> cdvdlabel.sh" >> $LOGFILE
echo "cdvdlabel.sh: Getting the label from the CD-ROM or DVD-RAM at $DEVICEFILE for `date`" >> $LOGFILE

actzTrace "XMDA   T: -> cdvdlabel.sh"
actzTrace "XMDA   F: cdvdlabel.sh: Getting the label from the CD-ROM or DVD-RAM at $DEVICEFILE for `date`"

# If the media is a UDF DVD-RAM, try to retrieve the DVD-RAM label using chkudf
if chkudf $DEVICEFILE | grep '(M) Volume Identifier:' > $LABELFILE 2>&1; then

    echo "cdvdlabel.sh: Successfully retrieved the label using chkudf." >> $LOGFILE
    actzTrace "XMDA   F: cdvdlabel.sh: Successfully retrieved the label using chkudf."

    echo "cdvdlabel.sh: Label File Listing:" >> $LOGFILE
    echo "" >> $LOGFILE
    cat $LABELFILE >> $LOGFILE
    echo "" >> $LOGFILE

# Else if the media is a iso9660 CD-ROM, then try to retrieve the CD-ROM label using the volname command
elif volname $DEVICEFILE > $LABELFILE 2>&1; then

    echo "cdvdlabel.sh: Successfully retrieved the label using volname." >> $LOGFILE
    actzTrace "XMDA   F: cdvdlabel.sh: Successfully retrieved the label using volname command."

    echo "cdvdlabel.sh: Label File Listing:" >> $LOGFILE
    echo "" >> $LOGFILE
    cat $LABELFILE >> $LOGFILE
    echo "" >> $LOGFILE

# Else the script failed to retrieve the label from the DVD-RAM or CD-ROM
else

    echo "cdvdlabel.sh: Failed to retrieve the label." >> $LOGFILE
    actzTrace "XMDA   F: cdvdlabel.sh: Failed to retrieve the label."

    echo "" >> $LOGFILE
    echo "cdvdlabel.sh: Unsuccessfully retrieved the label using chkudf which now returns:" >> $LOGFILE
	chkudf $DEVICEFILE >> $LOGFILE 2>&1;

    echo "" >> $LOGFILE
    echo "cdvdlabel.sh: Unsuccessfully retrieved the label using volname which returned:" >> $LOGFILE
    cat $LABELFILE >> $LOGFILE

    echo "<- cdvdlabel.sh for `date`" >> $LOGFILE
    echo "" >> $LOGFILE

    actzTrace "XMDA   T: <- cdvdlabel.sh for `date`"

    exit 1
fi

echo "<- cdvdlabel.sh for `date`" >> $LOGFILE
echo "" >> $LOGFILE

actzTrace "XMDA   T: <- cdvdlabel.sh for `date`"

exit 0

