#!/bin/bash

# cleancrash.sh
#
# Usage:
#    cleancrash.sh
#
# Description:
#    This script removes all the dumps in the jvm dump directory
#
# Command Line Parameters:
#
# Return Codes
#    0: normal script termination; no unrecoverable errors
#    1: invalid command line parameters
#    2: could not locate hmcfunctions script file
#
# Module History
#    01  04/12/04   Maui          - Initial Release


# -----------
# subroutines
# -----------

# subroutine for outputting help
echo_help() {
   echo "Usage: cleans out the pacrashdirectory files"
   echo "   `basename $0`"
}

# subroutine for checking if there were errors while collecting data
check_err() {
   if [ -s err.tmp ]; then
      echo "errors follow." >>$LOG
      cat -n err.tmp >>$LOG
   else
      echo "done." >>$LOG
   fi
   rm -f err.tmp
   echo >>$LOG
}


actzTrace "XPACLENT: -> cleancrash"

# -----------------------------------------
# perform parameter collection and checking
# -----------------------------------------

# check for parameters and output help if required
until [ -z "$1" -o -n "$HELP" ]; do
   case "$1" in
      -h | --help     )
         HELP="on"
      ;;
      *               )
         HELP="on"
         ERROR="Invalid parameter ( $1 )!"
      ;;
   esac
   shift
done

if [ -n "$ERROR" ]; then
   echo "Error: $ERROR"
   echo
   echo_help
   exit 1
fi

if [ -n "$HELP" ]; then
   echo_help
   exit 0
fi

actzTrace "XPACLENT: find the hmcfunctions"

# attempt to locate hmcfunctions script
if [ -z "$CONSOLE_PATH" ]; then
   CONSOLE_PATH="$HWMCAHOME/"
fi
FOUND=
for FUNCDIR in "" "$CONSOLE_PATH/" "$CONSOLE_PATH/native/scripts/"; do
   . ${FUNCDIR}hmcfunctions >/dev/null 2>&1 && FOUND=true && break 1
done
if [ -z "$FOUND" ]; then
   echo "Error: Could not locate hmcfunctions script file!"
   actzTrace "XPACLENT: couldn't find the functions"
   exit 2
fi

# find locations of necessary files
CRASH_DIR="`queryFileLocation pacrashdir`"



# ----------------------------------
# clean out allthe dumps
# ----------------------------------
echo "directory to clean is" ${CRASH_DIR} v1
echo "running cleancrash"
actzTrace "XPACLENT: ready to run it"
rm -rf ${CRASH_DIR}crash* >/dev/null 2>&1
actzTrace "XPACLENT: done running"

exit 0

