#!/bin/bash

# ejectmedia.sh
#
# Usage: ejectmedia.sh <device file> <log file>
#
# device file: the device file for the device
#
# Return Codes:
# 1 - Error ejecting the media
#
# Author: C. Schuck
#
#  03/17/2005  P. Provost  Fixed tracing

DEVICEFILE=$1
LOGFILE=$2

echo "-> ejectmedia.sh" >> $LOGFILE
actzTrace "XMDA   T: -> ejectmedia.sh"

echo "ejectmedia.sh: Ejecting the media at $DEVICEFILE for `date`" >> $LOGFILE
actzTrace "XMDA   F: ejectmedia.sh: Ejecting the media at $DEVICEFILE for `date`"

# Eject the media
if ! eject -v $DEVICEFILE >> $LOGFILE 2>&1; then

    echo "ejectmedia.sh: Couldn't eject the media...exiting" >> $LOGFILE
    actzTrace "XMDA   F: ejectmedia.sh: Couldn't eject the media...exiting"

    echo "<- ejectmedia.sh for `date`" >> $LOGFILE
    echo "" >> $LOGFILE

    actzTrace "XMDA   T: <- ejectmedia.sh for `date`"

    exit 1
fi

echo "<- ejectmedia.sh for `date`" >> $LOGFILE
echo "" >> $LOGFILE

actzTrace "XMDA   T: <- ejectmedia.sh for `date`"

exit 0

