#!/bin/bash

actzTrace "XSETNETT: getIP.sh $*"

intf=$1

# Run ifconfig to get the IP
line=$(/sbin/ifconfig $intf | grep "inet addr" | sed -e "s/^ \+//" -e "s/:/ /g" -e "s/ \+/ /g");
if [ -n "$line" ]; then
    addr=$(echo "$line" | cut -d' ' -f 3)
    mask=$(echo "$line" | cut -d' ' -f 7)
else
    addr="0.0.0.0"
    mask="0.0.0.0"
fi

actzTrace "XSETNETF: addr=$addr mask=$mask"
echo "$addr $mask"

config_file="/etc/sysconfig/network/ifcfg-$intf"
for ipv6addr in $(ip addr show $intf | grep inet6 | sed -e "s/^[[:space:]]*//" | cut -d' ' -f 2); do
    if ! grep -q "$ipv6addr" $config_file; then
        actzTrace "XSETNETF: getIP.sh found an autoconfigured address: $ipv6addr"
        echo "$ipv6addr"
    else
        actzTrace "XSETNETF: getIP.sh found $ipv6addr in the config file.. must be static"
    fi
done

