#!/bin/bash

actzTrace "XSETNETT: getIPv6Addrs.sh $*"

intf=$1
config_file="/etc/sysconfig/network/ifcfg-$intf"

for ipv6addr in $(ip addr show $intf | grep inet6 | sed -e "s/^[[:space:]]*//" | cut -d' ' -f 2); do
    if ! grep -q "$ipv6addr" $config_file; then
        actzTrace "XSETNETF: getIPv6Addrs.sh found an autoconfigured address: $ipv6addr"
        echo "$ipv6addr"
    else
        actzTrace "XSETNETF: getIPv6Addrs.sh found $ipv6addr in the config file.. must be static"
    fi
done

