#!/bin/bash
#  The ip6tables rule that accepts RELATED and ESTABLISHED packets does not
#  work for all qualified packets. In fact Ipv6 sockets to the EI gateways
#  do not open.  The rule will be added to the ALL-HMC-INPUT chain and will accept
#  all packet from the target address and remote port to the specific local port.
#  The rule will be removed when the connection the socket is associated with
#  is deactivated.
#  This code can be removed when the ip6tables rule has  be fixed.
# $1 = insert or delete the rule
# $2 =  source IP of the packet, EI address
# $3 = remote port number of the socket
# $4 = local port number of socket
if [ -x /sbin/ip6tables ]; then
    iptables=/sbin/ip6tables
elif [ -x /usr/sbin/ip6tables ]; then
    iptables=/usr/sbin/ip6tables
else
    actzTrace "XCHMHACK: rcsIp6tablesRelatedEstablishedRuleHack.sh : No ip6tables executable found."
    exit 5
fi
# $iptables --$1  ALL-HMC-INPUT   --source $2  --protocol tcp --source-port $3 --destination-port $4 -j ACCEPT
 $iptables --$1  ALL-HMC-INPUT   --source $2  --protocol tcp  -j ACCEPT
exit

