#!/bin/bash

actzTrace "XSETFWAT: -> restoreFirewallConfig"

BOOT_CONFIG_FILE=/etc/sysconfig/firewall

if [ -x /sbin/iptables-restore ]; then
    iptablesrestore=/sbin/iptables-restore
elif [ -x /usr/sbin/iptables-restore ]; then
    iptablesrestore=/usr/sbin/iptables-restore
else
    actzTrace "XSETFWAF: restoreFirewallConfig: No iptables-restore executable found."
    exit 0
fi

if [ -e $BOOT_CONFIG_FILE ]; then
    $iptablesrestore < $BOOT_CONFIG_FILE
    rc=$?
else
    actzTrace "XSETFWAF: restoreFirewallConfig: boot config file '$BOOT_CONFIG_FILE' not found"
    exit 0
fi

actzTrace "XSETFWAT: <- restoreFirewallConfig: rc=$rc"

exit $rc
