#!/bin/bash

# scanmedium.sh
#
# Usage: scanmedium.sh <mount point> <medium name>
#
# 00  10/06/2006  J. Kunz  Initial release, use dd command to thoroughly read the medium

MOUNTPOINT=$1
MEDIUMNAME=$2
ANSWER="N"

# ensure we got both parameters
if [ -n "$MEDIUMNAME" ]; then

	# look for the mount point in /etc/fstab
	PATTERN=`echo $MOUNTPOINT | sed -e 's?/?\\\/?g'`
	DEVICEFILE=`cat /etc/fstab | sed -e "/$PATTERN/!d" -e 's/ .*//1' `
	
	if [ -n "$DEVICEFILE" ]; then
	
		echo "You have requested a scan of the $MEDIUMNAME medium for errors."
		# warn about the impacts
        if [ "$MEDIUMNAME" == "CD/DVD" ]; then
			echo "Scanning the $MEDIUMNAME medium for errors could take 30 minutes or more"
			echo "and may impact console performance during that time."
		fi
		echo "Do you wish to proceed (Y/N)?"
		read ANSWER
		
		if [ "$ANSWER" == "y" ]; then
			ANSWER="Y"
		fi
		
		while [ "$ANSWER" == "Y" ]
		do
			echo "Please wait while the $MEDIUMNAME medium is scanned and do not run any tasks"
			echo "that would try to access the $MEDIUMNAME during the scan."
			echo ""
			if ! dd if=$DEVICEFILE bs=16K of=/dev/null 2>&1; then	
		 	    echo "An error was detected while scanning the $MEDIUMNAME medium."	
                echo "Please examine the $MEDIUMNAME medium for any physical damage."
                if [ "$MEDIUMNAME" == "CD/DVD" ]; then
                   echo "Check the $MEDIUMNAME medium for any smudges or fingerprints and clean it if necessary."
                fi
			else	
			    echo "No errors were detected while scanning the $MEDIUMNAME medium."		
			fi
		
            echo ""
			echo "Do you wish to scan another $MEDIUMNAME (Y/N)?"
			echo "If you do, then replace the $MEDIUMNAME medium now and respond when ready:"
	        read ANSWER
		
     		if [ "$ANSWER" == "y" ]; then
	    		ANSWER="Y"
		    fi
		
		done
	else
	   echo "Error, unable to determine the $MEDIUMNAME device location from /etc/fstab using $MOUNTPOINT!"
	fi
else
   echo "Error, missing parameter(s)."
   echo "Usage is: scanmedium <mount point> <medium name>"
fi

exit
