#!/bin/bash

listit () {
   runAsRoot getlabel.sh $2 2>/dev/null
   mount $1 > /dev/null 2>&1
   mountRc=$?
   ls -alHR $1
   if [ $mountRc -eq 0 ]; then
      umount $1 > /dev/null 2>&1
   fi
}

listitdev () {
   runAsRoot getlabel.sh $2 2>/dev/null
   mount -t auto $2 $1
   mountRc=$?
   #echo "mount rc=$mountRc"
   ls -alHR $1
   if [ $mountRc -eq 0 ]; then
      umount $1 > /dev/null 2>&1
   fi
}

device=""
mountpoint=""
foundclass=""
if [ "$1" == "USB" ]; then
   if [ -e "/sys/block" ]; then
      # We need to do things the new way, by using the "Device fike" information
      # in the output of the hwinfo command.
      hwinfo --usb | while read info_line;
      do
         #echo "device=$device foundclass=$foundclass"
         if [ -z "$device" ]; then
            if [ -z "$foundclass" ]; then
               hwclass=`echo $info_line | sed -e '/Hardware Class:/!d' -e 's/.*Hardware Class: //1'`
               #echo "hwclass=$hwclass"
               if [ -n "$hwclass" ]; then
                   if [ "$2" == "$hwclass" ]; then
                     foundclass="yes"
                   fi
               fi
            else
               devfile=`echo $info_line | sed -e '/Device File:/!d' -e 's/.*Device File: //1' -e 's/ .*//1'`
               if [ -n "$devfile" ]; then
                  if [ "$hwclass" == "disk" ]; then
                     device="${devfile}1"
                  else
                     device="$devfile"
                  fi
                  #echo "using device=$device"
                  if [ "$2" == "floppy" ]; then
                     mountpoint="/tmp/console/support/usb/floppy.${RANDOM}"
                  else
                     mountpoint="/tmp/console/support/usb/memorystick.${RANDOM}"
                  fi
                  mkdir -p "${mountpoint}" 2>/dev/null
                  listitdev "${mountpoint}" "$device"
                  rm -fr "${mountpoint}" 2>/dev/null
               fi
            fi
         fi
      done
   else
      # We need to do things the old way by looking in /tc/fstab
      # Look for all of the USB devices to get their associated unique IDs
      hwinfo --usb | while read info_line;
      do
         if [ -z "$device" ]; then
            id=`echo $info_line | sed -e '/Unique ID:/!d' -e 's/.*Unique ID: //1'`
            if [ -n "$id" ]; then
               unique_id=$id
            else
               hwclass=`echo $info_line | sed -e '/Hardware Class:/!d' -e 's/.*Hardware Class: //1'`
               if [ -n "$hwclass" ]; then
                  hw_classes[$i]=$hwclass
                  if [ "$2" == "$hwclass" ]; then
                     pattern=`echo ${unique_id} | sed -e 's?\.?\\\.?g'`
                     devline=`cat /etc/fstab | sed -e "/$pattern/!d"`
                     if [ -n "$devline" ]; then
                        device=`echo "$devline" | cut -f 1 '--delimiter= '`
                        mountpoint=`echo "$devline" | cut -f 2 '--delimiter= '`
                        listit "$mountpoint" "$device"
                     fi
                  fi
               fi
            fi
         fi
      done
   fi
else
   # it is not a USB device, so the mount point was passed in
   mountpoint="$1"
   pattern=`echo $1 | sed -e 's?/?\\\/?g'`
   device=`cat /etc/fstab | sed -e "/$pattern/!d" -e 's/ .*//1'`
   listit "$mountpoint" "$device"
fi

exit 0
