<%--
 This is an error page delivered by the Connect servlet when the user attempts
 to login using a userid that is disabled for logons.  Its job is to display
 an error message.
--%>

<%@taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@taglib prefix="hmc" uri="/WEB-INF/hmc.tld"%>

<%@page session="false"%>   <%-- prevent a session from being created --%>

<fmt:bundle basename="com.ibm.hwmca.fw.servlet.connect.res.connect">
<html>
<head>
   <hmc:title><fmt:message key="useridIsDisabledTitle"/></hmc:title>
   <link href='<%=application.getAttribute("hmcStyleSheet")%>' rel="stylesheet" type="text/css"/>
   <link rel="SHORTCUT ICON" href="/favicon.ico"/>
   <link rel="icon" href="/hmc.png" type="image/png"/>
</head>
<body>
<span class="cont1">
<c:if test="${empty tempMaxInvalid}">
<h1><fmt:message key="useridIsDisabledTitle"/></h1>
<p>
<fmt:message key="useridIsDisabledMessage">
   <fmt:param value="${pageContext.request.userPrincipal.name}"/>
</fmt:message>
</c:if>
<c:if test="${not empty tempMaxInvalid}">
<h1><fmt:message key="useridIsTempDisabledTitle"/></h1>
<p>
<fmt:message key="useridIsTempDisabledMessage">
   <fmt:param value="${pageContext.request.userPrincipal.name}"/>
</fmt:message>
</c:if>

<%@include file="linkToWelcomeOrClose.jsp"%>
</span>
</body>
</html>
</fmt:bundle>
