<%--
 This page is delivered by the RemotePreLogonServlet when it has authenticated
 the provided userid and password and wants to perform the actual logon.  Its
 job is to open a new window which will load the "/hmc/connect" URL.  In the
 current window, it will load a given URL in order to "repeat" the earlier
 request.
--%>

<%@taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@taglib prefix="hmc" uri="/WEB-INF/hmc.tld"%>

<%@page session="false"%>   <%-- prevent a session from being created --%>

<fmt:bundle basename="com.ibm.hwmca.fw.servlet.remotectl.res.remotectl">
<fmt:setBundle basename="com.ibm.hwmca.fw.servlet.connect.res.connect" var="connectBundle"/>
<html>
<head>
   <hmc:title><fmt:message key="performConnectTitle"/></hmc:title>
   <link href='<%=application.getAttribute("hmcStyleSheet")%>' rel="stylesheet" type="text/css"/>

   <script type="text/javascript">
      function process() {
         var newwin = window.open("/hmc/connect?autoLogonToken=${autoLogonToken}&option=closeWindow", "", "width=640,height=480,scrollbars,resizable");
         if (newwin == null) {
            window.alert("<fmt:message key='failedToOpenWindow' bundle='${connectBundle}'/>");
            window.location.replace("${retryURL}?autoLogonCancel=true");

         } else {
            window.location.replace("${retryURL}");
         }
      }
   </script>
</head>
<body onload="process();">
<span class="cont1">
<p><fmt:message key="performConnectMessage"/></p>
</span>
</body>
</html>
</fmt:bundle>
