<%--
 This is a page useful for development only.  The browser is directed to this
 page by TaskList.java when the user asks to display the size of a given task's
 panel.  It is useful when a developer wants to figure out what the ideal size
 of a panel is and what width and height values to specify in the markup for
 the panel.  This JSP will display the panel sizing information and offer a
 button to direct the user back to the "proper" content for the task.

 Note that since it is for development only, the strings on this page are not
 translated.
--%>

<%@page import="com.ibm.hwmca.fw.servlet.util.HMCSession"%>
<%@page import="com.ibm.hwmca.fw.servlet.util.BrowserGeometry"%>
<%@page import="com.ibm.hwmca.fw.servlet.util.TaskWindowPositionManager"%>
<%@page import="com.ibm.hwmca.fw.servlet.pmod.task.PanelModelTaskPortal"%>

<%@taglib prefix="hmc" uri="/WEB-INF/hmc.tld"%>

<%
HMCSession hmcSession = HMCSession.getHMCSession(session);
BrowserGeometry geometry = BrowserGeometry.getBrowserGeometry(hmcSession);
PanelModelTaskPortal portal = hmcSession.getTaskForWindowName(request.getParameter("windowName"));
%>

<html>
<head>
   <hmc:title>Panel Sizing Information for Task <%=portal.getTaskId()%></hmc:title>
   <link href='<%=application.getAttribute("hmcStyleSheet")%>' rel="stylesheet" type="text/css"/>

   <script type="text/javascript">
      function updatePanel() {
         window.location.replace("/hmc/content?windowName="+window.name);
      }
   </script>

   <style>
      .important {
         font-weight: bold;
         color:red;
      }
   </style>
</head>
<body>
<h3>Panel Sizing Information for Task <%=portal.getTaskId()%></h3>

<table frame="border" rules="all" cellpadding="3">
   <tr>
      <th>Description</th>
      <th>Value</th>
   </tr>

   <%
     String clientWidth  = request.getParameter("clientWidth");
     String scrollWidth  = request.getParameter("scrollWidth");
     String clientHeight = request.getParameter("clientHeight");
     String scrollHeight = request.getParameter("scrollHeight");
     boolean haveHorizontalScrollbar = geometry.hasScrollBar(clientWidth, scrollWidth);
     boolean haveVerticalScrollbar = geometry.hasScrollBar(clientHeight, scrollHeight);
   %>

   <tr>
      <td><b class="important">Width to specify in the panel markup
  <% if (haveHorizontalScrollbar) { %>
          if you like the current content width</b></td>
  <% } %>
      <td><b class="important"><%=geometry.getMarkupWidth(clientWidth)%></b></td>
   </tr>

   <tr>
      <td><b class="important">Height to specify in the panel markup
  <% if (haveVerticalScrollbar) { %>
          if you like the current content height</b></td>
  <% } %>
      <td><b class="important"><%=geometry.getMarkupHeight(clientHeight)%></b></td>
   </tr>

  <% if (haveHorizontalScrollbar) { %>
   <tr>
      <td><b class="important">Width to specify in the panel markup, if you
          don't want a horizontal scrollbar</b></td>
      <td><b class="important"><%=geometry.getMarkupWidth(scrollWidth)%></b></td>
   </tr>
  <% } %>

  <% if (haveVerticalScrollbar) { %>
   <tr>
      <td><b class="important">Height to specify in the panel markup, if you
          don't want a vertical scrollbar</b></td>
      <td><b class="important"><%=geometry.getMarkupHeight(scrollHeight)%></b></td>
   </tr>
  <% } %>

  <% if (TaskWindowPositionManager.SCALE_TASK_WINDOWS) { %>
  <%-- If we're not scaling, these numbers will be the same as above, so
       there's no good reason to show them again. --%>
   <tr>
      <td>Width of content area
  <% if (haveVerticalScrollbar) { %>
          (excluding the width of the vertical scroll bar)
  <% } %>
       </td>
      <td><%=clientWidth%></td>
   </tr>

   <tr>
      <td>Height of content area
  <% if (haveHorizontalScrollbar) { %>
          (excluding the height of the horizontal scroll bar)
  <% } %>
      </td>
      <td><%=clientHeight%></td>
   </tr>

  <% if (haveHorizontalScrollbar) { %>
   <tr>
      <td>Preferred width of content area (how wide it wants to be)</td>
      <td><%=scrollWidth%></td>
   </tr>
  <% } %>

  <% if (haveVerticalScrollbar) { %>
   <tr>
      <td>Preferred height of content area (how high it wants to be)</td>
      <td><%=scrollHeight%></td>
   </tr>
  <% } %>
  <% } %>

   <tr>
      <td>Horizontal scaling factor used for this session</td>
      <td><%=geometry.getWindowWidthScalingFactor()%></td>
   </tr>

   <tr>
      <td>Vertical scaling factor used for this session</td>
      <td><%=geometry.getWindowHeightScalingFactor()%></td>
   </tr>
</table>

<p>
   <input type="button" onclick="updatePanel();"
          value="Continue"
          class="b1" onmouseout="className='b1'"
          onmouseover="className='b2'" />
</p>
</body>
</html>
</fmt:bundle>
