<!--
/*********************************************************** {COPYRIGHT-TOP} ***
* Licensed materials - Property of IBM
* Tivoli Presentation Services
*
* (C) Copyright IBM Corp. 2003
*
* US Government Users Restricted Rights - Use, duplication, or
* disclosure restricted by GSA ADP Schedule Contract with
* IBM Corp.
*
* Module History:
* 11/09/2006  JMiller      Initial Release
* 02/16/2007  J. Miller    Rename Maintenance Level to Service Pack
* 03/16/2007  J. Miller    Add Serial Number, Model, and BIOS support
************************************************************ {COPYRIGHT-END} ****/
-->
<%@ page import="com.ibm.hwmca.ui.bonsai.util.hmcversion.HmcVersionInfo,
                 com.ibm.hwmca.fw.util.LocalizableText" %>
<%!
    private static final String HMCVER_BUNDLENAME = "com/ibm/hwmca/ui/bonsai/res/bonsai";
%>

<%
    HmcVersionInfo hmcVerInfo = HmcVersionInfo.getHmcVersionInfo();
    LocalizableText HMCVER                = new LocalizableText( HMCVER_BUNDLENAME, "hmcversion.title");
    LocalizableText HMCVER_VERSION        = new LocalizableText( HMCVER_BUNDLENAME, "hmcversion.version", new String[] { hmcVerInfo.getVersion() } );
    LocalizableText HMCVER_RELEASE        = new LocalizableText( HMCVER_BUNDLENAME, "hmcversion.release", new String[] { hmcVerInfo.getRelease() } );
    LocalizableText HMCVER_SERVICEPACK    = new LocalizableText( HMCVER_BUNDLENAME, "hmcversion.servicepack", new String[] { hmcVerInfo.getServicePack() } );
    LocalizableText HMCVER_BUILDLEVEL     = new LocalizableText( HMCVER_BUNDLENAME, "hmcversion.buildlevel", new String[] { hmcVerInfo.getBuildLevel() } );
    LocalizableText HMCVER_BASEVERSION    = new LocalizableText( HMCVER_BUNDLENAME, "hmcversion.baseversion",    new String[] { hmcVerInfo.getBaseVersion() } );
    LocalizableText HMCVER_MODELTYPE      = new LocalizableText( HMCVER_BUNDLENAME, "hmcversion.modeltype",      new String[] { hmcVerInfo.getModelType() } );
    LocalizableText HMCVER_SERIALNUMBER   = new LocalizableText( HMCVER_BUNDLENAME, "hmcversion.serialnumber",   new String[] { hmcVerInfo.getSerialNumber() } );
    LocalizableText HMCVER_BIOS           = new LocalizableText( HMCVER_BUNDLENAME, "hmcversion.bios",           new String[] { hmcVerInfo.getBIOS() } );
    LocalizableText HMCVER_ADDITIONALINFO = new LocalizableText( HMCVER_BUNDLENAME, "hmcversion.additionalinfo", new String[] { } );

    String hmcver               = HMCVER.toString(request.getLocale());
    String hmcverVersion        = HMCVER_VERSION.toString(request.getLocale());
    String hmcverRelease        = HMCVER_RELEASE.toString(request.getLocale());
    String hmcverServicePack    = HMCVER_SERVICEPACK.toString(request.getLocale());
    String hmcverBuildLevel     = HMCVER_BUILDLEVEL.toString(request.getLocale());
    String hmcverBaseVersion    = HMCVER_BASEVERSION.toString(request.getLocale());
    String hmcverModelType      = HMCVER_MODELTYPE.toString(request.getLocale());
    String hmcverSerialNumber   = HMCVER_SERIALNUMBER.toString(request.getLocale());
    String hmcverBIOS           = HMCVER_BIOS.toString(request.getLocale());
    String hmcverAdditionalInfo = HMCVER_ADDITIONALINFO.toString(request.getLocale());
    String hmcverFixes          = "";

    String[] fixes = hmcVerInfo.getFixes();
    if ( fixes != null && fixes.length > 0 ) {
        hmcverFixes = fixes[0];
        for( int i = 1; i < fixes.length; i++ ) {
            hmcverFixes = hmcverFixes + "<br>" + fixes[i];
        }
        hmcverAdditionalInfo = hmcverAdditionalInfo + "<br />" + hmcverFixes;
    } else {
        hmcverAdditionalInfo = "";
    }
%>
    <a href="#" class="popup"><%= hmcver %><span>
        <p><%= hmcverVersion        %><br />
           <%= hmcverRelease        %><br />
           <%= hmcverServicePack    %><br />
           <%= hmcverBuildLevel     %><br />
           <%= hmcverBaseVersion    %><br />
           <%= hmcverModelType      %><br />
           <%= hmcverSerialNumber   %><br />
           <%= hmcverBIOS           %><br />
           <%= hmcverAdditionalInfo %></p>
    </span></a>
