<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<!--<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">-->

<!--
/*********************************************************** {COPYRIGHT-TOP} ***
 * Licensed materials - Property of IBM
 * Tivoli Presentation Services
 *
 * (C) Copyright IBM Corp. 2003
 *
 * US Government Users Restricted Rights - Use, duplication, or
 * disclosure restricted by GSA ADP Schedule Contract with
 * IBM Corp.
 *
 * Module History:
 *   11/07/2007     J. Jenks        Initial release.
 *
 ************************************************************ {COPYRIGHT-END} ****/
-->
<%@taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>

<%@ page import="java.util.*,
                 com.ibm.hwmca.fw.managed.HwmcaObjectUIProperties,
                 com.ibm.hwmca.fw.servlet.util.HMCSession,
                 com.ibm.hwmca.fw.servlet.util.ServletRuntime,
                 com.ibm.hwmca.fw.settings.user.BonsaiUserSettings,
                 com.ibm.hwmca.fw.ui.UIInfo,
                 com.ibm.hwmca.fw.util.LocalizableText,
                 com.ibm.hwmca.ui.bonsai.BonsaiUIStyle,
                 com.ibm.hwmca.ui.bonsai.earth.BonsaiTreeManager,
                 com.ibm.hwmca.ui.bonsai.earth.BonsaiTreeNode,
                 com.ibm.hwmca.ui.bonsai.servlet.NavigationAction,
                 com.ibm.hwmca.ui.bonsai.servlet.WorkareaAction,
                 com.ibm.hwmca.ui.bonsai.servlet.util.UserObject,
                 com.ibm.hwmca.ui.bonsai.table.NameTableCellBean,
                 com.ibm.hwmca.ui.bonsai.table.TableRowPropertyMap,
                 com.ibm.hwmca.ui.bonsai.util.GraphicsConstants,
                 com.ibm.hwmca.ui.bonsai.util.SettingsRetriever"%>

<% response.flushBuffer(); %>

<fmt:bundle basename="com.ibm.hwmca.ui.bonsai.res.bonsai">

<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">

<!-- ===========================================================================
  This JSP is a view.  That is, the WclFacade and all data is defined inside a
  controller Servlet.

  The purpose of this JSP is to display all children in a
  style similar to that of the categorized tasks view.  However, no listening
  or dynamic updating is done, so this should only be used in cases where such
  things are not necessary.
  ========================================================================== -->

<%
    // attach the user context to this thread
    ServletRuntime.getRuntime().attachUserContextToServletThread(request);

    // get the user's session data
    HMCSession hmcSession = HMCSession.getHMCSession(session);
    UserObject userObj = UserObject.getUserObject(hmcSession);

    // get and set the body direction based on the locale
    String bodyDir = java.awt.ComponentOrientation.getOrientation(request.getLocale()).isLeftToRight() ? "ltr" : "rtl";
    pageContext.setAttribute("bodyDir", bodyDir);
%>

<head>

<link href="/css/ui/bonsai/categorizedtasks.css" rel="stylesheet" type="text/css" />
<link href="/css/ui/bonsai/bonsai.css" rel="stylesheet" type="text/css" />
<link href="/css/ui/bonsai/popup.css" rel="stylesheet" type="text/css" />

<script src="/js/ui/bonsai/nodrag.js" type="text/javascript"></script>
<script src="/js/ui/bonsai/utilities.js" type="text/javascript"></script>
<script src="/js/ui/bonsai/navcursor.js" type="text/javascript"></script>
<script src="/js/ui/bonsai/categorizedtasks.js" type="text/javascript"></script>
<script src="/js/ui/bonsai/asyncjsonrefresh.js" type="text/javascript"></script>

</head>

<%
    BonsaiUserSettings bonsaiSettings = SettingsRetriever.getBonsaiUserSettings(hmcSession);

    BonsaiTreeNode node = null;
    List<TableRowPropertyMap> rows = null;
    UIInfo uiInfo = null;
    StringBuffer bodyStyle = new StringBuffer();
    if ((node=BonsaiTreeManager.getBonsaiTreeManager().getTreeNode(userObj.getTreeSelection())) != null) {
        // get the configured body style info
        try {
            Map.Entry style = null;
            for (Iterator i = WorkareaAction.getURIStyle(node.getWorkarea()).entrySet().iterator(); i.hasNext(); ) {
                style = (Map.Entry)i.next();
                bodyStyle.append((String)style.getKey());
                bodyStyle.append(": ");
                bodyStyle.append((String)style.getValue());
                if (i.hasNext())
                    bodyStyle.append("; ");
            }
        } catch (IllegalArgumentException iaEx) {
            // workarea must have changed since we were asked to render, so ignore
        }

        // get the children and their properties to display on the page
        rows = BonsaiTreeManager.getBonsaiTreeManager().getTableProperties(node, userObj);

        // get the info for the page title
        uiInfo = node.getUIInfo();
    } else {
        rows = Collections.emptyList();
        uiInfo = new UIInfo(new LocalizableText(""), new LocalizableText(""));
    }
%>
<body style="<%= bodyStyle.toString() %>" onmousemove="navOnMouseMove('west');" onmouseout="navOnMouseOut();" dir="<c:out value='${bodyDir}'/>">
    <div id="bodyOuterDiv">
    <div id="bodyInnerDiv">
    <c:set var="showIcons" scope="page"><%= bonsaiSettings.isShowWorkareaIcons() %></c:set>

    <table width="100%">
        <tr>
            <td>
                <span class="ct_title"><%= uiInfo.getName( userObj.getLocale() ).replace( '\n', ' ' ) %></span>
                &nbsp;&nbsp;(&nbsp;<jsp:include page="/ui/bonsai/phmc-hmcversionpopup.jsp"></jsp:include>&nbsp;)
            </td>
            <td></td>
        </tr>
    </table>

    <table class="ct_tbl" id="ct_tbl">
        <tr class="ct_rootspacer"><td colspan="2"><img src="<%= GraphicsConstants.getTransparentIcon() %>" /></td></tr>
<%
    for (TableRowPropertyMap rowMap : rows) {
        if (!rowMap.isHidden()) {
            NameTableCellBean nameBean = (NameTableCellBean)rowMap.get(HwmcaObjectUIProperties.NAME_PROPERTY);
            String altText = new LocalizableText(BonsaiUIStyle.BUNDLE_NAME, "view.open.alt", new String[] {nameBean.getText()}).toString(userObj.getLocale());
            String caption = (String)rowMap.get(HwmcaObjectUIProperties.CAPTION_PROPERTY);
%>
        <tr onmouseover="this.style.backgroundColor='#eee';" onmouseout="this.style.backgroundColor='';">
            <td class="ct_taskname"><span><c:if test="${showIcons}"><a href="<%= nameBean.getOpenUrl() %>" title="<%= altText %>" alt="<%= altText %>" target="<%= NavigationAction.FRAME_NAME %>"><img border="0" width="16" height="16" src="<%= nameBean.getImageUrl() %>" /></a></c:if><a href="<%= nameBean.getOpenUrl() %>" title="<%= altText %>" alt="<%= altText %>" target="<%= NavigationAction.FRAME_NAME %>"><%= nameBean.getText() %></a></span></td>
            <td class="ct_taskdesc"><span title="<%= caption %>"><img border="0" width="16" height="16" src="<%= GraphicsConstants.getMiddotImageIcon() %>" /><%= caption %></span></td>
        </tr>
<%
        }
    }
%>
    </table>

    </div>
    </div>
</body>

</html>

</fmt:bundle>
