<%--
 PreLoginMonitor page for ip Director, contained in the Welcome Page (index.html) frameset.

 Module History:
 11/22/2006  J. Stapels   initial release
 03/22/2007  J. Miller    make status indicator icons/text hyperlinks to launch /hmc/connect
 04/26/2007  J. Jenks     updates for move to Tomcat 5.5
 05/16/2007  J. Jenks     make cursor the hand when hovering over icon
 06/14/2007  J. Stapels   renamed resource bundle
--%>

<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="ISO-8859-1" %>
<%@ page errorPage="errorpage.jsp" %>
<%@ page session="false" %>

<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>

<% response.flushBuffer(); %>

<fmt:bundle basename="com.ibm.hwmca.p.servlet.preloginmonitor.res.ipPreLoginMonitor">

<jsp:useBean id="statusBean" class="com.ibm.hwmca.p.servlet.preloginmonitor.PreLoginMonitorData">
    <jsp:setProperty name="statusBean" property="locale" value="<%= request.getLocale() %>" />
</jsp:useBean>

<%-- Ajax Grabber --%>

<%
if (request.getParameter( "update" ) != null) {

    response.setContentType( "text/javascript" );
%>

{
    "systemStatus"        : <jsp:getProperty name="statusBean" property="systemStatusGood" />,
    "systemMessage"       : "<jsp:getProperty name="statusBean" property="systemMessage" />",
    "attentionsStatus"    : <jsp:getProperty name="statusBean" property="attentionsStatusGood" />,
    "attentionsMessage"   : "<jsp:getProperty name="statusBean" property="attentionsMessage" />",
    "serviceablesStatus"  : <jsp:getProperty name="statusBean" property="serviceablesStatusGood" />,
    "serviceablesMessage" : "<jsp:getProperty name="statusBean" property="serviceablesMessage" />"
}

<% } else { %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<!-- BEGIN HTML -->
<html>
<head>
    <c:set var="sourcePage" scope="request" value="${pageContext.request.requestURI}" />

    <link href='<%=application.getAttribute("hmcStyleSheet")%>' rel="stylesheet" type="text/css"/>

    <style>

    /*
        COLORS
        good #0c0
        critical #f00
        attentions #cc0
        serviceables #f90
    */

    * {
        margin: 0px;
        padding: 0px;
        font-family: Helvetica, Arial, sans-serif;
        font-size: 12px inherit;
    }

    body { }


    a:link {
        color: #FFFFFF;
        text-decoration: none;
    }
	
    a:visited {
        color: #FFFFFF;
        text-decoration: none;
    }

    a:hover {
        color: #FFFFFF;
        text-decoration: underline;
    }

    a:active  {
        color: #FFFFFF;
        text-decoration: none;
    }

    ul {
        list-style-type: none;
        margin-top: 50px;
        margin: 0px auto;
    }

    .status li {
        margin: 0px 12px 12px;
        padding: 4px;
        /*background-color: #fff;*/
    }

    .status li.heading {
        margin: 0px;
        height: auto;
        border: none;
        background: none;
        font-size: 16px;
        font-weight: bold;
    }

    .status a.icon {
        display: block;
        width: 32px;
        height: 32px;
        float: left;
        z-index: 1;
        background-image: url(/images/fw/prelogin/okayIcon.gif);

        /* IE6 fixes for float and z-index bugs */
        margin-right: 0px !important;
        margin-right: -16px;
        position: static !important;
        position: relative;
    }

    .status h2 {
        margin: 7px 0px 0px 16px;
        padding: 1px 0px 0px 20px;
        height: 16px;
        background-color: #1e814d;
        background-image: url(/images/fw/prelogin/okayBar.gif);
        background-position: top right;
        background-repeat: repeat-y;
        border-width: 0px 0px 2px 0px;
        border-style: solid;
        border-color: #1e814d;
        color: #fff;
        font-size: 14px;
        font-weight: bold;
    }

    .status p {
        margin: 0px 0px 0px 36px;
        font-size: 12px;
    }

    #system.bad a.icon { background-image: url(/images/fw/prelogin/errorIcon.gif); }
    #system.bad h2       { border-color: #a91d20; background-color: #a91d20; background-image: url(/images/fw/prelogin/errorBar.gif); }

    #attentions.bad a.icon { background-image: url(/images/fw/prelogin/warningIcon.gif); }
    #attentions.bad h2       { /*color: #000;*/ border-color: #f5b84f; background-color: #f5b84f; background-image: url(/images/fw/prelogin/warningBar.gif); }

    #serviceables.bad a.icon { background-image: url(/images/fw/prelogin/serviceIcon.gif); }
    #serviceables.bad h2       { border-color: #905f37; background-color: #905f37; background-image: url(/images/fw/prelogin/serviceBar.gif); }

    </style>

    <script type="text/javascript" src="/js/tools/AsyncJson.js"><!-- AsynJson.js --></script>

    <script type="text/javascript">
    <!--

    var SECONDS_TILL_UPDATE = 15;

    /**
     * Sends a request to get updated information.
     */
    var sendRequest = function() {
    	try {
			new AsyncJson( "/preloginmonitor/status.jsp?update=true", processRequest );
		}
		catch( e ) {
			// It appears that using XMLHttpRequest has failed so instead simply reload the webpage.
			window.location.reload();
		}
    }

    /**
     * Process the request received back from the server.
     */
    var processRequest = function( data ) {

    	if (data != null) {
            var elem = null;

            elem = document.getElementById( "system" );
            if (elem.className != (data.systemStatus ? "" : "bad"))
                elem.className = data.systemStatus ? "" : "bad";

            elem = document.getElementById( "systemMessage" );
            if (elem.innerHTML != data.systemMessage)
                elem.innerHTML = data.systemMessage;

            elem = document.getElementById( "attentions" );
            if (elem.className != (data.attentionsStatus ? "" : "bad"))
                elem.className = data.attentionsStatus ? "" : "bad";

            elem = document.getElementById( "attentionsMessage" );
            if (elem.innerHTML != data.attentionsMessage)
                elem.innerHTML = data.attentionsMessage;

            elem = document.getElementById( "serviceables" );
            if (elem.className != (data.serviceablesStatus ? "" : "bad"))
                elem.className = data.serviceablesStatus ? "" : "bad";

            elem = document.getElementById( "serviceablesMessage" );
            if (elem.innerHTML != data.serviceablesMessage)
                elem.innerHTML = data.serviceablesMessage;

            window.setTimeout( "sendRequest()", SECONDS_TILL_UPDATE * 1000 );
    	}

    	else {
    		var body = document.getElementById( "body" );
    		body.innerHTML = "<br /><br /><div style='text-align:center;'><b><fmt:message key="hmcCommunicationFailed" /></b></div>";
   		}
    }

    window.setTimeout( "sendRequest()", SECONDS_TILL_UPDATE * 1000 );
    -->
    </script>
</head>

<%
  String bodyDir = java.awt.ComponentOrientation.getOrientation(request.getLocale()).isLeftToRight() ? "ltr" : "rtl";
  pageContext.setAttribute("bodyDir", bodyDir);
%>

<body dir="<c:out value='${bodyDir}'/>">

<ul class="status">
    <li id="system" <%= statusBean.isSystemStatusGood() ? "" : "class=\"bad\"" %>>
        <a class="icon" href="/hmc/connect" target="_parent"></a>
        <h2><a href="/hmc/connect" target="_parent"><fmt:message key="systemStatusTitle" /></a></h2>
        <p id="systemMessage"><jsp:getProperty name="statusBean" property="systemMessage" /></p>
    </li>
    <li id="attentions" <%= statusBean.isAttentionsStatusGood() ? "" : "class=\"bad\"" %>>
        <a class="icon" href="/hmc/connect" target="_parent"></a>
        <h2><a href="/hmc/connect" target="_parent"><fmt:message key="attentionsStatusTitle" /></a></h2>
        <p id="attentionsMessage"><jsp:getProperty name="statusBean" property="attentionsMessage" /></p>
    </li>
    <li id="serviceables" <%= statusBean.isServiceablesStatusGood() ? "" : "class=\"bad\"" %>>
        <a class="icon" href="/hmc/connect" target="_parent"></a>
        <h2><a href="/hmc/connect" target="_parent"><fmt:message key="serviceablesStatusTitle" /></a></h2>
        <p id="serviceablesMessage"><jsp:getProperty name="statusBean" property="serviceablesMessage" /></p>
    </li>
</ul>

</body>
</html>
<!-- END HTML -->

<% } %>
</fmt:bundle>
