<%--
 This is the HMC Welcome page.
--%>

<%@taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@taglib prefix="hmc" uri="/WEB-INF/hmc.tld"%>
<%@page session="false" %>   <%-- prevent a session from being created --%>

<fmt:bundle basename="com.ibm.hwmca.fw.servlet.preloginmonitor.res.preloginmonitor">

<jsp:useBean id="statusBean"
		class="com.ibm.hwmca.fw.servlet.preloginmonitor.PreLoginMonitor"
        scope="application">
</jsp:useBean>
<html>
<head>
  <link href='<%=application.getAttribute("hmcStyleSheet")%>' rel="stylesheet" type="text/css"/>
  <!--<hmc:title><jsp:getProperty name='statusBean' property='welcomeTitle'/></hmc:title>-->
  <hmc:title><%= statusBean.getWelcomeTitle(request.getLocale()) %></hmc:title>
  <link rel="SHORTCUT ICON" href="/favicon.ico"/>
  <link rel="icon" href="/hmc.png" type="image/png"/>
  <style type="text/css">
     .customerWelcomeText {
         border-color: #484ba4;
         border-style: solid none solid none;
         border-width: 4;
         margin-top: 1;
         background-image: none;
         background: white;
     }

     .customerWelcomeTextPre {
         margin: 0;
         font-family: serif;
         font-size: 100%;
         height: 90;
         overflow: auto;
         padding-right: 4;
     }

     .welcomeBodyClass {
         background-image: url(/preloginmonitor/welcomeBackground.png);
     }
  </style>
  <c:set var="customerWelcomeText" value="${statusBean.customerWelcomeText}"/>
  <script type="text/javascript">
   function maximizeWelcomeText() {
     <c:if test="${not empty customerWelcomeText}">
      var displayAreaHeight = -1;
      if ("clientHeight" in document.body) {
         displayAreaHeight = document.body.clientHeight;
      } else if ("innerHeight" in window) {
         displayAreaHeight = window.innerHeight;
      }

      var currentHeight = -1;
      var bodyTable = document.getElementById("wholeBody");
      if ("offsetHeight" in bodyTable) {
         currentHeight = bodyTable.offsetHeight;
      } else if ("offsetHeight" in document.body) {
         currentHeight = document.body.offsetHeight;
      } else if ("height" in window.document) {
         currentHeight = window.document.height;
      }

      if (displayAreaHeight != -1 && currentHeight != -1) {
         var extraPad = window.navigator.userAgent.indexOf("MSIE") != -1;
         <%-- Pad should be 17 for Firefox; 30 for IE --%>
         var pad = extraPad ? 30 : 17;

         if (displayAreaHeight - currentHeight > pad) {
            var cwt = document.getElementById("cwt");

            var increase = displayAreaHeight - currentHeight - pad;
            cwt.style.height = cwt.offsetHeight + increase;
         }
      }
     </c:if>
   }
  </script>
</head>
<%
  String bodyDir = java.awt.ComponentOrientation.getOrientation(request.getLocale()).isLeftToRight() ? "ltr" : "rtl";
  pageContext.setAttribute("bodyDir", bodyDir);
%>
<body onload="maximizeWelcomeText()" class="welcomeBodyClass" dir="<c:out value='${bodyDir}'/>">
<%--
 This <table> tag is here so we can measure the actual height of the document,
 since IE doesn't seem to return the correct value for document.body.offsetHeight
--%>
<table id="wholeBody" width="100%" cellspacing="0" cellpadding="0" cols="1">
<tr><td valign=\"top\">
<!-- <c:set var="title" value="${statusBean.welcomeTitle}"/> -->
<!--<c:set var="title" value="<%= statusBean.getWelcomeTitle(request.getLocale()) %>"/>-->
<hmc:banner bannerTitleIcon="/hmc.png" bannerTitle='<%= statusBean.getWelcomeTitle(request.getLocale()) %>'/>
<!--<hmc:banner bannerTitleIcon="/hmc.png" bannerTitle='<%= (String) pageContext.getAttribute("title") %>'/>-->
<c:if test="${not empty customerWelcomeText}">
<div class="customerWelcomeText" height="50%">
<c:if test="${statusBean.customerWelcomeTextAutoReflow}">
<div id="cwt" class="customerWelcomeTextPre">
<c:out value="${statusBean.customerWelcomeText}" escapeXml="false" />
</div>
</c:if>
<c:if test="${!statusBean.customerWelcomeTextAutoReflow}">
<pre id="cwt" class="customerWelcomeTextPre">
<c:out value="${statusBean.customerWelcomeText}" />
</pre>
</c:if>
</div>
</c:if>
<div height="50%">
<!-- <jsp:getProperty name='statusBean' property='welcomePage'/> -->
<%= statusBean.getWelcomePage(request.getLocale()) %>
</div>
</td></tr></table>
</body>
</html>
</fmt:bundle>
