
/**************************************************************************/
/* Handle multiple handlers for the onload event                          */
/* NOTE : This will not work with the body tag defines an onload handler. */
/**************************************************************************/
function hmcAddLoadEvent( func ) {
   var oldonload = window.onload;
   if ( typeof window.onload != 'function' ) {
      window.onload = func;
   } // end if
   else {
      window.onload = function() { try {oldonload()} catch (e) {}; func(); }   ;
   } // end else
} // hmcAddLoadEvent()


/*************************************************/
/* Methods for handling multiple event listeners */
/*************************************************/
/* if this javascript has already been referenced, do not re-reference ... */
if ( !window.hmcObjects ) {
   window.hmcObjects = []; /* array of objects that have registered listeners */
   /***********************************************************************/
   /* Add an event listener to specified object                           */
   /* source = object where listener will be attached                     */
   /* type   = type of the event, for example "load"                      */
   /* handler = function to be called when event is raised                */
   /* disable = boolean, if true, then do not use addEventListener method */
   /***********************************************************************/
   window.hmcAddEvent = function( source, type, handler, disable ) {
      var method   = "addEventListener";
      var fullType = "on" + type;
      disable = true;  // testing only !!!
      /* use built-in javascript addEventListener method? */
      if ( source[ method ] && !disable ) {
         return source[ method ]( type, handler, false );
      } /* end if */
      /* handle the listener management ourselves ... */
      else {
         /* does this object have any registered listeners? */
         if ( !source.hmcEvents ) {
            source.hmcEvents = {};     /* object containg all event listeners */
            hmcObjects[ hmcObjects.length ] = source;
         } /* end if */
         /* does this object have any registered listeners of the specified type? */
         var hmcEventTypes = source.hmcEvents[ type ];
         if ( !hmcEventTypes ) {
            hmcEventTypes = source.hmcEvents[ type ] = [];
         } /* end if */
         /* initialize handlers array for this type of listener */
         var hmcEventHandlers = hmcEventTypes[ hmcEventTypes.length - 1 ];
         /* does this object have any registered listeners not currently    */
         /* managed by EventManager?  That is, old-style listeners such as: */
         /*    <body onload="onloadHandler();">                             */
         if ( source[ fullType ] && source[ fullType ].hmcManaged ) {
            hmcEventHandlers[ hmcEventHandlers.length ] = handler;
         } /* end if */
         else {
            /* get all the handlers for this event type */
            hmcEventHandlers =
               hmcEventTypes[ hmcEventTypes.length ] =
               source[ fullType ] ? [ source[ fullType ], handler ] : [ handler ];
            /**************************************************************/
            /****** Create a manager function for this type of event ******/
            /**************************************************************/
            source[ fullType ] = function( e ) {
               var result = true;
               e = e || window.event;  /* IE does not present event on method */
               /* run all handlers in order of assignment */
               for ( var i = 0; i < hmcEventHandlers.length; i++ ) {
                  source.hmcHandler = hmcEventHandlers[i];
//                alert( source.hmcHandler );
                  result = ( source.hmcHandler(e) != false ) && result;
               } /* end for */
               return result;
            };
            /* mark this event type as managed by EventManager */
            source[ fullType ].hmcManaged = 1;
         } /* end else */
      } /* end else */
   }; /* hmcAddEvent */
   /*****************************************************/
   /* Clean up any registered listeners so as not cause */
   /* IE to crash with an out-of-memory situation.      */
   /*****************************************************/
   window.hmcCleanupEvents = function() {
      var source, type;
      for ( i = 0; i < hmcObjects.length; i++ ) {
         source = hmcObjects[i];
         for ( type in source.hmcEvents ) {
            source[ "on" + type ] = null;
         } /* end for */
         source.hmcEvents = source.hmcHandler = null;
      } /* end for */
   }; /* hmcCleanupEvents */
   /* Register the event to cleanup when the page unloads */
   hmcAddEvent( window, "unload",
                function(){ hmcAddEvent( window, "unload", hmcCleanupEvents )} );
} /* end if */


