// Certain functions in this file use functions defined in dynamic.js
var saveIndex = 0;
var winInfoList = new Object();

function saveWinInfo(info) {
   index = saveIndex++;
   winInfoList[index] = info;
   return index;
}

function getWinInfo(index) {
   if (index in winInfoList)
      return winInfoList[index];
   else
      return null;
}

function removeWinInfo(index) {
   if (index in winInfoList)
      delete winInfoList[index];
}

function markWindowCloseHandled(taskwinname) {
   for (var index in winInfoList) {
      if (winInfoList[index].checkingWindowName == taskwinname) {
         winInfoList[index].closeIsHandled = true;
      }
   }
}

function processTaskWindowUnload(taskwin) {
//window.alert("in processTaskWindowUnload()");
   // We copy some window properties to the info object now because IE won't
   // let us fetch them later.  Apparently, the only valid use of the Window
   // object after onunload returns in IE is to read the Window.closed property.
   info = new Object();
   info.checkingWindow = taskwin;
   info.checkingWindowName = taskwin.name;
   info.checkingWindowCount = 1000;       // Check every 10ms for 1 second
   info.taskId = taskwin.hmcTaskId;
   info.closeIsHandled = false;

   // We can't just pass the info object as an argument to the
   // checkForWindowClosed() function, so we must resort to this indirect
   // scheme, since we can pass a simple index.
   index = saveWinInfo(info);
   taskwin.closeHandled = true; //-opera
   info.timeoutObj = window.setTimeout("checkForWindowClosed("+index+")", 10);
}

function isWindowClosed(windowHandle) {
   // Recent versions of IE give exceptions checking the closed property of
   // a closed window, so we wrap the check in a try/catch and assume the
   // window is closed if an exception is encountered.  Some versions return
   // null for a closed window, so we handle that as well.
   try {
      var isClosed = windowHandle.closed;
      return isClosed == null ? true : isClosed;

   } catch (e) {
      return true;
   }
}

function checkForWindowClosed(index) {
//window.alert("in checkForWindowClosed");
   info = getWinInfo(index);
   if (info == null) {
//    window.alert("Got an interval event for an unknown task window index");
      // We don't renew the timeout, so we shouldn't get more events.
      return;
   }

   info.checkingWindowCount -= 10;

   if (isWindowClosed(info.checkingWindow)) {
      if (!info.closeIsHandled) {
         info.closeIsHandled = true;
         markWindowCloseHandled(info.checkingWindowName);

//       window.alert("Window shows closed after "+
//                    (1000-info.checkingWindowCount)+" milliseconds.  isWindowClosed(info.checkingWindow) == "+isWindowClosed(info.checkingWindow));
         processWindowClosed(info.taskId);

      } else {
//       window.alert("Window close already handled.");
      }
      removeWinInfo(index);
      return;
   }

   if (info.checkingWindowCount <= 0) {
//    window.alert("Window doesn't show closed.");
      removeWinInfo(index);

   } else {
      info.timeoutObj = window.setTimeout("checkForWindowClosed("+index+")", 10);
   }
}

function processWindowClosed(taskId) {
   var request = newHttpRequest();
   if (request != null) {
      // Use the XMLHttpRequest object to send the notification to the server
      request.open("GET", "/hmc/task?op=windowclose&taskId="+taskId);
      // There's no need to process any response.
      request.send(null);

   } else {
      // Send the notification the old way.  The server will respond with
      // JavaScript that closes this window.
      var tempwin = window.open("/hmc/task?op=windowclose&taskId="+taskId, "", "width=1,height=1,top="+screen.availHeight+",left="+screen.availWidth);
      tempwin.blur();
   }
}

function processMainWindowUnloaded(logoffAnnounceMsg) {
   // This method is used for both onunload and onbeforeunload.  We don't
   // actually want it to be called twice, but it's hard to know in advance
   // if a browser supports onbeforeunload, so we assign them both.  If we're
   // running as a beforeunload handler, therefore, we'll delete the onunload
   // property to prevent us from running again.  We do this in all
   // cases, actually, since it doesn't hurt.
   try {
      delete window.onunload;
   } catch (e) {
      // Ignore exception.
   }

   // A Logoff/Disconnect operation will close our window programmatically.
   // That operation first sets the hmcWindowIsClosed variable, so we use that
   // flag to know that this window close is intentional and that we should not
   // pop open a new window to prompt the user to logoff.
   if ("hmcWindowIsClosed" in window) {
      return;
   }

   window.hmcWindowIsClosed = "Y";

   windowName = new Date().getTime();
   var tempwin = window.open("", "mainlogoff_"+windowName, "width=500,height=500,scrollbars,resizable,top="+((screen.availHeight-500)/2)+",left="+((screen.availWidth-500)/2));

   var doc = tempwin.document;
   doc.writeln('<html><head>');
   doc.writeln('<script type="text/javascript">');
   doc.writeln('  function checkForMainWindowClose() {');
   doc.writeln('    var mwclosed = false;');
   doc.writeln('    /* Some versions of IE raise an exception on the following check */');
   doc.writeln('    try {');
   doc.writeln('       mwclosed = window.opener==null || window.opener.closed;');
   doc.writeln('    } catch (e) {');
   doc.writeln('       mwclosed = true;');
   doc.writeln('    }');
   doc.writeln('    if (mwclosed) {')
   doc.writeln('      window.location.replace("/hmc/task?op=mainwindowclose&windowname=mainlogoff_'+windowName+'");');
   doc.writeln('    } else {');
   doc.writeln('      window.close();');
   doc.writeln('    }');
   doc.writeln('  }');
   doc.writeln('  window.setTimeout("checkForMainWindowClose()", 50);');
   doc.writeln('</script>');
   doc.writeln('</head><body>');
   doc.writeln(logoffAnnounceMsg);
   doc.writeln('</body></html>');
   doc.close();
   tempwin.focus();
}

//-opera start
function makeHiddenWindow(mainWindow)
{
   userAgent  = navigator.userAgent.toLowerCase();
   isOpera    = ( userAgent.indexOf( "opera" ) != -1 );
   if (isOpera) {
      hiddenWin = window.open('', "hidden_window", 'height=1,width=1,top=0,left=0');
      doc = hiddenWin.document;
      doc.open();
      doc.writeln('<html><head><title>   </title></head><body>');
      doc.writeln('<script type="text/javascript">');
      doc.writeln('  var closedCount = 0;');
      doc.writeln('  var mainWindowChecker;');
      doc.writeln('  var mainWindow = window.open("", "'+mainWindow.name+'");');
      doc.writeln('  function monitorMainWindow() {');
      doc.writeln('    //window.alert("mainWindow="+mainWindow+"; closedCount="+closedCount);');
      doc.writeln('    if (mainWindow.closed != false) {');
      doc.writeln('      closedCount++;');
      doc.writeln('      if (closedCount > 2) {');
      doc.writeln('        window.moveBy(500+((screen.availWidth-500)/2), 500+((screen.availHeight-500)/2));');
      doc.writeln('        window.focus();');
      doc.writeln('        window.location.replace("/hmc/task?op=mainwindowclose&windowname=mainlogoff_local");');
      doc.writeln('      } else {');
      doc.writeln('        mainWindowChecker = window.setTimeout("monitorMainWindow()", 1000);');
      doc.writeln('      }');
      doc.writeln('    } else {');
      doc.writeln('      mainWindowChecker = window.setTimeout("monitorMainWindow()", 1000);');
      doc.writeln('    }');
      doc.writeln('  }');
      doc.writeln('  mainWindowChecker = window.setTimeout("monitorMainWindow()", 1000);');
      doc.writeln('  //window.alert("initial alert");');
      doc.writeln('</script>');
      doc.writeln('</body></html>');
      doc.close();
      hiddenWin.moveBy(-500, -500);
   }
}
var traceWin = null;
var doTracing = 0;
var taskWinIndex = 0;
var taskWinList = new Object();
var taskWinChecker = null;
//window.setTimeout("makeHiddenWindow(window)", 3000);

function mainTrace(data)
{
   if (doTracing == 1) {
      if (traceWin == null) {
         traceWin = window.open("", "opera_tracewin", "width=500,height=500,top=1,left=1");
         traceWin.document.writeln("<html><head><title>Main Trace Window</title></head><body><pre>");
      }
      traceWin.document.writeln(data);
   }
}

function registerTaskWindow(taskWin, taskId) {
    found = -1;
    for (i=0; ((i<taskWinIndex) && (found == -1)); i++) {
        if (taskWinList[i] != null) {
            if (taskId == taskWinList[i].taskId) {
                found = i;
            }
        }
    }
    if (found == -1) {
        mainTrace("registering task window: "+taskWin.name+" with id "+taskId);
        taskinfo = new Object();
        taskinfo.count = 0;
        taskinfo.registered = false;
        taskinfo.taskWindow = taskWin;
        taskinfo.taskWindowName = taskWin.name;
        taskinfo.taskId = taskId;
        taskWinList[taskWinIndex] = taskinfo;
        taskWinIndex++;
        if (taskWinIndex > 0) {
            mainTrace("scheduling check for "+taskWinIndex+" index");
            taskWinChecker = window.setTimeout("checkForTaskWindowsClosed()", 1000);
        }
        try {
           if ("appletReady" in this.frames.hmcTaskController) {
              tcapplet = this.frames.hmcTaskController.document.applets[0];
              if (tcapplet != null) {
                 tcapplet.registerTaskWindow(taskWin.name);
              }
              taskinfo.registered = true;
              mainTrace("registering with applet; task window: "+taskWin.name+" with id "+taskId);
           }
        }
        catch (ex) {
           mainTrace("caught exception registering with applet; task window: "+taskWin.name+" with id "+taskId+"\n\n"+ex);
        }
    }
}

function checkForTaskWindowsClosed()
{
    windowCount=0;
    //mainTrace("checking for closed task windows");
    for (i=0; i<taskWinIndex; i++) {
        //mainTrace("checking index "+i);
        if (taskWinList[i] != null) {
            //mainTrace("closed value is: "+isWindowClosed(taskWinList[i].taskWindow));
            if (isWindowClosed(taskWinList[i].taskWindow)) {
                taskWinList[i].count = taskWinList[i].count + 1;
                //mainTrace("count is: "+taskWinList[i].count);
                if (taskWinList[i].count > 2) {
                   if ("closeHandled" in taskWinList[i].taskWindow) {
                       // looks like we already saw the close
                   } else {
                       windowName = new Date().getTime();
                       var tempwin = window.open("/hmc/task?op=windowclose&taskId="+taskWinList[i].taskId, "windowclosed_"+windowName, "width=1,height=1,top="+screen.availHeight+",left="+screen.availWidth);
                       tempwin.blur();
                   }
                   try {
                      if ("appletReady" in this.frames.hmcTaskController) {
                         tcapplet = this.frames.hmcTaskController.document.applets[0];
                         if (tcapplet != null) {
                            tcapplet.deregisterTaskWindow(taskWinList[i].taskWindowName);
                         }
                         try {
                            mainTrace("deregistering with applet; task window: "+taskWinList[i].taskWindowName+" with id "+taskWinList[i].taskId);
                         } catch (tcex) {}
                      }
                   }
                   catch (ex) {
                      try {
                         mainTrace("caught exception deregistering with applet; task window: "+taskWinList[i].taskWindowName+" with id "+taskWinList[i].taskId+"\n\n"+ex);
                      } catch (tcex) {}
                   }
                   taskWinList[i] = null;
                } else {
                    windowCount++;
                }
            } else {
                windowCount++;
                taskWinList[i].count = 0;
                if (taskWinList[i].registered == false) {
                   try {
                      if ("appletReady" in this.frames.hmcTaskController) {
                         tcapplet = this.frames.hmcTaskController.document.applets[0];
                         mainTrace("tcapplet="+tcapplet);
                         if (tcapplet != null) {
                            tcapplet.registerTaskWindow(""+taskWinList[i].taskWindowName);
                         }
                         taskWinList[i].registered = true;
                         try {
                            mainTrace("reregistering with applet; task window: "+taskWinList[i].taskWindowName+" with id "+taskWinList[i].taskId);
                         } catch (tcex) {}
                      }
                   }
                   catch (ex) {
                      try {
                         mainTrace("caught exception reregistering with applet; task window: "+taskWinList[i].taskWindowName+" with id "+taskWinList[i].taskId+"\n\n"+ex);
                      } catch (tcex) {}
                   }
                }
            }
        }
    }
    //mainTrace("window count is now "+windowCount);
    if (windowCount > 0) {
        taskWinChecker = window.setTimeout("checkForTaskWindowsClosed()", 1000);
    } else {
        // no more task windows left, so reset the index to zero
        taskWinIndex = 0;
    }
}

function deRegisterTaskWindow(taskId) {
    windowCount=0;
    mainTrace("deregistering task window with id "+taskId);
    for (i=0; i<taskWinIndex; i++) {
        if (taskWinList[i] != null) {
            if (taskId == taskWinList[i].taskId) {
               try {
                  if ("appletReady" in this.frames.hmcTaskController) {
                     tcapplet = this.frames.hmcTaskController.document.applets[0];
                     if (tcapplet != null) {
                        tcapplet.deregisterTaskWindow(taskWinList[i].taskWindowName);
                     }
                  }
               }
               catch (ex) {
               }
               taskWinList[i] = null;
            } else {
               windowCount++;
            }
        }
    }
    mainTrace("window count is now "+windowCount);
    if (windowCount == 0) {
        taskWinIndex = 0;
    }
}
//-opera end
