/*
 * (c)  Copyright  IBM Corp.  1999, 2006  All Rights Reserved
 *
 *
 * US Government Users Restricted Rights - Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp
 *
 * Notes:
 * js file used to persist wcl table column widths
 *
 * Module History:
 * 05/23/2006  J. Miller    Initial Release
 * 08/30/2006  J. Miller    AJAX support for clearing column widths
 * 09/18/2006  J. Miller    new wtable onresize method to help align toolbar's buttons
 * 10/09/2006  J. Miller    onBonsaiWorkareaResizeAjax cleanup
 * 11/13/2006  J. Miller    kick up column width/scroll position updates using AJAX
 * 02/22/2007  J. Miller    resize table on frame resize when using ajax
 * 03/01/2007  J. Miller    table row client-side faux select
 *                          don't resize table on frame resize when using ajax unit initWidth bug can be fixed
 * 03/02/2007  J. Miller    reset rpvmax on resize
 * 03/23/2007  J. Miller    do not faux select table row if isAjaxOutstanding
 * 04/17/2007  JMiller      ajax resize table on frame resize fixes
 * 06/06/2007  JMiller      disable toolbar dropdown menus before perofrming row selection
 * 06/26/2007  JMiller      resize header cells of empty table
 * 08/28/2007  JMiller      save columns widths updates to set widths of columns in an auto-sized column
 * 09/24/2007  JMiller      use tableSettingsKey param to save columnWidths instead of tablePageId
 *
 */

var COLUMNWIDTHS_OPTION_CLEAR = 0;
var COLUMNWIDTHS_OPTION_AUTO  = 1;

//onBonsaiWorkareaResizeAjax - perform actions needed when a bonsai workarea frame is resized
// -in: divID  - id of the div containing the table
//      formID - id of AJAX form to submit
//      colUrl - callback url of the WTable colWidths trigger
//      event  - event which triggered this method
//-out: none, form submitted, values reset
function onBonsaiWorkareaResizeAjax(dataBodyEnc, formID, colUrl, event) {
  if ( typeof saveFrameDimensionsAjax == 'function' ) {
    saveFrameDimensionsAjax(event);
  }

  var dataBody = document.getElementById(dataBodyEnc);
  if ( !dataBody ) {
     return;
  }

  //if autosize reset rpvmax value
  var autosize = ( dataBody.getAttribute("autorpv") == "true" );
  if ( autosize ) {
    dataBody.setAttribute("rpvmax", 0);
    var scrollPaneEnc = dataBody.getAttribute('SPID');
    var scrollPane = document.getElementById(scrollPaneEnc);
    if (scrollPane != null) {
      scrollPane.childNodes[2].value = 0;
    }
  }

  //clear persisted column widths and resize table
  var dataBody = document.getElementById(dataBodyEnc);
  if (dataBody != null) {
    var scrollPaneEnc = dataBody.getAttribute('SPID');
    clearSavedColumnWidthsAjax(scrollPaneEnc, colUrl);

    if ( typeof setupTableAjax == 'function' ) {
      setupTableAjax(dataBodyEnc, true);
    }
  }
}

//onBonsaiWorkareaResize - perform actions needed when a bonsai workarea frame is resized
// -in: divID  - id of the div containing the table
//      event  - event which triggered this method
//-out: none, form submitted, values reset
function onBonsaiWorkareaResize(dataBodyEnc, event) {
  if ( typeof saveFrameDimensions == 'function' ) {
    saveFrameDimensions(event);
  }

  if ( typeof setupTable == 'function' ) {
    setupTable(dataBodyEnc, true);
  }
}

//clearSavedColumnWidthsAjax - clear values in AJAX divs that send column widths to server
// -in: divID - id of the div containing the table
//      colUrl - callback url of the WTable colWidths trigger
//-out: none
function clearSavedColumnWidthsAjax(divID, colUrl) {
  var div = document.getElementById(divID);
  if ( div != null ) {
    var headBody1 = document.getElementById(div.getAttribute('H1BID'));
    if ( headBody1 != null ) {
      //loop over table columns and set AJAX column width values
      var cellCount = headBody1.rows[0].cells.length-1;
      for (var c = 0; c < cellCount; c++) {
        var head1 = headBody1.rows[0].cells[c];
        head1.removeAttribute("prefWidth");
        try {
          head1.firstChild.rows[0].lastChild.lastChild.value = "0";
        } catch (widthError) {
          debug("Error setting table column width: [" + widthError.name + "] [" + widthError.message + "]");
        }
      }
      columnWidthsHelperAjax(divID, colUrl, COLUMNWIDTHS_OPTION_CLEAR);
    }
  }
}

//saveColumnWidths - submit column widths dimensions for persisitence
// -in: divID  - id of the div containing the table
//      colUrl - callback url of the WTable colWidths trigger
//      option - column widths persistence option
//-out: none, column width form submitted
function saveColumnWidthsAjax(divID, colUrl, option) {
  columnWidthsHelperAjax(divID, colUrl, option);
}

//updateTableDataAjax - submit AJAX form update
// -in: formID - id of AJAX form to submit
//-out: none, form submitted, values reset
function updateTableDataAjax(formID, action) {
  if ( action == null ) {
      action = '';
  }
  var form = document.getElementById(formID);
  if ( form != null ) {
    startRequest(form, '');
    // Reset the form values.
    if ( form.wclanchor != null && form.wclhidden != null ) {
      eval("form." + wclanchor + ".value = ''");
      eval("form." + wclhidden + ".value = ''");
    }
    return false;
  }
}

//columnWidthsHelperAjax - submit column widths dimensions for persisitence
// -in: divID - id of the div containing the table
//      colUrl - callback url of the WTable colWidths trigger
//      option - column widths persistence option
//-out: none, column width form submitted
function columnWidthsHelperAjax(divID, colUrl, option) {
  debugMsg("-> columnWidthsHelperAjax("+divID+", "+colUrl+", "+option+")");

  var url = colUrl;//"/hmc/ui/bonsai/columnwidths.do";
  var params = "";
  var inputName  = "";
  var inputValue = "";
  var input;

  try {
    var clearWidths = ( option != undefined && option == COLUMNWIDTHS_OPTION_CLEAR );
    var isAutoSized = ( option != undefined && option == COLUMNWIDTHS_OPTION_AUTO  );

    //if !clearWidths append inputs for column widths
    var div           = document.getElementById(divID);
    var headBody1     = document.getElementById(div.getAttribute('H1BID'));
    var cellCount     = headBody1.rows[0].cells.length-1;
    if ( !clearWidths ) {
      for (var c = 0; c < cellCount; c++) {
        var head1 = headBody1.rows[0].cells[c];
        inputName  = head1.getAttribute("colIdentifier");
        inputValue = head1.width;
        if ( isNaN(inputValue) ) {
           debugMsg("<- columnWidthsHelperAjax: ERROR - " + e.message);
           return;
        }
        params = addParam(params, inputName, inputValue);
      }
    }


    //tableSettingsKey
    inputName = "tableSettingsKey";
    inputValue = div.getAttribute("tableSettingsKey");
    params = addParam(params, inputName, inputValue);


    //clear widths?
    inputName  = "clearWidths";
    inputValue = ( clearWidths ) ? "true" : "false";
    params = addParam(params, inputName, inputValue);


    //auto-sized?
    inputName  = "autoSized";
    inputValue = ( isAutoSized ) ? "true" : "false";
    params = addParam(params, inputName, inputValue);


    //viewRows
    inputName = "viewRows";
    inputValue = ( clearWidths ) ? 0 : div.childNodes[1].value;
    params = addParam(params, inputName, inputValue);


    //rpvMax
    inputName = "rpvMax";
    inputValue = ( clearWidths ) ? 0 : div.childNodes[2].value;
    params = addParam(params, inputName, inputValue);


    //column order
    var colOrder  = "";
    for (var c = 0; c < cellCount; c++) {
      var head1 = headBody1.rows[0].cells[c];
      colId  = head1.getAttribute("colIdentifier");
      colOrder = colOrder + colId;
    }

    inputName  = "columnOrder";
    inputValue = colOrder;
    params = addParam(params, inputName, inputValue);
  } catch (e) {
    //no frame width/id -> abort
    debugMsg("<- columnWidthsHelperAjax: ERROR - " + e.message);
    return;
  }

  debugMsg("   columnWidthsHelperAjax: new AsyncJson("+url + params+")");
  try {
    new AsyncJson( url + params,
                   function(json) {
                     return true;
                   }
    );
  } catch( e ) {
  }

  debugMsg("<- columnWidthsHelperAjax");
  return true;
}



//clearSavedColumnWidths - submit request to clear saved column width dimensions for given tableID/workareaWidth
// -in: divID - id of the div containing the table
//-out: none, column width reset form submitted
function clearSavedColumnWidths(divID) {
  columnWidthsHelper(divID, true);
}

//saveColumnWidths - submit column widths dimensions for persisitence
// -in: divID - id of the div containing the table
//-out: none, column width form submitted
function saveColumnWidths(divID) {
  columnWidthsHelper(divID, false);
}

//saveColumnWidths - submit column widths dimensions for persisitence
// -in: divID - id of the div containing the table
//      clearWidths - clear saved column widths for this tableID/workareaWidth
//-out: none, column width form submitted
function columnWidthsHelper(divID, clearWidths) {
  var formName = "columnWidthsForm";
  var form = document.forms[formName];
  if ( form != null ) {
    document.body.removeChild(form);
  }

  //create form
  form = document.createElement( "FORM" );
  with ( form ) {
    name   = formName;
    id     = formName;
    action = "/hmc/ui/bonsai/columnwidths.do";
    method = "POST";
  }

  try {
    //tablePage id
    frame     = window.top.hmcmainui.workarea_frame.frames[0];
    inputName = "tablePageId";
    input     = document.getElementById( inputName );

    if ( frame && frame.document && frame.document.body && frame.document.body.getAttribute("id") ) {
      inputValue = frame.document.body.getAttribute("id");
      if ( !input ) {
        input = document.createElement( "INPUT" );
        with ( input ) {
          type  = "hidden";
          id    = inputName;
          name  = inputName;
        }
        form.appendChild( input );
      }
      input.value = inputValue;
    } else if ( input ) {
      form.removeChild( input );
    }


    //if !clearWidths append inputs for column widths
    var div           = document.getElementById(divID);
    var headBody1     = document.getElementById(div.getAttribute('H1BID'));
    var cellCount     = headBody1.rows[0].cells.length-1;
    if ( !clearWidths ) {
      for (var c = 0; c < cellCount; c++) {
        var head1 = headBody1.rows[0].cells[c];

        inputName  = head1.getAttribute("colIdentifier");
        inputValue = head1.width;
        input      = document.getElementById( inputName );

        if ( !input ) {
          input = document.createElement( "INPUT" );
          with ( input ) {
            type  = "hidden";
            id    = inputName;
            name  = inputName;
          }
          form.appendChild( input );
        }
        input.value = inputValue;
      }
    }

    //clear widths?
    inputName  = "clearWidths";
    inputValue = ( clearWidths ) ? "true" : "false";
    input      = document.getElementById( inputName );

    if ( !input ) {
      input = document.createElement( "INPUT" );
      with ( input ) {
        type  = "hidden";
        id    = inputName;
        name  = inputName;
      }
      form.appendChild( input );
    }
    input.value = inputValue;


    //column order
    var colOrder  = "";
    for (var c = 0; c < cellCount; c++) {
      var head1 = headBody1.rows[0].cells[c];
      colId  = head1.getAttribute("colIdentifier");
      colOrder = colOrder + colId;
    }

    inputName  = "columnOrder";
    input      = document.getElementById( inputName );
    inputValue = colOrder;

    if ( !input ) {
      input = document.createElement( "INPUT" );
      with ( input ) {
        type  = "hidden";
        id    = inputName;
        name  = inputName;
      }
      form.appendChild( input );
    }
    input.value = inputValue;

    submitMe = true;
  } catch (e) {
    //no frame width/id -> abort
    return;
  }

  document.body.appendChild(form);
  document.forms[formName].submit();
  return false;
}

//alignToolbarButtons - set the width of the parent TDs of the elements with the
//given IDs to the given widths
// -in: vmbId - id of the views menubutton
//      vmbTdWidth - desired width of the views menubutton's parent TD
//      sepId - id of the toolbar separator image
//      sepTdWidth - desired width of the separator's parent TD
//-out: none, parent TD widths updated
function alignToolbarButtons(vmbId, vmbTdWidth, sepId, sepTdWidth) {
    var vmb = document.getElementById(vmbId);
    var sep = document.getElementById(sepId);
    try {
        var vmbTd = vmb.parentNode;
        while( vmbTd.className != 'lyt2' ) {
            vmbTd = vmbTd.parentNode;
        }
        vmbTd.width = vmbTdWidth;
    } catch(e) {
    }
    try {
        var sepTd = sep.parentNode;
        while( sepTd.tagName.toUpperCase() != 'TD' ) {
            sepTd = sepTd.parentNode;
        }
        sepTd.width = sepTdWidth;
    } catch(e) {
    }
}


var BONSAI_SCROLL_TOP = "bonsaiTableScrollTop";   //name of cookie which stores the opened menu's path
//bonsaiSaveScrollPosition - handles scroll of table then sends scrollTOp up to server
// -in: scrollPaneID - id of the scrollPane
//      formID - id for wcl form to use to update the table data
//-out: none, scroll position update sent to server
function bonsaiSaveScrollPositionAjax(scrollPaneID, formID) {
    var scrollPane = document.getElementById(scrollPaneID);
    setScrollPositionAjax(scrollPane); //wcl method
    if ( scrollPane != null && scrollPane.scrollTop > 0 ) {
        var scrollTop = getCookie(BONSAI_SCROLL_TOP);
        if ( scrollTop == scrollPane.scrollTop ) {
            return;
        }
        createCookie(BONSAI_SCROLL_TOP, scrollPane.scrollTop);
    }
    updateTableDataAjax(formID, 'rahr');
}

//bonsaiSetScrollPosition - set the scrollTop for the elem with the given id
// -in: scrollPaneID - id of the scrollPane
//-out: none, scrollTop updated
function bonsaiSetScrollPosition(scrollPaneID) {
    var scrollPane = document.getElementById(scrollPaneID);
    if ( scrollPane != null ) {
        var scrollTop = getCookie(BONSAI_SCROLL_TOP);
        if ( scrollTop != null ) {
            scrollPane.scrollTop = scrollTop;
        }
    }
}


/** WTable **
 * persist table scrollTop
 * url - WTable callback url, may already have params defined
 * actionName - the name of the action being performed
 * actionValue - the name of the component performing the action
 * divId - the id of the table div
 * clearWait - if true ignore/clear isScrolling flag, used to process a script-trigger
 *             follow-up scroll event .5sec after the first scroll event is received.
 *             This is done because browsers currently trigger multiple scroll events
 *             while scrolling; ideally scrollTop should be persisted when onscrollend.
 */
function doScrlAjax(url, actionName, actionValue, divId, clearWait) {
    var div = document.getElementById(divId);
    if ( div == null ) {
        return;
    }

    try {
        window.top.hmcmainui.workarea_frame.workareaScrollTopValue = div.scrollTop;
        window.top.hmcmainui.workarea_frame.workareaScrollTopID    = window.top.hmcmainui.workarea_frame.frames[0].document.body.id;
    } catch(e) {
        try {
            window.top.hmcmainui.workarea_frame.workareaScrollTopValue = 0;
            window.top.hmcmainui.workarea_frame.workareaScrollTopID    = null;
        } catch(e) {
        }
    }

    try {
        if ( div.getAttribute(SCROLL_LOCK) == "true" && !clearWait ) {
           //already scrolling and not flagged to ignore lock, so dont process scroll event
           return;
        }
        div.setAttribute(SCROLL_LOCK, "true" );   //set div lock
    } catch (e) {
        return;
    }

    //only update if necessary
    if ( div.scrollTop != div.firstChild.value ) {
        setScrollPositionAjax(divId);

        //ajax update new scroll value
        try {
            var params = "";
            if ( url.indexOf('?') == -1 ) {
                params = "?";
            } else if ( url.indexOf('=') != -1 ) {
                params = "&";
            }
            params = params + actionName + "=" + actionValue + "(" + div.scrollTop + ")";
            new AsyncJson( url + params,
                           function(json) {
                               return true;
                           }
            );
        }catch (e) {
        }
    }

    //clear lock if this was a follow-up scroll event, otherwise schedule follow-up event after timeout
    if ( clearWait ) {
        div.setAttribute(SCROLL_LOCK, "false" );   //set div lock
    } else {
        setTimeout("doScrlAjax('" + url + "', '" + actionName + "', '" + actionValue + "', '" + divId + "', true)", 500);
    }
    return false;
}

/** WTable (scrolling)**
 * set scroll top value based on scroll position value
 */
function bonsaiSetScrollTopAjax(scroller)
{
   var scrollDiv = document.getElementById(scroller);
   if (scrollDiv != null) {
      var scrollPos = null;
      try {
          if ( document.body.id == window.top.hmcmainui.workarea_frame.workareaScrollTopID ) {
              scrollPos = window.top.hmcmainui.workarea_frame.workareaScrollTop;
          }
      } catch (e) {
      }
      if ( !scrollPos ) {
         scrollPos = scrollDiv.firstChild.value;
      }
      scrollDiv.scrollTop = scrollPos;
   }
}

//bonsaiToggleRowSelection
//client-side table row deselect - changes table row cells style class and
//hides/disables the rows select column image.  if the row is being
//deselected or radio select is used and another row is selected (indicated
//by selIndex != -1), the currently selected row's style is toggled and any
//context menu launcher in the row are disabled
// -in: dataBodyEnc - table div ID
//      rowIndex - index of row that is being toggled
//      newClass - new css class of the row that is being selected
//      newImage - img src for the toggled row's select cell
//      selIndex - index of currently selected row if radio selection enabled
//      selClass - new css class of the row that was selected
//      selImage - new img src for selected row's select cell
//      menuArray - js array containing the IDs of the buttons to disable
// -out: none
function bonsaiToggleRowSelection(dataBodyEnc, rowIndex, newClass, newImage, selIndex, selClass, selImage, menuArray) {
   try {
      //abort if isAjaxOutstanding
      if ( (typeof isAJAXOutstanding == "boolean") && isAJAXOutstanding ) {
         return;
      }

      // disable toolbar dropdown menus
      if ( menuArray ) {
         for ( var i = 0; i < menuArray.length;  i++ ) {
            var menuLauncher = document.getElementById(menuArray[i]);
            if ( menuLauncher ) {
               menuLauncher.disabledonclick = menuLauncher.onclick;
               menuLauncher.onclick = "";
            }
         }
      }

      // client-side row select
      var dataBody = document.getElementById(dataBodyEnc);
      if (dataBody != null) {
         //loop over columns in table
         var cellCount = dataBody.rows[rowIndex].cells.length;
         for (var c = 0; c < cellCount; c++) {
            var td = dataBody.rows[rowIndex].cells[c];
            var oldClass = td.className;

            //update table cell style/row selection image
            if ( selIndex == -1 || ( selIndex != -1 && selIndex != rowIndex ) ) {
               td.className = newClass;
               if ( c == 0 ) {
                  toggleAndDisableSelectImage(td, newImage);
               }
            }

            //toggle previously selected row class and select image and hide the popup menu
            if ( selIndex != -1 || oldClass == 'tbls2') {
               //toggle previously selected row class and select image
               if ( selIndex != -1 ) {
                  td = dataBody.rows[selIndex].cells[c];
                  td.className = selClass;
                  if ( c == 0 ) {
                     toggleAndDisableSelectImage(td, selImage);
                  }
               }

               disableCellPopupMenu(td, cellCount);
            }
         }
      }
   } catch(e) {
   }
}

//toggleAndDisableSelectImage
//hides/disables the row's select column image.
// -in: div - table div
//      newImage - img src for the toggled row's select cell
// -out: none
function toggleAndDisableSelectImage(div, newImage) {
   //loop til we find td's select image, then disable and change
   //it (refresh will reenable it)
   while ( div.firstChild && div.tagName != 'IMG' ) {
      div = div.firstChild;
   }
   if ( div.tagName == 'IMG' ) {
      div.parentNode.onclick = null;
      div.style.display = 'none';
      div.src = newImage;
      div.style.display = '';
   }
}

//disableCellPopupMenu
//hide/disable context menu launcher in the given row's cells
// -in: td - table row td
//      cellCount - number of columns in the table row
// -out: none
function disableCellPopupMenu(td, cellCount) {
   //hide the popup previously selected row's popup menu
   try {
      var links = td.getElementsByTagName('A');
      if ( links.length > 0 ) {
         //loop over the td's link decendants; disable any popup menu links
         //and hide their launcher images
         for (var l = 0; l < cellCount; l++) {
            var link = links[l];
            if ( link && link.id && link.id.indexOf("popup_") != -1 ) {
               link.disabled = true;
               link.firstChild.style.display = 'none';
            }
         }
      }
   } catch (e) {
   }
}



//resizeEmptyTable
//resize the table header row cells
// -in: h1bID - ID of the header table
// -out: none
function resizeEmptyTable(h1bID) {
   debugMsg("-> resizeEmptyTable");

   var headBody1 = document.getElementById(h1bID);
   var tableStyle1 = headBody1.style;
   var cellCount = headBody1.rows[0].cells.length-1;
   var widths = new Array(cellCount);

   var totalWidth = 0;
   var justifiedWidthShrink  = 0;   //width to play with when columns have to shrink
   var justifiedWidthEnlarge = 0;   //width to play with when columns have to enlarge

   //shrink header table to content
   headBody1.style.width='0px';
   if ( !WClient.isBrowserInternetExplorer() ) {
      for (var c = 1; c < cellCount; c++) {
         var head1 = headBody1.rows[0].cells[c];
         head1.width="0px";
      }
   }

   //get column widths and width to grow/shrink
   for (var c = 0; c < cellCount; c++) {
      var head1 = headBody1.rows[0].cells[c];
      widths[c] = head1.firstChild.clientWidth;

      totalWidth += widths[c];
      var justify = head1.getAttribute("justify");
      if ( justify == "shrink"  || justify == "shrinkAndEnlarge" ) {
        justifiedWidthShrink += widths[c];
      }
      if ( justify == "enlarge" || justify == "shrinkAndEnlarge" ) {
        justifiedWidthEnlarge += widths[c];
      }
   }

   //width to play with (because this table is either shrinking or enlarging)
   var tableWidth = headBody1.offsetWidth;

   //IE renders the spacer TH (whose colspan=#) with width=#px and wont let us
   //adjust its width, so decrement tableWidth by spacerTh.colSpan to prevent
   //the resized table from running off the page
   if ( WClient.isBrowserInternetExplorer() ) {
      var spacerTh = headBody1.rows[0].cells[cellCount-1].nextSibling;
      if ( spacerTh ) {
         tableWidth = tableWidth - spacerTh.colSpan;
      }
   }

   //set how much room we have to play with
   var justifiedWidth = ( tableWidth - totalWidth < 0 ) ? justifiedWidthShrink : justifiedWidthEnlarge;

   //disable autosizing
   tableStyle1.tableLayout = 'fixed';
   headBody1.style.overflowX='hidden';

   //set fixed column widths
   var misc = 0;
   var tableDiff = tableWidth - totalWidth;
   for (var c = 0; c < cellCount; c++) {
      var head1 = headBody1.rows[0].cells[c];
      var cellPadding = ( WClient.isBrowserInternetExplorer() ) ? 0 : (parseInt(head1.style.borderLeftWidth) + parseInt(head1.style.borderRightWidth));

      //justify column
      if ( justifiedWidth > 0 && tableWidth != totalWidth) {
         if ( ( tableDiff <  0  && head1.getAttribute("justify") != "enlarge" )
           || ( tableDiff >= 0  && head1.getAttribute("justify") != "shrink"  ) )
         {
            widths[c] = widths[c] + Math.round( tableDiff * (widths[c] / justifiedWidth) ) - cellPadding;
            if ( c == cellCount - 1 ) {
                widths[c] = widths[c] - misc;
            }
         }
         if ( widths[c] < getColumnMinWidth(head1) ) {
            misc = misc + getColumnMinWidth(head1) - widths[c];
            widths[c] = getColumnMinWidth(head1);
         }
      }

      widths[c] = Math.max(MIN_COL_WIDTH, widths[c]);

      head1.width = widths[c];

      //ensure header cell text doesnt overlay sort/resize buttons
      if ( tableDiff < 0 ) {
         head1.firstChild.style.tableLayout='fixed';
         head1.firstChild.rows[0].cells[0].width=widths[c]-21;
      }
   }

   adjustEmptyTableHeaderHeight(h1bID);

   debugMsg("<- resizeEmptyTable");
}



//adjustEmptyTableHeaderHeight
//resize the table header row resizer images of an empty table to the full
//height of their containing cell (needed if the table header text contains
//breakrules)
// -in: h1bID - ID of the header table
// -out: none
function adjustEmptyTableHeaderHeight(h1bID) {
   var headBody1 = document.getElementById(h1bID);
   var cellCount = headBody1.rows[0].cells.length-1;

   //set header row/resizer height in case column headers contain breakrules
   try {
      //abort if header height was already adjusted, avoiding a flash in firefox on windows
      var head1 = headBody1.rows[0].cells[0];
      if ( head1.firstChild.rows[0].lastChild.height == head1.firstChild.rows[0].height
        && head1.firstChild.rows[0].lastChild.height == head1.firstChild.rows[0].lastChild.firstChild.height )
      {
         return;
      }

      for (var c = 0; c < cellCount; c++) {
         head1 = headBody1.rows[0].cells[c];
         head1.firstChild.rows[0].height = '100%';
         head1.firstChild.rows[0].lastChild.height = '100%';
         head1.firstChild.rows[0].lastChild.firstChild.height = '100%';
      }

      var clientHeightHb = headBody1.clientHeight - 2;
      var clientHeightTr = headBody1.rows[0].clientHeight - 2;
      var clientHeightTd = headBody1.rows[0].cells[0].clientHeight - 2;

      if ( WClient.isBrowserInternetExplorer() ) {
         clientHeightHb = clientHeightTr;
         clientHeightTr = clientHeightTr;
         clientHeightTd = clientHeightTr;
      }

      for (var c = 0; c < cellCount; c++) {
         head1 = headBody1.rows[0].cells[c];
         head1.firstChild.rows[0].height = clientHeightHb;
         head1.firstChild.rows[0].lastChild.height = clientHeightTr;
         head1.firstChild.rows[0].lastChild.firstChild.height = clientHeightTd;
      }
   } catch (e) {
   }
}


