/**
 * (c)  Copyright  IBM Corp.  1999, 2003  All Rights Reserved
 *
 *
 * US Government Users Restricted Rights - Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp
 *
 * Notes:
 * BonsaiTaskbar js to resize left/region to its clientWidth and resize the
 * task button row to the remaining width, shrinking its buttons proportionally
 * as needed.
 *
 * Module History:
 * 06/26/07  JMiller    Initial Release
 *
 */

//resizeTaskbar
//handles the resizing of taskbar regions - left/right should be sized to fit
//and button row takes up the remaining space
//  -in: taskbarID   - ID of the taskbar tag
//       buttonRowID - ID of the button row tag
//       callbackUrl - url to which the updated updated region widths should be submitted
// -out: none
function resizeTaskbar(taskbarID, buttonRowID, callbackUrl)
{
   if ( WClient.isBrowserInternetExplorer() ) {
       resizeTaskbarIE(taskbarID, buttonRowID, callbackUrl)
   } else {
       resizeTaskbarMoz(taskbarID, buttonRowID, callbackUrl)
   }
}


//resizeTaskbarMoz
//handles the resizing of taskbar regions for Mozilla browsers - left/right should
//be sized to fit and button row takes up the remaining space
//  -in: taskbarID   - ID of the taskbar tag
//       buttonRowID - ID of the button row tag
//       callbackUrl - url to which the updated updated region widths should be submitted
// -out: none
function resizeTaskbarMoz(taskbarID, buttonRowID, callbackUrl) {
    //debugMsg("-> resizeTaskbarMoz('"+taskbarID+"', '"+buttonRowID+"', '"+callbackUrl+"')");

    var taskbarTable = document.getElementById(taskbarID);
    var taskButtonRow = document.getElementById(buttonRowID);
    if ( !taskbarTable || !taskButtonRow ) {
        //debugMsg("<- resizeTaskbarMoz: !taskbarTable: " + taskbarTable);
        //setTimeout("resizeTaskbarMoz('"+taskbarID+"', '"+buttonRowID+"', '"+callbackUrl+"')", 10);
        return;
    }

    var lReg = taskbarTable.rows[0].cells[0];
    var bReg = taskbarTable.rows[0].cells[1];
    var rReg = taskbarTable.rows[0].cells[2];
    if ( !lReg || !bReg || !rReg ) {
        //debugMsg("<- resizeTaskbarMoz: !lReg || !bReg || !rReg = !" + lReg + " || !" + bReg + " || !" + rReg);
        //setTimeout("resizeTaskbarMoz('"+taskbarID+"', '"+buttonRowID+"', '"+callbackUrl+"')", 10);
        return;
    }

    //callback is needed if left/right region widths are too small
    var isCallbackNeeded = (lReg.width < lReg.clientWidth || rReg.width < rReg.clientWidth );

    //calculate region widths
    var pageClientWidth = document.body.clientWidth;
    var taskCount = taskButtonRow.rows[0].cells.length - 1;//ignore spacer cell
    var taskTD;

    //this loop looks meaningless (since the table layout is reset to fixed right
    //after this in the next loop, but its needed to handle the case of a shrunken
    //button row being enlarged.  without this block the shrunken buttons are not
    //enlarged to their new size.
    for ( var i=0; i<taskCount; i++ ) {
        taskTD = taskButtonRow.rows[0].cells[i];
        taskTD.style.tableLayout = 'auto';
        taskTD.firstChild.style.tableLayout = 'auto';

        //need to reference clientWidth to force browser to calculate the value
        var str = taskTD.clientWidth + taskTD.firstChild.clientWidth;

        taskTD.style.tableLayout = 'fixed';
        taskTD.firstChild.style.tableLayout = 'fixed';
        str = taskTD.clientWidth + taskTD.firstChild.clientWidth;
    }

    var lWidth = lReg.clientWidth;
    var bWidth = bReg.clientWidth;
    var rWidth = rReg.clientWidth;
    var bWidthDesired = pageClientWidth - lWidth - rWidth;

    var widths = new Array(Math.max(taskCount,1));
    var compressionRate = bWidthDesired / bWidth ;

    if ( compressionRate < 1 ) {
        //calculate shrunken width of each task button
        for ( var i=0; i<taskCount; i++ ) {
            taskTD = taskButtonRow.rows[0].cells[i];
            widths[i] = taskTD.clientWidth * compressionRate;
        }

        //hide task button row while resizing its buttons
        taskButtonRow.parentNode.style.display='none';
        taskButtonRow.parentNode.style.tableLayout='fixed';

        //set shrunken width of each task button
        for ( var i=0; i<taskCount; i++ ) {
            taskTD = taskButtonRow.rows[0].cells[i];
            taskTD.width = widths[i] + "px";
            taskTD.firstChild.width = taskTD.width + "px";
            var str = taskTD.clientWidth + taskTD.firstChild.clientWidth;
        }

        //unhide task button row after resizing its buttons
        taskButtonRow.parentNode.style.display='';
    } else {
        //set desired width of each task button
        for ( var i=0; i<taskCount; i++ ) {
            taskTD = taskButtonRow.rows[0].cells[i];
            taskTD.width = taskTD.clientWidth + "px";
            taskTD.firstChild.width = taskTD.width + "px";
            var str = taskTD.clientWidth + taskTD.firstChild.clientWidth;
        }
    }

    //add callback to notfiy server of width used for left/right regions
    if (isCallbackNeeded && callbackUrl != null) {
        var requestUrl = callbackUrl+"?lWidth="+lWidth+"&bWidth="+bWidth+"&rWidth="+rWidth;
        //debugMsg("   resizeTaskbarMoz: window.top.hmcmainui.toolbar_frame.location.href=" + requestUrl);
        window.top.hmcmainui.toolbar_frame.location.href=requestUrl;
    }

    //debugMsg("<- resizeTaskbarMoz");
}


//resizeTaskbarIE
//handles the resizing of taskbar regions for Internet Explorer browsers
//left/right should be sized to fit and button row takes up the remaining space
//  -in: taskbarID   - ID of the taskbar tag
//       buttonRowID - ID of the button row tag
//       callbackUrl - url to which the updated updated region widths should be submitted
// -out: none
function resizeTaskbarIE(taskbarID, buttonRowID, callbackUrl) {
    //debugMsg("-> resizeTaskbarIE('"+taskbarID+"', '"+buttonRowID+"', '"+callbackUrl+"')");

    var taskbarTable = document.getElementById(taskbarID);
    var taskButtonRow = document.getElementById(buttonRowID);
    if ( !taskbarTable || !taskButtonRow ) {
        //debugMsg("<- resizeTaskbarIE: !taskbarTable: " + taskbarTable);
        //setTimeout("resizeTaskbarIE('"+taskbarID+"', '"+buttonRowID+"', '"+callbackUrl+"')", 10);
        return;
    }


    var lReg = taskbarTable.rows[0].cells[0];
    var bReg = taskbarTable.rows[0].cells[1];
    var rReg = taskbarTable.rows[0].cells[2];
    if ( !lReg || !bReg || !rReg ) {
        //debugMsg("<- resizeTaskbarIE: !lReg || !bReg || !rReg = !" + lReg + " || !" + bReg + " || !" + rReg);
        //setTimeout("resizeTaskbarIE('"+taskbarID+"', '"+buttonRowID+"', '"+callbackUrl+"')", 10);
        return;
    }

    //callback is needed if left/right region widths are too small
    var isCallbackNeeded = (lReg.width < lReg.clientWidth || rReg.width < rReg.clientWidth );

    //calculate region widths
    var pageClientWidth = document.body.clientWidth;
    var pageScrollWidth = document.body.scrollWidth;
    var taskCount = taskButtonRow.rows[0].cells.length - 1;//ignore spacer cell
    var widths = new Array(Math.max(taskCount,1));
    var brWidth = 0;

    //grab desired withd of the task buttons
    for ( var i=0; i<taskCount; i++ ) {
        taskTD = taskButtonRow.rows[0].cells[i];
        taskTD.firstChild.style.tableLayout = 'auto';
        widths[i] = taskTD.offsetWidth;//taskTD.firstChild.offsetWidth;
        brWidth += taskTD.offsetWidth;//taskTD.firstChild.offsetWidth;
    }

    var lWidth = lReg.clientWidth;
    var rWidth = rReg.clientWidth;
    var regWidth = ( lWidth + brWidth + rWidth );

    //compression rate of button row = buttonRow client width - total desired widths of buttons
    var compressionRate = ( (pageClientWidth-rWidth-lWidth) / brWidth );
    if ( compressionRate >= 1 ) {
        for ( var i=0; i<taskCount; i++ ) {
            taskTD = taskButtonRow.rows[0].cells[i];
            taskTD.firstChild.style.tableLayout = 'fixed';
            taskTD.firstChild.rows[0].cells[0].firstChild.style.tableLayout = 'fixed';
            taskTD.width = widths[i];// - 8;
        }

    } else {
        var taskTD;
        for ( var i=0; i<taskCount; i++ ) {
            taskTD = taskButtonRow.rows[0].cells[i];
            widths[i] = widths[i] * compressionRate;// - 20;
        }

        taskButtonRow.style.display='none';
        taskButtonRow.style.tableLayout='fixed';

        for ( var i=0; i<taskCount; i++ ) {
            taskTD = taskButtonRow.rows[0].cells[i];
            taskTD.firstChild.style.tableLayout = 'fixed';
            taskTD.width = (widths[i]) + "px";
        }

        taskButtonRow.style.display='';
    }

    //add callback to notfiy server of width used for left/right regions
    if (isCallbackNeeded && callbackUrl != null) {
        var requestUrl = callbackUrl+"?lWidth="+lWidth+"&rWidth="+rWidth;
        //debugMsg("   resizeTaskbarIE: window.top.hmcmainui.toolbar_frame.location.href=" + requestUrl);
        window.top.hmcmainui.toolbar_frame.location.href=requestUrl;
    }

    //debugMsg("<- resizeTaskbarIE");
}
