var traceWindow = null;
var traceText = '';
var preLoadedTraceText = '';
var MAX_LEVEL_TRACED = 3;     // trace is written if level <= MAX_LEVEL_TRACED
var MIN_LEVEL_VALUE = 1;
var MAX_LEVEL_VALUE = 3;
var MAX_TRACE_BUFFER_SIZE = 6000;  // max number of bytes held in 'traceText'
var TRACE_URL = '/html/ui/z/trace.html';
var traceWindowLoaded = false;

function trace(traceLevel, text)
{
   checkTraceWindow();

   if ((traceLevel == null) || (traceLevel == EMPTY) ||
       (traceLevel > MAX_LEVEL_VALUE) || (traceLevel < MIN_LEVEL_VALUE))
      text = 'Error, invalid trace level passed to trace(), trace level is [' + traceLevel + ']'
             + ', trace text is [' + text + ']';
   else
   {
      if (traceLevel <= MAX_LEVEL_TRACED)
      {
         var s = text + '<br>';
         if (traceWindow == null )
         {
            if (traceText.length > MAX_TRACE_BUFFER_SIZE)
            {
               // delete the first 20%
               var t = traceText.substr(traceText.length * .8);

               // find the start of a trace statement.
               var index = t.indexOf('<br>');
               if (index == -1)
                  index = 0;
               else
                  index = index + 4;  // skip past <br>
               var t = t.substr(index);
               traceText = t;
            }
            traceText = traceText + s;
         }
         else if( !traceWindowLoaded )
         {
             preLoadedTraceText += s;
         }
         else
         {
             preLoadedTraceText += s;
             traceWindow.setContentText( preLoadedTraceText );
             preLoadedTraceText = '';
         }
      }
   }
}

function getTrace()
{
   return traceText;
}

function setTraceWindowLoaded()
{
    traceWindowLoaded = true;
}

function checkTraceWindow()
{
   try
   {
      // See if the trace window was displayed then closed.
      if ((traceWindow != null) && (traceWindow.document == null))
      {
         traceWindow = null;
         traceWindowLoaded = false;
         traceText = '';
      }
   }
   catch (e)   // IE throws an exception
   {
      traceWindow = null;
      traceWindowLoaded = false;
      traceText = traceText + 'exception in checkTraceWindow() - KR<br>';
   }
}

function openTraceFunc( text )
{
    HTMLstring = '<HTML>\n';
    HTMLstring += '<HEAD>\n';
    HTMLstring += '<TITLE>Trace</TITLE>\n';
    HTMLstring += '<SCRIPT language="JavaScript">\n';
    HTMLstring += 'var contentText = "' + text + '";\n';
    HTMLstring += '</SCRIPT>\n';
    HTMLstring += '<SCRIPT src="/js/ui/z/trace_window.js" type="text/javascript">\n';
    HTMLstring += '</SCRIPT>\n';
    HTMLstring += '</HEAD>\n';
    HTMLstring += '<FRAMESET rows="95%,*" onload="setContent();">\n';
        HTMLstring += '<FRAME name="content" src="/html/ui/z/trace_content.htm">\n';
        HTMLstring += '<FRAME name="actions" src="/html/ui/z/trace_actions.htm" scrolling="no">\n';
    HTMLstring += '</FRAMESET>\n';
    HTMLstring += '</HTML>';

    traceWindow = window.open(TRACE_URL, 'Trace', 'resizable,scrollbars,height=700,width=400');

    traceWindow.document.write( HTMLstring );
    traceWindow.document.close();
}

function displayTrace()
{
    checkTraceWindow();

    if (traceWindow == null)
    {
        traceText = traceText + '   traceWindow is null, calling open() - KR<br>';

        openTraceFunc( traceText );
    }
}

function clearTrace()
{
    traceText = '';
}

function traceWindowUnloaded()
{
    traceWindow = null;
    traceWindowLoaded = false;
    traceText = 'Trace window closed<br>';
}
