// view ids
var INDEX_MSG_SELECT     = 0;
var INDEX_MSG_GROUPS     = 1;
var INDEX_MSG_EXCEPTIONS = 2;
var INDEX_MSG_ACTTASKS   = 3;
var INDEX_MSG_CONSACT    = 4;
var INDEX_MSG_LIST       = 5;
var INDEX_MSG_BOOKS      = 6;
var idGroups = 'vagrps';
var idExceptions = 'vaexcp';
var idActiveTasks = 'vaat';
var idConsoleActions = 'vaca';
var idBooks = 'vabooks';
var idList  = 'valist';
var idHelp  = 'vahelp';

var helpURL  = '/help/index.jsp';
var idsArray = [idGroups, idExceptions, idActiveTasks, idConsoleActions, idBooks, idList, idHelp];
var taskListTitle = "Task List Work Area"; // ??? substitution var
var vafInitialized = false;

var element1;
var element2;

function test()
{
   parent.message("in test");
}

function init()
{
   parent.trace(3, "-> vaf.init()");

   try
   {
      if (parent.isBrowserSupported() == true)
      {
         // Add event listeners.

         // 'onkeypress' is not a DOM Level 2 event
         if (document.addEventListener)
            // NN: Use the Netscape 4 event handler.
            document.captureEvents(Event.KEYPRESS);

         document.onkeypress = keyPressed;

         parent.trace(3, "   add click listeners");
         for (var i = 0; i < idsArray.length; i++)
         {
            var element = document.getElementById(idsArray[i]);
            if (element.addEventListener)
            {
               // NN, user DOM Level 2 event model
               element.addEventListener("click", changeSelection, false);
               element.addEventListener("dblclick", changeView, false);
            }
            else
            {
               // IE
               element.attachEvent("onclick", changeSelection);
               element.attachEvent("ondblclick", changeView);
            }
         }

         parent.init(document);

         // Preload the background images or the background will change to
         // white while the browser first fetchs the image.
         element1 = document.createElement("div");
         element1.style.backgroundImage = "url(" + acceptableImageName + ")";
         element2 = document.createElement("div");
         element2.style.backgroundImage = "url(" + unacceptableImageName + ")";

         setAcceptable(acceptable);

         parent.trace(3, "   activeViewId is " + activeViewId);
         parent.trace(3, "   selectedViewId is " + selectedViewId);
         var obj = document.getElementById("I" + activeViewId);
         if (obj)
            obj.style.backgroundImage = parent.activeImage;
         parent.setSelected(selectedViewId, document);

         changeMessage(selectedViewId);

         vafInitialized = true;
      }
   }
   catch (e)
   {
      parent.handleError(e, "Error in init() (ui/z/viewsarea.js)");
   }

   parent.trace(3, "<- vaf.init()");
}

function keyPressed(event)
{
   var result = true;   // don't cancel the key
   var key;

   if (!event)
      key = window.event.keyCode;   // IE event model
   else
      key = event.which;            // NN

   if (key == parent.ENTER_KEY)
   {
      changeView(event); // (selectedViewId);
      result = false;   // cancel the key
   }
   else
      result = parent.handleKey(key);

   return result;
}

function changeSelection(event)
{
   parent.trace(3, "-> vaf.changeSelection()");

   if (window.parent.frames['zuimsg'].setText)
      window.parent.frames['zuimsg'].setText(messages[INDEX_MSG_SELECT]);

   if (!event)
      event = window.event;   // IE event model

   //parent.unselectAll(document);

   var id = parent.getIdFromEvent(event);
   if (id != selectedViewId)
   {
      parent.setUnselected(selectedViewId, document);
      parent.setSelected(id, document);
      selectedViewId = id;
   }

   parent.trace(3, "<- vaf.changeSelection()");
}

function changeView(event)
{
   parent.trace(3, "-> vaf.changeView()");

   try
   {
      if (!event)
         event = window.event;   // IE event model

      if (selectedViewId == idBooks)
      {
         window.parent.frames['zuiwaf'].location.href = parent.booksURI;
      }
      else if (selectedViewId == idList)
      {
         window.parent.frames['zuiwaf'].displayTaskLists(taskListTitle);
         window.parent.frames['zuiwaf'].updateState();
      }
      else if (selectedViewId == idHelp)
      {
         openWindow = window.open(helpURL);
      }
      else
      {
         if (selectedViewId == idExceptions)
            setAcceptable(true);
         window.parent.frames['zuiwaf'].location.href = parent.workareaURI + '?view=' + selectedViewId;
      }
      changeMessage(selectedViewId);
   }
   catch (e)
   {
      parent.handleError(e, "Error in changeView() (ui/z/viewsarea.js)");
   }

   parent.trace(3, "<- vaf.changeView()");
}

function changeMessage(id)
{
   var msgIndex = INDEX_MSG_GROUPS;
   switch (id)
   {
      case idExceptions:
         msgIndex = INDEX_MSG_EXCEPTIONS;
         break;
      case idActiveTasks:
         msgIndex = INDEX_MSG_ACTTASKS;
         break;
      case idConsoleActions:
         msgIndex = INDEX_MSG_CONSACT;
         break;
      case idList:
         msgIndex = INDEX_MSG_LIST;
         break;
      case idBooks:
         msgIndex = INDEX_MSG_BOOKS;
         break;
   }

   if (window.parent.frames['zuimsg'].setText)
      window.parent.frames['zuimsg'].setText(messages[msgIndex]);
}

function setBackgroundImage(img)
{
   parent.trace(3, "-> vaf.setBackgroundImage(), img is " + img);

   var body = document.getElementsByTagName("body").item(0);
   body.style.backgroundImage = 'url(' + img + ')';

   parent.trace(3, "<- vaf.setBackgroundImage()");
}

// This is called by workarea.js when a new view is displayed.
function changeDisplayedView(viewId)
{
   parent.trace(3, "-> vaf.changeDisplayedView(), viewId is " + viewId);

   try
   {
      parent.setInactive(activeViewId, document);
      activeViewId = viewId;
      parent.setActive(activeViewId, document);
   }
   catch (e)
   {
      parent.handleError(e, "Error in changeDisplayedView() (ui/z/viewsarea.js)");
   }

   parent.trace(3, "<- vaf.changeDisplayedView()");
}

function setAcceptable(acceptable)
{
   parent.trace(3, "-> vaf.setAcceptable(), acceptable " + acceptable);

   try
   {
      if (acceptable == '0')
         setBackgroundImage(unacceptableImageName);
      else
         setBackgroundImage(acceptableImageName);
   }
   catch (e)
   {
      parent.handleError(e, "Error in setAcceptable() (ui/z/viewsarea.js)");
   }

   parent.trace(3, "<- vaf.setAcceptable()");
}

function setImages(accImage, unaccImage)
{
   parent.trace(3, "-> vaf.setImages(), accImage " + accImage + ", unaccImage " + unaccImage);

   try
   {
      unacceptableImageName = unaccImage;
      acceptableImageName = accImage;
      setAcceptable(acceptable);    // change the background
   }
   catch (e)
   {
      parent.handleError(e, "Error in setImages() (ui/z/viewsarea.js)");
   }

   parent.trace(3, "<- vaf.setImages()");
}

