/*********************************************************** {COPYRIGHT-TOP} ***
* Licensed Materials - Property of IBM
* Tivoli Presentation Services
*
* (C) Copyright IBM Corp. 2006  All Rights Reserved.
*
* US Government Users Restricted Rights - Use, duplication, or
* disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
************************************************************ {COPYRIGHT-END} ***
*******************************************************************************/

/*******************************************************************************
* This file contains AJAX utility functions.
*
* Module History:
* 12/06/2006  JMiller      remove existing and always add new buildMenu scripts in addScriptsToHead
* 12/08/2006  JMiller      merge in patch 58057
*                          handle Mozilla case where xmlHttpRequest object's status is unavailable
* 12/15/2006  JMiller      hide current context menu before processing update for non-IE browsers
* 01/26/2007  JMiller      do not hide current context menu in Firefox, instead leave the possibly out-dated menu open.
*                          This is a temp fix until WCL properly updates displayed context/popup menus during an AJAX update.
* 02/22/2007  JMiller      don't reload WUtilities.js after an AJAX update - reloading of WUtilities cleared the WUtilities_resizeCallbackMap, losing all frame resize actions
* 03/15/2007  JMiller      handle client-side ajax refresh request clashing - return false in start(Href)Request if isAJAXOutstanding
* 03/20/2007  JMiller      merge in patch 59824
* 03/30/2007  JMiller      updateAjaxDivs performance improvement
* 04/02/2007  JMiller      hide old container before adding new container in updateAjaxDivs
* 04/03/2007  JMiller      add refresh form action/value params to startHrefRequest
* 04/04/2007  JMiller      firefox linux update flash fix
* 04/24/2007  JMiller      buildMenu script handling fix
* 07/09/2007  JMiller      Don't remove buildMenu_ scripts if a menu is open
* 09/25/2007  JMiller      L3878 - Frozen context menu (never replace context_ns6.js)
* 12/18/2007  JMiller      S1856 - improve table selection request performance
* 02/06/2008  JMiller      S2621 - Frozen context menu (adjust scriptContent array index after removing script)
*
*******************************************************************************/

var isAJAXOutstanding = false;

var inputData = new FormsData();

var ajaxTables = new Array();

/** Creates XMLHttpRequest **
 */
var xmlHttpRequest = null;
function createXMLRequest() {
   if (window.ActiveXObject) {
      xmlHttpRequest = new ActiveXObject("Microsoft.XMLHTTP");
   }
   else if (window.XMLHttpRequest) {
      xmlHttpRequest = new XMLHttpRequest();
   }
}

function startHrefRequest(url, form, actionValue) {
   if (!isAJAXOutstanding) {
      isAJAXOutstanding = true;

      // Save the request so we can refresh if we encounter an error
      if ( form && refreshForm == "" ) {
         refreshForm = form;
         if ( actionValue ) {
            refreshParams = queryInputFields(form, actionValue);
         }
      }

      createXMLRequest();
      url = url + "&IsAjaxInvoked=YES" + getForms();
      debugInfo("Request: "+url);
      xmlHttpRequest.onreadystatechange = handleStateChange;
      xmlHttpRequest.open("GET", url, true);
      xmlHttpRequest.send(null);
      return true;
   }
   return false;
}

var refreshForm = "";
var refreshParams = "";
function startRequest(form, actionValue) {
   if (!isAJAXOutstanding) {
      isAJAXOutstanding = true;

      createXMLRequest();

      var inputFields = queryInputFields(form, actionValue);

      // Save all the form fields so we can save user changes during the request.
      inputData.initialize();

      //window.status = "Retrieving data from server";
      window.document.body.style.cursor = "wait";

      var idx = form.action.indexOf('#');
      if (idx > -1)
      {
         debug("Removing anchor");
         form.action = form.action.substring(0, idx);
      }

      // Save the request so we can refresh if we get new content.
      refreshForm = form.action;
      refreshParams = inputFields;

      debugInfo("Request; Post Form : "+form.id+", action: " +form.action);
      debugInfo("Input: "+inputFields);

      xmlHttpRequest.open("POST", form.action, true);
      xmlHttpRequest.onreadystatechange = handleStateChange;
      xmlHttpRequest.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");  // Without this line NO PARAMETERS get passed!  Sigh...
      xmlHttpRequest.send(inputFields);
      return true;
   }
   return false;
}

function startRefreshRequest(refreshFormAction, refreshInputFields, ajaxRefresh) {
   createXMLRequest();

   refreshInputFields = refreshInputFields.substring("IsAjaxInvoked=YES&".length);
   if (ajaxRefresh != null && ajaxRefresh == "YES") {
      refreshInputFields = "AjaxRefresh=YES&" + refreshInputFields;
   }
   debug("startRefreshRequest : form [" + refreshFormAction + "] action [" + refreshInputFields + "]");

   isAJAXOutstanding = true;
   //window.status = "Retrieving data from server";
   window.document.body.style.cursor = "wait";

   xmlHttpRequest.open("POST", refreshFormAction, true);
   xmlHttpRequest.onreadystatechange = handleRefreshStateChange;
   xmlHttpRequest.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");  // Without this line NO PARAMETERS get passed!  Sigh...
   xmlHttpRequest.send(refreshInputFields);
}

function getForms()
{
   var formsList = "";
   if (document.forms != null) {
      var addForm = false;
      var formDivs = null;
      for (var i = 0; i < document.forms.length; ++i) {
         addForm = false;
         var parent = document.forms[i].parentNode;
         while (!addForm && parent) {
            if ((parent.nodeType == 1) && (parent.getAttribute("id") == "AJAX_CONTAINER")) {
               addForm = true;
            }
            parent = parent.parentNode;
         }
         if (addForm) {
            formsList += document.forms[i].name + ",";
         }
      }
      if (formsList.length > 0) {
         formsList = "&AjaxForms=" + formsList;
      }
      debug("AJAX forms [" + formsList + "]");
   }
   return formsList;
}

function queryInputFields(form, actionValue) {
   var fieldString = "";
   if (form != null) {
      debug("action: " + actionValue);
      fieldString = "IsAjaxInvoked=YES";

      // Add the list of form names so we can tell when we're all done with
      // AJAX request in the form renderer.
      fieldString = fieldString + getForms();

      fieldList = form.getElementsByTagName("input");
      if (fieldList.length != 0) {
         for (var i = 0; i < fieldList.length; i++) {
            var fieldName = fieldList.item(i).getAttribute("name");
            var fieldType = fieldList.item(i).getAttribute("type");
            // Only process input tags with a NAME attr.
            if ((fieldName != null) && (fieldName != "")) {
               if ((fieldType == "text") || (fieldType == "hidden") || (fieldType == "password")) {
                  debugInfo("queryInputFields: input fieldName is '" + fieldName  + "'  value is '" + fieldList.item(i).value + "'  encodeURI: '" + encodeURI(fieldList.item(i).value) + "'");
                  fieldString = fieldString + "&" + fieldName + "=" + encodeURI(fieldList.item(i).value);
               }
               else if (((fieldType == "checkbox") || (fieldType == "radio")) && (fieldList.item(i).checked)) {
                  debugInfo("queryInputFields: input fieldName is '" + fieldName  + "'  value is '" + fieldList.item(i).value + "'  encodeURI: '" + encodeURI(fieldList.item(i).value) + "'");
                  fieldString = fieldString + "&" + fieldName + "=" + encodeURI(fieldList.item(i).value);
               }
               else if ((actionValue != null) && (actionValue != "") && (fieldName == actionValue)) {
                  if ((fieldType == "submit") || (fieldType == "reset")) {
                     fieldString = fieldString + "&" + fieldName + "=" + encodeURI(fieldList.item(i).value);
                  }
                  else if (fieldType == "image") {
                     fieldString = fieldString + "&" + fieldName + ".x=1" + "&" + fieldName + ".y=1";
                  }
               }
            }
         }
      }

      var selectList = form.getElementsByTagName("select");
      if (selectList.length != 0) {
         for (var i = 0; i < selectList.length; i++) {
            var sel = selectList.item(i);
            for (var j = 0; j < sel.length; j++) {
               if (sel.options[j].selected == true) {
                  debugInfo("queryInputFields: select name is '" + sel.name  + "'  value is '" + sel.options[j].value + "'  encodeURI: '" + encodeURI(sel.options[j].value) + "'");
                  fieldString = fieldString + "&" + sel.name + "=" + encodeURI(sel.options[j].value);
               }
            }
         }
      }

      var textAreaList = form.getElementsByTagName("textarea");
      if (textAreaList.length != 0) {
         for (var i = 0; i < textAreaList.length; i++) {
            var textArea = textAreaList.item(i);
            if (textArea.name != null && textArea.name != "") {
               debugInfo("queryInputFields: textarea name is '" + textArea.name  + "'  value is '" + textArea.value + "'  encodeURI: '" + encodeURI(textArea.value) + "'");
               fieldString = fieldString + "&" + textArea.name + "=" + encodeURI(textArea.value);
            }
         }
      }

      fieldString = fieldString + "&btimestamp="+new Date().getTime();
   }
   return fieldString;
}

function getResponseHeadElement(responseText) {
   var result = null;
   var upperResponse = responseText.toUpperCase();
   var headStartIndex = upperResponse.indexOf("<HEAD>");
   var headEndIndex = upperResponse.indexOf("</HEAD>");
   if (headStartIndex != -1 && headEndIndex != -1) {
      var headElement = document.createElement('div');
      headElement.innerHTML = '<BODY>' + xmlHttpRequest.responseText.substring(headStartIndex + "<HEAD>".length, headEndIndex) + '</BODY>';
      result = headElement;
   }
   return result;
}

function addScriptsToHead(documentElement) {
   if (documentElement != null) {
      var scriptContent = documentElement.getElementsByTagName('script');
      if (scriptContent != null && scriptContent.length > 0) {
         var documentHead = document.getElementsByTagName('head').item(0);
         var currentScripts = documentHead.getElementsByTagName('script');
         //debug("New scripts [" + scriptContent.length + "] existing scripts [" + currentScripts.length + "]");
         var newScript;
         var scriptExists;
         var numberExistingScripts = currentScripts.length;

         //if no visible menu is open, remove existing buildMenu_* function
         //definitions from documentHead to decrease processing time on future updates
         if ( (typeof visibleMenu_ == "undefined") || (visibleMenu_ == null) ) {
            for (var i = numberExistingScripts-1; i >= 0; i--) {
               try {
                  if ( currentScripts[i].innerHTML && currentScripts[i].innerHTML.indexOf('function buildMenu_') != -1 ) {
                     documentHead.removeChild(currentScripts[i]);
                  }
               } catch (e) {
               }
            }
         }

         numberExistingScripts = currentScripts.length;

         for (var j = 0; j < scriptContent.length; j++)
         {
            try {
               scriptExists = false;

               //auto-add buildMenu function definitions, otherwise add script only if script does not already exist in head
               if ( scriptContent[j].innerHTML && scriptContent[j].innerHTML.indexOf('function buildMenu_') != -1 ) {
                  scriptExists = false;
               } else {
                  for (var i = 0; i < numberExistingScripts; i++) {
                     //debug("Existing script(" + i + ") : type [" + (currentScripts[i].type ? currentScripts[i].type : "") + "] lang [" + (currentScripts[i].lang ? currentScripts[i].lang : "") + "] language [" + (currentScripts[i].language ? currentScripts[i].language : "") + "] src [" + (currentScripts[i].src ? currentScripts[i].src : "") + "] html [" + (currentScripts[i].innerHTML ? currentScripts[i].innerHTML : "") + "] ");
                     if (((scriptContent[j].type && currentScripts[i].type && scriptContent[j].type == currentScripts[i].type) ||
                          (scriptContent[j].lang && currentScripts[i].lang && scriptContent[j].lang == currentScripts[i].lang) ||
                          (scriptContent[j].language && currentScripts[i].language && scriptContent[j].language == currentScripts[i].language)) &&
                         ((scriptContent[j].src && currentScripts[i].src && scriptContent[j].src == currentScripts[i].src) ||
                          (scriptContent[j].innerHTML && currentScripts[i].innerHTML && scriptContent[j].innerHTML == currentScripts[i].innerHTML))) {
                        scriptExists = true;
                        break;
                     }
                  }
               }

               if (scriptExists) {
                  // Even though we won't add this script go ahead and run it.
                  // This is necessary for frames when the frame reload script
                  // (fMgr) is included in the response.
                  if (scriptContent[j].innerHTML) {
                     eval(scriptContent[j].innerHTML);
                  }
               } else {
                  debug("Adding script(" + j + ") : type [" + (scriptContent[j].type ? scriptContent[j].type : "") + "] lang [" + (scriptContent[j].lang ? scriptContent[j].lang : "") + "] language [" + (scriptContent[j].language ? scriptContent[j].language : "") + "] src [" + (scriptContent[j].src ? scriptContent[j].src : "") + "] html [" + (scriptContent[j].innerHTML ? scriptContent[j].innerHTML : "") + "]");
                  newScript = document.createElement('script');
                  documentHead.appendChild(newScript);
                  if (scriptContent[j].type) newScript.type = scriptContent[j].type;
                  if (scriptContent[j].lang) newScript.lang = scriptContent[j].lang;
                  if (scriptContent[j].language) newScript.language = scriptContent[j].language;
                  if (scriptContent[j].src) newScript.src = scriptContent[j].src;
                  // IE doesn't allow the innerHTML to be set.
                  //if (scriptContent[j].innerHTML) newScript.innerHTML = scriptContent[j].innerHTML;
                  if (scriptContent[j].innerHTML) newScript.text = scriptContent[j].innerHTML;
                  // Unfortunately this doesn't work...
                  //documentHead.appendChild(scriptContent[j]);
               }
            }
            catch (scriptError) {
               debugErr("Error adding script(" + j + ") : type [" + (scriptContent[j].type ? scriptContent[j].type : "") + "] lang [" + (scriptContent[j].lang ? scriptContent[j].lang : "") + "] language [" + (scriptContent[j].language ? scriptContent[j].language : "") + "] src [" + (scriptContent[j].src ? scriptContent[j].src : "") + "] html [" + (scriptContent[j].innerHTML ? scriptContent[j].innerHTML : "") + "]");
               debugErr("Error name [" + scriptError.name + "] message [" + scriptError.message + "]");
            }
         }
      }
   }
}

function addScriptsToDocument(sourceElement, targetElement) {
   var scriptContent = sourceElement.getElementsByTagName('script');
   if (scriptContent != null && scriptContent.length > 0) {
      var scriptsAdded = new Array();
      var skipped = 0;
      var newScript;
      var numberScripts = scriptContent.length;
      debug("addScriptsToDocument : New scripts [" + scriptContent.length + "]");
      for (var j = 0; j < numberScripts; j++)
      {
         try
         {
            // If the script is the setupTableAjax script save it for later so it won't flash the page.
            if ((!WClient.isBrowserInternetExplorer()) || (!scriptContent[j].innerHTML) || (scriptContent[j].innerHTML.indexOf("setupTableAjax") == -1))
            {
               var scriptKey = scriptContent[j].src ? scriptContent[j].src : scriptContent[j].innerHTML ? scriptContent[j].innerHTML : null;
               if (!scriptsAdded[scriptKey])
               {
                  scriptsAdded[scriptKey] = "true";
                  debug("addScriptsToDocument : Adding script(" + j + ") : type [" + (scriptContent[j].type ? scriptContent[j].type : "") + "] lang [" + (scriptContent[j].lang ? scriptContent[j].lang : "") + "] language [" + (scriptContent[j].language ? scriptContent[j].language : "") + "] src [" + (scriptContent[j].src ? scriptContent[j].src : "") + "] html [" + (scriptContent[j].innerHTML ? scriptContent[j].innerHTML : "") + "]");
                  newScript = document.createElement('script');
                  if (scriptContent[j].type) newScript.type = scriptContent[j].type;
                  if (scriptContent[j].lang) newScript.lang = scriptContent[j].lang;
                  if (scriptContent[j].language) newScript.language = scriptContent[j].language;
                  if (scriptContent[j].src) newScript.src = scriptContent[j].src;
                  // IE doesn't allow the innerHTML to be set.
                  //if (scriptContent[j].innerHTML) newScript.innerHTML = scriptContent[j].innerHTML;
                  if (scriptContent[j].innerHTML) newScript.text = scriptContent[j].innerHTML;
                  // Unfortunately this doesn't work...
                  //documentHead.appendChild(scriptContent[j]);
                  targetElement.appendChild(newScript);
               }
               else
               {
                  debug("addScriptsToDocument : Skipping script [" + scriptKey + "]");
                  skipped++;
               }
            }
            else
            {
               debug("addScriptsToDocument : Will add script later [" + scriptContent[j].innerHTML + "]");
               ajaxTables[ajaxTables.length] = scriptContent[j].innerHTML;
            }
            previousScript = scriptContent[j].innerHTML;
         }
         catch (scriptError)
         {
            debugErr("Error adding script(" + j + ") : type [" + (scriptContent[j].type ? scriptContent[j].type : "") + "] lang [" + (scriptContent[j].lang ? scriptContent[j].lang : "") + "] language [" + (scriptContent[j].language ? scriptContent[j].language : "") + "] src [" + (scriptContent[j].src ? scriptContent[j].src : "") + "] html [" + (scriptContent[j].innerHTML ? scriptContent[j].innerHTML : "") + "]");
            debugErr("Error name [" + scriptError.name + "] message [" + scriptError.message + "]");
         }
      }
      if (skipped > 0)
      {
         debug("addScriptsToDocument : skipped [" + skipped + "]");
      }
   }
}

function addSetupTableAjaxScripts()
{
   if (WClient.isBrowserInternetExplorer())
   {
      debug("addSetupTableAjaxScripts : num scripts [" + ajaxTables.length + "]");
      var extraScriptContainer = document.getElementById('WCL_AJAX_TABLE_SCRIPT_CONTAINER');
      if (!extraScriptContainer)
      {
         // Create a container for the scripts.
         extraScriptContainer = document.createElement('DIV');
         document.body.appendChild(extraScriptContainer);
         extraScriptContainer.setAttribute("id", "WCL_AJAX_TABLE_SCRIPT_CONTAINER");
      }
      var addSetupTableAjax = true;
      var existingScripts = extraScriptContainer.getElementsByTagName('SCRIPT');
      // Add the current scripts to the container.
      for (var index = 0; index < ajaxTables.length; ++index)
      {
         // See if we already have this script.
         if ((existingScripts != null) && (existingScripts.length > 0))
         {
            for (var existingIndex = 0; existingIndex < existingScripts.length; existingIndex++)
            {
               if (existingScripts[existingIndex].innerHTML == ajaxTables[index])
               {
                  addSetupTableAjax = false;
                  break;
               }
            }
         }

         if (addSetupTableAjax)
         {
            var newScript = document.createElement('script');
            newScript.type = "text/javascript";
            newScript.text = ajaxTables[index];
            debug("addSetupTableAjaxScripts : Adding [" + ajaxTables[index] + "]");
            extraScriptContainer.appendChild(newScript);
         }
      }
   }
}

function updateAjaxDivs(tempContent, updateForm, updateParams) {
   var anyDivs = null;
   var doAgain = true;
   var addExtra = true;
   var result = true;

   // If the response indicates the portlet threw an exception, disregard this ajax
   // update and rerender the entire page
   //Speed improvements:
   //  don't reference innerHTML property of tempContent repeatedly
   //  use regular expressions instead of indexOf
   var tempContent_innerHTML = tempContent.innerHTML;
   var puRe = new RegExp("This portlet is unavailable");
   var acRe = new RegExp("AJAX_CONTAINER");
   if (tempContent != null && tempContent_innerHTML.length > 0 &&
       (puRe.test(tempContent_innerHTML) ||
        !acRe.test(tempContent_innerHTML))) {
      doAgain = false;
      addExtra = false;
      result = false;
      debug("Detected a problem displaying portlet, so redisplaying page without ajax");
      window.setTimeout("startRefreshRequest('" + updateForm + "', '" + updateParams + "', 'NO')", 10);
   }
   while (doAgain == true) {
      anyDivs = tempContent.getElementsByTagName("DIV");
      doAgain = false;
      for (var i = 0; i < anyDivs.length && doAgain == false; i++) {
         // If we find an AJAX container in the response
         if (anyDivs[i].getAttribute("id") == "AJAX_CONTAINER") {
            // Replace its old contents in the DOM with the new contents
            var newContent = anyDivs[i].firstChild;
            if (newContent != null) {
               var newId = newContent.getAttribute("id");
               debug("Found a container [" + newId + "]");
               var oldContent = document.getElementById(newId);
               if (newId.substring(0, 3) == "CL_") {
                  debug("Processing TD [" + newId + "]");
                  var oldTd = oldContent.parentNode.parentNode;
                  var oldTr = oldTd.parentNode;
                  var newTd = newContent.parentNode.parentNode;
                  oldTr.replaceChild(newTd, oldTd);

                  //avoid doAgain processing if TD doesn't contain an AJAX_CONTAINER
                  var childDivs = newContent.getElementsByTagName("DIV");
                  for (var j = 0; j < childDivs.length && doAgain == false; j++) {
                     if (childDivs[j].getAttribute("id") == "AJAX_CONTAINER") {
                        doAgain = true;
                     }
                  }
                  if ( doAgain == false ) {
                     //divs in array (including div at index i were removed), 
                     //so decrement i to pick up next unprocessed DIV
                     i = i - 1;
                  }
               }
               else if (oldContent != null && newContent.innerHTML != oldContent.innerHTML) {
                  debug("Processing container [" + newId + "]");
                  var oldContainer = oldContent.parentNode;

                  //debug("old");
                  //debugHtml(oldContent.innerHTML);
                  //debug("new");
                  //debugHtml(newContent.innerHTML);

                  //In Mozilla, while updating containers (table ones at least) the old
                  //container remains visible after the new one is added; this
                  //causes the auto rows per viewport table code to initially
                  //set the new table height too small before correcting itself
                  //in the second pass through setupTable.  To prevent this flash
                  //we now hide the oldContainer before adding the new one.  If
                  //the add fails, we reset the display of the old container.
                  var oldDisplay = null;
                  if (WClient.isBrowserMozilla()) {
                     debug("Hiding child");
                     try {
                        // hide the old content
                        if (oldContainer.childNodes.length > 0) {
                           oldDisplay = oldContainer.childNodes[0].style.display;
                           oldContainer.childNodes[0].style.display='none';
                        }
                     }
                     catch (hideError) {
                        debugErr("Got an error hiding old content [" + hideError.name + "] [" + hideError.message + "]");
                     }
                  }

                  // Arg, update the forms here for Firefox so you can't see the updates happen.
                  if (WClient.isBrowserMozilla()) {
                     inputData.updateInputs(oldContent, newContent);
                  }

                  debug("Adding child");
                  try {
                     oldContainer.appendChild(newContent);
                  }
                  catch (addError) {
                     debugErr("Got an error adding new content: " + addError.toString());
                  }

                  // Arg, update the forms here for IE so that the checkbox update will work.
                  // The checkboxes need to be in the document so that we can set checked.
                  if (WClient.isBrowserInternetExplorer()) {
                     inputData.updateInputs(oldContent, newContent);
                  }

                  debug("Removing child");
                  try {
                     if ( WClient.isBrowserMozilla() && oldContainer.childNodes.length == 1 ) {
                        // Add failed so unhide the old content
                        oldContainer.childNodes[0].style.display=oldDisplay;
                     } else {
                        // Remove the old content and any scripts we added.
                        while (oldContainer.childNodes.length > 1) {
                           oldContainer.removeChild(oldContainer.childNodes[0]);
                        }
                     }
                  }
                  catch (removeError) {
                     debugErr("Got an error removing old content [" + removeError.name + "] [" + removeError.message + "]");
                  }

                  // Now add any scripts that were in the response because
                  // IE removes them when we do innerHTML = responseText.
                  addScriptsToDocument(newContent, oldContainer);

                  // Redo this processing as we could have nested AJAX content
                  //avoid doAgain processing if TD doesn't contain an AJAX_CONTAINER
                  var childDivs = newContent.getElementsByTagName("DIV");
                  for (var j = 0; j < childDivs.length && doAgain == false; j++) {
                     if (childDivs[j].getAttribute("id") == "AJAX_CONTAINER") {
                        doAgain = true;
                     }
                  }
                  if ( doAgain == false ) {
                     //divs in array (including div at index i were removed), 
                     //so decrement i to pick up next unprocessed DIV
                     i = i - 1;
                  }
               }
               else if ((oldContent == null) && (newId.substring(0, 3) == "PG_")) {
                  debug("Response contains new content so refresh [" + newId + "]");
                  addExtra = false;
                  result = false;
                  isAJAXOutstanding = false;
                  window.setTimeout('startRefreshRequest("' + updateForm + '", "' + updateParams + '", "YES")', 10);
                  //startRefreshRequest(updateForm);
                  break;
               }
            }
         }
      }
   }
   if (addExtra) {
      // Add any scripts that were outside of any AJAX containers.
      var extraScripts = tempContent.getElementsByTagName('script');
      if (extraScripts != null && extraScripts.length > 0) {
         debug("Adding extra scripts that were not in an AJAX container");
         // Remove the container that holds the scripts so we can start over.
         var extraScriptContainer = document.getElementById('WCL_AJAX_SCRIPT_CONTAINER');
         if (extraScriptContainer) {
            extraScriptContainer.parentNode.removeChild(extraScriptContainer);
         }
         // Create the container to hold the scripts.
         extraScriptContainer = document.createElement('div');
         document.body.appendChild(extraScriptContainer);
         extraScriptContainer.setAttribute("id", "WCL_AJAX_SCRIPT_CONTAINER");
         // Now add the scripts to this container.
         addScriptsToDocument(tempContent, extraScriptContainer);
      }
   }
   return result;
}

function handleStateChange() {
   if (typeof xmlHttpRequest != "undefined" && xmlHttpRequest != null && xmlHttpRequest.readyState == 4) {
      //wrap retrieve of xmlHttpRequest.status in try/catch to handle Mozilla case where object's status is unavailable
      var status = -1;
      try {
         status = xmlHttpRequest.status;
      } catch (e) {
         status = -1;
         isAJAXOutstanding = false;
      }
      if (status == 200) {
         try {
            var startTime = new Date();

            // Reset the ajax tables list.
            ajaxTables = new Array();

            // Save the refresh form.
            var previousForm = refreshForm;
            var previousParams = refreshParams;

            //window.status = "";
            var tempContent = document.createElement("div");
            tempContent.setAttribute("id","ServerResponse");
            //domContainer.appendChild(tempContent);

            //debug("Reading in complete response");
            //debugHtml(xmlHttpRequest.responseText);

            // Get scripts from the response HEAD and put them in the doc HEAD.
            var responseHead = getResponseHeadElement(xmlHttpRequest.responseText);
            addScriptsToHead(responseHead);

            debug("Reading in response");
            tempContent.innerHTML = xmlHttpRequest.responseText;

            //remove bothersome scripts from response head
            var scriptContent = tempContent.getElementsByTagName('script');
            if ( scriptContent != null ) {
               for (var j = 0; j < scriptContent.length; j++) {
                  try {
                     if ( scriptContent[j].src ) {
                        if ( scriptContent[j].src.indexOf("WUtilities.js") != -1 ) {
                           //remove WUtilties.js node from ajax update; prevent loss of onresize actions
                           tempContent.removeChild(scriptContent[j]);
                           j = j - 1;  //decrement j to account for shift in array
                        } else if ( (typeof visibleMenu_ != "undefined") && (scriptContent[j].src.indexOf("context_ns6.js") != -1) ) {
                           //if a visibleMenu_ is defined and context_ns6.js exists, remove
                           //context_ns6.js script tag from the tempContent, as to not freeze
                           //possible context menus.   Note this a temp fix that will leave an
                           //outdated context menu displayed and is only needed until WCL properly
                           //handles AJAX updates of displayed context/popup menus.
                           tempContent.removeChild(scriptContent[j]);
                           j = j - 1;  //decrement j to account for shift in array
                        }
                     }
                  } catch(e) {
                  }
               }
            }

            //debugHtml(tempContent.innerHTML);
            debug("Done reading in response");

            // Mark any input components as ok to update.
            inputData.markInputs(tempContent);

            // Now let's look in the response from the server
            if (updateAjaxDivs(tempContent, previousForm, previousParams))
            {
               addSetupTableAjaxScripts();
               callRunScripts();
            }

            isAJAXOutstanding = false;
            debug("handleStateChange : time to process AJAX request [" + (new Date().getTime() - startTime.getTime()) + "]");
         }
         catch(err) {
            debugErr("Got an error [" + err.name + "] [" + err.message + "]");
            debugErr(err.toString());
         }
         window.document.body.style.cursor = "auto";
      }
      //else {
      //   debug("handleStateChange : status [" + xmlHttpRequest.status + "]");
      //}
   }
   //else {
   //   debug("handleStateChange : readyState [" + xmlHttpRequest.readyState + "]");
   //}
}

function handleRefreshStateChange() {
   if (typeof xmlHttpRequest != "undefined" && xmlHttpRequest != null && xmlHttpRequest.readyState == 4) {
      if (xmlHttpRequest.status == 200) {
         try {

            debug("handleRefreshStateChange");
            //window.status = "";

            // Reset the ajax tables list.
            ajaxTables = new Array();

            //debugHtml(xmlHttpRequest.responseText);

            // Get scripts from the response HEAD and put them in the doc HEAD.
            var responseHead = getResponseHeadElement(xmlHttpRequest.responseText);
            addScriptsToHead(responseHead);

            if (!handleLoginPortlet(xmlHttpRequest.responseText)) {
               // Update the document with what we got in the response.
               document.body.innerHTML = xmlHttpRequest.responseText;

               // Now add any scripts that were in the response because
               // IE removes them when we do innerHTML = responseText.
               addScriptsToDocument(document.body, document.body);

               addSetupTableAjaxScripts();
               callRunScripts();

               if (WClient.isBrowserInternetExplorer()) {
                  // Since this is a new page let's scroll to the top.
                  window.scroll(0, 0);
               }
            }

            isAJAXOutstanding = false;
         }
         catch(err) {
            debugErr("Got an error refreshing [" + err.name + "] [" + err.message + "]");
         }
         window.document.body.style.cursor = "auto";
      }
      //else {
      //   debug("handleRefreshStateChange : status [" + xmlHttpRequest.status + "]");
      //}
   }
   //else {
   //   debug("handleRefreshStateChange : readyState [" + xmlHttpRequest.readyState + "]");
   //}
}

function handleLoginPortlet(responseString) {
   var result = false;
   // The portlet login JSP spits out invalid HTML. Firefox won't display
   // invalid HTML when you set document.body.innerHTML.  Let's see if this
   // is the login portlet and if it is then let's minimize and then maximize
   // it so FF will redraw it correctly.
   if (WClient.isBrowserMozilla()) {
      var indexJsp   = responseString.indexOf("LoginView.jsp");
      var indexForm  = responseString.indexOf("name=\"LoginForm\"");
      var indexUser  = responseString.indexOf("id=\"userID\" name=\"wps.portlets.userid\"");
      if ((indexJsp != -1) && (indexForm != -1) && (indexUser != -1)) {
         result = true;
         try {
            debug("handleLoginPortlet : refreshing login portlet...");
            // Minimize the login portlet.
            var minimize  = responseString.substring(0, indexForm).lastIndexOf("src='/wps/themes/html/title_alt_minimize.gif'");
            var hrefStart = responseString.substring(0, minimize).lastIndexOf("href='") + "href='".length;
            var hrefEnd   = responseString.substring(hrefStart).indexOf("'") + hrefStart;
            var minHref   = responseString.substring(hrefStart, hrefEnd);
            createXMLRequest();
            xmlHttpRequest.onreadystatechange = restoreLoginPortlet;
            debug("handleLoginPortlet : minimize href [" + minHref + "]");
            xmlHttpRequest.open("POST", minHref, true);
            xmlHttpRequest.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
            xmlHttpRequest.send(null);
         }
         catch (err) {
            debugErr("Got an error refreshing login portlet [" + err.name + "] [" + err.message + "]");
            window.location = null;
         }
      }
   }
   return result;
}

function restoreLoginPortlet() {
   if (typeof xmlHttpRequest != "undefined" && xmlHttpRequest != null && xmlHttpRequest.readyState == 4) {
      if (xmlHttpRequest.status == 200) {
         try {
            debug("handleLoginRestore");
            //debugHtml(xmlHttpRequest.responseText);
            var restore     = xmlHttpRequest.responseText.indexOf("title_alt_restore.gif");
            var hrefStart   = xmlHttpRequest.responseText.substring(0, restore).lastIndexOf("href='") + "href='".length;
            var hrefEnd     = xmlHttpRequest.responseText.substring(hrefStart).indexOf("'") + hrefStart;
            var restoreHref = xmlHttpRequest.responseText.substring(hrefStart, hrefEnd);
            debug("restoreLoginPortlet : restore href [" + restoreHref + "]");
            window.location = restoreHref;
         }
         catch (err) {
            debugErr("Got an error restoring login portlet [" + err.name + "] [" + err.message + "]");
            window.location = null;
         }
      }
   }
}

function callRunScripts() {
   // Javascript files that get added to the document do not get loaded
   // in IE until the page is loaded. This means that during the
   // addScriptsToDocument function if a js file is added and then a
   // function is called from that file it will not run (popup menus
   // call contextMenuSetIcons in context_ie.js). Let's add an image to
   // the end of the document so that when it's finished loading we can
   // run all the scripts again so that they are run successfully.
   if (document.images.length > 0) {
      var refreshImage = document.createElement('img');
      refreshImage.onload = runScripts;
      refreshImage.src    = document.images[document.images.length - 1].src;
      refreshImage.width  = '0';
      refreshImage.height = '0';
      document.body.appendChild(refreshImage);
   }
   else {
      setTimeout("runScripts()", 3000);
   }
}

function runScripts() {
   // Ok - if any scripts are included in the response run them.
   var anyScripts = document.getElementsByTagName('script');
   debug("runScripts : scripts [" + anyScripts.length+ "]");
   var previousScript = null;
   var skipped = 0;
   var startTime = new Date();
   if (anyScripts.length > 0) {
      for (var j = 0; j < anyScripts.length; j++) {
         try {
            // We don't need to eval the context menu buildMenu functions.
            // The setupTableAjax scripts are run during updateAjaxDivs.
            if ((anyScripts[j].innerHTML) && (anyScripts[j].innerHTML.indexOf("function buildMenu") == -1)) {
               if (previousScript == null || anyScripts[j].innerHTML != previousScript) {
                  debugHtml(anyScripts[j].innerHTML);
                  eval(anyScripts[j].innerHTML);
               }
               else {
                  skipped++;
               }
               previousScript = anyScripts[j].innerHTML;
            }
         }
         catch (runError) {
            debugErr("Got an error running script [" + runError.name + "] [" + runError.message + "]");
         }
      }
      if (skipped > 0) {
         debug("runScripts : skipped [" + skipped + "]");
      }
   }
   debug("runScripts : time to run scripts [" + (new Date().getTime() - startTime.getTime()) + "]");
   setTimeout("runOnloads();", 0);
}

function runOnloads() {
   // Run any images onloads that did not get run.
   var images = document.getElementsByTagName('img');
   var numImages = images.length;
   debug("runOnloads : images [" + numImages + "]");
   var current = null;
   var onloadString = null;
   for (var x = 0; x < numImages; ++x) {
      if (images[x].onload) {
         onloadString = null;
         current = images[x].onload.toString();
         if (WClient.isBrowserMozilla()) {
            if (current.indexOf('function onload(event)') == 0) {
               onloadString = current.substring(24, (current.length - 2));
            }
         }
         else {
            if (current.indexOf('function anonymous()') == 0) {
               onloadString = current.substring(23, (current.length - 2));
            }
         }
         debug("runOnloads : onload [" + onloadString + "]");

         //if ((onloadString != null) && ((onloadString.indexOf('WOverview.') != -1) || (onloadString.indexOf('WImageViewport.') != -1) || (onloadString.indexOf('WToggleButton.') != -1))) {
            debug("runOnloads : rerunning onload [" + onloadString + "]");
            eval(onloadString);
         //}
      }
   }
}

function FormsData()
{
   var formsData  = new Array();
   var inputList  = new Array();
   var changeList = new Array();
   var typeList   = new Array();

   this.initialize   = initialize;
   this.markInputs   = markInputs;
   this.updateInputs = updateInputs;
   this.addField     = addField;
   this.getField     = getField;
   this.reset        = reset;
   this.markInput    = markInput;

   function initialize()
   {
      this.reset();

      var fieldList = document.getElementsByTagName("input");
      for (var i = 0; i < fieldList.length; i++) {
         this.addField(fieldList.item(i), "input");
      }
      var textAreaList = document.getElementsByTagName("textarea");
      for (var i = 0; i < textAreaList.length; i++) {
         this.addField(textAreaList.item(i), "textarea");
      }
      var selectList = document.getElementsByTagName("select");
      for (var i = 0; i < selectList.length; i++) {
         this.addField(selectList.item(i), "select");
      }
   }

   function addField(input, type)
   {
      if ((input != null) && (input.id != null) && (input.id != "") && (input.name != null) && (input.name != "") && ((type != "input") || (input.type != "hidden")))
      {
         // See if we already have this input.
         var newInput = this.getField(input);
         if (newInput == null)
         {
            newInput = new FormField();
            formsData[formsData.length] = newInput;
         }
         newInput.update(input, type);
      }
   }

   function markInputs(docElement)
   {
      var changeType = 0;
      var fieldList = docElement.getElementsByTagName("input");
      for (var i = 0; i < fieldList.length; i++) {
         this.markInput(fieldList, i, fieldList.item(i).type);
      }
      var textAreaList = docElement.getElementsByTagName("textarea");
      for (var i = 0; i < textAreaList.length; i++) {
         this.markInput(textAreaList, i, "textarea");
      }
      var selectList = docElement.getElementsByTagName("select");
      for (var i = 0; i < selectList.length; i++) {
         this.markInput(selectList, i, "select");
      }
   }

   function markInput(fields, index, type)
   {
      // 0: ID was not found in saved data.
      // 1: Input was found and was the same.
      // 2: Server value was different from saved.
      var changed = 0;
      var input = fields.item(index);
      // Get the original input of this name.
      var num = formsData.length;
      for (var i = 0; i < num; ++ i)
      {
         if ((formsData[i].getName() == input.name) && (formsData[i].getType() == type))
         {
            if (type == "radio")
            {
               if (!formsData[i].tested)
               {
                  // Need to check all the radios to see if the server changed anything.
                  var match = true;
                  var numFields = fields.length;
                  var numValues = formsData[i].values.length;
                  //debug("markInput : testing radio buttons [" + formsData[i].getName() + "]");
                  for (var x = 0; x < numFields && match; ++x)
                  {
                     if (fields[x].type == "radio" && fields[x].name == formsData[i].getName())
                     {
                        match = false;
                        for (j = 0; j < numValues && !match; ++j)
                        {
                           if ((formsData[i].values[j] == fields[x].value) && (formsData[i].checks[j] == fields[x].checked) && (formsData[i].ids[j] == fields[x].id))
                           {
                              match = true;
                              formsData[i].matched[j] = match;
                           }
                        }
                     }
                  }
                  if (match)
                  {
                     //debug("markInput : all radio buttons from response are in original page");
                     // See if all the original checks were marked to tell if there were any original
                     // that were left out of the server response.
                     for (j = 0; j < numValues && match; ++j)
                     {
                        if (!formsData[i].matched[j])
                        {
                           //debug("markInput : radio button was not in server response [" + formsData[i].values[j] + "]");
                           // Found an entry that was not in the response.
                           match = false;
                        }
                     }
                     // Save this info for later so we don't have to do that junk again!
                     formsData[i].passed = match;
                  }
                  formsData[i].tested = true;
               }
               changed = (formsData[i].passed ? 1 : 2);
               //debug("markInput : name [" + input.name + "] type [" + type + "] changed [" + changed + "]");
            }
            else if ((type == "checkbox") && (input.id = formsData[i].getId()))
            {
               changed = ((formsData[i].value == input.value && formsData[i].checked == input.checked) ? 1 : 2);
               //debug("markInput : name [" + input.name + "] type [" + type + "] changed [" + changed + "]");
            }
            else if ((type == "text" || type == "password" || type == "textarea") && (input.id = formsData[i].getId()))
            {
               changed = ((formsData[i].value == input.value) ? 1 : 2);
               //debug("markInput : name [" + input.name + "] type [" + type + "] changed [" + changed + "]");
            }
            else if ((type == "select") && (input.id = formsData[i].getId()))
            {
               // Make sure all of the options are the same.
               var match = true;
               var numOptions = input.options.length;
               //debug("markInput : name [" + formsData[i].getId() + "] selections [" + numOptions + "]");
               for (var z = 0; z < numOptions && match; ++z)
               {
                  if ((input.options[z].value != formsData[i].values[z]) || (input.options[z].text != formsData[i].selections[z]) || (input.options[z].selected != formsData[i].selected[z]))
                  {
                     match = false;
                  }
               }
               changed = match ? 1 : 2;
               //debug("markInput : name [" + input.name + "] type [" + type + "] changed [" + changed + "]");
            }
            //break;
         }
      }
      if (changed > 0)
      {
         //debug("markInput : field changed so saving name [" + input.name + "] id [" + input.id + "] type [" + type + "] changed [" + changed + "]");
         inputList[inputList.length] = input;
         changeList[changeList.length] = changed;
         typeList[typeList.length] = type;
      }
   }

   function updateInputs(oldContent, newContent)
   {
      var num = inputList.length;
      for (var index = 0; index < num; ++index)
      {
         try
         {
            var oldInput = document.getElementById(inputList[index].id);
            //debug("updateInputs : processing input [" + inputList[index].id + "]");
            if ((typeList[index] == "text" || typeList[index] == "password" || typeList[index] == "textarea") && (oldInput.value != inputList[index].value) && (changeList[index] == 1))
            {
               //debug("updateInputs : updating [" + inputList[index].id + "] [" + inputList[index].name + "] type [" + typeList[index] + "] text [" + oldInput.value + "]");
               inputList[index].value = oldInput.value;
            }
            else if ((typeList[index] == "checkbox") && (oldInput.checked != inputList[index].checked) && (changeList[index] == 1))
            {
               //debug("updateInputs : updating [" + inputList[index].id + "] [" + inputList[index].name + "] type [" + typeList[index] + "] checked [" + oldInput.checked + "]");
               inputList[index].checked = oldInput.checked;
            }
            else if ((typeList[index] == "radio") && (oldInput.checked != inputList[index].checked) && (changeList[index] == 1))
            {
               //debug("updateInputs : updating [" + inputList[index].id + "] [" + inputList[index].name + "] type [" + typeList[index] + "] checked [" + oldInput.checked + "]");
               inputList[index].checked = oldInputs.checked;
            }
            else if (typeList[index] == "select")
            {
               if (changeList[index] == 1)
               {
                  //debug("updateInputs : updating [" + inputList[index].id + "] [" + inputList[index].name + "] type [" + typeList[index] + "] selected [" + oldInput.value + "]");
                  for (var i = 0; i < oldInput.length; ++i)
                  {
                     inputList[index].options[i].selected = oldInput.options[i].selected;
                  }
               }
               else if (changeList[index] == 2)
               {
                  //debug("updateInputs : resetting [" + inputList[index].id + "] [" + inputList[index].name + "] type [" + typeList[index] + "]");
                  if ((inputList[index].type != null) && (inputList[index].type == "select-multiple"))
                  {
                     inputList[index].selectedIndex = -1;
                  }
                  else
                  {
                     inputList[index].selectedIndex = 0;
                  }
               }
            }
         }
         catch (inputError)
         {
            debugErr("Error updating input " + inputList[index].id + " [" + inputError.name + "] message [" + inputError.message + "]");
         }
      }
   }

   function getField(input)
   {
      var result = null;
      var num = formsData.length;
      for (var i = 0; i < num; ++i)
      {
         if (formsData[i].equals(input))
         {
            result = formsData[i];
            break;
         }
      }
      return result;
   }

   function reset()
   {
      formsData  = new Array();
      inputList  = new Array();
      changeList = new Array();
      typeList   = new Array();
   }
}

function FormField()
{
   var id;
   var type;
   var name;

   this.getId   = getId;
   this.getType = getType;
   this.getName = getName;

   this.update = update;
   this.equals = equals;

   function getId()
   {
      return id;
   }

   function getType()
   {
      return type;
   }

   function getName()
   {
      return name;
   }

   function update(input, type)
   {
      if (type == "input")
      {
         type = input.type;
      }
      if ((type == "text") || (type == "password") || (type == "textarea"))
      {
         setData(input.id, type, input.name);
         this.value = input.value;
      }
      else if (type == "checkbox")
      {
         setData(input.id, type, input.name);
         this.value   = input.value;
         this.checked = input.checked;
      }
      else if (type == "radio")
      {
         setData(input.id, type, input.name);
         if (this.values == null)
         {
            this.values  = new Array();
            this.checks  = new Array();
            this.matched = new Array();
            this.ids     = new Array();
         }
         var numValues = this.values.length;
         this.values[numValues]  = input.value;
         this.checks[numValues]  = input.checked;
         this.ids[numValues]     = input.id;
         this.matched[numValues] = false;
         this.tested = false;
         this.passed = false;
      }
      else if (type == "select")
      {
         setData(input.id, type, input.name);
         this.values     = new Array();
         this.selections = new Array();
         this.selected   = new Array();
         var numSelections = input.options.length;
         for (var i = 0; i < numSelections; ++i)
         {
            this.values[i]     = input.options[i].value;
            this.selections[i] = input.options[i].text;
            this.selected[i]   = input.options[i].selected;
         }
      }
   }

   function setData(fieldId, fieldType, fieldName)
   {
      id   = fieldId;
      type = fieldType;
      name = fieldName;
   }

   function equals(field)
   {
      var result = false;
      if ((field.type != null) && (field.type == "radio")) {
         // Group radio buttons by name.
         result = (field.name == name);
      }
      else {
         result = ((field.id == id) && (field.name == name));
      }
      return result;
   }
}

function debug(msg) {
   debugWithColor(msg,"black",false);
}

function debugErr(msg) {
   debugWithColor(msg,"red",false);
}

function debugInfo(msg) {
   debugWithColor(msg,"blue",false);
}

function debugHtml(msg) {
   debugWithColor(msg,"green",true);
}

var debugWindow = null;
var informed = false;
var debugOn = false;
function debugWithColor(msg, color, ignoreFormatting) {
   if (debugOn == true) {
      if (debugWindow == null) {
         debugWindow = window.open("","","width=800,heigth=200,left=0,top=0,resize=yes,scrollbars=yes");
         window.document.body.onunload = "debugWindow.document.close();debugWindow=null";
      }
      try {
         if (debugWindow != null) {
            if (ignoreFormatting == false) {
               debugWindow.document.write('<ul><li style="color:'+color+'">');
               debugWindow.document.write(msg);
               debugWindow.document.write("</ul>");
            }
            else {
               debugWindow.document.write('<ul><li style="color:'+color+'"><XMP>');
               debugWindow.document.write(msg);
               debugWindow.document.write("</XMP></ul>");
            }

            debugWindow.scroll(0,1000000);
         }
         window.focus();
      }
      catch (msg){
         if (informed == false) {    // If user has already been informed, don't do it again
            alert("A popup blocker is preventing the debug info from displaying.");
            informed = true;
         }

      }
   }
}

function trim(str) {
  return str.replace(/^\s*|\s*$/g,"");
}

