/*********************************************************** {COPYRIGHT-TOP} ***
* Licensed Materials - Property of IBM
* Tivoli Presentation Services
*
* (C) Copyright IBM Corp. 2002, 2006  All Rights Reserved.
*
* US Government Users Restricted Rights - Use, duplication, or
* disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
************************************************************ {COPYRIGHT-END} ***
*******************************************************************************/

/*******************************************************************************
* This file contains all of the javascript functions used by the WCL renderers
* during traditional execution when AJAX is not being used. The functions
* defined here must be stateless -- that is, no member variables can be defined,
* so all state information must be passed into the function as parameters.
*
* Module History:
* 08/15/2006  JMiller      adjustTableHeight call and column resizing fix for IE
* 08/30/2006  JMiller      adjustTableHeight returns viewRows value
* 09/20/2006  JMiller      Empty column header rendering fix
* 01/12/2007  JMiller      adjustTableHeight fix - call getTop with recursive flag to correctly get table offsetTop
* 02/20/2007  Koziol       add doTblKeyPress - allows space to be hit to select radio button for a row
* 03/01/2007  JMiller      remove table hoverTitle calls on resize
* 03/02/2007  JMiller      adjust table height only when needed
* 03/13/2007  JMiller      fix firefox for windows flash after ajax update
* 03/14/2007  JMiller      adjustTableHeight fix - parseInt numeric attributes before compare
* 04/17/2007  JMiller      ajax resize table on frame resize fixes
*******************************************************************************/
var MIN_COL_WIDTH = 30;
var MIN_ROWS_VISIBLE = 2;
var MAX_COL_WIDTH = 9999;
var SCROLL_LOCK = "isScrolling";


/**
 * Static delcaration of WTableData class.
 */
if ( !self.WTableData )
{
    self.WTableData = new WTableDataImpl();
}

function WTableDataImpl()  // @02
{
    this.tableColumns_ = null;
}


/** AWInputComponent **
 * action - the name of the action. do not encode because it is used as the
 *          value of a hidden input field.
 * formName - this encoded name of the form
 * wclhidden - the encoded name of the hidden field
 */
function frmAct(action, formName, wclhidden) {
   if (document != null && document.forms != null && formName != null) {
      var form = document.forms[formName];
      if (form != null) {
         eval( "form." + wclhidden + ".value = '" + action + "'" );
      }
   }
}

/** WNotebook **
 * formName - the encoded name of the form
 * actionName - the name of the action being performed
 * actionValue - the name of the component performing the action
 * actionNameEnc - the encoded name of the action being performed
 * wclhidden - the encoded name of the hidden field
 * wclanchor - the encoded name of the hidden field for the anchor
 */
function doNb(formName, actionName, actionValue, actionNameEnc, wclhidden, wclanchor) {
   return doSubmit(formName, actionName, actionValue, null, actionNameEnc, wclhidden, wclanchor);
}

/** WWizard **
 * formName - the encoded name of the form
 * actionName - the name of the action being performed
 * actionValue - the name of the component performing the action
 * actionNameEnc - the encoded name of the action being performed
 * wclhidden - the encoded name of the hidden field
 * wclanchor - the encoded name of the hidden field for the anchor
 */
function doWiz(formName, actionName, actionValue, actionNameEnc, wclhidden, wclanchor) {
   return doSubmit(formName, actionName, actionValue, null, actionNameEnc, wclhidden, wclanchor);
}

/** WTree (for the expand/collapse events) **
 * formName - the encoded name of the form
 * actionName - the name of the action being performed
 * actionValue - the name of the component performing the action
 * anchorName - the name of the anchor used when the page is refreshed
 * actionNameEnc - the encoded name of the action being performed
 * wclhidden - the encoded name of the hidden field
 * wclanchor - the encoded name of the hidden field for the anchor
 * idName - the encoded name of the hidden field that specifies which tree in the form is performing the action
 */
function doTree(formName, actionName, actionValue, anchorName, actionNameEnc, wclhidden, wclanchor, idName){
   if (document != null && document.forms != null && formName != null) {
      var form = document.forms[formName];
      if (form != null) {
         if(idName != null){
             eval("form." + idName + ".value = '" + idName + "'");
         }
      }
   }
   return doSubmit(formName, actionName, actionValue, anchorName, actionNameEnc, wclhidden, wclanchor);
}

/**
 * formName - the encoded name of the form
 * actionName - the name of the action being performed
 * actionValue - the name of the component performing the action
 * anchorName - the name of the anchor used when the page is refreshed
 * actionNameEnc - the encoded name of the action being performed
 * wclhidden - the encoded name of the hidden field
 * wclanchor - the encoded name of the hidden field for the anchor
 */
function doSubmit(formName, actionName, actionValue, anchorName, actionNameEnc, wclhidden, wclanchor) {
   if (document != null && document.forms != null && formName != null) {
      var form = document.forms[formName];
      if (form != null) {
         if (actionName != null) {
            eval("form." + actionNameEnc + ".value = '" + actionValue + "'");
            eval("form." + wclhidden + ".value = '" + actionName + "'");
         }

         // We have to store the anchor as a hidden field so that it gets passed
         // along when the form's method is GET.  (When the method is GET, the
         // parameters on the form's action are ignored!)  The date ensures we'll
         // have a unique URL so that a URL can be invoked twice consecutively.
         if (anchorName != null) {
            var aDate = new Date();
            eval("form." + wclanchor + ".value = '" + anchorName + '_' + aDate.getTime() + "'");
            var idx = form.action.indexOf('#');
            if (idx > -1) {
                // strip off the anchor that's already on the url
                form.action = form.action.substring(0, idx);
            }
            form.action += '#' + anchorName;
         }

         form.submit();
      }
   }
   return false;
}

/** WTable **
 * formName - the encoded name of the form
 * anchorName - the name of the anchor used when the page is refreshed
 * wclanchor - the encoded name of the hidden field for the anchor
 */
function doAnchor(formName, anchorName, wclanchor) {
   var form = document.forms[formName];
   if (form != null && anchorName != null && wclanchor != null) {
      var aDate = new Date().getTime();
      eval("form." + wclanchor + ".value = '" + aDate + "'");

      // remove existing anchorName
      var index = form.action.indexOf( "#" );
      if ( index != -1 )
      {
          form.action = form.action.substring( 0, index );
      }
      form.action += '#' + anchorName;

      var inputName = "wclAnchorHash";
      var input  = document.getElementById( inputName );
      if ( !input )
      {
          input = document.createElement( "INPUT" );
          with ( input )
          {
              type  = "hidden";
              id    = inputName;
              name  = inputName;
          }
          form.appendChild( input );
      }
      input.value = anchorName;
   }
   return true;
}

/** WTable **
 * formName - the encoded name of the form
 * actionName - the name of the action being performed
 * actionValue - the name of the component performing the action
 * anchorName - the name of the anchor used when the page is refreshed
 * actionNameEnc - the encoded name of the action being performed
 * wclhidden - the encoded name of the hidden field
 * wclanchor - the encoded name of the hidden field for the anchor
 */
function doTbl(formName, actionName, actionValue, anchorName, actionNameEnc, wclhidden, wclanchor, event) {
   if ( event != null ) {
      //if user ctrl-/shift-/alt-clicked for table action, prevent action from opening new tab/window/etc
      if ( event.ctrlKey || event.shiftKey || event.altKey ) {
         if ( event.preventDefault ) {
            //W3C Model, Mozilla/Opera
            event.preventDefault();
            event.stopPropagation();
         } else {
            //Microsoft Model, IE
            event.returnValue = false;
            event.cancelBubble = true;
         }

         //if shift-click, turn actionValue "select(n)" into "select(multi-n)"
         if ( event.shiftKey && actionValue.indexOf("select") != -1 ) {
            var re = /(select\()(\d*\))/;
            actionValue = actionValue.replace(re, "$1multi-$2");
         }
      }//endIf
   }//endIf

   if (document != null && document.forms != null && formName != null) {
      var form = document.forms[formName];
      if (form != null) {
         //save scrollTop value
         var re = /[^\_]*(\_.*)/;
         var divId = formName.replace(re, "DD$1");
         var div = document.getElementById(divId);
         if ( div != null && form != null && form.clientScrollTop !=null ) {
            eval("form.clientScrollTop.value = '" + div.scrollTop + "'");
         }

         //table action
         if (actionName != null) {
            eval("form." + actionNameEnc + ".value = '" + actionValue + "'");
            eval("form." + wclhidden + ".value = '" + actionName + "'");
         }

         doAnchor(formName, anchorName, wclanchor);
         form.submit();
      }
      return false;
   }//endIf
}

/** WTable
 *
 * Mimic regular radio buttons/check boxes in tables so space
 * bar can be used.
 *
 * @param actionElement the anchorelement
 * @param event         keyPress Event
 */
function doTblKeyPress( actionElement, event ){
    //get the keycode
    if( event ){
        var wevent = new WEvent(event);
        //if space bar fire its onclick event
        if( wevent && actionElement && wevent.getKeyCode() == 32){
            if ( event.preventDefault ) {
                //W3C Model, Mozilla/Opera
                event.preventDefault();
                event.stopPropagation();
            } else {
                //Microsoft Model, IE
                event.returnValue = false;
                event.cancelBubble = true;
            }
            actionElement.onclick();
        }
    }
}

/** WTable **
 * persist table scrollTop
 * formAction - form action url
 * actionName - the name of the action being performed
 * actionValue - the name of the component performing the action
 * divId - the id of the table div
 * clearWait - if true ignore/clear isScrolling flag, used to process a script-trigger
 *             follow-up scroll event .5sec after the first scroll event is received.
 *             This is done because browsers currently trigger multiple scroll events
 *             while scrolling; ideally scrollTop should be persisted when onscrollend.
 */
function doScrl(formAction, actionName, actionValue, divId, clearWait) {
   var div = document.getElementById(divId);
   if ( div == null ) {
      return;
   }

   try {
      if ( div.getAttribute(SCROLL_LOCK) == "true" && !clearWait ) {
         //already scrolling and not flagged to ignore lock, so dont process scroll event
         return;
      }
      div.setAttribute(SCROLL_LOCK, "true" );   //set div lock
   } catch (e) {
      return;
   }

   try {
      var formName = "tableScroll";
      var form = document.forms[formName];
      if ( form == null ) {
         form = document.createElement( "FORM" );
         with ( form ) {
            name   = formName;
            id     = formName;
            action = formAction;
         }
      }

      //request no content response
      var inputName = "refresh_type";
      var inputValue = "no_content";
      var input  = document.getElementById( inputName );
      if ( !input ) {
         input = document.createElement( "INPUT" );
         with ( input ) {
            type  = "hidden";
            id    = inputName;
            name  = inputName;
         }
         form.appendChild( input );
      }
      input.value = inputValue;

      //div.scrollTop input
      input  = document.getElementById( actionName );
      var div = document.getElementById(divId);
      if ( div != null ) {
         if ( !input ) {
            input = document.createElement( "INPUT" );
            with ( input ) {
               type  = "hidden";
               id    = actionName;
               name  = actionName;
            }
            form.appendChild( input );
         }
         input.value = actionValue + "(" + div.scrollTop + ")";
      }

      document.body.appendChild(form);
      form.submit();
   }catch (e) {
   }

   //clear lock if this was a
   if ( clearWait ) {
      setScrollLock(divId, "false");
   } else {
      setTimeout("doScrl('" + formAction + "', '" + actionName + "', '" + actionValue + "', '" + divId + "', true)", 500);
   }
   return false;
}

function setScrollLock(divId, lockValue) {
   var div = document.getElementById(divId);
   if ( div != null ) {
      div.setAttribute(SCROLL_LOCK, lockValue);
   }
}


/** WTable (scrolling)**
 * setup table for scrolling
 */
function setupTable(dataBodyEnc, resetTable)
{
   var dataBody = document.getElementById(dataBodyEnc);
   if ( dataBody == null ) {
      return;
   }

   if ( ( WClient.isBrowserOpera() && dataBody.clientHeight > 0)
     || (!WClient.isBrowserOpera() && dataBody.offsetHeight > 0) )
   {
      if ( resetTable == null ) {
         resetTable = false;
      } else if ( resetTable ) {
         minimizeTable(dataBodyEnc);
      }

      if ( !WClient.isBrowserInternetExplorer() ) {
         adjustTableHeight(dataBodyEnc);
      }

      var scrollPaneEnc = dataBody.getAttribute('SPID');
      var scrollPane = document.getElementById(scrollPaneEnc);
      if ( scrollPane.onscroll != null ) {
         setScrollLock(scrollPaneEnc, "true");
      }
      if (scrollPane.getAttribute('H1BID')) {
         resizeDiv(scrollPaneEnc, resetTable);

         if ( WClient.isBrowserOpera() ) {
            var div = document.getElementById(scrollPaneEnc);
            var headBody2 = document.getElementById(div.getAttribute('H2BID'));
            headBody2.style.display = 'none';
            resizeDiv(scrollPaneEnc, false);
         }

         setTimeout("setScrollTop('" + scrollPaneEnc + "')", WClient.isBrowserInternetExplorer() ? 300 : 10);
      }

      if ( WClient.isBrowserInternetExplorer() ) {
         adjustTableHeight(dataBodyEnc);
      }

      // set scroll position for tasks
      setTimeout( "ensureIndexIsVisible('" + dataBodyEnc + "')", WClient.isBrowserInternetExplorer() ? 300 : 10 );
   }
   else
      setTimeout("setupTable('" + dataBodyEnc + "', " + resetTable + ")", 10);
}

/** WTable (scrolling)
 *  Handle scrollbar positioning for tasks ...
 */
function ensureIndexIsVisible( dataBodyEnc ) {
    var dataBody = document.getElementById(dataBodyEnc);
    if ( !dataBody ) {
       return;
    } // end if
    var currPage = dataBody.getAttribute('CPG');
    if ( currPage ) {
        var scrollPaneEnc = dataBody.getAttribute('SPID');
        var scrollPane    = document.getElementById(scrollPaneEnc);
        var viewRows      = parseInt(dataBody.getAttribute('RPV'));
        scrollPane.scrollTop = dataBody.rows[ currPage * viewRows ].offsetTop;
    } // end if
} // ensureIndexIsVisible()

/** WTable
 * set table height based on set rows per viewport value
 */
function adjustTableHeight(dataBodyEnc) {
    var dataBody = document.getElementById(dataBodyEnc);
    if ( !dataBody ) {
       return;
    }
    var scrollPaneEnc = dataBody.getAttribute('SPID');
    var scrollPane = document.getElementById(scrollPaneEnc);
    var actionBarEnc = dataBody.getAttribute('ABID');
    var actionBar = document.getElementById(actionBarEnc);
    var offset = actionBar ? actionBar.offsetHeight : 0;
    var viewRows = parseInt(dataBody.getAttribute('RPV'));
    var autorpv = dataBody.getAttribute('AUTORPV');
    var rpvMax  = parseInt(dataBody.getAttribute('RPVMAX'));
    var numRows = parseInt(dataBody.getAttribute('DR'));
    var maxViewRows = rpvMax;

    var height = WClient.isBrowserOpera() ? dataBody.clientHeight : dataBody.offsetHeight;
    var rowHeight = height / dataBody.rows.length;
    var miscHeight = WClient.isBrowserMozilla() ? 3 : 0;   //add misc space to account for hidden inputs, which mozilla doesnt completely hide

    if ( autorpv == 'true' ) {
      //need to autoresize if IE or no rpvmax given (not known by server yet) or
      //the viewport is too big for the number of rows we have, or we're
      //not showing as many rows possible
      if ( WClient.isBrowserInternetExplorer() || rpvMax <= 0 || viewRows > numRows || viewRows != rpvMax ) {
        //flagged for auto-size
        scrollPane.style.height = offset + (rowHeight * numRows) + miscHeight;

        var miscSpace = 100;
        var defaultScrollTop = ( WClient.isBrowserInternetExplorer() ) ? 70 : 55;
        if (scrollPane.parentNode) {
            var scrollTop = WUtilities.getTop(scrollPane.parentNode, true);
            if ( scrollTop <= 0) {
                scrollTop = defaultScrollTop;
            }
            var buffer =  ( WClient.isBrowserInternetExplorer() ) ? 20 : 15;
            miscSpace = ( scrollPane.parentNode.offsetHeight - scrollPane.scrollHeight ) + scrollTop + buffer; //space occupied by table Header/Footer + vertical offset of table + browser-dependent buffer
            if ( miscSpace < 0 ) {
                miscSpace = 100;
            }
        }
        viewRows = Math.floor( ( ( WClient.isBrowserInternetExplorer() ? document.body.offsetHeight : window.innerHeight ) - miscSpace ) / rowHeight);
        maxViewRows = viewRows;

        viewRows = Math.max(Math.min(MIN_ROWS_VISIBLE,numRows),Math.min(numRows, viewRows));   //min MIN_ROWS_VISIBLE rows (or numRows, if < MIN_ROWS_VISIBLE rows) visible
      }
    } else {
        //user-defined, static rows per viewport value
        viewRows = Math.min(numRows, viewRows);
    }

    scrollPane.style.height = offset + (rowHeight * viewRows) + miscHeight;
    scrollPane.height = offset + (rowHeight * viewRows) + miscHeight;

    //hide scrollbar if all rows visible
    if ( WClient.isBrowserMozilla() ) {
        scrollPane.style.overflow  = viewRows == numRows ? "hidden" : "-moz-scrollbars-vertical";
    } else if ( WClient.isBrowserInternetExplorer() ) {
        scrollPane.style.overflowY = viewRows == numRows ? "hidden" : "auto";
    }

    return new Array(viewRows, maxViewRows);
}


/** WTable **
 * persistent client div scrollTop value; prevents table warping on refresh
 */
function setScrollTop(divID) {
   var div = document.getElementById(divID);
   if ( div != null ) {
      try {
         var clientScrollTop = div.getAttribute('CST');
         if ( clientScrollTop != null && clientScrollTop != '' && clientScrollTop != 'null' ) {
            div.scrollTop = clientScrollTop;
            div.setAttribute('CST','');
         }
         if ( div.onscroll != null ) {
            setTimeout("setScrollLock('" + divID + "', 'false')", 500);
         }
      } catch (e) {
      }
   }
}

/** WTable (scrolling)**
 * handles resize of div
 */
function resizeDiv(divID, resetTable)
{
   if ( resetTable == null ) {
      resetTable = false;
   }
   if ( WClient.isBrowserOpera() ) {    //opera call before IE as Opera may identify itself as IE
       resizeDivOpera(divID, resetTable);
   } else if ( WClient.isBrowserInternetExplorer() ) {
       resizeDivIE(divID, resetTable);
   } else {
       resizeDivMoz(divID, resetTable);
   }
}

/** WTableColumn (drag-n-drop)**
 * handles resize of table columns
 */
function tcDND(event, evtCode, columnId, divID)
{
   var wevent = new WEvent(event);
   var column = document.getElementById(columnId);

   switch (evtCode) {
   case 1: // mouseDown (grab)
      if (!column.isDragging)
      {
         var cells = column.firstChild.rows[0].cells;
         //var minWidth = 20;
         //
         //for (var i=1; i < cells.length; i++)
         //   minWidth += parseInt(cells[i].width);
         //
         //column.minWidth = minWidth;
         column.isDragging = true;
         column.startPosition = column.currentPosition = wevent.getPagePosition();
         column.startWidth = WUtilities.getWidth(column);
         // save document's mouse handlers
         document._onselectstart = document.onselectstart;
         document._onmousemove = document.onmousemove;
         document._onmouseup = document.onmouseup;
         document.body._cursor = document.body.style.cursor;
         // temporarily override document's mouse handlers
         document.onselectstart = new Function("event", "return false;");
         document.onmousemove = new Function("event", "return tcDND(event, 2, '" + columnId + "', '" + divID + "');");
         document.onmouseup = new Function("event", "return tcDND(event, 3, '" + columnId + "', '" + divID + "');");
         document.body.style.cursor = "e-resize";

         return false;
      }
      break;
   case 2: // mouseMove (drag)
      if (column.isDragging)
      {
         var mousePosition = wevent.getPagePosition();
         var difference = mousePosition.getX() - column.startPosition.getX();
         var div = document.getElementById(divID);
         if(div != null){
           var bidi = div.getAttribute("BIDI");

           if (bidi)
             difference = -difference;
         }

         column.width = Math.min(Math.max(column.startWidth + difference, column.minWidth), column.maxWidth) + "px";
         column.currentPosition = mousePosition;

         if(div != null){
           resizeDiv(divID, false);
         }

         return false;
      }
      break;
   case 3: // mouseUp (drop)
      if (column.isDragging)
      {
         column.isDragging = false;
         // restore document's mouse handlers
         document.onselectstart = document._onselectstart;
         document.onmousemove = document._onmousemove;
         document.onmouseup = document._onmouseup;
         document.body.style.cursor = document.body._cursor;
         // save width
         var input = column.firstChild.rows[0].lastChild.lastChild;

         input.value = column.width ? column.width : "-1";

         return false;
      }
      break;
   }
   return true;
}

/** WTableColumn
 *  returns a column's minWidth
 */
function getColumnMinWidth(column) {
   if ( column.minWidth ) {
      return column.minWidth;
   }
   return MIN_COL_WIDTH;
}

/** WTableColumn
 *  returns a column's maxWidth
 */
function getColumnMaxWidth(column) {
   if ( column.maxWidth ) {
      return column.maxWidth;
   }
   return MAX_COL_WIDTH;
}

/** WTableColumn
 *  initialize min/maxWidth values for the column at colIdx in the table inside of divID whose current width is width
 */
function initColumnMinMaxWidths(divID, colIdx, width) {
   var div = document.getElementById(divID);
   var headBody1 = document.getElementById(div.getAttribute('H1BID'));
   var column = headBody1.rows[0].cells[colIdx];

   //determine maxWidth
   var minWidth = MIN_COL_WIDTH;
   try {
      if ( ( column.getAttribute("justify") == "enlarge" && width > minWidth )
        || column.getAttribute("justify") == "none" )
      {
         minWidth = width;
      }
   } catch (e) {
      minWidth = MIN_COL_WIDTH;
   }
   column.minWidth = minWidth;

   //determine maxWidth
   var maxWidth = MAX_COL_WIDTH;
   try {
      if ( column.getAttribute("justify") == "shrink" || column.getAttribute("justify") == "none" ) {
         maxWidth = width;
      }
   } catch (e) {
      maxWidth = MAX_COL_WIDTH;
   }
   column.maxWidth = maxWidth;
}

/** WTableColumn (successive drag-n-drop)**
 * handles successive resize of table columns
 */
function tcSDND(event, evtCode, columnId, divID)
{
   var wevent = new WEvent(event);
   var column = document.getElementById(columnId);

   //init tableColumn id <-> columndIndex hash
   var div = document.getElementById(divID);
   if ( WTableData.tableColumns_ == null ) {
     WTableData.tableColumns_ = new Array();
   }
   if ( WTableData.tableColumns_[divID] == null ) {
      WTableData.tableColumns_[divID] = new Array();
      var headBody1 = document.getElementById(div.getAttribute('H1BID'));
      var cellCount = headBody1.rows[0].cells.length-1;
      for (var c = 0; c < cellCount; c++) {
         var head1 = headBody1.rows[0].cells[c];
         WTableData.tableColumns_[divID][c] = head1.id;
         WTableData.tableColumns_[divID][head1.id] = c;
      }
   }

   switch (evtCode) {
   case 1: // mouseDown (grab)
      if (!column.isDragging)
      {
         column.isDragging = true;
         column.startPosition = column.currentPosition = wevent.getPagePosition();
         column.startWidth = WUtilities.getWidth(column);
         // save document's mouse handlers
         document._onselectstart = document.onselectstart;
         document._onmousemove = document.onmousemove;
         document._onmouseup = document.onmouseup;
         document.body._cursor = document.body.style.cursor;
         // temporarily override document's mouse handlers
         document.onselectstart = new Function("event", "return false;");
         document.onmousemove = new Function("event", "return tcSDND(event, 2, '" + columnId + "', '" + divID + "');");
         document.onmouseup = new Function("event", "return tcSDND(event, 3, '" + columnId + "', '" + divID + "');");
         document.body.style.cursor = "e-resize";

         //loop over columns and ensure column's needed values are set
         for (var i=WTableData.tableColumns_[divID][column.id]-1; i >= 0; i--) {
            var currColumn = document.getElementById(WTableData.tableColumns_[divID][i]);
            currColumn.startWidth = WUtilities.getWidth(currColumn);
         }

         return false;
      }
      break;
   case 2: // mouseMove (drag)
      if (column.isDragging)
      {
         var mousePosition = wevent.getPagePosition();
         var difference = mousePosition.getX() - column.startPosition.getX();
         var bidi = document.getElementById(divID).getAttribute("BIDI");

         if (bidi)
            difference = -difference;

         columnWidth = column.startWidth + difference;
         column.currentPosition = mousePosition;

         if ( columnWidth < MIN_COL_WIDTH && WTableData.tableColumns_ != null && WTableData.tableColumns_[divID] != null ) {
            //successive shrinking
            var columnIndex = WTableData.tableColumns_[divID][columnId]; //get column index from table columns hash (init by setupTable)
            var i = 1;
            var done = false;
            var startWidth = column.startWidth;

            column.width = MIN_COL_WIDTH + "px";
            var cellPadding = ( WClient.isBrowserInternetExplorer() ) ? 0 : (parseInt(column.style.borderLeftWidth) + parseInt(column.style.borderRightWidth));
            if ( column.startWidth - parseInt(column.width) > 0 ) {
               column.startPosition = new Position(column.startPosition.getX() - (column.startWidth - parseInt(column.width) - cellPadding), column.startPosition.getY(), column.startPosition.getZ());
            }
            difference = difference + column.startWidth - parseInt(column.width);
            column.startWidth = parseInt(column.width);

            //may need to loop through columns if previous column is already minWidth
            while ( columnIndex-i >= 0 && !done ) {
               var prevColumn = document.getElementById(WTableData.tableColumns_[divID][columnIndex-i]);

               //if prevColumn is already minWidth, skip to column preceeding it
               if ( parseInt(prevColumn.width) <= MIN_COL_WIDTH ) {
                  prevColumn.width = MIN_COL_WIDTH + "px";
                  if ( prevColumn.startWidth - parseInt(prevColumn.width) > 0 ) {
                     column.startPosition = new Position(column.startPosition.getX() - (prevColumn.startWidth - parseInt(prevColumn.width) - cellPadding), column.startPosition.getY(), column.startPosition.getZ());
                  }
                  difference = difference + prevColumn.startWidth - parseInt(prevColumn.width);
                  prevColumn.startWidth = parseInt(prevColumn.width);
                  i++;
               } else {
                  prevColumn.isDragging = true;  //flag column as dragging, so that its width is properly stored by drop case (below)
                  prevColumn.width = Math.max(prevColumn.startWidth + difference, MIN_COL_WIDTH) + "px";
                  done = true;
               }
            }
         } else {
            column.width = columnWidth + "px";
         }

         resizeDiv(divID, false);

         return false;
      }
      break;
   case 3: // mouseUp (drop)
      if (column.isDragging)
      {
         column.isDragging = false;
         // restore document's mouse handlers
         document.onselectstart = document._onselectstart;
         document.onmousemove = document._onmousemove;
         document.onmouseup = document._onmouseup;
         document.body.style.cursor = document.body._cursor;
         // save width
         var input = column.firstChild.rows[0].lastChild.lastChild;

         input.value = column.width ? column.width : "-1";
         column.startWidth = WUtilities.getWidth(column);

         //loop over all isDragging columns, saving their width
         var colCount = WTableData.tableColumns_[divID].length;
         var done = false;
         for (var i=colCount-1; i >= 0; i--){
            var currColumn = document.getElementById(WTableData.tableColumns_[divID][i]);

            if ( i <= WTableData.tableColumns_[divID][column.id]-1 && !done) {
                if (currColumn.isDragging) {
                   currColumn.isDragging = false;
                   // save width
                   var input = currColumn.firstChild.rows[0].lastChild.lastChild;

                   input.value = currColumn.width ? currColumn.width : "-1";
                   currColumn.startWidth = WUtilities.getWidth(currColumn);
                } else {
                   done = true;
                }
            }

            currColumn.setAttribute("prefWidth", currColumn.width);
         }

         //save column widths if external method is defined
         if ( typeof saveColumnWidths == 'function' ) {
             saveColumnWidths(divID);
         }
         return false;
      }
      break;
   }
   return true;
}



/** WTable (scrolling)**
 * handles resize of div for IE
 */
function resizeDivIE(divID, resetTable)
{
   var div = document.getElementById(divID);
   var resizeOption = div.getAttribute("resizeOption") == null ? '' : div.getAttribute("resizeOption");
   var headBody1 = document.getElementById(div.getAttribute('H1BID'));
   var headBody2 = document.getElementById(div.getAttribute('H2BID'));
   var tableStyle = headBody2.parentNode.style;
   var cellCount = headBody2.rows[0].cells.length-1;
   var widths = new Array(cellCount);
   var init = ( headBody1.rows[0].cells[0].getAttribute("initWidth") == null );
   var preset =  ( init && headBody1.rows[0].cells[0].width != '' ) || ( resetTable && headBody1.rows[0].cells[0].getAttribute("prefWidth") != null );
   tableStyle.tableLayout = 'auto';

   var totalWidth = 0;
   var justifiedWidthShrink  = 0;    //width to play with when columns have to shrink
   var justifiedWidthEnlarge = 0;    //width to play with when columns have to enlarge

   if ( resetTable || init ) {
      for (var c = 0; c < cellCount; c++) {
         var head1 = headBody1.rows[0].cells[c];
         var head2 = headBody2.rows[0].cells[c];

         head1.style.tableLayout = 'auto';
         head2.firstChild.style.tableLayout = 'auto';

         if ( preset && head1.getAttribute("prefWidth") == null ) {
            head1.setAttribute("prefWidth", head1.width);
         }

         widths[c] = ( preset ) ? head1.width : parseInt(head2.offsetWidth);
         totalWidth += widths[c];

         var justify = head1.getAttribute("justify");
         if ( justify == "shrink"  || justify == "shrinkAndEnlarge" ) {
           justifiedWidthShrink += widths[c];
         }
         if ( justify == "enlarge" || justify == "shrinkAndEnlarge" ) {
           justifiedWidthEnlarge += widths[c];
         }

         //init column min/maxWidth values
         if ( init ) {
            head1.setAttribute("initWidth", widths[c]);
            initColumnMinMaxWidths(divID, c, widths[c]);
         }
      }
   } else {
      for (var c = 0; c < cellCount; c++) {
         var head1 = headBody1.rows[0].cells[c];
         var head2 = headBody2.rows[0].cells[c];
         head2.firstChild.style.tableLayout = 'fixed';
         widths[c] = head1.width;
      }
   }

   tableStyle.display = 'none';
   tableStyle.tableLayout = 'fixed';
   tableStyle.display = '';

   //width to play with (because this table is either shrinking or enlarging)
   var tableWidth = headBody1.offsetWidth;
   var justifiedWidth = ( tableWidth - totalWidth < 0 ) ? justifiedWidthShrink : justifiedWidthEnlarge;

   var misc = 0;
   var cellSum = 0;
   for (var c = 0; c < cellCount; c++) {
       var head1 = headBody1.rows[0].cells[c];
       var head2 = headBody2.rows[0].cells[c];
       var shrunk = false;

       try {
           headBody1.rows[0].cells[c].firstChild.firstChild.firstChild.firstChild.height = '100%';
       } catch (e) {}

       //justify column
       if ( !preset && ( resetTable || init ) ) {
          if ( c == cellCount-1 && resizeOption == "WTableResizeLast" ) {
              shrunk = true;
              widths[c] = "100%";
          } else if ( c == cellCount-1 && resizeOption == "WTableResizeEndColumns" && tableWidth != totalWidth ) {
              widths[c] = Math.max(head1.offsetWidth,tableWidth-cellSum);
          } else if ( justifiedWidth > 0 && head1.getAttribute("justify") != "none" && tableWidth != totalWidth) {
              if ( ( tableWidth - totalWidth <  0  && head1.getAttribute("justify") != "enlarge" )
                || ( tableWidth - totalWidth >= 0  && head1.getAttribute("justify") != "shrink"  ) )
              {
                 widths[c] = widths[c] + Math.round( (tableWidth - totalWidth) * (widths[c] / justifiedWidth) );
                 if ( c == cellCount - 1 ) {
                    widths[c] = widths[c] - misc;
                 }
              }
              if ( widths[c] < getColumnMinWidth(head1) ) {
                 misc = misc + getColumnMinWidth(head1) - widths[c];
                 widths[c] = getColumnMinWidth(head1);
              }
          }
       }

       widths[c] = Math.max(MIN_COL_WIDTH, widths[c]);

       //head2.width = head1.width = widths[c];
       head2.width = head1.width = ( widths[c] != '' ) ? widths[c] : head1.width;
       cellSum = cellSum + parseInt(head2.width);
   }

   if ( resetTable || init ) {
      headBody2.setAttribute("initWidth", tableWidth);
   }

   //set table background to table header width
   if ( cellSum <= headBody2.getAttribute("initWidth") ) {
      headBody2.parentNode.width = headBody2.getAttribute("initWidth");
   }

   //increase header row height, in case column headers contain breakrules
   try {
       var clientHeight = headBody1.rows[0].cells[0].clientHeight;
       for (var c = 0; c < cellCount; c++) {
           headBody1.rows[0].cells[c].firstChild.firstChild.firstChild.firstChild.height = clientHeight;
       }
   } catch (e) {}
}

/** WTable (scrolling)**
 * handles resize of div for Mozilla
 */
function resizeDivMoz(divID, resetTable)
{
   var div = document.getElementById(divID);
   var resizeOption = div.getAttribute("resizeOption") == null ? '' : div.getAttribute("resizeOption");
   var headBody1 = document.getElementById(div.getAttribute('H1BID'));
   var headBody2 = document.getElementById(div.getAttribute('H2BID'));
   var tableStyle  = headBody2.parentNode.style;
   var tableStyle1 = headBody1.style;
   var cellCount = headBody2.rows[0].cells.length-1;
   var widths = new Array(cellCount);
   var init = ( headBody1.rows[0].cells[0].getAttribute("initWidth") == null );
   var preset =  ( init && headBody1.rows[0].cells[0].width != '' ) || ( resetTable && headBody1.rows[0].cells[0].getAttribute("prefWidth") != null );
   var presetWidths = new Array(cellCount);

   var totalWidth = 0;

   div.style.width='0px';           //shrink div to content
   headBody1.style.width='0px';     //shrink header table to content
   headBody2.style.width='0px';     //shrink data table to content

   if ( resetTable || init ) {
      var justifiedWidthShrink  = 0;   //width to play with when columns have to shrink
      var justifiedWidthEnlarge = 0;   //width to play with when columns have to enlarge

      headBody2.setAttribute("initWidth", div.parentNode.clientWidth);

      for (var c = 0; c < cellCount; c++) {
         var head1 = headBody1.rows[0].cells[c];
         var head2 = headBody2.rows[0].cells[c];
         head2.firstChild.style.tableLayout = 'auto';

         if ( preset && head1.getAttribute("prefWidth") == null ) {
            head1.setAttribute("prefWidth", head1.width);
         }

         widths[c] = parseInt( ( preset ) ? head1.width
                                          : ( (resetTable) ? head1.getAttribute("initWidth") : head2.offsetWidth ) );

         totalWidth += widths[c];
         var justify = head1.getAttribute("justify");
         if ( justify == "shrink"  || justify == "shrinkAndEnlarge" ) {
           justifiedWidthShrink += widths[c];
         }
         if ( justify == "enlarge" || justify == "shrinkAndEnlarge" ) {
           justifiedWidthEnlarge += widths[c];
         }

         //init column min/maxWidth values
         if ( init ) {
            head1.setAttribute("initWidth", widths[c]);
            initColumnMinMaxWidths(divID, c, widths[c]);
         }
      }
   } else {
      //drag and drop resizing going on
      for (var c = 0; c < cellCount; c++) {
         var head1 = headBody1.rows[0].cells[c];
         var head2 = headBody2.rows[0].cells[c];
         head2.firstChild.style.tableLayout = 'fixed';
         widths[c] = head1.width;
      }
   }

   //width to play with (because this table is either shrinking or enlarging)
   var justifiedWidth = ( headBody1.offsetWidth - totalWidth < 0 ) ? justifiedWidthShrink : justifiedWidthEnlarge;

   //disable autosizing
   tableStyle.tableLayout  = 'fixed';
   tableStyle1.tableLayout = 'fixed';
   div.style.width = '100%';
   headBody1.style.overflowX='hidden';
   headBody2.style.overflowX='hidden';

   //set fixed column widths
   var misc = 0;
   var cellSum = 0;
   for (var c = 0; c < cellCount; c++) {
      var head1 = headBody1.rows[0].cells[c];
      var head2 = headBody2.rows[0].cells[c];
      var shrunk = false;
      var cellPadding = ( WClient.isBrowserInternetExplorer() ) ? 0 : (parseInt(head1.style.borderLeftWidth) + parseInt(head1.style.borderRightWidth));

      try {
         headBody1.rows[0].cells[c].firstChild.firstChild.firstChild.firstChild.height = '100%';
      } catch (e) {}

      //justify column
      if ( head1.getAttribute("justify") != "none" && !preset && ( resetTable || init ) ) {
         var cellPadding = parseInt(head1.style.borderLeftWidth) + parseInt(head1.style.borderRightWidth);
         if ( c == cellCount-1 && resizeOption == "WTableResizeLast" ) {
            shrunk = true;
            widths[c] = "100%";
         } else if ( c == cellCount-1 && resizeOption == "WTableResizeEndColumns" && headBody1.offsetWidth != totalWidth ) {
            widths[c] = widths[c] + Math.round( (headBody1.offsetWidth - totalWidth) * (widths[c] / justifiedWidth) ) - cellPadding - misc;
         } else if ( justifiedWidth > 0 && headBody1.offsetWidth != totalWidth) {
            if ( ( headBody1.offsetWidth - totalWidth <  0  && head1.getAttribute("justify") != "enlarge" )
              || ( headBody1.offsetWidth - totalWidth >= 0  && head1.getAttribute("justify") != "shrink"  ) )
            {
               widths[c] = widths[c] + Math.round( (headBody1.offsetWidth - totalWidth) * (widths[c] / justifiedWidth) ) - cellPadding;
               if ( c == cellCount - 1 ) {
                   widths[c] = widths[c] - misc;
               }
            }
            if ( widths[c] < getColumnMinWidth(head1) ) {
               misc = misc + getColumnMinWidth(head1) - widths[c];
               widths[c] = getColumnMinWidth(head1);
            }
         }
      }

      widths[c] = Math.max(MIN_COL_WIDTH, widths[c]);
      cellSum = cellSum + parseInt(widths[c]) + parseInt(cellPadding);

      head1.width = widths[c];
      head2.width = head1.width;
      head2.firstChild.width = head1.width;
   }

   headBody2.width = Math.max(cellSum, headBody2.getAttribute("initWidth"));
   headBody2.style.marginRight = "0px";
   headBody2.style.paddingRight = "0px";
   div.firstChild.border="0px";

   //increase header row height, in case column headers contain breakrules
   try {
      var clientHeight = headBody1.rows[0].cells[0].clientHeight;
      for (var c = 0; c < cellCount; c++) {
         headBody1.rows[0].cells[c].firstChild.firstChild.firstChild.firstChild.height = clientHeight;
      }
   } catch (e) {}
}


/** WTable (scrolling)**
 * handles resize of div for Opera
 */
function resizeDivOpera(divID, resetTable)
{
   var div = document.getElementById(divID);
   var resizeOption = div.getAttribute("resizeOption") == null ? '' : div.getAttribute("resizeOption");
   var headBody1 = document.getElementById(div.getAttribute('H1BID'));
   var headBody2 = document.getElementById(div.getAttribute('H2BID'));
   var tableStyle  = headBody2.parentNode.style;
   var tableStyle1 = headBody1.style;
   var cellCount = headBody2.rows[0].cells.length-1;
   var widths = new Array(cellCount);
   var init = ( headBody1.rows[0].cells[0].width == '' );

   var divWidth = div.offsetWidth;
   var totalWidth = 0;

   var justifiedWidthShrink  = 0;    //width to play with when columns have to shrink
   var justifiedWidthEnlarge = 0;    //width to play with when columns have to enlarge

   //flag tables for autosize
   if ( resetTable || init ) {
      div.style.width         = '0px';
      div.style.overflow      = 'auto'
      headBody1.style.width   = '0px';
      headBody2.style.width   = '0px';
      tableStyle1.tableLayout = 'auto';

      //get auto-sized column widths
      for (var c = 0; c < cellCount; c++) {
         var head1 = headBody1.rows[0].cells[c];
         var head2 = headBody2.rows[0].cells[c];

         head1.style.tableLayout = 'auto';
         head2.firstChild.style.tableLayout = 'auto';

         widths[c] = ( resetTable && headBody1.rows[0].cells[0].width != '' ) ? head1.getAttribute("initWidth") : ( head2.offsetWidth == 0 ) ? head1.offsetWidth : head2.offsetWidth;
         totalWidth = parseInt(totalWidth) + parseInt(widths[c]);

         if ( head1.getAttribute("justify") != "none" ) {
            justifiedWidth += parseInt(widths[c]);
         }

         //init column min/maxWidth values
         if ( init ) {
            head1.setAttribute("initWidth", widths[c]);
            initColumnMinMaxWidths(divID, c, widths[c]);
         }
      }
   }

   //width to play with (because this table is either shrinking or enlarging)
   var justifiedWidth = ( headBody1.offsetWidth - totalWidth < 0 ) ? justifiedWidthShrink : justifiedWidthEnlarge;

   //disable autosizing
   tableStyle.display      = 'none';
   tableStyle.tableLayout  = 'fixed';
   tableStyle1.display     = 'none';
   tableStyle1.tableLayout = 'fixed';
   div.style.width='100%';
   var divWidth = div.offsetWidth;
   tableStyle.display      = '';
   tableStyle1.display     = '';

   if ( resetTable || init ) {
      //set fixed column widths
      var cellSum = 0;
      var misc = 0;
      for (var c = 0; c < cellCount; c++) {
         var head1 = headBody1.rows[0].cells[c];
         var head2 = headBody2.rows[0].cells[c];
         var shrunk = false;

         if ( c == cellCount-1 && resizeOption == "WTableResizeLast" ) {
            shrunk = true;
            widths[c] = "100%";
         } else if ( justifiedWidth > 0 && head1.getAttribute("justify") != "none" && divWidth != totalWidth ) {
            if ( ( headBody1.offsetWidth - totalWidth <  0  && head1.getAttribute("justify") != "enlarge" )
              || ( headBody1.offsetWidth - totalWidth >= 0  && head1.getAttribute("justify") != "shrink"  ) )
            {
               widths[c] = widths[c] + Math.round( (divWidth - totalWidth) * (widths[c] / justifiedWidth) );
               if ( c == cellCount - 1 ) {
                   widths[c] = widths[c] - misc;
               }
            }
            if ( widths[c] < getColumnMinWidth(head1) ) {
               misc = misc + getColumnMinWidth(head1) - widths[c];
            }
         }

         //the scrollbar may be overwriting the lastfew characters in the table, cant tell if scrollbar is visible though
         if ( div.scrollHeight > (div.offsetHeight + 20) && resizeOption != "WTableResizeLast" && head1.getAttribute("justify") != "none" && totalWidth >= (divWidth - 20) ) { //20 should be scrollar width
            widths[c] = widths[c] - ( 20 / cellCount ); //20 should be scrollar width
         }

         widths[c] = Math.max(getColumnMinWidth(head1), (!resetTable && !init) ? head1.width : widths[c]);

         head2.width = head1.width = widths[c];
         cellSum = parseInt(cellSum) + parseInt(head1.width);
      }

   } else {
      //set fixed column widths
      for (var c = 0; c < cellCount; c++) {
         var head1 = headBody1.rows[0].cells[c];
         var head2 = headBody2.rows[0].cells[c];
         var body2 = headBody2.nextSibling;

         var rowCount = body2.rows.length;
         //set fixed column widths
         for (var r = 0; r < rowCount; r++) {
            var cell        = body2.rows[r].cells[c];
            var cellStyle   = document.defaultView.getComputedStyle(cell, "");
            var cellPadding = parseInt(cellStyle.getPropertyValue("padding"));
            var shrunk = false;

            if ( c == cellCount-1 ) {
               shrunk = true;
               cell.width  = '100%';
               head2.width = head1.width;
            } else {
               cell.width  = head1.width - (2 * cellPadding);   //account for left & right cell padding
               head2.width = head1.width;
            }
         }

         if ( c == cellCount-1 ) {
            head1.width = head2.width;
         }
      }
   }

   //increase header row height, in case column headers contain breakrules
   for (var c = 0; c < cellCount; c++) {
       headBody1.rows[0].cells[c].firstChild.firstChild.firstChild.firstChild.height = headBody1.rows[0].cells[c].clientHeight;
   }
}


//enable/disable title attirbute for a specific column in the given table
//for Opera, title must be moved from the table cell to its first child (span)
function hoverTitle(divID, table, c, width, shrunk) {
   var div = document.getElementById(divID);
   var headBody1 = document.getElementById(div.getAttribute('H1BID'));
   var rowCount = table.rows.length;
   for (var r = 0; r < rowCount; r++) {
      var head1 = headBody1.rows[0].cells[c];
      var cell = table.rows[r].cells[c];
      var title = cell.getAttribute('title');
      if ( width < head1.getAttribute("initWidth") || shrunk ) {
         if ( title == null || title == '' ) {
            title = cell.getAttribute('disabled_title');
            if ( title == null ) {
               title = '';
            }
         }
         if ( WClient.isBrowserOpera() ) {
            cell.firstChild.setAttribute('title', title);
         } else {
            cell.setAttribute('title', title);
         }
      } else {
         if ( title != null && title != '' ) {
            cell.setAttribute('disabled_title', title);
         }
         if ( WClient.isBrowserOpera() ) {
            cell.firstChild.removeAttribute('title');
         } else {
            cell.removeAttribute('title');
         }
      }
   }
}


/** WTable (scrolling)**
 * handles resize of div for Mozilla
 */
function minimizeTable(dataBodyEnc)
{
   try {
      if ( WClient.isBrowserOpera() ) {
         return;
      }

      var dataBody = document.getElementById(dataBodyEnc);
      var divID = dataBody.getAttribute('SPID');
      var div = document.getElementById(divID);

      //shrink table down to 4 rows
      var actionBarEnc = dataBody.getAttribute('ABID');
      var actionBar = document.getElementById(actionBarEnc);
      var offset = actionBar ? actionBar.offsetHeight : 0;
      var height = WClient.isBrowserOpera() ? dataBody.clientHeight : dataBody.offsetHeight;
      var rowHeight = height / dataBody.rows.length;
      div.style.height = offset + (rowHeight * 4);

      var headBody1 = document.getElementById(div.getAttribute('H1BID'));
      var headBody2 = document.getElementById(div.getAttribute('H2BID'));

      if ( WClient.isBrowserInternetExplorer() ) {
         headBody2.parentNode.width = '100%';
      }

      var preset = ( headBody1.rows[0].cells[0].getAttribute("prefWidth") != null );

      if ( !preset ) {
         headBody1.width = headBody2.width/10;
         headBody2.width = headBody2.width/10;
         headBody1.style.tableLayout = 'auto';
         headBody2.style.tableLayout = 'auto';
      }

      div.style.width='0px';           //shrink div to content

      var cellCount = headBody2.rows[0].cells.length-1;
      for (var c = 0; c < cellCount; c++) {
         var head1 = headBody1.rows[0].cells[c];
         var head2 = headBody2.rows[0].cells[c];

         try {
            head1.firstChild.rows[0].lastChild.firstChild.height = '100%';
         } catch (e) {}

         if ( preset ) {
            head1.width = head1.getAttribute("prefWidth");
            head2.width = head1.getAttribute("prefWidth");
         } else if ( head1.getAttribute("justify") != "none" && head1.getAttribute("justify") != "shrink" ) {
            head1.width = ( head1.width == '' ) ? '' : (head1.getAttribute("initWidth") == null ? head1.width/2 : head1.getAttribute("initWidth")/2);
            head2.width = ( head2.width == '' ) ? '' : (head1.getAttribute("initWidth") == null ? head1.width/2 : head1.getAttribute("initWidth")/2);
            head2.firstChild.width = head1.width;
         }

         head1.firstChild.rows[0].lastChild.firstChild.height = head2.clientHeight;
      }

      if ( !preset ) {
         headBody1.width = '0px';
         headBody2.width = '0px';
         headBody1.width = headBody1.offsetWidth;
      }
   } catch (e) {
   }
}

