/*
 * Decompiled with CFR 0.152.
 */
package java.util.logging;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.harmony.logging.internal.nls.Messages;

public class LogRecord
implements Serializable {
    private static final long serialVersionUID = 5372048053134512534L;
    private static final int MAJOR = 1;
    private static final int MINOR = 4;
    private static long currentSequenceNumber = 0L;
    private static ThreadLocal<Integer> currentThreadId = new ThreadLocal();
    private static int initThreadId = 0;
    private Level level;
    private long sequenceNumber;
    private String sourceClassName;
    private String sourceMethodName;
    private String message;
    private int threadID;
    private long millis;
    private Throwable thrown;
    private String loggerName;
    private String resourceBundleName;
    private transient ResourceBundle resourceBundle;
    private transient Object[] parameters;
    private transient boolean sourceInited;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LogRecord(Level level, String string) {
        if (null == level) {
            throw new NullPointerException(Messages.getString("logging.4"));
        }
        this.level = level;
        this.message = string;
        this.millis = System.currentTimeMillis();
        Class<LogRecord> clazz = LogRecord.class;
        synchronized (LogRecord.class) {
            this.sequenceNumber = currentSequenceNumber++;
            Integer n = currentThreadId.get();
            if (null == n) {
                this.threadID = initThreadId;
                currentThreadId.set(initThreadId++);
            } else {
                this.threadID = n;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            this.sourceClassName = null;
            this.sourceMethodName = null;
            this.loggerName = null;
            this.parameters = null;
            this.resourceBundle = null;
            this.resourceBundleName = null;
            this.thrown = null;
            return;
        }
    }

    public Level getLevel() {
        return this.level;
    }

    public void setLevel(Level level) {
        if (null == level) {
            throw new NullPointerException(Messages.getString("logging.4"));
        }
        this.level = level;
    }

    public String getLoggerName() {
        return this.loggerName;
    }

    public void setLoggerName(String string) {
        this.loggerName = string;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String string) {
        this.message = string;
    }

    public long getMillis() {
        return this.millis;
    }

    public void setMillis(long l) {
        this.millis = l;
    }

    public Object[] getParameters() {
        return this.parameters;
    }

    public void setParameters(Object[] objectArray) {
        this.parameters = objectArray;
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public void setResourceBundle(ResourceBundle resourceBundle) {
        this.resourceBundle = resourceBundle;
    }

    public String getResourceBundleName() {
        return this.resourceBundleName;
    }

    public void setResourceBundleName(String string) {
        this.resourceBundleName = string;
    }

    public long getSequenceNumber() {
        return this.sequenceNumber;
    }

    public void setSequenceNumber(long l) {
        this.sequenceNumber = l;
    }

    public String getSourceClassName() {
        this.initSource();
        return this.sourceClassName;
    }

    private void initSource() {
        if (!this.sourceInited) {
            int n;
            StackTraceElement[] stackTraceElementArray = new Throwable().getStackTrace();
            String string = null;
            for (n = 0; n < stackTraceElementArray.length && !(string = stackTraceElementArray[n].getClassName()).equals(Logger.class.getName()); ++n) {
            }
            while (++n < stackTraceElementArray.length && stackTraceElementArray[n].getClassName().equals(string)) {
            }
            if (n < stackTraceElementArray.length) {
                this.sourceClassName = stackTraceElementArray[n].getClassName();
                this.sourceMethodName = stackTraceElementArray[n].getMethodName();
            }
            this.sourceInited = true;
        }
    }

    public void setSourceClassName(String string) {
        this.sourceInited = true;
        this.sourceClassName = string;
    }

    public String getSourceMethodName() {
        this.initSource();
        return this.sourceMethodName;
    }

    public void setSourceMethodName(String string) {
        this.sourceInited = true;
        this.sourceMethodName = string;
    }

    public int getThreadID() {
        return this.threadID;
    }

    public void setThreadID(int n) {
        this.threadID = n;
    }

    public Throwable getThrown() {
        return this.thrown;
    }

    public void setThrown(Throwable throwable) {
        this.thrown = throwable;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeByte(1);
        objectOutputStream.writeByte(4);
        if (null == this.parameters) {
            objectOutputStream.writeInt(-1);
        } else {
            objectOutputStream.writeInt(this.parameters.length);
            for (Object object : this.parameters) {
                objectOutputStream.writeObject(null == object ? null : object.toString());
            }
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        byte by = objectInputStream.readByte();
        byte by2 = objectInputStream.readByte();
        if (by != 1) {
            throw new IOException(Messages.getString("logging.5", by, by2));
        }
        int n = objectInputStream.readInt();
        if (n >= 0) {
            this.parameters = new Object[n];
            for (int i = 0; i < this.parameters.length; ++i) {
                this.parameters[i] = objectInputStream.readObject();
            }
        }
        if (null != this.resourceBundleName) {
            try {
                this.resourceBundle = Logger.loadResourceBundle(this.resourceBundleName);
            }
            catch (MissingResourceException missingResourceException) {
                this.resourceBundle = null;
            }
        }
    }
}

