/*
 * Decompiled with CFR 0.152.
 */
package java.util.logging;

import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import org.apache.harmony.logging.internal.nls.Messages;

public class Logger {
    @Deprecated
    public static final Logger global = new Logger("global", null);
    public static final String GLOBAL_LOGGER_NAME = "global";
    private volatile String name;
    private Logger parent;
    private volatile Level levelObjVal;
    private volatile int levelIntVal;
    private Filter filter;
    private String resBundleName;
    private ResourceBundle resBundle;
    private List<Handler> handlers;
    private boolean notifyParentHandlers;
    private boolean isNamed;
    List<Logger> childs;
    private LogManager manager;
    private boolean handlerInited;

    protected Logger(String string, String string2) {
        if (null == string2) {
            this.resBundleName = null;
            this.resBundle = null;
        } else {
            this.resBundle = Logger.loadResourceBundle(string2);
            this.resBundleName = string2;
        }
        this.name = string;
        this.parent = null;
        this.filter = null;
        this.childs = new ArrayList<Logger>();
        this.notifyParentHandlers = true;
        this.isNamed = true;
        this.levelObjVal = null;
        this.levelIntVal = Level.INFO.intValue();
    }

    private void setLevelImpl(Level level) {
        int n = this.levelIntVal;
        this.levelObjVal = level;
        this.levelIntVal = null == level ? (null != this.parent ? this.parent.levelIntVal : Level.INFO.intValue()) : level.intValue();
        if (n != this.levelIntVal) {
            this.forceChildsToInherit();
        }
    }

    private void forceChildsToInherit() {
        for (Logger logger : this.childs) {
            if (null != logger.levelObjVal) continue;
            logger.setLevelImpl(null);
        }
    }

    static ResourceBundle loadResourceBundle(String string) {
        ClassLoader classLoader = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
        if (null != classLoader) {
            try {
                return ResourceBundle.getBundle(string, Locale.getDefault(), classLoader);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        if (null != (classLoader = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return ClassLoader.getSystemClassLoader();
            }
        }))) {
            try {
                return ResourceBundle.getBundle(string, Locale.getDefault(), classLoader);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        final Class[] classArray = AccessController.doPrivileged(new PrivilegedAction<Class<?>[]>(){

            @Override
            public Class<?>[] run() {
                return new PrivateSecurityManager().privateGetClassContext();
            }
        });
        for (int i = 1; i < classArray.length; ++i) {
            final int n = i;
            try {
                classLoader = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                    @Override
                    public ClassLoader run() {
                        return classArray[n].getClassLoader();
                    }
                });
                if (null == classLoader) continue;
                return ResourceBundle.getBundle(string, Locale.getDefault(), classLoader);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        throw new MissingResourceException(Messages.getString("logging.8", string), string, null);
    }

    public static Logger getAnonymousLogger() {
        return Logger.getAnonymousLogger(null);
    }

    public static Logger getAnonymousLogger(String string) {
        Logger logger = new Logger(null, string);
        logger.isNamed = false;
        logger.internalSetParent(LogManager.getLogManager().getLogger(""));
        return logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateResourceBundle(Logger logger, String string) {
        Logger logger2 = logger;
        synchronized (logger2) {
            if (null == logger.getResourceBundleName()) {
                if (null == string) {
                    return;
                }
                logger.resBundle = Logger.loadResourceBundle(string);
                logger.resBundleName = string;
            } else if (!logger.getResourceBundleName().equals(string)) {
                throw new IllegalArgumentException(Messages.getString("logging.9", string, logger.getResourceBundleName()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Logger getLoggerWithRes(String string, String string2, boolean bl) {
        LogManager logManager = LogManager.getLogManager();
        Logger logger = null;
        LogManager logManager2 = logManager;
        synchronized (logManager2) {
            logger = logManager.getLogger(string);
            if (null == logger) {
                logger = new Logger(string, string2);
                logManager.addLogger(logger);
                return logger;
            }
        }
        if (bl) {
            Logger.updateResourceBundle(logger, string2);
        }
        return logger;
    }

    public static Logger getLogger(String string) {
        return Logger.getLoggerWithRes(string, null, false);
    }

    public static Logger getLogger(String string, String string2) {
        return Logger.getLoggerWithRes(string, string2, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHandler(Handler handler) {
        if (null == handler) {
            throw new NullPointerException(Messages.getString("logging.A"));
        }
        if (this.isNamed) {
            LogManager.getLogManager().checkAccess();
        }
        this.initHandler();
        Logger logger = this;
        synchronized (logger) {
            this.handlers.add(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initHandler() {
        if (!this.handlerInited) {
            Logger logger = this;
            synchronized (logger) {
                if (!this.handlerInited) {
                    if (this.handlers == null) {
                        this.handlers = new ArrayList<Handler>();
                    }
                    if (this.manager == null) {
                        return;
                    }
                    String string = this.manager.getProperty("".equals(this.name) ? "handlers" : this.name + ".handlers");
                    if (null == string) {
                        return;
                    }
                    String[] stringArray = string.split(",|\\s");
                    for (int i = 0; i < stringArray.length; ++i) {
                        Handler handler;
                        String string2 = stringArray[i];
                        if (string2.equals("") || (handler = (Handler)LogManager.getInstanceByClass(string2)) == null) continue;
                        this.handlers.add(handler);
                        String string3 = this.manager.getProperty(string2 + ".level");
                        if (null == string3) continue;
                        handler.setLevel(Level.parse(string3));
                    }
                    this.handlerInited = true;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Handler[] getHandlers() {
        this.initHandler();
        Logger logger = this;
        synchronized (logger) {
            return this.handlers.toArray(new Handler[this.handlers.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHandler(Handler handler) {
        if (this.isNamed) {
            LogManager.getLogManager().checkAccess();
        }
        if (null == handler) {
            return;
        }
        this.initHandler();
        Logger logger = this;
        synchronized (logger) {
            this.handlers.remove(handler);
        }
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void setFilter(Filter filter) {
        if (this.isNamed) {
            LogManager.getLogManager().checkAccess();
        }
        this.filter = filter;
    }

    public Level getLevel() {
        return this.levelObjVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLevel(Level level) {
        if (this.isNamed) {
            LogManager.getLogManager().checkAccess();
        }
        LogManager logManager = LogManager.getLogManager();
        synchronized (logManager) {
            this.setLevelImpl(level);
        }
    }

    public boolean getUseParentHandlers() {
        return this.notifyParentHandlers;
    }

    public void setUseParentHandlers(boolean bl) {
        if (this.isNamed) {
            LogManager.getLogManager().checkAccess();
        }
        this.notifyParentHandlers = bl;
    }

    public Logger getParent() {
        return this.parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void internalSetParent(Logger logger) {
        LogManager logManager = LogManager.getLogManager();
        synchronized (logManager) {
            this.parent = logger;
            if (null == this.levelObjVal) {
                this.setLevelImpl(this.levelObjVal);
            }
            logger.addChild(this);
        }
    }

    public void setParent(Logger logger) {
        if (null == logger) {
            throw new NullPointerException(Messages.getString("logging.B"));
        }
        LogManager.getLogManager().checkAccess();
        this.internalSetParent(logger);
    }

    final void addChild(Logger logger) {
        this.childs.add(logger);
    }

    final void removeChild(Logger logger) {
        this.childs.remove(logger);
    }

    public String getName() {
        return this.name;
    }

    public ResourceBundle getResourceBundle() {
        return this.resBundle;
    }

    public String getResourceBundleName() {
        return this.resBundleName;
    }

    private boolean internalIsLoggable(Level level) {
        int n = this.levelIntVal;
        if (n == Level.OFF.intValue()) {
            return false;
        }
        return level.intValue() >= n;
    }

    public boolean isLoggable(Level level) {
        return this.internalIsLoggable(level);
    }

    private void setResourceBundle(LogRecord logRecord) {
        if (null != this.resBundleName) {
            logRecord.setResourceBundle(this.resBundle);
            logRecord.setResourceBundleName(this.resBundleName);
        } else {
            Logger logger = this.parent;
            while (null != logger) {
                if (null != logger.resBundleName) {
                    logRecord.setResourceBundle(logger.resBundle);
                    logRecord.setResourceBundleName(logger.resBundleName);
                    return;
                }
                logger = logger.parent;
            }
        }
    }

    public void entering(String string, String string2) {
        if (this.internalIsLoggable(Level.FINER)) {
            LogRecord logRecord = new LogRecord(Level.FINER, "ENTRY");
            logRecord.setLoggerName(this.name);
            logRecord.setSourceClassName(string);
            logRecord.setSourceMethodName(string2);
            this.setResourceBundle(logRecord);
            this.log(logRecord);
        }
    }

    public void entering(String string, String string2, Object object) {
        if (this.internalIsLoggable(Level.FINER)) {
            LogRecord logRecord = new LogRecord(Level.FINER, "ENTRY {0}");
            logRecord.setLoggerName(this.name);
            logRecord.setSourceClassName(string);
            logRecord.setSourceMethodName(string2);
            logRecord.setParameters(new Object[]{object});
            this.setResourceBundle(logRecord);
            this.log(logRecord);
        }
    }

    public void entering(String string, String string2, Object[] objectArray) {
        if (this.internalIsLoggable(Level.FINER)) {
            Serializable serializable;
            String string3 = "ENTRY";
            if (null != objectArray) {
                serializable = new StringBuilder("ENTRY");
                for (int i = 0; i < objectArray.length; ++i) {
                    ((StringBuilder)serializable).append(" {" + i + "}");
                }
                string3 = ((StringBuilder)serializable).toString();
            }
            serializable = new LogRecord(Level.FINER, string3);
            ((LogRecord)serializable).setLoggerName(this.name);
            ((LogRecord)serializable).setSourceClassName(string);
            ((LogRecord)serializable).setSourceMethodName(string2);
            ((LogRecord)serializable).setParameters(objectArray);
            this.setResourceBundle((LogRecord)serializable);
            this.log((LogRecord)serializable);
        }
    }

    public void exiting(String string, String string2) {
        if (this.internalIsLoggable(Level.FINER)) {
            LogRecord logRecord = new LogRecord(Level.FINER, "RETURN");
            logRecord.setLoggerName(this.name);
            logRecord.setSourceClassName(string);
            logRecord.setSourceMethodName(string2);
            this.setResourceBundle(logRecord);
            this.log(logRecord);
        }
    }

    public void exiting(String string, String string2, Object object) {
        if (this.internalIsLoggable(Level.FINER)) {
            LogRecord logRecord = new LogRecord(Level.FINER, "RETURN {0}");
            logRecord.setLoggerName(this.name);
            logRecord.setSourceClassName(string);
            logRecord.setSourceMethodName(string2);
            logRecord.setParameters(new Object[]{object});
            this.setResourceBundle(logRecord);
            this.log(logRecord);
        }
    }

    public void throwing(String string, String string2, Throwable throwable) {
        if (this.internalIsLoggable(Level.FINER)) {
            LogRecord logRecord = new LogRecord(Level.FINER, "THROW");
            logRecord.setLoggerName(this.name);
            logRecord.setSourceClassName(string);
            logRecord.setSourceMethodName(string2);
            logRecord.setThrown(throwable);
            this.setResourceBundle(logRecord);
            this.log(logRecord);
        }
    }

    public void severe(String string) {
        if (this.internalIsLoggable(Level.SEVERE)) {
            LogRecord logRecord = new LogRecord(Level.SEVERE, string);
            logRecord.setLoggerName(this.name);
            this.setResourceBundle(logRecord);
            this.log(logRecord);
        }
    }

    public void warning(String string) {
        if (this.internalIsLoggable(Level.WARNING)) {
            LogRecord logRecord = new LogRecord(Level.WARNING, string);
            logRecord.setLoggerName(this.name);
            this.setResourceBundle(logRecord);
            this.log(logRecord);
        }
    }

    public void info(String string) {
        if (this.internalIsLoggable(Level.INFO)) {
            LogRecord logRecord = new LogRecord(Level.INFO, string);
            logRecord.setLoggerName(this.name);
            this.setResourceBundle(logRecord);
            this.log(logRecord);
        }
    }

    public void config(String string) {
        if (this.internalIsLoggable(Level.CONFIG)) {
            LogRecord logRecord = new LogRecord(Level.CONFIG, string);
            logRecord.setLoggerName(this.name);
            this.setResourceBundle(logRecord);
            this.log(logRecord);
        }
    }

    public void fine(String string) {
        if (this.internalIsLoggable(Level.FINE)) {
            LogRecord logRecord = new LogRecord(Level.FINE, string);
            logRecord.setLoggerName(this.name);
            this.setResourceBundle(logRecord);
            this.log(logRecord);
        }
    }

    public void finer(String string) {
        if (this.internalIsLoggable(Level.FINER)) {
            LogRecord logRecord = new LogRecord(Level.FINER, string);
            logRecord.setLoggerName(this.name);
            this.setResourceBundle(logRecord);
            this.log(logRecord);
        }
    }

    public void finest(String string) {
        if (this.internalIsLoggable(Level.FINEST)) {
            LogRecord logRecord = new LogRecord(Level.FINEST, string);
            logRecord.setLoggerName(this.name);
            this.setResourceBundle(logRecord);
            this.log(logRecord);
        }
    }

    public void log(Level level, String string) {
        if (this.internalIsLoggable(level)) {
            LogRecord logRecord = new LogRecord(level, string);
            logRecord.setLoggerName(this.name);
            this.setResourceBundle(logRecord);
            this.log(logRecord);
        }
    }

    public void log(Level level, String string, Object object) {
        if (this.internalIsLoggable(level)) {
            LogRecord logRecord = new LogRecord(level, string);
            logRecord.setLoggerName(this.name);
            logRecord.setParameters(new Object[]{object});
            this.setResourceBundle(logRecord);
            this.log(logRecord);
        }
    }

    public void log(Level level, String string, Object[] objectArray) {
        if (this.internalIsLoggable(level)) {
            LogRecord logRecord = new LogRecord(level, string);
            logRecord.setLoggerName(this.name);
            logRecord.setParameters(objectArray);
            this.setResourceBundle(logRecord);
            this.log(logRecord);
        }
    }

    public void log(Level level, String string, Throwable throwable) {
        if (this.internalIsLoggable(level)) {
            LogRecord logRecord = new LogRecord(level, string);
            logRecord.setLoggerName(this.name);
            logRecord.setThrown(throwable);
            this.setResourceBundle(logRecord);
            this.log(logRecord);
        }
    }

    public void log(LogRecord logRecord) {
        if (this.internalIsLoggable(logRecord.getLevel())) {
            Filter filter = this.filter;
            if (null != filter && !filter.isLoggable(logRecord)) {
                return;
            }
            this.initHandler();
            Handler[] handlerArray = this.getHandlers();
            for (Handler handlerArray2 : handlerArray) {
                handlerArray2.publish(logRecord);
            }
            Object object = this;
            Logger logger = ((Logger)object).parent;
            while (logger != null && ((Logger)object).getUseParentHandlers()) {
                Handler[] handlerArray3;
                for (Handler handler : handlerArray3 = logger.getHandlers()) {
                    handler.publish(logRecord);
                }
                object = logger;
                logger = ((Logger)object).parent;
            }
        }
    }

    public void logp(Level level, String string, String string2, String string3) {
        if (this.internalIsLoggable(level)) {
            LogRecord logRecord = new LogRecord(level, string3);
            logRecord.setLoggerName(this.name);
            logRecord.setSourceClassName(string);
            logRecord.setSourceMethodName(string2);
            this.setResourceBundle(logRecord);
            this.log(logRecord);
        }
    }

    public void logp(Level level, String string, String string2, String string3, Object object) {
        if (this.internalIsLoggable(level)) {
            LogRecord logRecord = new LogRecord(level, string3);
            logRecord.setLoggerName(this.name);
            logRecord.setSourceClassName(string);
            logRecord.setSourceMethodName(string2);
            logRecord.setParameters(new Object[]{object});
            this.setResourceBundle(logRecord);
            this.log(logRecord);
        }
    }

    public void logp(Level level, String string, String string2, String string3, Object[] objectArray) {
        if (this.internalIsLoggable(level)) {
            LogRecord logRecord = new LogRecord(level, string3);
            logRecord.setLoggerName(this.name);
            logRecord.setSourceClassName(string);
            logRecord.setSourceMethodName(string2);
            logRecord.setParameters(objectArray);
            this.setResourceBundle(logRecord);
            this.log(logRecord);
        }
    }

    public void logp(Level level, String string, String string2, String string3, Throwable throwable) {
        if (this.internalIsLoggable(level)) {
            LogRecord logRecord = new LogRecord(level, string3);
            logRecord.setLoggerName(this.name);
            logRecord.setSourceClassName(string);
            logRecord.setSourceMethodName(string2);
            logRecord.setThrown(throwable);
            this.setResourceBundle(logRecord);
            this.log(logRecord);
        }
    }

    public void logrb(Level level, String string, String string2, String string3, String string4) {
        if (this.internalIsLoggable(level)) {
            LogRecord logRecord = new LogRecord(level, string4);
            if (null != string3) {
                try {
                    logRecord.setResourceBundle(Logger.loadResourceBundle(string3));
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
                logRecord.setResourceBundleName(string3);
            }
            logRecord.setLoggerName(this.name);
            logRecord.setSourceClassName(string);
            logRecord.setSourceMethodName(string2);
            this.log(logRecord);
        }
    }

    public void logrb(Level level, String string, String string2, String string3, String string4, Object object) {
        if (this.internalIsLoggable(level)) {
            LogRecord logRecord = new LogRecord(level, string4);
            if (null != string3) {
                try {
                    logRecord.setResourceBundle(Logger.loadResourceBundle(string3));
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
                logRecord.setResourceBundleName(string3);
            }
            logRecord.setLoggerName(this.name);
            logRecord.setSourceClassName(string);
            logRecord.setSourceMethodName(string2);
            logRecord.setParameters(new Object[]{object});
            this.log(logRecord);
        }
    }

    public void logrb(Level level, String string, String string2, String string3, String string4, Object[] objectArray) {
        if (this.internalIsLoggable(level)) {
            LogRecord logRecord = new LogRecord(level, string4);
            if (null != string3) {
                try {
                    logRecord.setResourceBundle(Logger.loadResourceBundle(string3));
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
                logRecord.setResourceBundleName(string3);
            }
            logRecord.setLoggerName(this.name);
            logRecord.setSourceClassName(string);
            logRecord.setSourceMethodName(string2);
            logRecord.setParameters(objectArray);
            this.log(logRecord);
        }
    }

    public void logrb(Level level, String string, String string2, String string3, String string4, Throwable throwable) {
        if (this.internalIsLoggable(level)) {
            LogRecord logRecord = new LogRecord(level, string4);
            if (null != string3) {
                try {
                    logRecord.setResourceBundle(Logger.loadResourceBundle(string3));
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
                logRecord.setResourceBundleName(string3);
            }
            logRecord.setLoggerName(this.name);
            logRecord.setSourceClassName(string);
            logRecord.setSourceMethodName(string2);
            logRecord.setThrown(throwable);
            this.log(logRecord);
        }
    }

    void setManager(LogManager logManager) {
        String string;
        if (this.manager != logManager) {
            this.manager = logManager;
            this.handlerInited = false;
        }
        if (null != (string = logManager.getProperty(this.name + ".level"))) {
            try {
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        Logger.this.setLevel(Level.parse(string));
                        return null;
                    }
                });
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    synchronized void reset() {
        this.levelObjVal = null;
        this.levelIntVal = Level.INFO.intValue();
        if (this.handlers != null) {
            for (Handler handler : this.handlers) {
                try {
                    handler.close();
                }
                catch (Exception exception) {}
            }
            this.handlers.clear();
        }
        this.handlerInited = false;
    }

    static class PrivateSecurityManager
    extends SecurityManager {
        PrivateSecurityManager() {
        }

        public Class<?>[] privateGetClassContext() {
            return super.getClassContext();
        }
    }
}

