/*
 * Decompiled with CFR 0.152.
 */
package java.util.logging;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;

public class SimpleFormatter
extends Formatter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String format(LogRecord logRecord) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(MessageFormat.format("{0, date} {0, time} ", new Date(logRecord.getMillis())));
        stringBuilder.append(logRecord.getSourceClassName()).append(" ");
        stringBuilder.append(logRecord.getSourceMethodName()).append(LogManager.getSystemLineSeparator());
        stringBuilder.append(logRecord.getLevel().getName()).append(": ");
        stringBuilder.append(this.formatMessage(logRecord)).append(LogManager.getSystemLineSeparator());
        if (null != logRecord.getThrown()) {
            stringBuilder.append("Throwable occurred: ");
            Throwable throwable = logRecord.getThrown();
            PrintWriter printWriter = null;
            try {
                StringWriter stringWriter = new StringWriter();
                printWriter = new PrintWriter(stringWriter);
                throwable.printStackTrace(printWriter);
                stringBuilder.append(stringWriter.toString());
            }
            finally {
                if (printWriter != null) {
                    try {
                        printWriter.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return stringBuilder.toString();
    }
}

