#!/bin/sh
#
# Purpose:
#   This script is used to run the first pass of all of the registration scripts
#   in the current directory.  This pass is run before the CIMOM is started.
#
#   Registration will take place only if a marker file is present.
#
#   The base tower script is run first.  Then all other scripts in the
#   current directory (with the exception of this one and the registration
#   script) are run.
#****************************************************************************

marker="cimregister"
basescript="cimpreregisterbase.sh"

# If the marker file is not present, we don't have to do anything.
if [ -e ${marker} ]; then
  actzTrace "CIMOMRGT: -> cimpreregister.sh"
  # If there is a base tower script, run it first.
  if [ -e ${basescript} ]; then
    sh ${basescript} preregistration
  fi
  # Now run the rest of the scripts in this directory
  ls *.sh | grep -v cimregister.sh | grep -v cimpreregister.sh | grep -v ${basescript} | xargs -i+ sh + preregistration

  # Disable the HTTPS and SLP ports while we are (potentially) registering our
  # classes
  cimconfig -ps enableHttpsConnection=false
  #cimconfig -ps slp=false

  actzTrace "CIMOMRGT: <- cimpreregister.sh"
fi
