#!/bin/bash

# devicefile.sh
#
# Usage: devicefile.sh <device file> <temp file> <log file>
#
# Return Codes:
# 1 - Error finding device file
#
# Author: C. Schuck
#
#  03/17/2005  P. Provost Fixed tracing

DEVICEFILE=$1
TEMPFILE=$2
LOGFILE=$3

echo "-> devicefile.sh" >> $LOGFILE
echo "devicefile.sh: Checking /dev for any symbolic links to $DEVICEFILE for `date`" >> $LOGFILE

actzTrace "XMDA   T: -> devicefile.sh"
actzTrace "XMDA   F: devicefile.sh: Checking /dev for any symbolic links to $DEVICEFILE for `date`"

# Check the /dev directory for any symbolic links to the $DEVICEFILE
if ls -l /dev | grep '>' | grep -i $DEVICEFILE > $TEMPFILE; then

    actzTrace "XMDA   F: devicefile.sh: A symbolic link to $DEVICEFILE exists in /dev"
    echo "devicefile.sh: A symbolic link to $DEVICEFILE exists in /dev" >> $LOGFILE

    cat $TEMPFILE >> $LOGFILE     # Add the result of the search to the log file

    echo "<- devicefile.sh for `date`" >> $LOGFILE
    echo "" >> $LOGFILE

    actzTrace "XMDA   T: <- devicefile.sh for `date`"

    exit 0
else

    echo "devicefile.sh: No symbolic link to $DEVICEFILE exists in /dev" >> $LOGFILE
    actzTrace "XMDA   F: devicefile.sh: No symbolic link to $DEVICEFILE exists in /dev"

    echo "<- devicefile.sh for `date`" >> $LOGFILE
    echo "" >> $LOGFILE

    actzTrace "XMDA   T: <- devicefile.sh for `date`"

    exit 1
fi
