#!/bin/bash

# diskettelabel.sh
#
# Usage: diskettelabel.sh <device file> <label file> <log file> <dos letter>
#
# Return Codes:
# 1 - Error reading the label
#
# Author: C. Schuck
#
# Module History
#  00  11/21/2003  P. Provost - Changed to use /sbin/e2label because /sbin is not in the root path
#  01  03/17/2005  P. Provost - Fixed tracing
#  02  06/30/2005  P. Provost - Sets environment variable for data/mtools.conf

DEVICEFILE=$1
LABELFILE=$2
LOGFILE=$3
DOSLETTER=$4
MTOOLSFILE=$5

echo "-> diskettelabel.sh" >> $LOGFILE
echo "diskettelabel.sh: Getting the label from the diskette at $DEVICEFILE for `date`." >> $LOGFILE

actzTrace "XMDA   T: -> diskettelabel.sh"
actzTrace "XMDA   F: diskettelabel.sh: Getting the label from the diskette at $DEVICEFILE for `date`"

# set the environment variable for the path to the user defined mtools.conf file
export MTOOLSRC=$MTOOLSFILE

# If the diskette is a DOS diskette, retrieve the diskette label using mdir
if mdir $DOSLETTER > $LABELFILE 2>&1; then

    echo "diskettelabel.sh: Successfully retrieved the diskette label using mdir at `date`." >> $LOGFILE
    actzTrace "XMDA   F: diskettelabel.sh: Successfully retrieved the diskette label using mdir at `date`."

    echo "diskettelabel.sh: Label File Listing:" >> $LOGFILE
    echo "" >> $LOGFILE
    cat $LABELFILE >> $LOGFILE
    echo "" >> $LOGFILE

# Else if the diskette is a Linux diskette, retrieve the diskette label using e2label
elif /sbin/e2label $DEVICEFILE > $LABELFILE 2>&1; then

    echo "diskettelabel.sh: Successfully retrieved the diskette label using e2label at `date`." >> $LOGFILE
    actzTrace "XMDA   F: diskettelabel.sh: Successfully retrieved the diskette label using e2label at `date`."

    echo "diskettelabel.sh: Label File Listing:" >> $LOGFILE
    echo "" >> $LOGFILE
    cat $LABELFILE >> $LOGFILE
    echo "" >> $LOGFILE

# Else the script failed to retrieve the label from the diskette
else

    echo "diskettelabel.sh: The attempts to retrieve the label from the diskette have failed at `date`." >> $LOGFILE
    actzTrace "XMDA   F: diskettelabel.sh: The attempts to retrieve the label from the diskette have failed at `date`."

    echo "<- diskettelabel.sh for `date`" >> $LOGFILE
    echo "" >> $LOGFILE

    actzTrace "XMDA   T: <- diskettelabel.sh for `date`"

    exit 1
fi

echo "<- diskettelabel.sh for `date`" >> $LOGFILE
echo "" >> $LOGFILE

actzTrace "XMDA   T: <- diskettelabel.sh for `date`"

exit 0

