#!/bin/sh

if [ -n "$1" ]; then
   label=""
   if [ "$1" == "/dev/fd0" ]; then
      # it is a floppy
      label=`mlabel -s a: | sed -e 's/.* is //1'`
   else
      # see if it is some USB device
      mtpattern=`echo $1 | sed -e 's?/?\\\/?g'`
      mtdev=`cat ${CONSOLE_PATH}data/mtools.conf | sed -e "/\"$mtpattern\"/!d" -e 's/drive //1' -e 's/ .*//1'`
      if [ -n "$mtdev" ]; then
         # it is some sort of mtools thing
         label=`MTOOLSRC=${CONSOLE_PATH}data/mtools.conf mlabel -s $mtdev | sed -e 's/.* is //1'`
      else
         # let's try UDF format
         label=`chkudf $1 | sed -e '/^\*\*/d' -e '/Volume Identifier:/!d' -e "s/.*: '//1" -e "s/'.*//1"`
         if [ -z "$label" ]; then
            # let's try CD format
            label=`volname $1`
         fi
      fi
   fi
   echo -e "Label: $label\n"
fi
exit 