#!/bin/bash

# usbmemlabel.sh
#
# Usage: usbmemlabel.sh <device file> <label file> <log file> <dos letter>
#
# Return Codes:
# 1 - Error reading the label
#
# Author: P. Provost
#
# Module History
#  00  10/07/2004  P. Provost - Initial release
#  01  03/17/2005  P. Provost - Fixed tracing
#  02  06/30/2005  P. Provost - Sets environment variable for data/mtools.conf

DEVICEFILE=$1
LABELFILE=$2
LOGFILE=$3
DOSLETTER=$4
MTOOLSFILE=$5

echo "-> usbmemlabel.sh" >> $LOGFILE
echo "usbmemlabel.sh: Getting the label from the USB flash memory drive at $DEVICEFILE for `date`" >> $LOGFILE

actzTrace "XMDA   T: -> usbmemlabel.sh"
actzTrace "XMDA   F: usbmemlabel.sh: Getting the label from the USB flash memory drive at $DEVICEFILE for `date`"

# set the environment variable for the path to the user defined mtools.conf file
export MTOOLSRC=$MTOOLSFILE

# If the USB flash memory drive is DOS formatted, retrieve the volume label using mdir
if mdir $DOSLETTER > $LABELFILE 2>&1; then

    actzTrace "XMDA   F: usbmemlabel.sh: Successfully retrieved the volume label using mdir."
    echo "usbmemlabel.sh: Successfully retrieved the volume label using mdir." >> $LOGFILE

    echo "usbmemlabel.sh: Label File Listing:" >> $LOGFILE
    cat $LABELFILE >> $LOGFILE

# Else if the USB flash memory drive is Linux formatted, retrieve the volume label using e2label
elif /sbin/e2label $DEVICEFILE > $LABELFILE 2>&1; then
    actzTrace "XMDA   F: usbmemlabel.sh: Successfully retrieved the volume label using e2label."
    echo "usbmemlabel.sh: Successfully retrieved the volume label using e2label." >> $LOGFILE

    echo "usbmemlabel.sh: Label File Listing:" >> $LOGFILE
    cat $LABELFILE >> $LOGFILE

# Else the script failed to retrieve the volume label from the USB flash memory drive
else
    actzTrace "XMDA   F: usbmemlabel.sh: The attempts to retrieve the label from the USB flash memory drive have failed."
    echo "usbmemlabel.sh: The attempts to retrieve the label from the USB flash memory drive have failed." >> $LOGFILE

    echo "<- usbmemlabel.sh for `date`" >> $LOGFILE
    echo "" >> $LOGFILE

    actzTrace "XMDA   T: <- usbmemlabel.sh for `date`"

    exit 1
fi

echo "<- usbmemlabel.sh for `date`" >> $LOGFILE
echo "" >> $LOGFILE

actzTrace "XMDA   T: <- usbmemlabel.sh for `date`"

exit 0

