<%--
 This is an error page delivered by HmcFormAuthenticator.java when it denies
 the HTTP request authorization without giving the user a chance to enter a
 userid and password.  This occurs in some unusual situations, such as a
 failure to authenticate when autologging a user.  The job of this jsp is
 merely to display an error message.
--%>

<%@taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@taglib prefix="hmc" uri="/WEB-INF/hmc.tld"%>
<%@page contentType="text/html; charset=UTF-8"%>

<fmt:bundle basename="com.ibm.hwmca.fw.servlet.connect.res.connect">
<html>
<head>
   <hmc:title><fmt:message key="failedAuthenticationTitle"/></hmc:title>
   <link href='<%=application.getAttribute("hmcStyleSheet")%>' rel="stylesheet" type="text/css"/>
   <link rel="SHORTCUT ICON" href="/favicon.ico"/>
   <link rel="icon" href="/hmc.png" type="image/png"/>
</head>
<body>
<span class="cont1">
<h1><fmt:message key="failedAuthenticationTitle"/></h1>

<p style="font-weight:bold; color:red">
<c:out value="${customMessage}" escapeXml="false">
 <fmt:message key="failedAuthenticationMessage"/>
</c:out>

<c:if test="${not empty offerCloseButton}">
   <script type="text/javascript">
      function closeButton() {
         window.top.close();
      }
   </script>

<p>
   <input type="button" onclick="closeButton()"
          value="<fmt:message key='closeButtonLabel'/>"
          class="b1" onmouseout="className='b1'"
          onmouseover="className='b2'" />
</p>
</c:if>

<%-- Invalidate the HTTP session.  No HMCSession has yet been created. --%>
<% session.invalidate(); %>
</span>
</body>
</html>
</fmt:bundle>
