<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
	"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<!--<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">-->

<!--
/*********************************************************** {COPYRIGHT-TOP} ***
* Licensed materials - Property of IBM
*
* (C) Copyright IBM Corp. 2003
*
* US Government Users Restricted Rights - Use, duplication, or
* disclosure restricted by GSA ADP Schedule Contract with
* IBM Corp.
*
* Module History:
* 05/21/2007  J. Jenks     Convert from p for use on z.
* 11/29/2007  K. Tong      Update status images, IE6 PNG fix
************************************************************ {COPYRIGHT-END} ****/
-->
<%@taglib prefix="wcl" uri="/WEB-INF/WCLTagLib.tld"%>
<%@taglib prefix="hmc" uri="/WEB-INF/hmc.tld"%>
<%@taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>

<%@page import="java.util.Iterator,
                java.util.List,
                java.util.Map,
                javax.servlet.ServletConfig,
                javax.servlet.ServletContext,
                javax.servlet.ServletException,
                javax.servlet.http.HttpServletRequest,
                javax.servlet.http.HttpServletResponse,
                javax.servlet.http.HttpSession,
                javax.servlet.jsp.JspFactory,
                javax.servlet.jsp.JspWriter,
                org.apache.jasper.runtime.HttpJspBase,
                com.ibm.hwmca.fw.servlet.util.HMCSession,
                com.ibm.hwmca.fw.servlet.util.HMCSession,
                com.ibm.hwmca.fw.servlet.util.ServletRuntime,
                com.ibm.hwmca.fw.settings.user.BonsaiUserSettings,
                com.ibm.hwmca.fw.util.LocalizableText,
                com.ibm.hwmca.ui.bonsai.earth.BonsaiTreeManager,
                com.ibm.hwmca.ui.bonsai.earth.BonsaiTreeNode,
                com.ibm.hwmca.ui.bonsai.servlet.ControllerServlet,
                com.ibm.hwmca.ui.bonsai.servlet.HealthAction,
                com.ibm.hwmca.ui.bonsai.servlet.WorkareaAction,
                com.ibm.hwmca.ui.bonsai.servlet.util.UserObject,
                com.ibm.hwmca.ui.bonsai.servlet.util.UserObjectListener,
                com.ibm.hwmca.ui.bonsai.status.ExceptionsAndMessagesTreeModel,
                com.ibm.hwmca.ui.bonsai.status.StatusOverviewModel,
                com.ibm.hwmca.ui.bonsai.status.StatusUtils,
                com.ibm.hwmca.ui.bonsai.status.TypedChildrenStatisticsBean,
                com.ibm.hwmca.ui.bonsai.util.SettingsRetriever,
                com.ibm.hwmca.ui.bonsai.util.GraphicsConstants" %>

<fmt:bundle basename="com.ibm.hwmca.ui.bonsai.res.bonsai">

<%!
    private static final LocalizableText TITLE = new LocalizableText("com.ibm.hwmca.ui.bonsai.res.bonsai",
                                                                     "status.overview.title");
    private static final LocalizableText CAPTION = new LocalizableText("com.ibm.hwmca.ui.bonsai.res.bonsai",
                                                                       "phmc.status.overview.caption");
    private static final String MODEL_SESSION_KEY = "ExcAndMsgsStatusOverviewModel";
%>

<%
  String bodyDir = java.awt.ComponentOrientation.getOrientation(request.getLocale()).isLeftToRight() ? "ltr" : "rtl";
  pageContext.setAttribute("bodyDir", bodyDir);
%>

<% // create modifier suffix to be used for CSS class names
   String suffix = "";
   if ( bodyDir.equals( "rtl" ) ) {
		suffix = "_RTL";
   }
%>		
	

<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">

<!-- ===========================================================================
  This JSP is a view.  That is, the WclFacade and all data is defined inside a
  controller Servlet.
  ========================================================================== -->
<wcl:Foundation
	objectScope="session"
    wclFacadeScope="<%= HMCSession.getHMCSession(session).getHMCCustomScope().getScopeName() %>"
    wclFacadeScopeId="<%= ControllerServlet.FACADE_ID_ATTRIBUTE %>"
    pageName="excandmsgsstatusoverviewpage">

<head>
<link href="/css/ui/bonsai/excandmsgsoverview.css" rel="stylesheet" type="text/css"/>
<script src="/js/ui/bonsai/nodrag.js" type="text/javascript"></script>
<script src="/js/ui/bonsai/utilities.js" type="text/javascript"></script>
<script src="/js/ui/bonsai/navcursor.js" type="text/javascript"></script>
<script src="/js/ui/bonsai/asyncjsonrefresh.js" type="text/javascript"></script>
<!--[if IE]>
<style>
	.png_icon {
		position: relative;
		top: 15px;
		left: 18px;
	}
	
	.png_icon_RTL {
		position: relative;
		top: 15px;
		right: 18px;
	}	
</style>
<![endif]-->
<%
    // attach the user context to this thread
    ServletRuntime.getRuntime().attachUserContextToServletThread(request);

    // get the user's session data
    HMCSession hmcSession = HMCSession.getHMCSession(session);
    UserObject userObj = UserObject.getUserObject(hmcSession);
    BonsaiUserSettings bonsaiSettings = SettingsRetriever.getBonsaiUserSettings(hmcSession);
    String waKey = request.getParameter("wakey");
    if (waKey == null)
    {
        throw(new IllegalArgumentException("request parameter 'wakey' is required but missing!"));
    }

    // get the model, creating it if this is the first request by the session
    synchronized(session)
    {
        if (hmcSession.getSessionAttribute(MODEL_SESSION_KEY) == null)
        {
            StatusOverviewModel model = new StatusOverviewModel(ControllerServlet.HEALTH_TREE_KEY,
                                                                waKey,
                                                                userObj);
            BonsaiTreeManager.getBonsaiTreeManager().getEventQueue().addEventQueueListener(model);
            model.init();
            hmcSession.setSessionAttribute(MODEL_SESSION_KEY, model);

            // setup a UserObjectListener so we can deregister backend listener registrations
            userObj.addUserObjectListener(
                new UserObjectListener()
                {
                    public void userObjectDisconnecting(UserObject userObj) {}
                    public void userObjectReconnecting(UserObject userObj) {}
                    public void userObjectDying(UserObject userObj)
                    {
                        StatusOverviewModel model = (StatusOverviewModel)(userObj.getHMCSession().getSessionAttribute(MODEL_SESSION_KEY));
                        BonsaiTreeManager.getBonsaiTreeManager().getEventQueue().removeEventQueueListener(model);
                    }
                }
            );
        }
    }

    // retrieve the body style info
    StringBuffer bodyStyle = new StringBuffer();
    try
    {
        Map.Entry style = null;
        for (Iterator i = WorkareaAction.getURIStyle(waKey).entrySet().iterator(); i.hasNext(); )
        {
            style = (Map.Entry)i.next();
            bodyStyle.append((String)style.getKey());
            bodyStyle.append(": ");
            bodyStyle.append((String)style.getValue());
            if (i.hasNext())
            {
                bodyStyle.append("; ");
            }
        }
    }
    catch (IllegalArgumentException iaEx)
    {
        // workarea must have changed since we were asked to render, so ignore
    }

    // determine if the client is using IE6, for PNG display
	String theagent = request.getHeader("USER-AGENT");
	boolean isIE6 = false;
	if (theagent.indexOf("MSIE 6.0")!=-1) {
		isIE6 = true;
	}
%>

</head>

<c:set var="showIcons" scope="page"><%= bonsaiSettings.isShowWorkareaIcons() %></c:set>

<body style="<%= bodyStyle.toString() %>" onmousemove="navOnMouseMove('west');" onmouseout="navOnMouseOut();" dir="<c:out value='${bodyDir}'/>">
<div id="bodyOuterDiv">

<% if (isIE6) { %>
<!-- IE 6.  -->
<img id="titleImage<%= suffix %>" src="<%= GraphicsConstants.TRANSPARENT %>" width="30" height="30" style="height:30px;width:30px;filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src='/res/com/ibm/hwmca/ui/bonsai/images/status-overview-30.png', sizingMethod='image');" />
<% } else { %>
<!-- NOT IE 6.  -->
<img id="titleImage<%= suffix %>" src="/res/com/ibm/hwmca/ui/bonsai/images/status-overview-30.png" width="30" height="30" />
<% } %><wcl:WTitledLayout objectScopeId="excandmsgsStatusOverviewTitle" description="<%= CAPTION.toString(request.getLocale()) %>" title="<%= TITLE.toString(request.getLocale()) %>" ></wcl:WTitledLayout>

<%
	int    exceptions 	       = -1;
    String exceptionImage      = "";
	String exceptionText       = "";
	String exceptionMiniText   = "";
	String exceptionAnchorAttr = "";
	int    hwMsgs              = -1;
    String hwMsgImage          = "";
	String hwMsgText           = "";
	String hwMsgMiniText       = "";
	String hwMsgAnchorAttr     = "";
	int	   osMsgs              = -1;
    String osMsgImage          = "";
	String osMsgText           = "";
	String osMsgMiniText       = "";
	String osMsgAnchorAttr     = "";

    StatusOverviewModel model = (StatusOverviewModel)(HMCSession.getHMCSession(session).getSessionAttribute(MODEL_SESSION_KEY));
    List                beans = model.getBeans();
    Iterator            i     = beans.iterator();
    while (i.hasNext()) {
        TypedChildrenStatisticsBean bean = (TypedChildrenStatisticsBean)i.next();

        String miniText = "";
        Map minis = bean.getTypedChildrenStats();
        if (minis != null) {
        	Iterator n = minis.keySet().iterator();
        	while (n.hasNext()) {
        		Class[] classObjects = (Class[])n.next();
        		String  className    = classObjects[0].getName();
        		int     numOfType    = ((Integer)minis.get( classObjects )).intValue();
        		
        		if (numOfType > 0) {
        			miniText += "<span><img height=\"16\" width=\"16\" src=\"" + StatusUtils.getCategoryIcon( className ) + "\" /> "
						      + StatusUtils.getCategoryName( request.getLocale(), className ) + ": " + numOfType + "</span>";
        		}
        	}
        }

		if (bean.getStatusType() == ExceptionsAndMessagesTreeModel.STATUS_TYPE_EXCEPTIONS) {
			exceptions = bean.getTotalChildren();
            exceptionImage = bean.getDisabledImage();
			exceptionText = bean.getName();
			exceptionMiniText = miniText;
            if (exceptions > 0) {
                exceptionImage = bean.getImage();
                exceptionAnchorAttr = "href=\"" + HealthAction.getSelectionUrl(bean.getId()) + "\" "
                                    + "target=\"" + HealthAction.FRAME_NAME + "\" "
                                    + "title=\"" + new LocalizableText("com.ibm.hwmca.ui.bonsai.res.bonsai", "view.open.alt", new String[] { exceptionText }).toString(request.getLocale()) + "\"";
            }
		}
		else if (bean.getStatusType() == ExceptionsAndMessagesTreeModel.STATUS_TYPE_HWMESSAGES) {
			hwMsgs = bean.getTotalChildren();
            hwMsgImage = bean.getDisabledImage();
			hwMsgText = bean.getName();
			hwMsgMiniText = miniText;
            if (hwMsgs > 0) {
                hwMsgImage = bean.getImage();
                hwMsgAnchorAttr = "href=\"" + HealthAction.getSelectionUrl(bean.getId()) + "\" "
                                + "target=\"" + HealthAction.FRAME_NAME + "\" "
                                + "title=\"" + new LocalizableText("com.ibm.hwmca.ui.bonsai.res.bonsai", "view.open.alt", new String[] { hwMsgText }).toString(request.getLocale()) + "\"";
            }
		}
		else if (bean.getStatusType() == ExceptionsAndMessagesTreeModel.STATUS_TYPE_OSMESSAGES) {
			osMsgs = bean.getTotalChildren();
            osMsgImage = bean.getDisabledImage();
			osMsgText = bean.getName();
			osMsgMiniText = miniText;
            if (osMsgs > 0) {
                osMsgImage = bean.getImage();
                osMsgAnchorAttr = "href=\"" + HealthAction.getSelectionUrl(bean.getId()) + "\" "
                                + "target=\"" + HealthAction.FRAME_NAME + "\" "
                                + "title=\"" + new LocalizableText("com.ibm.hwmca.ui.bonsai.res.bonsai", "view.open.alt", new String[] { osMsgText }).toString(request.getLocale()) + "\"";
            }
        }
    }
%>

<ul class="status">
    <% if (exceptions >= 0) { %>
    <li id="exceptions" <%= exceptions == 0 ? "" : "class=\"bad"+ suffix + "\"" %>>
        <a class="icon<%= suffix %>" <%= exceptionAnchorAttr %>>
			<% if (isIE6) { %>
			<!-- IE 6.  -->
			<img src="<%= GraphicsConstants.TRANSPARENT %>" border="0" class="png_icon<%= suffix %>" style="height:30px;width:30px;filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src='<%= exceptionImage %>', sizingMethod='image');" />
			<% } else { %>
			<!-- NOT IE 6.  -->
			<img src="<%= exceptionImage %>" class="png_icon<%= suffix %>" border="0" height="30" width="30" />
			<% } %>
		</a>
        <h2<%= bodyDir.equals( "rtl" ) ? " class=\"RTL\"" : "" %>><table><tr><td><a <%= exceptionAnchorAttr %>><%= exceptionText %></a></td><td> (<%= exceptions %>)</td></tr></table></h2>
        <p id="exceptionsMessage"<%= bodyDir.equals( "rtl" ) ? " class=\"RTL\"" : "" %>><%= exceptionMiniText %></p>
    </li>
    <% } if (hwMsgs >= 0) { %>
    <li id="hwmessages" <%= hwMsgs == 0 ? "" : "class=\"bad"+ suffix + "\"" %>>
        <a class="icon<%= suffix %>" <%= hwMsgAnchorAttr %>>
			<% if (isIE6) { %>
			<!-- IE 6.  -->
			<img src="<%= GraphicsConstants.TRANSPARENT %>" border="0" class="png_icon<%= suffix %>" style="height:30px;width:30px;filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src='<%= hwMsgImage %>', sizingMethod='image');" />
			<% } else { %>
			<!-- NOT IE 6.  -->
			<img src="<%= hwMsgImage %>" class="png_icon<%= suffix %>" border="0" height="30" width="30" />
			<% } %>        	
        </a>
        <h2<%= bodyDir.equals( "rtl" ) ? " class=\"RTL\"" : "" %>><table><tr><td><a <%= hwMsgAnchorAttr %>><%= hwMsgText %></a></td><td> (<%= hwMsgs %>)</td></tr></table></h2>
        <p id="hwMsgsMessage"<%= bodyDir.equals( "rtl" ) ? " class=\"RTL\"" : "" %>><%= hwMsgMiniText %></p>
    </li>
    <% } if (osMsgs >= 0) { %>
    <li id="osmessages" <%= osMsgs == 0 ? "" : "class=\"bad"+ suffix + "\"" %>>
        <a class="icon<%= suffix %>" <%= osMsgAnchorAttr %>>
			<% if (isIE6) { %>
			<!-- IE 6.  -->
			<img src="<%= GraphicsConstants.TRANSPARENT %>" border="0" class="png_icon<%= suffix %>" style="height:30px;width:30px;filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src='<%= osMsgImage %>', sizingMethod='image');" />
			<% } else { %>
			<!-- NOT IE 6.  -->
			<img src="<%= osMsgImage %>" class="png_icon<%= suffix %>" border="0" height="30" width="30" />
			<% } %>           	        	
        </a>
        <h2<%= bodyDir.equals( "rtl" ) ? " class=\"RTL\"" : "" %>><table><tr><td><a <%= osMsgAnchorAttr %>><%= osMsgText %></a></td><td> (<%= osMsgs %>)</td></tr></table></h2>
        <p id="osMsgsMessage"<%= bodyDir.equals( "rtl" ) ? " class=\"RTL\"" : "" %>><%= osMsgMiniText%></p>
    </li>
    <% } %>
</ul>


</div>
</body>

</wcl:Foundation>

</html>

</fmt:bundle>
