/********************************************/
/********** Default Button Support **********/
/********************************************/

var ENTER_KEY  =  13;
var ESCAPE_KEY =  27; // ESC
var HELP_KEY   = 112; // F1

var DEFAULT_BUTTON = "isDefault";

/**
 *
 * Determine if ENTER key pressed in an input element.  If so, programmatically
 * "click" the default button, if designated.
 *
 * Pressing the ENTER key will trigger the default button only when keyboard
 * focus is :
 *
 *    -- On the default button itself
 *    -- On a text entry field ... NOT a multi-line textarea
 *    -- On a password field
 *    -- On a checkbox
 *    -- On a radio button
 *
 * The default button will NOT be activated when keyboard focus is on a hyperlink.
 *
 * Some browsers do not consider an item selected in combobox or listbox until
 * the user has pressed the ENTER key.  The default button will NOT be activated
 * when keyboard focus is on either a combobox or listbox.
 *
 * Finally, the default button will NOT be activated when keyboard focus is on
 * either component of an input type="file" component since there appears to be
 * no way to determine if focus is in the text field or on the BROWSE button.
 *
 */
function keyPressed( evnt ) {
   var swallowKeyPress = false;
   var evnt = (evnt) ? evnt : ((event) ? event : null);
   if ( evnt ) {
      var source  = (evnt.target) ? evnt.target : ((evnt.srcElement) ? evnt.srcElement : null);
      var keycode = evnt.keyCode;

      /***** ENTER Key processing *****/
      if ( keycode == ENTER_KEY ) {
         var type = ( source.type ) ? source.type.toUpperCase() : "null";
         var id   = ( source.id ) ? source.id : "null";
         if ( type == "TEXT"     || type == "PASSWORD" ||
              type == "CHECKBOX" || type == "RADIO"    || type =="IMAGE" ) {
            if ( source.form ) {
               var buttons = source.form.elements;
               for ( var i = 0; i < buttons.length; i++ ) {
                  if ( buttons[i].type ) {
                      type = buttons[i].type.toUpperCase();
                      if ( type == "BUTTON" || type == "SUBMIT" || type == "IMAGE" ) {
                         if ( buttons[i].getAttribute( DEFAULT_BUTTON ) &&
                              buttons[i].getAttribute( DEFAULT_BUTTON ).toUpperCase() == "TRUE" ) {
                             if ( !buttons[i].disabled ) {
                                swallowKeyPress = true;
                                buttons[i].click();
                                break;
                             } // end if
                         } // end if
                      } // end if
                  } // end if
               } // end for
            } // endif
         } // end if
      } // end if

      /***** ESCAPE Key processing *****/
//    else if ( keycode == ESCAPE_KEY ) {
//       if ( source.form ) {
//          var buttons = source.form.elements;
//          for ( i = 0; i < buttons.length; i++ ) {
//             var value = buttons[i].value.toUpperCase();
//             if ( value == "CANCEL" ) {
//                swallowKeyPress = true;
//                buttons[i].click();
//                break;
//             } // end if
//          } // end for
//       } // endif
//    } // end else if

      /***** F1 Key processing *****/
//    else if ( keycode == HELP_KEY ) {
//       if ( source.form ) {
//          var buttons = source.form.elements;
//          for ( i = 0; i < buttons.length; i++ ) {
//             var value = buttons[i].value.toUpperCase();
//             if ( value == "HELP" ) {
//                swallowKeyPress = true;
//                buttons[i].click();
//                break;
//             } // end if
//          } // end for
//       } // endif
//    } // end else if
   } // end if

   if ( swallowKeyPress ) {
      if ( evnt.returnValue ) {
         evnt.returnValue = false;
      } // end if
      else if ( evnt.preventDefault ) {
         evnt.preventDefault();
      } // end else if
      else {
         return false;
      } // end else
   } // end if

} // keyPressed()

/**
 * Register a handler to process a keypress.
 */
function registerDefaultButtonListener() {
   // If browser is IE, then addEventListener method is not supported ...
   if ( document.addEventListener ) {
      document.addEventListener( "keypress", keyPressed, false );
   } // end if
   else {
      document.attachEvent( "onkeypress", keyPressed );
   } // end else
} // registerDefaultButtonListener()


/*******************************************/
/********** Initial Focus Support **********/
/*******************************************/

/** */
function dataObject() {
   this.firstNonSubmit = null;
   this.firstSubmit    = null;
   this.initialFocus   = null;
   this.defaultButton  = null;
   this.fdaIcon        = null;
   this.allSubmitItems = true;
} // dataObject()

var INITIAL_FOCUS = "initialFocus";

var ATTR_HREF     = "HREF";
var ATTR_READONLY = "READONLY";
var ATTR_TABINDEX = "TABINDEX";
var ATTR_TITLE    = "TITLE";
var FDA_TITLE     = "?";
var TAG_ANCHOR    = "A";
var TAG_BUTTON    = "BUTTON";
var TAG_INPUT     = "INPUT";
var TAG_SELECT    = "SELECT";
var TAG_TEXTAREA  = "TEXTAREA";
var TYPE_HIDDEN   = "HIDDEN";
var TYPE_PASSWORD = "PASSWORD";
var TYPE_SUBMIT   = "SUBMIT";
var TYPE_TEXT     = "TEXT";
var TYPE_TEXTAREA = "TEXTAREA";
var VALUE_HELP    = "HELP";

var focusElement = null;

/**
 *
 * Set the inital focus on the panel.
 *
 * Priority is given to form elements.  Anchor tags with HREF attributes are
 * given secondary priority.  So, for example, if a panel has a menu and an
 * input field, the input field will end up with initial focus.  This was a
 * compromise made in order to speed up processing.
 *
 * It seems that form.elements does not return INPUT tags with type="IMAGE".
 * I tried this on Firefox, Internet Explorer and Mozilla.
 *
 * The revised algorithm should be sufficient for the great majority of panels.
 * One trouble spot will be large tables (1000+ rows of data) that have
 * selectable rows.  Client-side select tables pose the greatest problem, since
 * all the "select" components are form elements.  Server-side tables have
 * anchor tags with href attributes.
 *
 */
function setInitialPanelFocus() {
   var data = new dataObject();
   if ( document.forms.length > 0 ) {
      evaluateForm( document.forms[0], data );

//    var output = "";
//    if ( data.firstNonSubmit != null ) {
//       output += "First Non-Submit = " + data.firstNonSubmit.tagName + " : " + data.firstNonSubmit.type + " : " + data.firstNonSubmit.id + "\n";
//    } // end if
//    if ( data.firstSubmit != null ) {
//       output += "First Submit = " + data.firstSubmit.tagName + " : " + data.firstSubmit.value + "\n";
//    } // end if
//    if ( data.initialFocus != null ) {
//       output += "Initial Focus = " + data.initialFocus.tagName + " : " + data.initialFocus.id + "\n";
//    } // end if
//    if ( data.defaultButton != null ) {
//       output += "Default Button = " + data.defaultButton.tagName + " : " + data.defaultButton.value + "\n";
//    } // end if
//    alert( output );

      focusElement = null;
      // Is there a default button?  If so, it has preference over initial focus
      if ( data.defaultButton ) {
         // Only buttons on the panel ... i.e. Confirmation Panel
         if ( data.allSubmitItems ) {
            focusElement = data.defaultButton;
         } // end if
         // This is somewhat counter-intuitive ...
         else if ( data.initialFocus && data.initialFocus.type.toUpperCase() == TYPE_SUBMIT ) {
            focusElement = data.defaultButton;
         } // end else if
         // Give focus to explicitly set item ...
         else if ( data.initialFocus ) {
            focusElement = data.initialFocus;
         } // end else if
         // ... else give fucus to the first non-submit item ...
         else if ( data.firstNonSubmit ) {
            focusElement = data.firstNonSubmit;
         } // end else if
         // ... as a fallback, give focus to the default button
         else {
            focusElement = data.defaultButton;
         } // end else if
      } // end if
      // No default button defined.  Look for initial focus item first.
      else {
         // Set item with explicit focus first ...
         if ( data.initialFocus ) {
            focusElement = data.initialFocus;
         } // end if
         // ... else give focus to the first non-submit item ...
         else if ( data.firstNonSubmit ) {
            focusElement = data.firstNonSubmit;
         } // end else if
         // ... else give focus to the first button ...
         else if ( data.firstSubmit ) {
            focusElement = data.firstSubmit;
         } // end else if
         // ... else give focus to the fda icon ...
         else if ( data.fdaIcon ) {
            focusElement = data.fdaIcon;
         } // end else if
         // ... else give up ...
         else {
            // Punt ... nothing to set focus on ...
         } // end else
      } // end else
   } // end if
   if ( focusElement != null ) {
      /*********************************************************************/
      /* Catch any oddball cases where focus cannot be given to an element */
      /*********************************************************************/
      setTimeout( "try{focusElement.focus();}catch(e){}", 0 );
   } // end if

// var output = "";
// if ( focusElement != null ) {
//    output += "Focus Element = :" + focusElement.tagName + ":" + focusElement.type + ":" + focusElement.value + ":\n";
// } // end if
// if ( data.defaultButton != null ) {
//    var defaultButton = data.defaultButton;
//    output += "Default Button = :" + defaultButton.tagName + ":" + defaultButton.type + ":" + defaultButton.value + ":\n";
// } // end if
// alert( output );

} // setInitialPanelFocus()

/**
 *
 * Look at a form determining which components are eligible for initial
 * focus and what button, if any, is set to the default.
 *
 */
function evaluateForm( form, data ) {
   if ( form != null ) {
      var elements = form.elements;
      for ( var i = 0; i < elements.length; i++ ) {

         var element = elements[i];

         // consider a form element iff it is not contained inside a WTable ...
         if ( !isElementInWTable( form,element ) ) {
             var tagName = ( element.tagName == null ) ? "" : element.tagName.toUpperCase();

             // Look at all form elements, ignoring those that are
             // hidden, disabled or readonly
             if ( tagName == TAG_INPUT  ||
                  tagName == TAG_BUTTON ||
                  tagName == TAG_SELECT ||
                  tagName == TAG_TEXTAREA ) {
                var type       = element.type.toUpperCase();
                var value      = element.value.toUpperCase();
                var disabled   = element.disabled;
                var visibility = element.style.visibility;
                var readonly   = element.readOnly;

    //          alert( "Element :: " + tagName + " : " + type );

                var defaultButton = element.getAttribute( DEFAULT_BUTTON ) &&
                                    element.getAttribute( DEFAULT_BUTTON ).toUpperCase() == "TRUE";
                var initialFocus  = element.getAttribute( INITIAL_FOCUS  ) &&
                                    element.getAttribute( INITIAL_FOCUS  ).toUpperCase() == "TRUE";

                /***************************************************************************/
                /* There are cases where an enabled visible element is contained inside an */
                /* invisible element, such as a div.  In this case, focus cannot be given  */
                /* to the desired element ... it throws an exception in IE ...             */
                /***************************************************************************/
                if ( type != TYPE_HIDDEN && !disabled && !readonly && visibility != "hidden" ) {
                   if ( data.firstNonSubmit == null && type != TYPE_SUBMIT && value != VALUE_HELP ) {
//                      ( type == TYPE_TEXT || type == TYPE_PASSWORD || type == TYPE_TEXTAREA ) ) {
                      data.firstNonSubmit = element;
                   } // end if
                   if ( data.firstSubmit == null && type == TYPE_SUBMIT ) {
                      data.firstSubmit = element;
                   } // end if
                   if ( data.initialFocus == null && initialFocus ) {
                      data.initialFocus = element;
                   } // end if
                   if ( data.defaultButton == null && defaultButton ) {
                      data.defaultButton = element;
                   } // end if
                   if ( data.allSubmitItems && type != TYPE_SUBMIT ) {
                      data.allSubmitItems = false;
                   } // end if
                } // end if

             } // end if
          } // end if

      } // end for
   } // end if

} // evaluateForm()

/**
 * Check if element is contained in the body of a WTable ...
 */
function isElementInWTable( form, element ) {
    var result  = false;
    var current = element;
    while ( current != null && current != form ) {
        if ( current.getAttribute( "h1bid" ) ) {
            result = true;
            break;
        } // end if
        else {
            current = current.parentNode;
        } // end else
    } // end while
    return result;
} // isElementInWTable()

