// The following function dynamically resizes windows in the "historical" way,
// except that it takes advantage of new information regarding the browser
// geometry.  The alternative way is to include the panel width and height in
// the markup or a resource bundle that accompanies the markup.
function adjustWindowSizeCompatibly(defWidth, defHeight, screenVerticalAdjustment,
                                    hDecorWidth, vScrollWidth,
                                    vDecorHeight, hScrollHeight,
                                    contentAreaOffsetLeft, contentAreaOffsetTop) {
   var element = document.getElementById("hmcPanelTable");
   var desiredWidth = -1, desiredHeight = -1;

   // If the width and height were explicitly given, use those.
   var attr = element.attributes.getNamedItem["width"];
   if (attr != null) desiredWidth = attr.value;

   attr = element.attributes.getNamedItem["height"];
   if (attr != null) desiredHeight = attr.value;

   if (desiredWidth == -1 && desiredHeight == -1) {
      // If the window starts narrow, we don't necessarily want it to stay
      // narrow.  Give the window the default size initially and let it go up
      // or down from there.
      window.resizeTo(defWidth, defHeight);
   }

   var setFullWidth  = desiredWidth  == -1;
   var setFullHeight = desiredHeight == -1;

   // If no explicit values, but the browser will tell us the size, use that.
   if (desiredWidth == -1 && "offsetWidth" in element) {
//window.alert("Browser says to use "+element.offsetWidth+" for width")
      desiredWidth = element.offsetWidth;
   }

   if (desiredHeight == -1 && "offsetHeight" in element) {
//window.alert("Browser says to use "+element.offsetHeight+" for height")
      desiredHeight = element.offsetHeight;
   }

   // Resize if we know what the desired size is, otherwise leave it alone.
   if (desiredWidth != -1 && desiredHeight != -1) {
      // See if we can figure out how much extra to add to account for the frame
      var widthPadding = 32, heightPadding = 32;

      if ("innerWidth" in window && "outerWidth" in window) {
            widthPadding = window.outerWidth - window.innerWidth;
      } else {
         if (hDecorWidth > widthPadding)
            widthPadding = hDecorWidth;
      }

      if ("innerHeight" in window && "outerHeight" in window) {
            heightPadding = window.outerHeight - window.innerHeight;
      } else {
         if (vDecorHeight > heightPadding)
            heightPadding = vDecorHeight;
      }
//window.alert("Using widthPadding=="+widthPadding+" and heightPadding=="+heightPadding);

      var screenAvailHeight = screen.availHeight - screenVerticalAdjustment;

      var extraWidth = 27;
      var extraHeight = 19;   // was 24
      if (vScrollWidth  > extraWidth)  extraWidth  = vScrollWidth;
      if (hScrollHeight > extraHeight) extraHeight = hScrollHeight;

//window.alert("Using extra width pad of "+extraWidth+", height pad of "+extraHeight);
      var finalWidth  = desiredWidth + widthPadding + extraWidth;
//window.alert("finalWidth=="+finalWidth+", screen.availWidth=="+screen.availWidth);
//if (finalWidth > screen.availWidth) window.alert("Limiting width to "+screen.availWidth);
      if (finalWidth > screen.availWidth)
         finalWidth = screen.availWidth;

      var finalHeight = desiredHeight + heightPadding + extraHeight;
//window.alert("finalHeight=="+finalHeight+", screen.availHeight=="+screen.availHeight);
//if (finalHeight > screen.availHeight) window.alert("Limiting height to "+screen.availHeight);
      if (finalHeight > screenAvailHeight)
         finalHeight = screenAvailHeight;

      if (("screenX" in window && "screenY" in window) ||
          ("screenLeft" in window && "screenTop" in window)) {
         // Capture window position.  Since screenLeft and screenTop give
         // info regarding the location of the content area, attempt to deduce
         // browser window location by subtracting the padding.
         var localScreenX = ("screenX" in window) ? window.screenX : window.screenLeft - contentAreaOffsetLeft;
         var localScreenY = ("screenY" in window) ? window.screenY : window.screenTop - contentAreaOffsetTop;
//window.alert("Window is at coords "+localScreenX+", "+localScreenY);

         // Remember the beginning position of the window
         window.savedScreenX = localScreenX;
         window.savedScreenY = localScreenY;
//       alert("Window is presently at "+window.savedScreenX+", "+window.savedScreenY);

         // If we resized the window, the right edge or bottom edge might now
         // be off the screen.  Move left or up to correct that if necessary.
         var moveLeft = 0, moveUp  = 0;
         if (localScreenX + finalWidth > screen.availWidth)
            moveLeft = localScreenX + finalWidth - screen.availWidth;

         if (localScreenY + finalHeight > screenAvailHeight)
            moveUp = localScreenY + finalHeight - screenAvailHeight;

         if (moveLeft != 0 || moveUp != 0) {
            window.moveBy(-moveLeft, -moveUp);
         }
      }

      // We don't resize the window until we move it to an appropriate
      // location on the screen since some browsers (IE 7) will shrink the
      // window rather than let it go outside the window bounds.
      window.resizeTo(finalWidth, finalHeight);
   }

   // Change this so that the panel stretches when the window is made wider
//if (setFullWidth) window.alert("Setting width to 100%");
   if (setFullWidth)  element.setAttribute("width", "100%");

   // Change this so that the panel stretches when the window is made taller
   if (setFullHeight) element.setAttribute("height", "100%");
}

function adjustWindowPosition(x, y) {
   try {
      window.moveTo(x, y);
   } catch (e) {
      // Ignore exception
   }
}

function adjustWindowSize(windowWidth, windowHeight) {
   try {
      window.resizeTo(windowWidth, windowHeight);
   } catch (e) {
      // Ignore exception
   }
}

function trackWindowPosition() {
   if ("screenX" in window && "screenY" in window) {
      // Firefox-like browsers
      window.savedScreenX = window.screenX;
      window.savedScreenY = window.screenY;

   } else if ("screenLeft" in window && "screenTop" in window) {
      // IE-like browsers
      window.savedScreenLeft = window.screenLeft;
      window.savedScreenTop  = window.screenTop;
   }
}

function reportPanelSizeInformation() {
   // Used during development to report on the panel size information for a
   // showing panel.
   window.location.replace("/hmc/tasks/showPanelSize.jsp?windowName="+window.name+
                           "&clientWidth="+document.body.clientWidth+
                           "&scrollWidth="+document.body.scrollWidth+
                           "&clientHeight="+document.body.clientHeight+
                           "&scrollHeight="+document.body.scrollHeight);
}

function isWindowClosed(windowHandle) {
   // Recent versions of IE give exceptions checking the closed property of
   // a closed window, so we wrap the check in a try/catch and assume the
   // window is closed if an exception is encountered.
   try {
      var isClosed = windowHandle.closed;
      return isClosed == null ? true : isClosed;

   } catch (e) {
      return true;
   }
}

function getHMCMainWindow(target) {
   // window.opener refers to the TaskController frame in the main ui window.
   // window.opener.top, therefore, refers to that frameset, which is defined
   // in mainuiFrameset.jsp.
   if ("hmcuimainwin" in target) {
//alert("using hmcuimainwin from window properties");
      return target.hmcuimainwin;
   } else if ("hmcMainWindowName" in target) {
      try {
         var mw = window.open("", target.hmcMainWindowName);
         if (mw != null) {
            // See if it's the main window we're expecting.  If it is,
            // it has a function called markWindowCloseHandled().  If our
            // window.open() call just created the window, then it won't.
            if ("markWindowCloseHandled" in mw)
               return mw;
            mw.close();  // We must have just opened it.  Close it quickly.
         }
      } catch (e) {
      }
   } else {
      try {
         if (target.opener != null) {
            var parts = target.opener.top.name.split('_');
            var topname = 'hmcuimainwin';
            if (parts != null && parts.length > 0) {
               topname = parts[parts.length-1];
            }
            if (topname == "hmcuimainwin") {
//alert("using opener.top");
               return target.opener.top;
            }
         }

//alert("using window.open from inside window with name="+window.name);
         var mw = window.open("", "hmcuimainwin");
         if (mw != null) {
            // See if it's the main window we're expecting.  If it is,
            // it has a function called markWindowCloseHandled().  If our
            // window.open() call just created the window, then it won't.
            if ("markWindowCloseHandled" in mw)
               return mw;
            mw.close();  // We must have just opened it.  Close it quickly.
         }

      } catch (e) {
      }
   }

   return null;
}

function callProcessTaskWindowUnload() {
   var mw = getHMCMainWindow(window);
   if (mw != null && isWindowClosed(mw)) return;

   //-opera start
   // deregister with the main UI window, so window closes are no longer monitored
   var userAgent  = navigator.userAgent.toLowerCase();
   var isOpera    = ( userAgent.indexOf( "opera" ) != -1 );
   if (isOpera) {
       if (mw != null && "deRegisterTaskWindow" in mw)
          mw.deRegisterTaskWindow(window.hmcTaskId);
   }
   //-opera end

   if (mw != null && "processTaskWindowUnload" in mw)
      mw.processTaskWindowUnload(window);
}

function initializeWinProps(taskId, mainWindowName) {
   //alert("in initializeWinProps().  Task id is "+taskId+"; main window name is "+mainWindowName);
   window.hmcTaskId = taskId;
   window.hmcMainWindowName = mainWindowName;

   try {
      if (opener != null && opener.top.name == mainWindowName)
         window.hmcuimainwin = opener.top;
      else
         var mw = window.open("", mainWindowName);
         if (mw != null) {
            // See if it's the main window we're expecting.  If it is,
            // it has a function called markWindowCloseHandled().  If our
            // window.open() call just created the window, then it won't.
            if ("markWindowCloseHandled" in mw) {
               window.hmcuimainwin = mw;
            } else {
               mw.close();  // We must have just opened it.  Close it quickly.
            }
         }

   } catch (e) {
      // Can't figure out main window
   }
}

function hmcFormSubmitted() {
   var hmcWindowPosition = null;
   if ("screenX" in window && "screenY" in window &&
       "savedScreenX" in window && "savedScreenY" in window) {
      // Firefox-like browsers
      if (window.screenX != window.savedScreenX ||
          window.screenY != window.savedScreenY) {    // Window was moved
         hmcWindowPosition = ""+window.screenX+","+window.screenY+",window";
      }

   } else if ("screenLeft" in window && "screenTop" in window &&
          "savedScreenLeft" in window && "savedScreenTop" in window) {
      // IE-like browsers
      if (window.screenLeft != window.savedScreenLeft ||
          window.screenTop != window.savedScreenTop) {    // Window was moved
         hmcWindowPosition = ""+window.screenLeft+","+window.screenTop+",content";
      }
   }

   if (hmcWindowPosition != null) {
      if ("action" in this && this.action.indexOf("/hmc/wcl/") != -1) {
         // Create a hidden form field to transmit the current window position
         // This name/value pair will be included in the form that is submitted.
         var hmcScreenElement = document.createElement("input");
         hmcScreenElement.setAttribute("type", "hidden");
         hmcScreenElement.setAttribute("name", "hmcWindowPosition");
         hmcScreenElement.setAttribute("value", hmcWindowPosition);
         this.appendChild(hmcScreenElement);
      }
   }
}

//-opera start
var mainWinChecker;
var mainWindow;
var closeCount = 0;
function checkMainWindow() {
   //window.alert("closeCount="+closeCount+";.closed="+isWindowClosed(mainWindow));
   if (mainWindow != null && isWindowClosed(mainWindow)) {
      if (closeCount > 2) {
         tempwin = window.open("", "mainlogoff_local", "width=500,height=500,top="+((screen.availHeight-500)/2)+",left="+((screen.availWidth-500)/2));
         if ("xCloseHandled" in tempwin) {
         } else {
            tempwin.xCloseHandled = true;
            tempwin.location.replace("/hmc/task?op=mainwindowclose&windowname=mainlogoff_local");
         }
         if (window.name != "mainlogoff_local") {
            window.close();
         }
      } else {
         closeCount++;
         mainWindowChecker = window.setTimeout("checkMainWindow()", 1000);
      }
   } else {
      closeCount = 0;
      mainWindowChecker = window.setTimeout("checkMainWindow()", 1000);
   }
}

var mainWinRegister;

function registerWithMainWindow() {
   if (window.name.indexOf("mainlogoff_") != 0) {
      mw = getHMCMainWindow(window);

      if (mw != null && "registerTaskWindow" in mw) {
         mw.registerTaskWindow(window, window.hmcTaskId);
         mainWindow = mw;
         checkMainWindow();
      } else {
         // setup timer to try and register later
         //window.alert("trying to register later with main window for window: "+window.name+"\nwindow.opener="+window.opener+"\n"+"window.top.name="+window.top.name);
         mainWinRegister = window.setTimeout("registerWithMainWindow()", 1000);
      }
   }
}
//-opera end

function trapWindowClose() {
//alert("in trapWindowClose");
   window.onunload = callProcessTaskWindowUnload;

// Commenting out the following for now, since it reloads the wrong URL.
// setUpJSError(); //HMCPanel.java includes onerror.js

   // Trap any form submissions so that we can communicate any window moves
   for (var i=0; i<document.forms.length; ++i) {
//    alert("Form "+i+": "+(typeof document.forms[i].onsubmit));
      document.forms[i].onsubmit = hmcFormSubmitted;
   }

   //-opera start
   // register with the main UI window, so window closes can be performed with Opera
   var userAgent  = navigator.userAgent.toLowerCase();
   var isOpera    = ( userAgent.indexOf( "opera" ) != -1 );
   if (isOpera) {
      registerWithMainWindow();
   }
   //-opera end
}

