/*
 * (c)  Copyright  IBM Corp. 2006  All Rights Reserved
 *
 * US Government Users Restricted Rights - Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp
 *
 *  Notes:
 *		Currently tested with FireFox 1.5, and IE6
 *
 *  Module History:
 *		(Handled by version control)
 *
 *  Author:
 *    	Jason Stapels
 */

/**
 * This class is used to send asynchronous requests to the server using
 * XMLHttpRequest (aka AJAX). The response expects to receive a JSON formatted
 * object back which is then parsed and handed back to the caller.
 *
 * @param url - The url to send the request too (GET will be used).
 * @param callback - A function that will be called with the JSON response as it's parameter (or null if there's an error).
 *
 * @throws Error - An Error exception if XMLHttpRequest is not supported by the browser or could not be instantiated.
 */
var AsyncJson = function( url, callback ) {

    this.callback = callback;

    this.request = false;
    this.errorText = "";

    this.submitRequest( url );
};

/*
 * Define the methods.
 */
AsyncJson.prototype = {

    /**
     * PUBLIC - This function will return any error text associated with the request.
     *
     * @return - A string containing the most recent error msg, otherwise an empty string.
     */
    getErrorText : function() {
        return this.errorText;
    },

    /**
     * PRIVATE - This function will handle submitting the request via the XMLHttpRequest object.
     */
    submitRequest : function( url ) {

        // Check for native XMLHttpRequest support.
        if( window.XMLHttpRequest ) {
            try {
                this.request = new XMLHttpRequest();
            }
            catch( e ) {
                this.request = false;
            }
        }

        // No native support so try to use an ActiveXObject.
        else if( window.ActiveXObject ) {
            try {
                this.request = new ActiveXObject( "Microsoft.XMLHTTP" );

                // TODO: I'm not sure why there's two versions of it or if
                // these are the same. At some point I should research which
                // one is "more" correct.
                //
                //this.request = new ActiveXObject( "Msxml2.XMLHTTP" );
            }
            catch( e ) {
                this.request = false;
            }
        }

        // Use the request if it's valid.
        if( this.request ) {

            // Create a wrapper function so that our handler is called as an
            // instance method rather than a static method.
            var wrapper = function() { AsyncJson.prototype.requestHandler.apply( wrapper.instance ); };
            wrapper.instance = this;

            // Set the handler method.
            this.request.onreadystatechange = wrapper;
            // Set the URL.
            this.request.open( "GET", url, true );
            // Workaround IE's cacheing.
            this.request.setRequestHeader( "If-Modified-Since", "Sat, 1 Jan 2000 00:00:00 GMT" );
            // Submit the request.
            this.request.send( "" );
        }

        else {
            throw new Error( "This browser does not appear to support XMLHttpRequest" );
        }
    },

    /**
     * PRIVATE - This function is used as the callback handler for the XMLHttpRequest.
     */
    requestHandler : function() {

		// Must catch communication exceptions (https://bugzilla.mozilla.org/show_bug.cgi?id=238559#c0)
		try {
	        // Make sure the request has finished.
	        if( this.request.readyState == 4 ) {
	
	            // Make sure the request was a success.
	            if( this.request.status == 200 ) {
	                var json = eval( '(' + this.request.responseText + ')' );
	                this.callback( json );
	            }
	
	            // There was a failure.
	            else {
	                this.errorText = this.request.statusText;
	                this.callback( null );
	            }
	        }
		}
		catch( e ) {
			this.errorText = e.description;
			this.callback( null );
		}
		
    }
};
