/*
 * (c)  Copyright  IBM Corp.  1999, 2006  All Rights Reserved
 *
 *
 * US Government Users Restricted Rights - Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp
 *
 * Notes:
 * bonsai js utilities
 *
 * Module History:
 * 11/13/2006  J. Miller    Initial Release
 * 03/15/2007  J. Miller    handle client-side ajax refresh request clashing - add bonsaiStartHrefRequest
 *                          add debug utilities
 * 03/20/2007  J. Miller    add window/frame name to debug info
 * 04/03/2007  J. Miller    ODT K3942 - pass refresh form action to startHrefRequest (used if request fails)
 * 06/26/2007  J. Miller    pass refreshUrl to startHrefRequest (if no form action)
 * 07/11/2007  J. Miller    reload frame if AJAX request cannot be submitted (page is reloading or does not contain ajax support)
 * 08/06/2007  J. Miller    resubmit only one failed ajax request at a time
 *
 */

//track whether an AJAX retry is outstanding
var isRetryOutstanding = false;
//reg exp to determine if the request is an AJAX retry
var retryRequestRe = new RegExp("retryRequest=true");

//bonsaiStartHrefRequest
//if startHrefRequest fails because another ajax request is being processed
//an ajax request is submitting to the given refreshUrl?refreshParams
// -in: url - url for startHrefRequest
//      refreshUrl - url to submit the request if startHrefRequest fails
//      refreshParams - parameters for request if startHrefRequest fails
//      reloadUrl - url to set the frame location to if AJAX update cannot be performed
//-out: none
function bonsaiStartHrefRequest(url, refreshUrl, refreshParams, reloadUrl) {
    var debugColor = getRandomColor();	//use new debug color for each call
    debugMsg("-> bonsaiStartHrefRequest('"+url+"', '"+refreshUrl+"', '"+refreshParams+"', '"+reloadUrl+"')", debugColor);
    if ( typeof startHrefRequest == 'function' ) {
        //pass startHrefRequest a refresh form action or refresh URL; used if refreshForm unset
        var rc = startHrefRequest(url, ( document.forms[0] ? document.forms[0].action : refreshUrl ));
        debugMsg("   bonsaiStartHrefRequest: rc/retryRequestRe.test(url)/isRetryOutstanding = " + rc + "/" + retryRequestRe.test(url) + "/" + isRetryOutstanding, (!rc ? "red" : debugColor));
        try {
            if ( !rc ) {
                //submit retry request if this is a retry request that failed
                //to be processed or no other retries are outstanding
                if ( retryRequestRe.test(url) || !isRetryOutstanding ) {
                    isRetryOutstanding = true;

                    //startHrefRequest failed, so kick a request up to the refresh url
                    if ( refreshUrl && refreshUrl != "" ) {
                        if ( refreshParams && refreshParams != "" ) {
                           refreshUrl = refreshUrl + "?" + refreshParams;
                        }
                        debugMsg("   bonsaiStartHrefRequest: setTimeout AsyncJson - " + refreshUrl, debugColor);
                        setTimeout("new AsyncJson('" + refreshUrl + "', function(json) { return false; } );", 100);
                    }
                }
            } else {
                //clear isRetryOutstanding flag if retry went through
                debugMsg("   bonsaiStartHrefRequest: clear? " + retryRequestRe.test(url), debugColor);
                if ( retryRequestRe.test(url) ) {
                    debugMsg("   bonsaiStartHrefRequest: cleared" );
	                isRetryOutstanding = false;
	            }
            }
        } catch (e) {
            debugMsg("   bonsaiStartHrefRequest: refresh ERROR = " + e.message, debugColor);
        }
    } else if ( reloadUrl && reloadUrl != "" ) {
        //rather than submit an ajax update request on a frame that either doesnt
        //support ajax updates or is reloading, we set the frame location to reloadUrl
        debugMsg("   bonsaiStartHrefRequest: NO startHrefRequest == no AJAX, so reload - " + reloadUrl, debugColor);
        document.location=reloadUrl;
    }
    debugMsg("<- bonsaiStartHrefRequest('"+url+"', '"+refreshUrl+"', '"+refreshParams+"', '"+reloadUrl+"')", debugColor);
}


//addParam - add the given param name/value pair to the given url param string
// -in: params - url parameter string (ex: "", "?name1=val1", or "?name1=val1&name2=val2...")
//      name   - name of the parameter to add
//      value  - value of the parameter to add
//-out: updated parameter string
function addParam(params, name, value) {
    if ( params == "" ) {
        params = "?"
    } else {
        params = params + "&"
    }
    params  = params + name + "=" + value;

    return params;
}


var bonsaiInformed = false;
var bonsaiDebugOn = false;
var frameColor = getRandomColor();
//debugMsg - adds text to the debug window, opening debug window if needed
// -in: text - message to add to the debug window
//      useXmp - output text in xmp tag if true (optional)
//      color - color of the output text (optional)
//      hideTimeStamp - do not display time stamp if true (optional)
//-out: none
function debugMsg(text, color, useXmp, hideTimeStamp) {
    if ( !bonsaiDebugOn ) {
        return;
    }

    try {
        //open debug window if needed
        if ( !window.top.debugWindow || window.top.debugWindow.closed) {
            window.top.debugWindow = window.open("", "Debug", "left=0,top=0,width=450,height=550,scrollbars=yes,status=yes,resizable=yes");
            window.top.debugWindow.opener = self;
            window.top.debugWindow.document.open();
            window.top.debugWindow.document.write("<HTML><HEAD><TITLE>Debug Window</TITLE></HEAD><BODY><PRE>\n");
        }
    }
    catch (msg){
        if (bonsaiInformed == false) {    // If user has already been informed, don't do it again
            alert("A popup blocker is preventing the debug info from displaying.");
            bonsaiInformed = true;
        }
        return;
    }

    //default color to black
    if ( !color || color == "" ) {
        color = 'black';
    }

    //show timestamp?
    var ts = "";
    if ( !hideTimeStamp ) {
        ts = getTimeStamp() + ": ";
    }

    //window/frame name
    var windowName = window.name;
    var len = Math.min(windowName.length, 12);
    windowName = windowName.substring(0,len);
    while ( windowName.length < 13 ) {
        windowName = windowName + " ";
    }

    //add text
    if (!useXmp) {
        window.top.debugWindow.document.write("<span style=\"color:"+frameColor+"\">" + ts + windowName + "</span><span style=\"color:"+color+"\">" + text + "</span>\n");
    } else {
        window.top.debugWindow.document.write("<span style=\"color:"+frameColor+"\">" + ts + windowName + "</span><span style=\"color:"+color+"\"><xmp>" + text + "</xmp></span>\n");
    }
//    window.top.debugWindow.scroll(0,1000000);
}


//getTimeStamp - returns a timestamp string - (new Date()).getTime()
// -in: none
//-out: time stamp text string
function getTimeStamp() {
    var date = new Date();
    var time = date.getTime();
    var sec = Math.floor(time  / 1000);
    var ms  = "" + (time - (sec * 1000)) + "";
    if ( ms == "0" ) {
       ms = "000";
    } else {
       while ( ms.length < 3 ) {
         ms = "0" + ms;
       }
    }
    return sec + "." + ms;
}


//getRandomColor - return a random html color code of the form #HHHHHH
// -in: none
//-out: randomly generated color code
function getRandomColor() {
    var hex = "0123456789ABCDEF";
    var color = "#";
    var rand;
    for (var i=0; i<6; i++ ) {
        rand = Math.floor(Math.random()*16);
        color = color + hex.substr(rand,1);
    }
    return color;
}