/*********************************************************** {COPYRIGHT-TOP} ***
* Licensed Materials - Property of IBM
* Tivoli Presentation Services
*
* (C) Copyright IBM Corp. 2004  All Rights Reserved.
*
* US Government Users Restricted Rights - Use, duplication, or
* disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
************************************************************ {COPYRIGHT-END} ***
* Change Activity on 7/30/04 version 1.8:
* 11/09/2007  P. Liu (Pop) Support left-click context menu icon for topology viewport //-01
*                          Support sever-side initiated refresh/reload
* 12/19/2007  P. Liu (Pop) Support auto-resize image height //-02
*                          Add debug facility //-03, copy from Justin's code
*                          Fix width adjust when overview is visible //-04
*
*******************************************************************************/

/**
 * Static, Singleton Constructor
 */
if ( !self.WImageViewport )
{
    self.WImageViewport = new WImageViewportImpl();
}

//-03 begin
var MydebugMsgFlag=false;

function MydebugMsg(text) {

    if (MydebugMsgFlag == false)
       return;

    try {
        //open debug window if needed
        if ( !window.top.debugWindow || window.top.debugWindow.closed) {
            window.top.debugWindow = window.open("", "Debug", "left=0,top=0,width=450,height=550,scrollbars=yes,status=yes,resizable=yes");
            window.top.debugWindow.opener = self;
            window.top.debugWindow.document.open();
            window.top.debugWindow.document.write("<HTML><HEAD><TITLE>Debug Window</TITLE></HEAD><BODY><PRE>\n");
        }
    }
    catch (msg){
        return;
    }

    window.top.debugWindow.document.write("<span style=\"color:black\">" + text + "</span>\n");
}
//-03 end


function WImageViewportImpl()
{
    // constant variables
    this.MOUSE_MODE_RESIZE  = "resize";
    this.MOUSE_MODE_SELECT  = "select";
    this.MOUSE_MODE_ZOOM    = "zoom";
    this.MOUSE_MODE_PAN     = "pan";

    this.setMouseMode       = WImageViewport_setMouseMode;
    this.getMouseMode       = WImageViewport_getMouseMode;

    this.setFocalPoint      = WImageViewport_setFocalPoint;
    this.getFocalPoint      = WImageViewport_getFocalPoint;
    this.setZoomLevel       = WImageViewport_setZoomLevel;
    this.getZoomLevel       = WImageViewport_getZoomLevel;
    this.getViewRectangle   = WImageViewport_getViewRectangle;
    this.getWorldRectangle  = WImageViewport_getWorldRectangle;
    this.setWorldRectangle  = WImageViewport_setWorldRectangle;
    this.checkViewBounds    = WImageViewport_checkViewBounds;

    // event handler methods
    this.handleLoad         = WImageViewport_handleLoad;
    this.handleMousedown    = WImageViewport_handleMousedown;
    this.handleMousemove    = WImageViewport_handleMousemove;
    this.handleMouseup      = WImageViewport_handleMouseup;

    // action handler methods
    this.handlePan          = WImageViewport_handlePan;
    this.handleResize       = WImageViewport_handleResize;
    this.handleSelect       = WImageViewport_handleSelect;
    this.handleZoom         = WImageViewport_handleZoom;

    // action methods
    this.fitToView          = WImageViewport_fitToView;
    this.fitViewToRectangle = WImageViewport_fitViewToRectangle;
    this.pan                = WImageViewport_pan;
    this.resize             = WImageViewport_resize;
    this.select             = WImageViewport_select;
    this.zoom               = WImageViewport_zoom;
    this.zoomBy             = WImageViewport_zoomBy;

    // helper methods
    this.init                = WImageViewport_init;
    this.update              = WImageViewport_update;
    this.loadImage           = WImageViewport_loadImage;

    // context menu methods
    this.handleContextMenu  = WImageViewport_handleContextMenu;
    this.handleContextMenuItem = WImageViewport_handleContextMenuItem;
    this.createContextMenu   = WImageViewport_createContextMenu;
    this.destroyContextMenu  = WImageViewport_destroyContextMenu;

    //-01 begin
    this.refreshAll = WImageViewport_refreshAll;
    this.resendSelect = WImageViewport_resendSelect;
    this.repaintImage = WImageViewport_repaintImage;
    this.savedParameters = null;
    //-01 end


}

//-01 begin
function WImageViewport_repaintImage(viewportId)
{
    var viewport = document.getElementById( viewportId );
    if (viewport!=null && viewport.imageUrl != null )
    {
        this.loadImage( viewportId, viewport.imageUrl );
    }
}

function WImageViewport_resendSelect(viewportId)
{
    var viewport = document.getElementById( viewportId );
    if (viewport ==null)
    {
        return;
    }
    var parameters = this.savedParameters;
    if (parameters == null)
    {
        return;
    }
    var form = WUtilities.buildForm(
         viewport.refreshURL,
         parameters,
         ( viewport.isInPortal ? viewport.portletNamespacePrefix : "" ),
         ( viewport.isInPortal ? viewport.portletNamespaceSuffix : "" ) );
          // add form to DOM and submit
    document.body.appendChild( form );
    form.submit();
    this.savedParameters = null;
}

function WImageViewport_refreshAll(viewportId)
{
    var viewport = document.getElementById( viewportId );
    if (viewport ==null)
    {
        return;
    }
    var image = document.getElementById( viewport.imageId );

    var worldRectangle = this.getWorldRectangle( viewportId );

    var renderWidth = parseFloat( image.width );
    var renderHeight = parseFloat( image.height );
    var wZoomFactor = ( worldRectangle.width  / renderWidth  );
    var hZoomFactor = ( worldRectangle.height / renderHeight );

    this.setZoomLevel( viewportId, Math.max( wZoomFactor, hZoomFactor ) );

    var x = worldRectangle.x + Math.floor( worldRectangle.width  / 2 );
    var y = worldRectangle.y + Math.floor( worldRectangle.height / 2 );

    this.setFocalPoint( viewportId, new Point( x, y ) );

    var params = new Object();
    params['fitToView'] = true;

    var form = WUtilities.buildForm( viewport.refreshURL,
                                     params,
                                 ( viewport.isInPortal ? viewport.portletNamespacePrefix : "" ),
                                ( viewport.isInPortal ? viewport.portletNamespaceSuffix : "" ) );

    // add form to DOM and submit
    document.body.appendChild( form );
    form.submit();

}
//-01 end

function WImageViewport_handleWindowResize( e, viewportId )
{
    // handle resize
    var viewport = document.getElementById( viewportId );

    var imageLayer = document.getElementById( viewport.imageLayerId );
    var imageLayerTop = WUtilities.getTop( imageLayer, true );
    var imageLayerLeft = WUtilities.getLeft( imageLayer, true );
    var imageLayerWidth = parseInt( imageLayer.style.width );
    var imageLayerHeight = parseInt( imageLayer.style.height );

    var mouseLayer = document.getElementById( viewport.mouseLayerId );
    mouseLayer.style.top = imageLayerTop + "px";
    mouseLayer.style.left = imageLayerLeft + "px";
    mouseLayer.style.width = imageLayerWidth + "px";
    mouseLayer.style.height = imageLayerHeight + "px";
}

function WImageViewport_init( viewportId, worldRectangle, focalPoint, zoomLevel, minZoomLevel, maxZoomLevel, mouseMode, imageLayerId, imageId, mouseLayerId, resizeImageId, imageUrl, isRTL, isInPortal, portletNamespacePrefix, portletNamespaceSuffix, isRefreshEnabled, refreshURL, isMenuEnabled, isAutoResizeEnabled )
{
    var viewport = document.getElementById( viewportId );

        // only initialize IDs if first time through this method
        if ( !viewport.imageLayerId )
        {
            // save IDs
            viewport.imageLayerId = imageLayerId;
            viewport.imageId = imageId;
            viewport.mouseLayerId = mouseLayerId;
            viewport.resizeImageId = resizeImageId;
            viewport.lassoId = viewportId + "lasso";
        viewport.menuId = null; // set later internally
        // save url
        viewport.imageUrl = imageUrl;
        // save direction
        viewport.isRTL = isRTL;
        // save portlet settings
        viewport.isInPortal = isInPortal;
        viewport.portletNamespacePrefix = portletNamespacePrefix;
        viewport.portletNamespaceSuffix = portletNamespaceSuffix;
        // save refresh feature enablement
        viewport.isRefreshEnabled = isRefreshEnabled;
        viewport.refreshURL = refreshURL;
        // save context menu feature enablement
        viewport.isMenuEnabled = isMenuEnabled;
        // save auto resize feature enablement
        viewport.isAutoResizeEnabled = isAutoResizeEnabled;
        viewport.callbacks = new Array();

        // setup resize listener
        WUtilities.addResizeCallback( viewportId, new Function( "e", "WImageViewport_handleWindowResize(e,'" + viewportId + "');return true;" ) );
    }

    // convert world coordinates to browser coordinates
    viewport.worldX = worldRectangle.x;
    viewport.worldY = worldRectangle.y;
    focalPoint.x -= worldRectangle.x;
    focalPoint.y -= worldRectangle.y;
    worldRectangle.x = 0;
    worldRectangle.y = 0;

    this.setWorldRectangle( viewportId, worldRectangle );
    this.setFocalPoint( viewportId, focalPoint );
    this.setZoomLevel( viewportId, zoomLevel );
    viewport.minZoomLevel = minZoomLevel;
    viewport.maxZoomLevel = maxZoomLevel;

    // set mouseMode
    this.setMouseMode( viewportId, mouseMode, true );

    if ( viewport.isAutoResizeEnabled && !viewport.autoResized )
    {
        WUtilities.addResizeCallback( viewportId, new Function(  "WImageViewport_autoResizeOnWindowResize('" + viewportId + "');" ) );

        viewport.autoResized = true;
        WImageViewport_autoResize( viewportId );
    }
    else
    {
        // load image
        this.loadImage( viewportId, viewport.imageUrl );
    }
    viewport = document.getElementById( viewportId );


}

function WImageViewport_autoResizeOnWindowResize( viewportId )
{
    var viewport = document.getElementById( viewportId );

    // clear previous timer
    clearTimeout( viewport.timer );
    viewport.timer = null;
    viewport.isWindowResizeEvent = true;

    // Set timer to avoid responding to the myriad of resize events that are fired as
    // user drags window
    viewport.timer = setTimeout( "WImageViewport_autoResize('" + viewportId + "')", 200 );

}

function WImageViewport_autoResize( viewportId )
{
    if ( window.loaded )
    {
        var viewport = document.getElementById( viewportId );

        // get image
        var image = document.getElementById( viewport.imageId );
        // get image layer
        var imageLayer = document.getElementById( viewport.imageLayerId );
        // get viewer
        var viewer = findViewer( viewport.parentNode );


        // get image dimensions
        var imageWidth = WUtilities.getWidth( image );
        var imageHeight = WUtilities.getHeight( image );

        // save original image width
        var originalImageWidth = imageWidth;

        // get current viewer width
        var viewerWidth = WUtilities.getWidth( viewer );
        var viewerHeight = WUtilities.getHeight( viewer );
        MydebugMsg("before shrink, viewer="+viewerWidth+","+viewerHeight);
        MydebugMsg("             , image ="+imageWidth+","+imageHeight);

        // find portlet, if in portal
        var portlet = null;
        if ( viewport.isInPortal )
        {
            portlet = findPortlet( viewer.parentNode );
            if ( portlet == null )
            {
                // assume we're in ISC
                portlet = findISCPortlet( viewer.parentNode );
            }
        }

        // shrink viewport image
        image.width = 100;
        imageLayer.style.width = 100 + "px";

        //-02 begin, need to shrink height to auto-adjust toolbar size (it is 100% width)
        //     strange?!
        image.height = 100;
        imageLayer.style.height = 100 + "px";
        //-02 end

        // Mozilla will not collapse portlet table b/c it's width is 100%, so force collapse
        if ( WClient.isBrowserMozilla() )
        {
            if ( portlet != null )
            {
                portlet.width = 100;
            }
            if ( viewer != null )
            {
                viewer.width = 100;
                viewer.height = 100;
            }
        }

        // get min viewer width
        var minViewerWidth = WUtilities.getWidth( viewer );
        viewerHeight = WUtilities.getHeight( viewer );
        MydebugMsg("after shrink, viewer="+minViewerWidth+","+viewerHeight);

        var newWindowDimension = null;
        if ( WClient.isBrowserInternetExplorer() )
        {
            //-02 begin
            // this is a bug? since it won't work for auto-resize height
            // newWindowDimension = new Dimension( WUtilities.getWidth( document.body ),
            //                                    WUtilities.getHeight( document.body ) );
            newWindowDimension = new Dimension( document.body.clientWidth,
                                                document.body.clientHeight );
            //-02 end

        }
        else
        {
            newWindowDimension = new Dimension( window.innerWidth,
                                                window.innerHeight );
        }
        MydebugMsg("current window size="+newWindowDimension.getWidth()+","+newWindowDimension.getHeight());
        // auto-resize was kicked off by window resize event

        if ( viewport.isWindowResizeEvent )
        {
            //-02 begin
            var adjust_x=60;
            var adjust_y=120;
            if ( WClient.isBrowserInternetExplorer() ){
               adjust_x=80;
               adjust_y=150;
            }
            var overview = document.getElementById( viewport.overviewId );
            var overviewWidth = ( overview != null ? ( WUtilities.getWidth( overview ) + 10 ) : 0 ); //-04

            MydebugMsg("stored window size="+viewport.windowDimension.getWidth()+","+viewport.windowDimension.getHeight());
            imageWidth = newWindowDimension.getWidth() - adjust_x - overviewWidth;
            if ( imageWidth < 200 )
                imageWidth = 200;

            imageHeight = newWindowDimension.getHeight()  - adjust_y;
            if ( imageHeight < 200 )
                imageHeight =  200;

            // need to hook up with saveFrameDimenions() which should be called when frame is resized
            if (  ( typeof saveFrameDimensions ) == "function" )
            {
                  saveFrameDimensions(null);
            }
            //-02 end
        }
        else // evaluate surrounding container for possible resize
        {
            if ( viewport.isInPortal && portlet != null )
            {
                if ( WClient.isBrowserInternetExplorer() )
                {
                    // grow viewport image
                    image.width = 5000;
                    imageLayer.style.width = 5000 + "px";

                    // see how viewport grew by checking horizontal scrolling
                    var amountScrolled = document.body.scrollWidth - document.body.clientWidth;

                    // shrink image width
                    if ( amountScrolled > 0 )
                    {
                        imageWidth = 5000 - amountScrolled;
                    }
                    // grow image width
                    else
                    {
                        var portletWidth = WUtilities.getWidth( portlet.parentNode ) - 10;
                        var difference = portletWidth - viewerWidth;

                        imageWidth += difference;
                    }
                }
                else
                {
                    portlet.width = "100%";
                    var portletWidth = WUtilities.getWidth( portlet.parentNode ) - 32;

                    // grow by available space
                    var availSpace = portletWidth - viewerWidth;
                    imageWidth += availSpace;
                }
            }
            else // isInServlet
            {
                var bodyWidth = WUtilities.getWidth( document.body );
                var viewerLeft = WUtilities.getLeft( viewer, true );
                var viewerRight = viewerLeft + viewerWidth;
                if ( viewport.isRTL )
                {
                    // adjust for IE scrollbar
                    if ( WClient.isBrowserInternetExplorer() )
                    {
                        bodyWidth -= 32;
                    }

                    imageWidth += ( bodyWidth - viewerWidth );
                    var amountScrolled = document.body.scrollWidth - bodyWidth;
                    if ( amountScrolled > 0 )
                    {
                        imageWidth -= amountScrolled;
                        //imageWidth -= 20;
                    }
                    window.status = bodyWidth + "," + viewerWidth + "," + amountScrolled;
                }
                else
                {
                    // adjust for IE scrollbar
                    if ( WClient.isBrowserInternetExplorer() )
                    {
                        bodyWidth -= 20;
                    }
                    imageWidth += ( bodyWidth - viewerRight );
                }
            }
        }

        MydebugMsg("before RTL processing, image ="+imageWidth+","+imageHeight);

        // store new window dimension
        viewport.windowDimension = newWindowDimension;

        /* useless any more since we will auto-resize image
        if ( !viewport.isRTL)
        {
            // check that new image size won't constrict viewport below minimum width
            var overview = document.getElementById( viewport.overviewId );
            var overviewWidth = ( overview != null ? WUtilities.getWidth( overview ) : 0 );

            var minViewportWidth = minViewerWidth - overviewWidth - 20;
            if ( imageWidth < minViewportWidth )
            {
                viewport.magicNumber = minViewportWidth - imageWidth;
                imageWidth = minViewportWidth;
            }
            else if ( viewport.magicNumber )
            {
                imageWidth -= viewport.magicNumber;
            }
        }
        */

        // Mozilla will not collapse table if it's width is 100%, so force collapse
        if ( WClient.isBrowserMozilla() )
        {
            if ( portlet != null )
            {
                portlet.width = 100;
            }
            if ( viewer != null )
            {
                viewer.width = 100;
            }
        }

        // never let viewport get smaller than 100 pixels
        if ( imageWidth <  100 )
        {
            imageWidth = 100;
        }

        // reset resize state
        viewport.isWindowResizeEvent = false;

        // restore viewport image width for now
        image.width = originalImageWidth;
        imageLayer.style.width = originalImageWidth + "px";

        MydebugMsg("after RTL processing to resize, image ="+imageWidth+","+imageHeight);
        // always resize to ensure image is requested
        WImageViewport.resize( viewportId, imageWidth, imageHeight );
    }
    else
    {
        setTimeout( 'WImageViewport_autoResize("' + viewportId + '")', 100 );
    }
}

/**
 * Get the portlet prefix used to identify portlet HTML blocks
 * @param portlet The DIV that composes the inner-most HTMLElement container of a portlet's
 *        content.
 */
function getPortletPrefix( portlet )
{
    var portletId = portlet.id.substring( "DIV_".length );
    var portletSplit = portletId.split("_");
    return ( portletSplit[0] + "_" + portletSplit[1] + "_" );

}

/**
 * Get number of portlets on a page
 * @param portlet The DIV that composes the inner-most HTMLElement container of a portlet's
 *        content.
 */
function getNumPortlets( portlet )
{
    var portletPrefix = getPortletPrefix( portlet );
    var numPortlets = 0;
    for ( var i = 0; i < document.anchors.length; i++ )
    {
        var anchor = document.anchors[i];
        if ( anchor.name != null && anchor.name.indexOf( portletPrefix ) == 0 )
        {
            numPortlets++;
        }
    }
    return numPortlets;
}

/**
 * Returns the DIV that composes the inner-most HTMLElement container of a portlet's content.
 * @param element A known child of the portlet from which to begin traversing up the DOM.
 */
function findPortlet( element )
{
    if ( element != null )
    {
        if ( element.tagName != null &&
             element.tagName.toUpperCase() == "DIV" &&
             element.id != null &&
             element.id.indexOf( "DIV_" ) == 0 )
        {
            return element;
        }
        else
        {
            // recurse
            return findPortlet( element.parentNode );
        }
    }
    return null;
}

/**
 * Returns the TABLE that contains the portlet body.
 * @param element A known child of the portlet from which to begin traversing up the DOM.
 */
function findISCPortlet( element )
{
    if ( element != null )
    {
        if ( element.tagName != null &&
             element.tagName.toUpperCase() == "TABLE" &&
             element.className != null &&
             element.className == "wpsPortletBody" )
        {
            return element;
        }
        else
        {
            // recurse
            return findISCPortlet( element.parentNode );
        }
    }
    return null;
}


/**
 * Return the TABLE that is the outermost layout container of the viewer
 * @param element A known child of the viewer from which to begin traversing up the DOM.
 */
function findViewer( element )
{
    if ( element != null )
    {
        if ( element.tagName != null &&
             element.tagName.toUpperCase() == "FORM" )
        {
            var viewer = element;
            for ( var i = 0; i < viewer.childNodes.length; i++ )
            {
                var child = viewer.childNodes.item( i );
                if ( child.tagName != null &&
                     child.tagName.toUpperCase() == "SPAN" )
                {
                    // return the TABLE element that is the SPANs only child
                    return child.childNodes.item(0);
                }
            }
        }
        else
        {
            // recurse
            return findViewer( element.parentNode );
        }
    }
    return null;
}


/**
 * Perform view update
 *
 * @param viewportId The unique ID of viewport instance
 * @param parameters Object map containing [name,value] pairs to
 *        be appended to base imageUrl
 * @param isSelect Whether or not this is a select update, as
 *        currently refresh only applied to select actions.
 */

//-01 begin
function WImageViewport_update( viewportId, parameters, isSelect )
{
    var viewport = document.getElementById( viewportId );

    // add action
    if ( parameters['action'] == null )
    {
        parameters['action'] = "update";
    }
    // add timestamp to ensure unique URL
    parameters['timestamp'] = (new Date()).getTime();
    if ( parameters['selX'] != null && parameters['selY'] != null)
    {
        this.savedParameters = parameters;
    }else
    {
        this.savedParameters = null;
    }
    var url = WUtilities.buildURL( viewport.imageUrl,
                                       parameters,
                                       null,
                                       null );
    // non-invasively update view only
    // initiate download to send update
    var connection = new WConnection();
    connection.download( url, null, 120000 );

}
//-01 end


function WImageViewport_loadImage( viewportId, imageUrl )
{
    var viewport = document.getElementById( viewportId );
    var mouseLayer = document.getElementById( viewport.mouseLayerId );
    var imageLayer = document.getElementById( viewport.imageLayerId );
    var image = document.getElementById( viewport.imageId );

    document.body.style.cursor = "wait";

    if ( viewport.callbacks == null )
    {
    // create callback array
    viewport.callbacks = new Array();
    }
    // store fade-in callback
    viewport.callbacks[ viewportId + "FADE_IN" ] = fadeInCallback;

    // if overview is present, save overview callback
    /*
    try
    {
        viewport.callbacks[ viewportId + "OVERVIEW" ] = WOverview.callback;
    }
    catch ( e )
    {
        // WOverview is not present. Set empty function.
        viewport.callbacks[ viewportId + "OVERVIEW" ] = new Function( "viewportId", "return true;" );
    }
    */

    // set image state
    image.isLoading = true;

    // disable mouse layer
    mouseLayer.disabled = true;

    if ( WClient.isBrowserInternetExplorer() &&
         image.filters &&
         image.filters.length > 0)
    {
        // apply filter (holds application of style constant until play is called)
        image.filters[0].Apply();
    }
    //if ( WClient.isBrowserNetscape() ||
    //     ( WClient.isBrowserMozilla() && parseFloat( WClient.mozMinor ) >= 1.4 ) )
    //{
    //    // clear opacity
    //    image.style.MozOpacity = 0.0;
    //}

    // reset image layer position
    image.style.top = "0px";
    image.style.left = "0px";

    var parameters = new Object();
    parameters['action'] = "image";
    parameters['timestamp'] = (new Date()).getTime();

    // build url
    var url = WUtilities.buildURL( imageUrl,
                                   parameters,
                                   null, null ); // no prefix or suffix b/c going through proxy servlet
    // set image source
    image.src = url;
}

function WImageViewport_handleLoad( viewportId )
{
    var viewport = document.getElementById( viewportId );

    if ( viewport.imageId )
    {
        var image = document.getElementById( viewport.imageId );

        var isLoadEventForViewImage = ( image.src.indexOf( viewport.imageUrl ) != -1 );
        var isViewImageLoading = ( image.isLoading );
        var hasWindowFinishedLoading = ( window.loaded );

        if ( isLoadEventForViewImage && isViewImageLoading && hasWindowFinishedLoading )
        {
            // set image state
            image.isLoading = false;

            // get dimension and position of image layer
            var imageLayer = document.getElementById( viewport.imageLayerId );
            var imageLayerTop = WUtilities.getTop( imageLayer, true );
            var imageLayerLeft = WUtilities.getLeft( imageLayer, true );
            var imageLayerWidth = parseInt( imageLayer.style.width );
            var imageLayerHeight = parseInt( imageLayer.style.height );
            // ensure image layer is visible
            imageLayer.style.visibility = "visible";

            // set dimension and postion of mouse layer
            var mouseLayer = document.getElementById( viewport.mouseLayerId );
            mouseLayer.style.top = imageLayerTop + "px";
            mouseLayer.style.left = imageLayerLeft + "px";
            mouseLayer.style.width = imageLayerWidth + "px";
            mouseLayer.style.height = imageLayerHeight + "px";
            // show and enable mouse layer
            mouseLayer.style.visibility = "visible";
            mouseLayer.disabled = false;

            // show resize image
            if ( viewport.resizeImageId )
            {
                var resizeImage = document.getElementById( viewport.resizeImageId );
                if ( resizeImage )
                {
                    resizeImage.style.visibility = "visible";
                }
            }

            // iterate through callbacks
            if ( viewport.callbacks != null )
            {
                var callbackName = null;
                for ( callbackName in viewport.callbacks )
                {
                    var callback = viewport.callbacks[ callbackName ];
                    callback( viewportId );
                }
            }
            // reload overview image, if present
            if ( viewport.overviewId != null )
            {
                var overview = document.getElementById( viewport.overviewId );
                if ( overview != null && !overview.isLoading )
                {
                    // add timestamp to ensure unique URL (avoid caching in Mozilla)
                    var params = new Object();
                    params[ 'timestamp'] = ""+(new Date()).getTime();
                    var url = WUtilities.buildURL( overview.overviewImageUrl,
                                                   params,
                                                   null,
                                                   null );
                    overview.isLoading = true;
                    overview.src = url;
                }
            }
        }
        else if ( !hasWindowFinishedLoading )
        {
            if ( !viewport._initRecurseCount )
            {
                viewport._initRecurseCount = 0;
            }
            // only recurse for 30 seconds ( 300 x 100 ms = 30 s )
            if ( viewport._initRecurseCount < 300 )
            {
                viewport._initRecurseCount++;
                setTimeout( 'WImageViewport.handleLoad("' + viewportId + '")', 100 );
            }
        }
    }
    document.body.style.cursor = "default";
}

function fadeInCallback( viewportId )
{
    var viewport = document.getElementById( viewportId );
    if ( viewport.imageId )
    {
        var image = document.getElementById( viewport.imageId );
        // fade in image
        if ( WClient.isBrowserInternetExplorer() &&
            image.filters &&
            image.filters.length > 0)
        {
             // play filter
            image.filters[0].Play();
        }
        //if ( WClient.isBrowserNetscape() ||
        //     ( WClient.isBrowserMozilla() && parseFloat( WClient.mozMinor ) >= 1.4 ) )
        //{
        //    // fade in
        //    fadeIn( viewport.imageId, 0.25 );
        //}
    }
}

function fadeIn( imageLayerId, opacityIncrament, iteration )
{
    var iterationCount = ( iteration ? iteration : 0 );
    var imageLayer = document.getElementById( imageLayerId );
    var opacity = parseFloat( imageLayer.style.MozOpacity );
    if ( !isNaN(opacity) && opacity < 1.0 && iterationCount < 100 )
    {
        imageLayer.style.MozOpacity = opacity + opacityIncrament;
        setTimeout( "fadeIn('" + imageLayerId + "'," + opacityIncrament + "," + (++iterationCount) + ")", 100 )
    }
    else
    {
        imageLayer.style.MozOpacity = 1.0;
    }
}

function WImageViewport_setFocalPoint( viewportId, focalPoint )
{
    var viewport = document.getElementById( viewportId );

    viewport.focalPoint = focalPoint;
}

function WImageViewport_getFocalPoint( viewportId )
{
    var viewport = document.getElementById( viewportId );

    return viewport.focalPoint;
}

function WImageViewport_setZoomLevel( viewportId, zoomLevel )
{
    var viewport = document.getElementById( viewportId );

    viewport.zoomLevel = zoomLevel;
}

function WImageViewport_getZoomLevel( viewportId )
{
    var viewport = document.getElementById( viewportId );

    return viewport.zoomLevel;
}

function WImageViewport_getWorldRectangle( viewportId )
{
    var viewport = document.getElementById( viewportId );

    return viewport.worldRectangle;
}

function WImageViewport_setWorldRectangle( viewportId, worldRectangle )
{
    var viewport = document.getElementById( viewportId );

    viewport.worldRectangle = worldRectangle;
}


function WImageViewport_checkViewBounds( viewportId, viewRectangle )
{
    var vb = viewRectangle;
    var wb = this.getWorldRectangle( viewportId );

    var vbAdjusted = false;

    //**********************************************************************
    //* Check the boundaries of the viewPort against the world coordinates
    //**********************************************************************
    var wbX2 = wb.x + wb.width,
    wbY2 = wb.y + wb.height,

    vbX2 = vb.x + vb.width,
    vbY2 = vb.y + vb.height;

    if ( vb.width > wb.width )
    {
        vb.width = wb.width;
        vbAdjusted = true;
    }

    if ( vb.height > wb.height )
    {
        vb.height = wb.height;
        vbAdjusted = true;
    }

    if ( vbX2 > wbX2 )
    {
        vb.x = wbX2 - vb.width;
        vbAdjusted = true;
    }
    else if ( vb.x < wb.x )
    {
        vb.x = wb.x;
        vbAdjusted = true;
    }

    if ( vbY2 > wbY2 )
    {
        vb.y = wbY2 - vb.height;
        vbAdjusted = true;
    }
    else if ( vb.y < wb.y )
    {
        vb.y = wb.y;
        vbAdjusted = true;
    }

    //**********************************************************************
    //  Have we adjusted the view rectangle in the code above?
    //**********************************************************************
    if ( vbAdjusted )
    {
        //var x = vb.x + Math.floor( vb.width  / 2 );
        //var y = vb.y + Math.floor( vb.height / 2 );

        //this.setFocalPoint( viewportId, new Point( x, y ) );
        this.fitViewToRectangle( viewportId, vb );
    }
}

function WImageViewport_fitViewToRectangle( viewportId, rectangle )
{
    var viewport = document.getElementById( viewportId );
    var image = document.getElementById( viewport.imageId );

    var renderWidth = parseFloat( image.width );
    var renderHeight = parseFloat( image.height );

    var wZoomFactor = ( rectangle.width / renderWidth  );
    var hZoomFactor = ( rectangle.height / renderHeight );

    var newZoomLevel = Math.max( wZoomFactor, hZoomFactor );
    //if ( newZoomLevel >= viewport.minZoomLevel )
    {
        this.setZoomLevel( viewportId, newZoomLevel );

        var focalX = rectangle.x + Math.floor( rectangle.width / 2 );
        var focalY = rectangle.y + Math.floor( rectangle.height / 2 );
        var newFocalPoint = new Point( focalX, focalY );

        this.setFocalPoint( viewportId, newFocalPoint );
    }
}

/**
 * Calculate view rectangle based on focal point and zoom level
 */
function WImageViewport_getViewRectangle( viewportId )
{
    var viewport = document.getElementById( viewportId );
    var image = document.getElementById( viewport.imageId );
    var renderWidth = parseFloat( image.width );
    var renderHeight = parseFloat( image.height );
    var zoomLevel = this.getZoomLevel( viewportId );
    var focalPoint = this.getFocalPoint( viewportId );
    var width = Math.round( renderWidth * zoomLevel );
    var height = Math.round( renderHeight * zoomLevel );
    var x = focalPoint.getX() - Math.floor(width/2);
    var y = focalPoint.getY() - Math.floor(height/2);

    var viewRectangle = new Rectangle( x, y, width, height );

    //this.checkViewBounds( viewportId, viewRectangle );

    return viewRectangle;
}

function WImageViewport_setMouseMode( viewportId, mouseMode, noPersist )
{
    var viewport = document.getElementById( viewportId );

    if ( mouseMode != viewport.mouseMode )
    {
        // store mouse mode
        viewport.mouseMode = mouseMode;

        // change cursor to reflect mouse mode
        var mouseLayer = document.getElementById( viewport.mouseLayerId );
        switch ( mouseMode )
        {
        case this.MOUSE_MODE_ZOOM:
            mouseLayer.style.cursor = "crosshair";
            break;
        case this.MOUSE_MODE_PAN:
            mouseLayer.style.cursor = "move";
            break;
        default:
            mouseLayer.style.cursor = "default";
            break;
        }

        // persist mouse mode to backend
        if ( !noPersist )
        {
        var url = viewport.imageUrl;
        url += ( url.indexOf( "?" ) == -1 ? "?" : "&" );
        // append mouse mode
        url += "mode=";
        url += mouseMode;
        // append action
        url += "&action=mouse&";
        // append timestamp to ensure unique URL
        url += (new Date()).getTime();

        // open connection to server
        var connection = new WConnection();

        // initiate download to send new moust mode
        connection.download( url, null, 120000 );
    }
}
}

function WImageViewport_getMouseMode( viewportId )
{
    var viewport = document.getElementById( viewportId );

    return ( viewport.mouseMode ? viewport.mouseMode : this.MOUSE_MODE_SELECT );
}

/**
 * Handle context menu event.
 *
 * @param e The Event object generated by user action [ REQUIRED ]
 * @param viewportId The id of the outermost viewport HTMLElement [ REQUIRED ]
 * @param mouseMode Mode in which to handle this mouse event. This value does
 *        not affect global mouse mode [ OPTIONAL ]
 */
function WImageViewport_handleContextMenu( e, viewportId, mouseMode )
{
    var viewport = document.getElementById( viewportId );

    if ( viewport.isMenuEnabled )
    {
        // destroy current context menu
        WImageViewport.destroyContextMenu( viewportId );
        // reset menu item handled state
        viewport.menuItemHandled = false;

        var wEvent = new WEvent( e );
        var pagePosition = wEvent.getPagePosition();
        var mouseX = pagePosition.getX();
        var mouseY = pagePosition.getY();

        // calculate mouse position relative to image
        var image = document.getElementById( viewport.imageId );
        var contextX = ( mouseX - WUtilities.getLeft( image, true ) );
        var contextY = ( mouseY - WUtilities.getTop ( image, true ) );

        // store context menu position
        viewport.contextPosition = new Position( contextX, contextY );

        // dynamicaly build menu by downloading menu items
        var params = new Object();
        params[ 'action' ] = "contextMenu";
        params[ 'viewportId'] = viewportId;
        params[ 'contextX'] = contextX;
        params[ 'contextY'] = contextY;
        this.update( viewportId, params, false );

        return false;
    }
    return true;
}

/**
 * Handle selection of a context menu item
 */
function WImageViewport_handleContextMenuItem( viewportId, formName, actionName, actionValue, actionNameEnc, menuID, menuCmd, wclhidden )
{
    var viewport = document.getElementById( viewportId );
    var viewportMenuId = "wclMenuCmd" + viewport.menuId;

    // check to see if this is command for our context menu
    if ( viewportMenuId == menuID )
    {
        // check that this menu item has not already been handled
        if ( !viewport.menuItemHandled )
        {
            viewport.menuItemHandled = true;

            var params = new Object();
            params[ 'action'] = "contextMenuItem";
            params[ 'menuCommand'] = menuCmd;
            params[ 'contextX'] = viewport.contextPosition.getX();
            params[ 'contextY'] = viewport.contextPosition.getY();

            // build submission form
            var form = WUtilities.buildForm( viewport.refreshURL,
                                             params,
                                             ( viewport.isInPortal ? viewport.portletNamespacePrefix : "" ),
                                             ( viewport.isInPortal ? viewport.portletNamespaceSuffix : "" ) );

            // add form to DOM and submit
            document.body.appendChild( form );
            form.submit();


        }

        return false;
    }
    else
    {
        // pass through to overridden, default doPop
        return self.store_doPop( formName, actionName, actionValue, actionNameEnc, menuID, menuCmd, wclhidden );
    }
}

function WImageViewport_handleContextMenuEvent( viewportId, menu, event )
{

    var viewport = document.getElementById( viewportId );

    switch ( event )
    {
    case 'MENU_CREATED':
        //-01 we need the mouseout to dismiss context menu
        ////////////////menu.menuTag.onmouseout = new Function( "e", "return true;" );

        // override menu item event handlers
        WImageViewport_overrideMenuItemEventHandlers( menu );

        // override document mouse listener (set by context menu) so that mousedown
        // on scroll bars will not dismiss the menu
        if ( document.store_onmousedown == null )
        {
            document.store_onmousedown = document.onmousedown;
            document.onmousedown = new Function( "e", "return true;" );

            document.body.store_onmousedown = document.body.onmousedown;
            document.body.onmousedown = new Function( "e", "return WImageViewport_handleContextMenuDismiss( new WEvent( e ), '" + viewportId + "' );" );
        }
        break;
    case 'MENU_SHOWN':
        break;
    case 'MENU_HIDDEN':
        // restore document mouse listener
        if ( document.store_onmousedown != null )
        {
            document.onmousedown = document.store_onmousedown;
            document.store_onmousedown = null;
            document.body.onmousedown = document.body.store_onmousedown;
            document.body.store_onmousedown = null;
        }
        break;
    case 'MENU_DESTROYED':
        break;
    }
}

function WImageViewport_handleContextMenuDismiss( wEvent, viewportId )
{
    var viewport = document.getElementById( viewportId );
    if ( viewport != null )
    {
        var menu = getContextMenu( viewport.menuId );
        if ( menu != null && menu.isVisible )
        {
            if ( document.store_onmousedown != null )
            {

                return document.store_onmousedown( wEvent.getEventObject() );

            }
            return true;
        }
    }
    if ( document.body.store_onmousedown != null )
    {

        return document.body.store_onmousedown( wEvent.getEventObject() );
    }
    return true;
}

function WImageViewport_handleMenuItemMousedown( event, clientAction )
{
    clientAction = unescape(clientAction);
    //-01 : do not eval, else will double launch the HMC task
    //eval( clientAction );
    return false;
}

/**
 * Create and show context menu. This assumes that all MenuItems have
 * already been added to menu object.
 *
 * @param buildFunction Reference to buildMenu_ function/method
 */
function WImageViewport_createContextMenu( viewportId, menuId, modelId, buildMenuFunction )
{
    var viewport = document.getElementById( viewportId );

    // store ids
    viewport.menuId = menuId;
    viewport.modelId = modelId;
    viewport.menuLauncherId = viewportId + "_MENU_LAUNCHER";

    // get context menu launcher
    var launcher = document.getElementById( viewport.menuLauncherId );
    if ( !launcher )
    {
        launcher = document.createElement( "DIV" );
        launcher.id = viewport.menuLauncherId;
        with ( launcher.style )
        {
            position = "absolute";
            zIndex = "-1";
            width = "1px";
            height = "1px";
        }
        document.body.appendChild( launcher );
    }

    // position context menu launcher
    var image = document.getElementById( viewport.imageId );
    launcher.style.top = viewport.contextPosition.getY() + WUtilities.getTop ( image, true ) + "px";
    launcher.style.left = viewport.contextPosition.getX() + WUtilities.getLeft( image, true ) + "px";

    var formName = null;

    // build url
    var params = new Object();
    params[ 'action'] = "contextMenuItem";
    var url = WUtilities.buildURL( viewport.refreshURL,
                                   params,
                                   ( viewport.isInPortal ? viewport.portletNamespacePrefix : "" ),
                                   ( viewport.isInPortal ? viewport.portletNamespaceSuffix : "" ) );
    // build menu
    var menu = buildMenuFunction( menuId, url, !viewport.isRTL, formName );

    // check for empty menu b/c context script will actually render an invisible
    // empty menu that must be dismissed by clicking.
    if ( menu.items != null && menu.items.length > 0 )
    {
        // clone menu into this namespace/DOM
        menu = cloneMenu( menu, menuId, false );

        // store off original doPop function, so viewport can pass through to it if necessary
        if ( self.store_doPop == null )
        {
            self.store_doPop = self.doPop;
        }
        // override doPop function
        // FYI: actionValue == modelId, menuCmd == ICommandListener.commandName
        self.doPop = new Function( "formName, actionName, actionValue, actionNameEnc, menuID, menuCmd, wclhidden",
                                   "return WImageViewport_handleContextMenuItem( '" + viewportId + "', formName, actionName, actionValue, actionNameEnc, menuID, menuCmd, wclhidden );" );

        // add listener so we can undo doPop override
        menu.addListener( new Function( "menu, event", "return WImageViewport_handleContextMenuEvent( '" + viewportId + "', menu, event );" ) );

        // force menu creation here because we want to specify true for recurse
        // parameter, thus building the entire menu/submenu hierarchy upfront.
        if ( menu.menuTag == null )
        {
            menu.create( true );
        }
        // show menu
        contextMenuShow( viewport.menuId, false, false, launcher, true );
    }
}

/**
 * Override menu item event handlers. Otherwise, we won't get click notification
 * on menu items.
 */
function WImageViewport_overrideMenuItemEventHandlers( menu )
{
    if ( menu != null )
    {
        for ( var i = 0; i < menu.items.length; i++ )
        {
            var item = menu.items[i];
            if ( item.submenu != null )
            {
                // recurse
                WImageViewport_overrideMenuItemEventHandlers( item.submenu );
            }
            else
            {
                var anchorTag = item.anchorTag;
                if ( anchorTag != null )
                {
                    var eventHandler = escape(anchorTag.onclick);
                    anchorTag.onmousedown = new Function( "event", "return WImageViewport_handleMenuItemMousedown(event, '" + eventHandler + "');" );
                    anchorTag.onclick = new Function(  "return false;" );
                    // we also want to override the cell's onclick and onmousedown event handlers so that
                    // clicks on the TD/cell can be captured.
                    var cell = anchorTag.parentNode;
                    cell.onclick = new Function( "event", "return WImageViewport_handleMenuItemMousedown(event, '" + eventHandler + "');" );
                    cell.onmousedown = new Function(  "return false;" );
                }
            }
        }
    }
}

/**
 * Destroy context menu and all menu items, including all HTMLElements used
 * to render the menu.
 */
function WImageViewport_destroyContextMenu( viewportId )
{
    var viewport = document.getElementById( viewportId );

    if ( viewport.menuId != null )
    {
        var menu = getContextMenu( viewport.menuId );

        if ( menu != null )
        {
            menu.destroy();
        }
    }
}



/**
 * Handle mouse down event.
 *
 * @param e The Event object generated by user action [ REQUIRED ]
 * @param viewportId The id of the outermost viewport HTMLElement [ REQUIRED ]
 * @param mouseMode Mode in which to handle this mouse event. This value does
 *        not affect global mouse mode [ OPTIONAL ]
 */
function WImageViewport_handleMousedown( e, viewportId, mouseMode )
{
    var wEvent = new WEvent( e );
    var viewport = document.getElementById( viewportId );
    var mode = ( mouseMode ? mouseMode : this.getMouseMode( viewportId ) );


    // only handle left mouse button
    // NOTE: This could be problematic in a Linux environment where mouse buttons
    // have been reassigned
    if ( wEvent.getButtonCode() != 0 &&
         wEvent.getButtonCode() != 1 )
    {
        return true;
    }

    // check that this is not an attempt to dismiss a visible context menu
    if ( viewport.menuId != null )
    {
        var menu = getContextMenu( viewport.menuId );
        if ( menu != null && menu.isVisible )
        {

            return true;
        }
    }

    // set start and current position
    var mousePosition = wEvent.getPagePosition();

    viewport.startPosition   = new Position( mousePosition.getX(), mousePosition.getY() );
    viewport.currentPosition = new Position( mousePosition.getX(), mousePosition.getY() );

    if ( !viewport.mouseDown )
    {
        // override document.onmousemove
        viewport.store_onmousemove = document.onmousemove;
        document.onmousemove = new Function( "e", "WImageViewport.handleMousemove( e, '" + viewportId + "','" + mode + "' );" );

        // override document.onmouseup
        viewport.store_onmouseup = document.onmouseup;
        document.onmouseup = new Function( "e", "WImageViewport.handleMouseup( e, '" + viewportId + "','" + mode + "' );" );

        // disable document.onselectstart
        viewport.store_onselectstart = document.onselectstart;
        document.onselectstart = new Function( "return false;" );

        // save document cursor style
        viewport.store_cursor = document.body.style.cursor;

        // get image layer dimensions and position
        var imageLayer = document.getElementById( viewport.imageLayerId );
        var imageLayerTop = WUtilities.getTop( imageLayer, true );
        var imageLayerLeft = WUtilities.getLeft( imageLayer, true );
        var imageLayerWidth = parseInt( imageLayer.style.width );
        var imageLayerHeight = parseInt( imageLayer.style.height );

        // perform mode-specific action
        switch ( mode )
        {
        case this.MOUSE_MODE_RESIZE:
            // override document cursor style
            if ( viewport.isRTL )
            {
                document.body.style.cursor = "ne-resize";
            }
            else
            {
                document.body.style.cursor = "se-resize";
            }
            // get resize image
            if ( viewport.resizeImageId )
            {
                var resizeImage = document.getElementById( viewport.resizeImageId );
                // create resizeBox element
                var resizeBox = document.createElement( "DIV" );
                with ( resizeBox )
                {
                    id = viewportId + "resizeBox";
                    with ( style )
                    {
                        position = "absolute";
                        width = imageLayerWidth - 4 + "px";
                        height = imageLayerHeight - 4 + "px";
                        top = imageLayerTop + "px";
                        left = imageLayerLeft + "px";
                        zIndex = "101";
                        background = "url('" + resizeImage.src + "')";
                        backgroundRepeat = "no-repeat";
                        if ( viewport.isRTL )
                        {
                            backgroundPosition = "bottom left";
                            cursor = "ne-resize";
                        }
                        else
                        {
                            backgroundPosition = "bottom right";
                            cursor = "se-resize";
                        }
                    }
                }
                document.body.appendChild( resizeBox );
                // set resizeBox CSS class name
                resizeBox.className = "vp22";
            }
            break;
        case this.MOUSE_MODE_ZOOM:
            // override document cursor style
            document.body.style.cursor = "crosshair";
            // create lasso element
            var lasso = document.createElement( "DIV" );
            with ( lasso )
            {
                id = viewport.lassoId;
                with ( style )
                {
                    position = "absolute";
                    width = "0px";
                    height = "0px";
                    top = mousePosition.getY() + "px";
                    left = mousePosition.getX() + "px";
                    zIndex = "100";
                }
            }
            document.body.appendChild( lasso );
            // create blank image element
            var blankImage = document.createElement( "IMG" );
            with ( blankImage )
            {
                width = "1";
                height = "1";
                border = "0";
                with ( style )
                {
                    display = "block";
                }
            }
            lasso.appendChild( blankImage );
            // set lasso CSS class name
            lasso.className = "vp21";
            break;
        case this.MOUSE_MODE_PAN:
            // override document cursor style
            document.body.style.cursor = "move";
            break;
        case this.MOUSE_MODE_SELECT:
            break;
        }

        // set mouse state
        viewport.mouseDown = true;
        return false;
    }
    return true;
}

/**
 * Handle mouse move event.
 *
 * @param e The Event object generated by user action [ REQUIRED ]
 * @param viewportId The id of the outermost viewport HTMLElement [ REQUIRED ]
 * @param mouseMode Mode in which to handle this mouse event. This value does
 *        not affect global mouse mode [ OPTIONAL ]
 */
function WImageViewport_handleMousemove( e, viewportId, mouseMode )
{
    var viewport = document.getElementById( viewportId );
    var mode = ( mouseMode ? mouseMode : this.getMouseMode( viewportId ) );

    if ( viewport.mouseDown && mode != this.MOUSE_MODE_SELECT )
    {
        var wEvent = new WEvent( e );

        // get current mouse position
        var mousePosition = wEvent.getPagePosition();
        var mouseX = mousePosition.getX();
        var mouseY = mousePosition.getY();

        // compute mouse movement
        var diffX = ( mouseX - viewport.currentPosition.getX() );
        var diffY = ( mouseY - viewport.currentPosition.getY() );

        // get image layer dimensions and position
        var imageLayer = document.getElementById( viewport.imageLayerId );
        var imageLayerTop = WUtilities.getTop( imageLayer, true );
        var imageLayerLeft = WUtilities.getLeft( imageLayer, true );
        var imageLayerWidth = parseInt( imageLayer.style.width );
        var imageLayerHeight = parseInt( imageLayer.style.height );

        switch ( mode )
        {
        case this.MOUSE_MODE_RESIZE:
            if (  viewport.resizeImageId )
            {
                var resizeImage = document.getElementById( viewport.resizeImageId );
                if ( resizeImage )
                {
                    // store parent element
                    var parentId = resizeImage.parentNode.id;
                    viewport.resizeImageParentId = parentId;
                    // store resizeImage dimensions
                    viewport.resizeImageWidth = resizeImage.width;
                    viewport.resizeImageHeight = resizeImage.height;
                    // store resizeImage HTML for later recreation
                    viewport.resizeImageHTML = resizeImage.parentNode.innerHTML;
                    // remove resizeImage
                    resizeImage.parentNode.removeChild( resizeImage );
                }

                // position resizeBox
                var resizeBox = document.getElementById( viewportId + "resizeBox" );
                var resizeBoxLeft = parseInt(resizeBox.style.left);
                var resizeBoxWidth = parseInt(resizeBox.style.width)
                var resizeBoxHeight = parseInt(resizeBox.style.height)

                if ( viewport.isRTL )
                {
                    // moving horizontally in quadrant IV
                    if ( mouseX < (imageLayerLeft+imageLayerWidth-viewport.resizeImageWidth) )
                    {
                        resizeBox.style.left = resizeBoxLeft + diffX + "px";
                        resizeBox.style.width = resizeBoxWidth - diffX + "px";
                    }
                    else
                    {
                        resizeBox.style.left = (imageLayerLeft+imageLayerWidth-viewport.resizeImageWidth) + "px";
                        resizeBox.style.width = viewport.resizeImageWidth + "px";
                    }
                    // moving vertically in quadrant one
                    if ( mouseY > (imageLayerTop+viewport.resizeImageHeight) )
                    {
                        resizeBox.style.height = resizeBoxHeight + diffY + "px";
                    }
                    else
                    {
                        resizeBox.style.height = viewport.resizeImageHeight + "px";
                    }
                }
                else
                {
                    // moving horizontally in quadrant one
                    if ( mouseX > imageLayerLeft )
                    {
                        resizeBox.style.width = Math.max( mouseX - imageLayerLeft, viewport.resizeImageWidth ) + "px";
                    }
                    // moving vertically in quadrant one
                    if ( mouseY > imageLayerTop )
                    {
                        resizeBox.style.height = Math.max( mouseY - imageLayerTop, viewport.resizeImageHeight ) + "px";
                    }
                }
            }

            break;
        case this.MOUSE_MODE_ZOOM:
            // resize lasso element
            var lasso = document.getElementById( viewport.lassoId );

            var minTop = imageLayerTop;
            var maxTop = imageLayerTop + imageLayerHeight;
            var minLeft = imageLayerLeft;
            var maxLeft = imageLayerLeft + imageLayerWidth;

            var startX = viewport.startPosition.getX();
            var startY = viewport.startPosition.getY();
            var mouseX = mousePosition.getX();
            var mouseY = mousePosition.getY();

            // TODO :check bounds
            if ( mouseY < minTop )
            {
                mouseY = minTop;
            }
            else if ( mouseY > maxTop )
            {
                mouseY = maxTop;
            }
            if ( mouseX < minLeft )
            {
                mouseX = minLeft;
            }
            else if ( mouseX > maxLeft )
            {
                mouseX = maxLeft;
            }

            var inverseAspect = imageLayerHeight/imageLayerWidth;
            var aspect = imageLayerWidth/imageLayerHeight;

            var lassoTop = 0;
            var lassoLeft = 0;
            var lassoWidth = Math.abs( startX - mouseX );
            var lassoHeight = Math.abs( startY - mouseY );

            if ( lassoWidth > lassoHeight )
            {
                lassoHeight = inverseAspect * lassoWidth;
            }
            else
            {
                lassoWidth = aspect * lassoHeight;
            }

            // moving North
            if ( mousePosition.getY() < startY )
            {
                lassoTop = startY - lassoHeight;
            }
            // moving South
            else
            {
                lassoTop = startY;
            }

            // moving West
            if ( mousePosition.getX() < startX )
            {
                lassoLeft = startX - lassoWidth;
            }
            else
            {
                lassoLeft = startX;
            }

            if ( lassoTop < minTop )
            {
                lassoTop = minTop
            }
            if ( lassoLeft < minLeft )
            {
                lassoLeft = minLeft;
            }

            if ( lassoTop + lassoHeight > maxTop )
            {
                lassoHeight = maxTop - lassoTop;
            }
            if ( lassoLeft + lassoWidth > maxLeft )
            {
                lassoWidth = maxLeft - lassoLeft;
            }

            lasso.style.top = lassoTop + "px";
            lasso.style.left = lassoLeft + "px";
            lasso.style.width = lassoWidth + "px";
            lasso.style.height = lassoHeight + "px";

            break;
        case this.MOUSE_MODE_PAN:
            // move image layer
            var image = document.getElementById( viewport.imageId );
            var imageTop = parseInt( image.style.top );
            var imageLeft = parseInt( image.style.left );

            image.style.top = imageTop + diffY + "px";
            image.style.left = imageLeft + diffX + "px";
            break;
        }

        // update current position
        viewport.currentPosition = mousePosition;
    }
}

/**
 * Handle mouse up event.
 *
 * @param e The Event object generated by user action [ REQUIRED ]
 * @param viewportId The id of the outermost viewport HTMLElement [ REQUIRED ]
 * @param mouseMode Mode in which to handle this mouse event. This value does
 *        not affect global mouse mode [ OPTIONAL ]
 */
function WImageViewport_handleMouseup( e, viewportId, mouseMode )
{
    var viewport = document.getElementById( viewportId );
    var mode = ( mouseMode ? mouseMode : this.getMouseMode( viewportId ) );

    if ( viewport.mouseDown )
    {
        // set mouse state
        viewport.mouseDown = false;

        var wEvent = new WEvent( e );

        if ( mode == this.MOUSE_MODE_SELECT )
        {

            this.handleSelect( wEvent, viewportId );
        }
        else
        {
            // get current mouse position
            var mousePosition = wEvent.getPagePosition();
            var mouseX = mousePosition.getX();
            var mouseY = mousePosition.getY();

            // update current position
            viewport.currentPosition.x = mouseX;
            viewport.currentPosition.y = mouseY;

            // restore event handlers
            document.onmouseup = viewport.store_onmouseup;
            document.onmousemove = viewport.store_onmousemove;
            document.onselectstart = viewport.store_onselectstart;
            //restore cursor style
            document.body.style.cursor = viewport.store_cursor;

            // perform action
            switch ( mode )
            {
            case this.MOUSE_MODE_RESIZE:
                if ( viewport.resizeImageId )
                {
                    var resizeBox = document.getElementById( viewportId + "resizeBox" );

                    var diffX = viewport.currentPosition.getX() - viewport.startPosition.getX();
                    if ( viewport.isRTL )
                    {
                        diffX *= -1;
                    }
                    var diffY = viewport.currentPosition.getY() - viewport.startPosition.getY();

                    if ( diffX != 0 || diffY != 0 )
                    {
                        // resize image
                        //var image = document.getElementById( viewport.imageId );
                        //image.style.width = parseInt( image.style.width ) + diffX + "px";
                        //image.style.height = parseInt( image.style.height ) + diffY + "px";
                        // resize image layer
                        var imageLayer = document.getElementById( viewport.imageLayerId );
                        imageLayer.style.width = parseInt( imageLayer.style.width ) + diffX + "px";
                        imageLayer.style.height = parseInt( imageLayer.style.height ) + diffY + "px";

                        // resize mouse layer
                        var mouseLayer = document.getElementById( viewport.mouseLayerId );
                        mouseLayer.style.width = parseInt( mouseLayer.style.width ) + diffX + "px";
                        mouseLayer.style.height = parseInt( mouseLayer.style.height ) + diffY + "px";

                        this.handleResize( wEvent, viewportId );
                    }

                // recreate resizeImage
                    var resizeImage = document.getElementById( viewport.resizeImageId );
                    if ( !resizeImage )
                    {
                        var resizeImageParent = document.getElementById( viewport.resizeImageParentId );
                        resizeImageParent.innerHTML = viewport.resizeImageHTML;
                    }

                    // remove resizeBox
                    resizeBox.parentNode.removeChild( resizeBox );
                }

                break;
            case this.MOUSE_MODE_ZOOM:

                if ( viewport.currentPosition.getY() < viewport.startPosition.getY() )
                {
                    // moving North
                    var tempPositionY = viewport.startPosition.y;
                    viewport.startPosition.y = viewport.currentPosition.y;
                    viewport.currentPosition.y = tempPositionY
                }
                if ( viewport.currentPosition.getX() < viewport.startPosition.getX() )
                {
                    // moving West
                    var tempPositionX = viewport.startPosition.x;
                    viewport.startPosition.x = viewport.currentPosition.x;
                    viewport.currentPosition.x = tempPositionX
                }
                this.handleZoom( wEvent, viewportId );
                // remove lasso
                var lasso = document.getElementById( viewport.lassoId );
                lasso.parentNode.removeChild( lasso );
                break;
            case this.MOUSE_MODE_PAN:
                this.handlePan( wEvent, viewportId );
                break;
            case this.MOUSE_MODE_SELECT:
                this.handleSelect( wEvent, viewportId );
                break;
            }
        }
    }
}



/**
 * Handle pan action.
 */
function WImageViewport_handlePan( wEvent, viewportId )
{
    var viewport = document.getElementById( viewportId );
    var deltaX = viewport.currentPosition.getX() - viewport.startPosition.getX();
    var deltaY = viewport.currentPosition.getY() - viewport.startPosition.getY();

    var zoomLevel = this.getZoomLevel( viewportId );

    deltaX = Math.floor( deltaX * zoomLevel );
    deltaY = Math.floor( deltaY * zoomLevel );

    if ( deltaX != 0 || deltaY != 0 )
    {
        this.pan( viewportId, -deltaX, -deltaY );
    }
}

/**
 * Handle viewport resize action.
 */
function WImageViewport_handleResize( wEvent, viewportId )
{
    var viewport = document.getElementById( viewportId );
    var mouseLayer = document.getElementById( viewport.mouseLayerId );
    var width  = parseInt( mouseLayer.style.width );
    var height = parseInt( mouseLayer.style.height );

    if ( width > 0 && height > 0 )
    {
        this.resize( viewportId, width, height );
    }

}

/**
 * Handle select action. This could be click on viewport
 * or toggling of mouse mode in toolbar.
 */
function WImageViewport_handleSelect( wEvent, viewportId )
{
    var viewport = document.getElementById( viewportId );
    var image = document.getElementById( viewport.imageId );

    var x = ( viewport.currentPosition.getX() - WUtilities.getLeft( image, true ) );
    var y = ( viewport.currentPosition.getY() - WUtilities.getTop ( image, true ) );

    this.select( viewportId, x, y );
}

/**
 * Handle zoom action.
 */
function WImageViewport_handleZoom( wEvent, viewportId )
{
    var viewport = document.getElementById( viewportId );
    var image    = document.getElementById( viewport.imageId );
    var lasso    = document.getElementById( viewport.lassoId );

    var imageX = WUtilities.getLeft( image, true );
    var imageY = WUtilities.getTop( image, true );

    var lassoTop = parseInt( lasso.style.top ) - imageY;
    var lassoLeft = parseInt( lasso.style.left ) - imageX;
    var lassoWidth = parseInt( lasso.style.width );
    var lassoHeight = parseInt( lasso.style.height );

    // convert lasso values into world coordinates
    var viewRectangle = this.getViewRectangle( viewportId );
    var zoomLevel = this.getZoomLevel( viewportId );
    var y = viewRectangle.y + Math.round( lassoTop * zoomLevel );
    var x = viewRectangle.x + Math.round( lassoLeft * zoomLevel );
    var width = Math.round( lassoWidth * zoomLevel );
    var height = Math.round( lassoHeight * zoomLevel );

    this.zoom( viewportId, x, y, width, height );
}

/**
 * Zoom the viewport to fit the the entire world within.
 *
 * @param viewportId The id of the outermost viewport HTMLElement [ REQUIRED ]
 */
function WImageViewport_fitToView( viewportId )
{

    var viewport = document.getElementById( viewportId );

    var image = document.getElementById( viewport.imageId );

    var worldRectangle = this.getWorldRectangle( viewportId );

    var renderWidth = parseFloat( image.width );
    var renderHeight = parseFloat( image.height );
    var wZoomFactor = ( worldRectangle.width  / renderWidth  );
    var hZoomFactor = ( worldRectangle.height / renderHeight );

    this.setZoomLevel( viewportId, Math.max( wZoomFactor, hZoomFactor ) );

    var x = worldRectangle.x + Math.floor( worldRectangle.width  / 2 );
    var y = worldRectangle.y + Math.floor( worldRectangle.height / 2 );

    this.setFocalPoint( viewportId, new Point( x, y ) );

    var params = new Object();
    params['fitToView'] = true;

    this.update( viewportId, params );

}

/**
 * Pan the viewport by specified values. This will build a URL and
 * request a new image. After image has loaded, callback (if any) will be
 * called.
 *
 * @param viewportId The id of the outermost viewport HTMLElement [ REQUIRED ]
 * @param deltaX The number of pixels to pan along the x-axis [ REQUIRED ]
 * @param deltaY The number of pixels to pan along the y-axis [ REQUIRED ]
 */
function WImageViewport_pan( viewportId, deltaX, deltaY )
{
    var viewport = document.getElementById( viewportId );

    // handle pan locally
    var focalPoint = this.getFocalPoint( viewportId );
    this.setFocalPoint( viewportId, new Point( focalPoint.getX() + deltaX, focalPoint.getY() + deltaY ) );
    var viewRectangle = this.getViewRectangle( viewportId );
    var focalPoint2 = this.getFocalPoint( viewportId );

    deltaX = focalPoint2.x - focalPoint.x;
    deltaY = focalPoint2.y - focalPoint.y;

    var params = new Object();
    params['panX'] = deltaX;
    params['panY'] = deltaY;

    this.update( viewportId, params );
}

/**
 * Pan the viewport to the specified dimension. This will build a URL and
 * request a new image. After image has loaded, callback (if any) will be
 * called.
 *
 * @param viewportId The id of the outermost viewport HTMLElement [ REQUIRED ]
 * @param width The new width of the viewport [ REQUIRED ]
 * @param height The new height of the viewport [ REQUIRED ]
 */
function WImageViewport_resize( viewportId, width, height )
{
    var viewport = document.getElementById( viewportId );
    var image = document.getElementById( viewport.imageId );
    var imageLayer = document.getElementById( viewport.imageLayerId );

    image.width = width;
    image.height = height;
    imageLayer.style.width = width + "px";
    imageLayer.style.height = height + "px";

    // Values below must be set to fix a problem in Mozilla where
    // visible width will remain unaffected by just setting
    // new dimensions on image and imageLayer.
    try
    {
        // DIV
        image.parentNode.style.width = width + "px";
        image.parentNode.style.height = height + "px";
        // DIV
        image.parentNode.parentNode.style.width = width + "px";
        image.parentNode.parentNode.style.height = height + "px";
    }
    catch ( err ) { }

    var params = new Object();
    params['rW'] = width;
    params['rH'] = height;


    this.update( viewportId, params );
}

/**
 * Select the viewport at the specified location. This will build a URL and
 * request a new image. After image has loaded, callback (if any) will be
 * called.
 *
 * @param viewportId The id of the outermost viewport HTMLElement [ REQUIRED ]
 * @param x The selected position along the x-axis [ REQUIRED ]
 * @param y The selected position along the y-axis [ REQUIRED ]
 */
function WImageViewport_select( viewportId, x, y )
{
    var viewport = document.getElementById( viewportId );
    var viewRectangle = this.getViewRectangle( viewportId );

    var params = new Object();
    params['selX'] = x;
    params['selY'] = y;
    //-01 being
    // added to simulate left-click context menu icon stuff
    // store context menu position
    viewport.contextPosition = new Position( x, y );
    params[ 'viewportId'] = viewportId;
    // destroy current context menu
    WImageViewport.destroyContextMenu( viewportId );
    // reset menu item handled state
    viewport.menuItemHandled = false;
    //-1 end

    this.update( viewportId, params, true );
}

/**
 * Zoom the viewport to fit the specified rectangle. This will build a URL and
 * request a new image. After image has loaded, callback (if any) will be
 * called.
 *
 * @param viewportId The id of the outermost viewport HTMLElement [ REQUIRED ]
 * @param x The x value of the zoom rectangle       [ REQUIRED ]
 * @param y The y value of the zoom rectangle       [ REQUIRED ]
 * @param width The width of the zoom rectangle     [ REQUIRED ]
 * @param height The height of the zoom rectangle   [ REQUIRED ]
 */
function WImageViewport_zoom( viewportId, x, y, width, height )
{
    var viewport = document.getElementById( viewportId );

    var params = new Object();
    params['zX'] = ( viewport.worldX + x );
    params['zY'] = ( viewport.worldY + y );
    params['zW'] = width;
    params['zH'] = height;

    this.update( viewportId, params );
}

/**
 * Zoom the viewport by the specified delta. This will build a URL and
 * request a new image. After image has loaded, callback (if any) will be
 * called.
 *
 * @param viewportId The id of the outermost viewport HTMLElement [ REQUIRED ]
 * @param zoomLevelDelta The amount to change the current zoom level [ REQUIRED ]
 */
function WImageViewport_zoomBy( viewportId, zoomLevelDelta )
{
    var viewport = document.getElementById( viewportId );

    var viewRectangle = this.getViewRectangle( viewportId );
    var worldRectangle = this.getWorldRectangle( viewportId );

    var zoomLevel = this.getZoomLevel( viewportId );
    var newZoomLevel = zoomLevel + zoomLevelDelta;
    var isZoomable = ( newZoomLevel >= viewport.minZoomLevel && newZoomLevel <= viewport.maxZoomLevel &&
                       ( !viewRectangle.equals( worldRectangle ) ||
                         zoomLevelDelta < 0 ) );

    if ( isZoomable )
    {
        // set zoom level
        this.setZoomLevel( viewportId, newZoomLevel );

        var params = new Object();
        params['zoom'] = newZoomLevel;

        this.update( viewportId, params );
    }
}
