/*********************************************************** {COPYRIGHT-TOP} ***
* Licensed Materials - Property of IBM
* Tivoli Presentation Services
*
* (C) Copyright IBM Corp. 2000, 2006  All Rights Reserved.
*
* US Government Users Restricted Rights - Use, duplication, or
* disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
************************************************************ {COPYRIGHT-END} ***/

/**
 * @param secureURL URL pointing to content served using HTTPS. This URL will
 *        be used to set the src attribute of a transparent IFRAME that is used
 *        to fix bleeding of HTMLSelectElements through absolutely
 *        positioned HTMLElements in Internet Explorer. If using a secure
 *        server, this URL must be specified at the risk of experiencing
 *        "Secure/Non-Secure" warnings issued by the browser. The URL must
 *        be secure and from the same domain as the containing window/frame.
 */
function TimeChooser(id, textID, buttonID, pattern, isLTR, tabIndex, secureURL) {
    this.id = id;
    this.textID = textID;
    this.buttonID = buttonID;
    this.pattern = pattern;
    this.is24hr = pattern.indexOf('a') == -1;
    this.showSeconds = pattern.indexOf('s') != -1;
    this.isLTR = isLTR;
    this.tabIndex = tabIndex;
    this.secureURL = ( secureURL ? secureURL : null );
    this.title = null;
    this.layer = null;

    // stores text
    this.text = new Array();
    // stores style sheets
    this.styleSheets = new Array();
    // stores elements by id
    this.elementsById = new Array();

    //functions
    this.showTimeChooser = TimeChooser_show;
    this.hideTimeChooser = TimeChooser_hide;
    this.setText = TimeChooser_setText;
    this.getText = TimeChooser_getText;
    this.makeId = TimeChooser_makeId;
    this.getElementById = TimeChooser_getElementById;
    this.addStyleSheet = TimeChooser_addStyleSheet;
    this.createTimeDiv = TimeChooser_createTimeDiv;
    this.parseTime = TimeChooser_parseTime;
    this.formatNumber = TimeChooser_formatNumber;
}

function TimeChooser_makeId(id, element) {
    var eid = this.id + "_" + id;
    if (element != null) {
        this.elementsById[eid] = element;
    }
    return eid;
}

function TimeChooser_getElementById(id, aDoc) {
    if (aDoc != null)
        return aDoc.getElementById(id);
    else
        return document.getElementById(id);
}


function TimeChooser_setText(textKey, textObj) {
    this.text[textKey] = textObj;
}

function TimeChooser_getText(textKey) {
    var rText = this.text[textKey];
    if (rText == null) {
        rText = textKey;
    }
    return rText;
}

function TimeChooser_addStyleSheet(css) {
    this.styleSheets[this.styleSheets.length] = css;
}

function TimeChooser_hide() {
  if (this.layer != null)
    this.layer.setVisible(false);
}

function TimeChooser_show() {
   if (this.layer == null || !this.layer.isRendered()) {
      this.layer = WLayerFactory.createWLayer(this.id, self, false, true, false, this.secureURL );
      this.layer.setHTMLElement(this.createTimeDiv());
      this.layer.render();
   }
   else if (this.layer != null && this.layer.isVisible()) {
       this.hideTimeChooser();
       return;
   }

   var doc = null;
   // find textfield using buttonId since the textId isn't necessarily unique
   // the button and the text field are in the same TR but are separated by a spacer TD
   // the INPUT is the last item in the neighboring TD --
   // status indicator is the first item if there is no label text
   var tftd = this.getElementById(this.buttonID, doc).parentNode.previousSibling.previousSibling;
   var textfield = tftd.childNodes[tftd.childNodes.length-1];
   var timevalues = this.parseTime(textfield.value, this.pattern);
   var posX = WUtilities.getLeft(textfield, true);
   var posY = WUtilities.getTop(textfield, true) + WUtilities.getHeight(textfield, true);

   if (!this.isLTR)
       posX -= this.layer.getDimension().getWidth() - WUtilities.getWidth(textfield);

   this.getElementById(this.makeId("hours"), doc).value = timevalues[0];
   this.getElementById(this.makeId("minutes"), doc).value = timevalues[1];
   this.getElementById(this.makeId("seconds"), doc).value = timevalues[2];
   if (!this.is24hr) {
       var ampm = this.getElementById(this.makeId("ampm"), doc);
       ampm.selectedIndex = ampm.options[1].value.toUpperCase() == timevalues[3].toUpperCase() ? 1 : 0;
   }
   this.layer.setPosition(new Position(posX, posY));
   this.layer.setVisible(true);
   this.getElementById(this.makeId("hours"), doc).focus();

}

function TimeChooser_createTimeDiv() {
   var div = document.createElement("DIV");
   var hidden = document.createElement("INPUT");
   var table = document.createElement("TABLE");
   var thead = document.createElement("THEAD");
   var tbody = document.createElement("TBODY");
   var tfoot = document.createElement("TFOOT");
   var ctable = document.createElement("TABLE");
   var cbody = document.createElement("TBODY");
   var tr = document.createElement("TR");
   var td = document.createElement("TD");
   var nbsp = document.createElement("SPAN");
   var ok = document.createElement("INPUT");
   var cancel = document.createElement("INPUT");
   var hours = document.createElement("INPUT");
   var minutes = document.createElement("INPUT");
   var seconds = document.createElement("INPUT");
   var ampm = document.createElement("SELECT");
   var option = document.createElement("OPTION");

   div.id = this.makeId("timeDiv", div);
   // allow for dynamic sizing in Netscape and IE
   if ( !WClient.isBrowserMozilla() || WClient.isBrowserNetscape() )
   {
       div.style.width = "0%";
   }

   ok.type = "button";
   ok.value = this.getText("OK");
   ok.className="b1";
   //@pchin ok.onmouseover = TimeChooser_buttonOverHandler;
   //@pchin ok.onmouseout = TimeChooser_buttonOutHandler;
   ok.onclick = TimeChooser_buttonOkHandler;
   cancel.type = "button";
   cancel.value = this.getText("CANCEL");
   cancel.className="b1";
   //@pchin cancel.onmouseover = TimeChooser_buttonOverHandler;
   //@pchin cancel.onmouseout = TimeChooser_buttonOutHandler;
   cancel.onclick = TimeChooser_buttonCancelHandler;
   hours.type = "text";
   hours.size = 2;
   hours.maxLength = 2;
   hours.className="te1";
   hours.id = this.makeId("hours", hours);
   minutes.type = "text";
   minutes.size = 2;
   minutes.maxLength = 2;
   minutes.className="te1";
   minutes.id = this.makeId("minutes", minutes);
   seconds.type = this.showSeconds ? "text" : "hidden";
   seconds.size = "2";
   seconds.maxLength = 2;
   seconds.className="te1";
   seconds.id = this.makeId("seconds", seconds);
   ampm.className="cb1";
   ampm.id = this.makeId("ampm", ampm);

   option.innerHTML = this.getText("AM");
   option.value = this.getText("AM");
   ampm.appendChild(option);
   option = document.createElement("OPTION");
   option.innerHTML = this.getText("PM");
   option.value = this.getText("PM");
   ampm.appendChild(option);

   if (this.tabIndex != 0) {
       ok.tabIndex = this.tabIndex;
       cancel.tabIndex = this.tabIndex;
       hours.tabIndex = this.tabIndex;
       minutes.tabIndex = this.tabIndex;
       seconds.tabIndex = this.tabIndex;
       ampm.tabIndex = this.tabIndex;
   }

   hidden.type = "hidden";
   hidden.value = this.id;
   div.appendChild(hidden);

   table.border = 0;
   table.cellSpacing = 0;
   table.cellPadding = 0;
   table.dir = this.isLTR ? "LTR" : "RTL";
   table.className="tc4";
   nbsp.innerHTML = "&nbsp;";

   div.appendChild(table);
   table.appendChild(thead);


   ctable.border = 0;
   ctable.cellSpacing = 0;
   ctable.cellPadding = 0;
   ctable.dir = "LTR";
   ctable.className = "tc5";
   tr = document.createElement("TR");
   td = document.createElement("TD");
   td.className = "tc6";
   table.appendChild(thead);

   thead.appendChild(tr);
   tr.appendChild(td);


   td.appendChild(ctable);
   ctable.appendChild(cbody);
   tr = document.createElement("TR");
   td = document.createElement("TD");
   cbody.appendChild(tr);
   tr.appendChild(td);
   td.className="tc1";

   td.innerHTML = this.getText("HOURS");

   td = document.createElement("TD");
   tr.appendChild(td);
   td.innerHTML = this.getText("MINUTES");
   td.className="tc1";

   if (this.showSeconds) {
       td = document.createElement("TD");
       tr.appendChild(td);
       td.innerHTML = this.getText("SECONDS");
       td.className="tc1";
   }

   td = document.createElement("TD");
   tr.appendChild(td);
   td.innerHTML = "&nbsp;";
   td.className="tc1";

   tr = document.createElement("TR");
   td = document.createElement("TD");
   td.className="tc2";
   ctable.appendChild(tbody);
   tbody.appendChild(tr)
   tr.appendChild(td);
   td.appendChild(hours);

   td = document.createElement("TD");
   td.className="tc2";
   tr.appendChild(td);
   td.appendChild(minutes);

   if (this.showSeconds) {
       td = document.createElement("TD");
       td.className="tc2";
       tr.appendChild(td);
   }
   td.appendChild(seconds);

   td = document.createElement("TD");
   td.className="tc2";
   tr.appendChild(td);
   if (!this.is24hr)
       td.appendChild(ampm);
   else
       td.innerHTML = "&nbsp;";

   tr = document.createElement("TR");
   td = document.createElement("TD");
   td.className="tc3";
   table.appendChild(tfoot);
   tfoot.appendChild(tr);
   tr.appendChild(td);
   td.colSpan = this.showSeconds ? 4 : 3;
   td.alignment = "left";
   td.appendChild(ok);
   td.appendChild(nbsp);
   td.appendChild(cancel);

   return div;
}

function TimeChooser_parseTime( val, format )
{
  // Return values.
  var hh = "0";
  var mm = "0";
  var ss = "0";
  var ampm = "";

  // Vars for parsing
  var i = 0;
  var c = "";
  var token = "";
  var tokenNum = 0;

  if (val != null && val.length > 0)
  {
    // ensure the AM/PM string is separated from the hh:mm string
    var nlsAM = this.getText("AM")
    var nlsPM = this.getText("PM")
    val = val.replace(new RegExp(nlsAM), nlsAM + " ");
    val = val.replace(new RegExp(nlsPM), nlsPM + " ");

    // replace every non-word character with spaces
    val = val.replace(new RegExp("\\W", "g"), " ");

    // replace multiple whitespace characters with a single space
    val = val.replace(new RegExp("\\s+", "g"), " ");

    // split on whitespace
    var parms = val.split(" ");

    while ( i < format.length && tokenNum < parms.length )
    {
      // get next token from format string
      c = format.charAt( i );
      token = "";
      while ( ( format.charAt( i ) == c) && ( i < format.length ))
      {
        token += format.charAt( i++ );
      }

      if ( token == "hh" || token == "h" ||
           token == "HH" || token == "H" )
      {
        hh = this.formatNumber(parms[tokenNum++], 1);
      }
      else if ( token == "mm" || token == "m" )
      {
        mm = this.formatNumber(parms[tokenNum++], 1);
      }
      else if ( token == "ss" || token == "s" )
      {
        ss = this.formatNumber(parms[tokenNum++], 1);
      }
      else if ( token == "a" )
      {
        ampm = parms[tokenNum++];

        if (isNaN(parseInt(ampm)))
        {
          if ( ampm != null &&
               ampm.toUpperCase() != nlsAM &&
               ampm.toUpperCase() != nlsPM )
          {
            // Parsing error, set it to the default value
            ampm = nlsAM;
          }
        }
        else
        {
          // Don't consume numeric tokens for AM/PM,
          // chances are this wasn't the user's intent.
          tokenNum --;

          // Parsing error, set it to the default value
          ampm = nlsAM;
        }
      }
    }
    }

  return new Array( hh, mm, ss, ampm );
}

function TimeChooser_formatNumber(number, digits) {
   if (isNaN(parseInt(number, 10)))
      number = "0";
   while (number.length < digits)
      number = "0" + number;

   return number;
}

function TimeChooser_formatTime(timechooser, hours, minutes, seconds, ampm) {
   var format = timechooser.pattern;
   var time =  timechooser.pattern;
   var token = "";
   var i = 0;
   var c = "";
   var token = "";

   while (i < format.length)
   {
     // Grab consequetive characters and put them in a token
     c = format.charAt( i );
     token = "";
     while ( ( format.charAt(i) == c ) && ( i < format.length ) )
     {
       token += format.charAt( i++ );
     }

    if ( token == "hh" || token == "h" ||
         token == "HH" || token == "H" )
    {
      time = time.replace(new RegExp(token), timechooser.formatNumber(hours, token.length));
    }
    else if ( token == "mm" || token == "m" )
    {
      time = time.replace(new RegExp(token), timechooser.formatNumber(minutes, token.length));
    }
    else if ( token == "ss" || token == "s" )
    {
   if (timechooser.showSeconds)
      {
        time = time.replace(new RegExp(token), timechooser.formatNumber(seconds, token.length));
      }
    }
    else if ( token == "a" )
    {
   if (!timechooser.is24hr)
      {
        time = time.replace(new RegExp(token), ampm);
      }
    }
   }

   return time;
}

function TimeChooser_getTimeChooser(event) {
    var tc = null;
    var tag = getEventTarget(event);
    while (tag != null && tag.tagName != "DIV") {
        tag = tag.parentNode;
        if (tag != null && tag.tagName == "DIV") {
            tc = eval(tag.childNodes[0].value);
            break;
        }
    }
    return tc;
}

function TimeChooser_buttonOkHandler(event) {
    //@pchin TimeChooser_buttonOutHandler(event);

    var tc = TimeChooser_getTimeChooser(event);
    if (tc != null) {
        // gather time field values
        var doc = getEventTarget(event).ownerDocument;
        var hours = tc.getElementById(tc.makeId("hours"), doc).value;
        var minutes = tc.getElementById(tc.makeId("minutes"), doc).value;
        var seconds = tc.getElementById(tc.makeId("seconds"), doc ).value;
        var ampm = tc.is24hr ? "" : tc.getElementById(tc.makeId("ampm"), doc).value;

        // update the time text field - using buttonId since the textId isn't necessarily unique
        // the button and the text field are in the same TR but are separated by a spacer TD
        // the INPUT is the last item in the neighboring TD --
        // status indicator is the first item if there is no label text
        var tftd = tc.getElementById(tc.buttonID).parentNode.previousSibling.previousSibling;
        var timeInput = tftd.childNodes[tftd.childNodes.length-1];
        timeInput.value = TimeChooser_formatTime(tc, hours, minutes, seconds, ampm);

        // cancel the dialog
        TimeChooser_buttonCancelHandler(event);
    }
    else
       alert("TimeChooser_buttonOkHandler - null");
}


function TimeChooser_buttonCancelHandler(event) {
    //@pchin TimeChooser_buttonOutHandler(event);

    var tc = TimeChooser_getTimeChooser(event);
    if (tc != null) {
        tc.hideTimeChooser();

        // set focus on the time button
        var timeButton = tc.getElementById(tc.buttonID);
        timeButton.focus();
    }
    else
       alert("TimeChooser_buttonCancelHandler - null")
}

function TimeChooser_buttonOverHandler(event) {
    var tag = getEventTarget(event);
    if (tag != null) {
        tag.className = "b2";
        if (document.all)
            tag.style.height = "100%";
    }
}

function TimeChooser_buttonOutHandler( event ) {
    var tag = getEventTarget(event);
    if (tag != null) {
        tag.className = "b1";
        if (document.all)
            tag.style.height = "100%";
    }
}
