/* IBM_PROLOG_BEGIN_TAG                                                   */
/* This is an automatically generated prolog.                             */
/*                                                                        */
/*                                                                        */
/*                                                                        */
/* Licensed Materials - Property of IBM                                   */
/*                                                                        */
/* (C) COPYRIGHT International Business Machines Corp. 1998,2008          */
/* All Rights Reserved                                                    */
/*                                                                        */
/* US Government Users Restricted Rights - Use, duplication or            */
/* disclosure restricted by GSA ADP Schedule Contract with IBM Corp.      */
/*                                                                        */
/* IBM_PROLOG_END_TAG                                                     */
/*===========================================================================*/
/*                                                                           */
/* Module Name:  ct_rmc.h                                                    */
/*                                                                           */
/* Description:                                                              */
/*     Interface definitions common to the Resource Monitoring and Control   */
/*     API and the Resource Manager API.                                     */
/*                                                                           */
/*     This file is formatted to be viewed with tab stops set to 4.          */
/*===========================================================================*/
/* @(#)13   1.15   src/rsct/rmc/mccommon/ct_rmc.h, mccommon, rsct_rfos, rfos0838a 11/16/07 18:17:23 */

#ifndef _H_CT_RMC
#define _H_CT_RMC

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include <rsct/ct.h>

/*****************************************************************************/
/*                                                                           */
/*     Data types and enumerations common to the RMCAPI and the RMgrAPI      */
/*                                                                           */
/*****************************************************************************/

/* define a type for resource class ids -- this is only for compatibility */
typedef ct_resource_class_id_t rmc_resource_class_id_t;

/* define a type for attribute ids */
typedef ct_int32_t rmc_attribute_id_t;

/* define a type for action ids */
typedef ct_int32_t rmc_action_id_t;

/* define a type for error injection ids */
typedef ct_int32_t rmc_error_id_t;
        
/* enumeration of variable types (a variable is a dynamic attribute) */

typedef enum {
	RMC_COUNTER,
	RMC_QUANTITY,
	RMC_STATE,
    RMC_QUANTUM
} rmc_variable_type_t;

/* enumeration of the possible resource type */
typedef enum {
    RMC_TYPE_FIXED,
    RMC_TYPE_FLOATING,
    RMC_TYPE_CONCURRENT
} rmc_resource_type_t;

/* enumeration of resource category */
typedef enum {
    RMC_CATEGORY_MANAGED,
    RMC_CATEGORY_ALIAS,
    RMC_CATEGORY_NOCONTROL
} rmc_resource_category_t;

/* enumeration of the bit of a "ConfigChanged dynamic attribute */
typedef enum {
    RMC_CONFIG_CHG_NONE=0,
    RMC_CONFIG_CHG_ATTR=1,
    RMC_CONFIG_CHG_ACLS=2,
    RMC_CONFIG_CHG_CONSTRAINTS=4
} rmc_config_changed_t;
    
/* enumeration of the possible resource state */
   
typedef enum {
    RMC_OPSTATE_UNKNOWN=0,
    RMC_OPSTATE_ONLINE,
    RMC_OPSTATE_OFFLINE,
    RMC_OPSTATE_FAILED_OFFLINE,
    RMC_OPSTATE_STUCK_ONLINE,
    RMC_OPSTATE_PENDING_ONLINE,
    RMC_OPSTATE_PENDING_OFFLINE,
    RMC_OPSTATE_MIXED,
    RMC_OPSTATE_INELIGIBLE,
    RMF_OPSTATE_MASK=0x7f,
    RMC_OPSTATE_MANUAL_MODE=0x80,
    RMC_OPSTATE_ONLINE_MANUAL,
    RMC_OPSTATE_OFFLINE_MANUAL,
    RMC_OPSTATE_FAILED_OFFLINE_MANUAL,
    RMC_OPSTATE_STUCK_ONLINE_MANUAL,
    RMC_OPSTATE_PENDING_ONLINE_MANUAL,
    RMC_OPSTATE_PENDING_OFFLINE_MANUAL,
    RMC_OPSTATE_MIXED_MANUAL,
    RMC_OPSTATE_INELIGIBLE_MANUAL
} rmc_opstate_t;

/* enumeration of the possible move states */

typedef enum {
	RMC_MOVESTATE_NONE=0,
	RMC_MOVESTATE_PREPARE,
	RMC_MOVESTATE_READY,
	RMC_MOVESTATE_FAILED,
	RMC_MOVESTATE_ENDING
} rmc_movestate_t;

/* enumeration of the possible quorum states */

typedef enum {
	RMC_QUORUM_STATE_HAS=0,
	RMC_QUORUM_STATE_PENDING,
	RMC_QUORUM_STATE_NONE,
	RMC_QUORUM_STATE_UNKNOWN,
	RMC_QUORUM_STATE_NO_SUPPORT
} rmc_quorum_state_t;

/* HealthState - Indicate resource health; augments what is available
 *               via OpState.
 *
 * UNKNOWN       =  0 The resource is offline (OpState = 2).
 * OKAY          =  5 The resource is online with no problems (OpState = 1).
 * WARNING       = 10 Not used.
 * MINOR         = 15 In IBM.VolumeGroup, one or more of the IBM.Disk resources
 *                    making this VG has gone offline; the VG remains online,
 *                    though some of its FileSystems may be inaccessible. Not
 *                    used in other classes.
 * MAJOR         = 20 Not used.
 * CRITICAL      = 25 Not used.
 * FATAL         = 30 Equivalent to OpState=3, Failed Offline.
 * SYSTEMGONE    = 31 Not used.
 * NOTAPPLICABLE = 32 Not used.
 * IN_PROGRESS   = 33 An operation is currently in progress. The value is set
 *                    every five seconds while an online or offline operation
 *                    for this resource is in progress.
 */

typedef enum {
    RMC_HEALTHSTATE_UNKNOWN       = 0,
    RMC_HEALTHSTATE_OKAY          = 5,
    RMC_HEALTHSTATE_WARNING       = 10,
    RMC_HEALTHSTATE_MINOR         = 15,
    RMC_HEALTHSTATE_MAJOR         = 20,
    RMC_HEALTHSTATE_CRITICAL      = 25,
    RMC_HEALTHSTATE_FATAL         = 30,
    RMC_HEALTHSTATE_SYSTEMGONE    = 31,
    RMC_HEALTHSTATE_NOTAPPLICABLE = 32,
    RMC_HEALTHSTATE_IN_PROGRESS   = 33
} rmc_healthstate_t;

/* enumeration of constraint types.  */

typedef enum {
	RMC_CONST_HARD_DEPENDS_ON   = 0,
	RMC_CONST_SOFT_DEPENDS_ON,
	RMC_CONST_HARD_DEPENDS_ON_COLOCATED,
	RMC_CONST_SOFT_DEPENDS_ON_COLOCATED
} rmc_constraint_type_t;

/* enumeration of equivalency policies */
typedef enum {
    RMC_EQU_DEFAULT_POLICY = 0,
    RMC_EQU_PREFERRED_HOME_POLICY
} rmc_equivalency_policy_t;

/* enumeration of equivalency qualifiers */
typedef enum {
    RMC_EQU_AUTO_RETURN_HOME=1,
    RMC_EQU_SERIAL=2
} rmc_equivalency_modifiers_t;

/* define a type to hold information about a constraint */
    
typedef struct {
	ct_int32_t				     constraint_id;
    ct_resource_handle_t         constraint_handle;
    rmc_constraint_type_t        type;
    ct_resource_handle_t         cur_resource;
    rmc_equivalency_policy_t     equ_policy;
    rmc_equivalency_modifiers_t  equ_modifiers;
    ct_uint32_t                  sup_rsrc_count;
    ct_resource_handle_t         sup_rsrc_list[1];    
} rmc_constraint_t;

/* define a type for the parameter on ConstraintAdvisory() to contain failing and
   alternate resource specifications. */

typedef struct {
    ct_int32_t           constraint_id;
    ct_resource_handle_t affected_resource;
    ct_resource_handle_t replacement_resource;
} rmc_constraint_alternate_resource_t;

/* define a type for the parameter to Online() that requires a resolved constraint */
typedef struct {
    ct_int32_t           constraint_id;
    ct_resource_handle_t resource_handle;
} rmc_constraint_resolved_t;
    
/* enumeration of Integrity Check types */

typedef enum {
	RMC_QUICK_INTEGRITY_CHECK = 0,
	RMC_THOROUGH_INTEGRITY_CHECK
} rmc_integrity_check_type_t;

/* enumeration of severity levels in Integrity Check Response */

typedef enum {
	RMC_SEVERITY_INFORMATION,
	RMC_SEVERITY_WARNING,
	RMC_SEVERITY_ERROR
} rmc_severity_t;

/* enumeration of resource manager control log entry types */

typedef enum {
	RMC_CTRL_LOG_ONLINE_REQUEST = 0,
	RMC_CTRL_LOG_OFFLINE_REQUEST,
	RMC_CTRL_LOG_CONSTRAINT_ADV_REQUEST,
	RMC_CTRL_LOG_TRANSITION_ONLINE,
	RMC_CTRL_LOG_TRANSITION_ONLINE_PENDING,
	RMC_CTRL_LOG_TRANSITION_OFFLINE_PENDING,
	RMC_CTRL_LOG_TRANSITION_OFFLINE,
	RMC_CTRL_LOG_TRANSITION_FAILED_OFFLINE,
	RMC_CTRL_LOG_TRANSITION_FAILED_ONLINE
} rmc_log_entry_type_t;

/* name of directory where RMC resource mamnager instances execute; place
 * where core files are produced. The first %s is the cluster id; the second
 * %s is the resource manager name.
 */
#define RMC_RM_RUN_DIR_FMT     "/var/ct/%s/run/mc/%s"

/* name of directory where RMC resource mananger log files are placed.
 * The first %s is the cluster id; the second is the resource manager name.
 */
#define RMC_RM_LOG_DIR_FMT     "/var/ct/%s/log/mc/%s"

#ifdef __cplusplus
} // end extern "C"
#endif /* __cplusplus */

#endif	/* _H_CT_RMC */
