# IBM_PROLOG_BEGIN_TAG 
# This is an automatically generated prolog. 
#  
#  
#  
# Licensed Materials - Property of IBM 
#  
# (C) COPYRIGHT International Business Machines Corp. 2004,2008 
# All Rights Reserved 
#  
# US Government Users Restricted Rights - Use, duplication or 
# disclosure restricted by GSA ADP Schedule Contract with IBM Corp. 
#  
# IBM_PROLOG_END_TAG 
package LPRM_cli_rc;
#"@(#)64   1.1   src/rsct/rm/LPRM/cli/pm/LPRM_cli_rc.pm.perl, LPRM, rsct_rfos, rfos0838a 1/18/05 04:31:55"
######################################################################
#                                                                    #
# Package: LCRM_cli_rc.pm                                            #
#                                                                    #
# Description:                                                       #
#   This package contains return codes used for the LPRM CLI         #
#   commands. Each return code can be referenced separately, or as   #
#   a whole using the 'return_codes' EXPORT_TAG.                     #
#                                                                    #
# Examples:                                                          #
#   use LPRM_cli_rc qw(LPRM_CLI_BAD_OPERAND LPRM_CLI_BAD_FLAG)       #
#   - exports only 2 of the return codes for use in the calling      #
#     program.                                                       #
#                                                                    #
#   use LPRM_cli_rc qw(:return_codes)                                #
#   - exports all return codes included in the EXPORT_TAG            #
#     return_codes. (the ':' is needed to access the tag)            #
#                                                                    #
#--------------------------------------------------------------------#
#                                                                    #
# Inputs:                                                            #
#                                                                    #
# Outputs:                                                           #
#                                                                    #
# External References:                                               #
#   Perl Modules:   constant, Exporter                               #
#                                                                    #
# Tab Settings:                                                      #
#   4 and tabs should be expanded to spaces before saving this file. #
#   in vi:  (:set ts=4  and   :%!expand -4)                          #
#                                                                    #
# Change Activity:                                                   #
#   041222 JAC 112254: Initial design and write.                     #
######################################################################

use Exporter ();
use constant;
@ISA = qw(Exporter);
@EXPORT_OK = qw(    LPRM_CLI_SUCCESS
                    LPRM_CLI_RMC_ERROR
                    LPRM_CLI_ERROR
                    LPRM_CLI_BAD_FLAG
                    LPRM_CLI_BAD_OPERAND
                    LPRM_CLI_USER_ERROR
                    LPRM_CLI_NOT_FOUND
);


#--------------------------------------------------------------------#
# EXPORT TAGS is used to refer to the return codes as a group        #
#--------------------------------------------------------------------#

%EXPORT_TAGS = (
return_codes => [qw(LPRM_CLI_SUCCESS
                    LPRM_CLI_RMC_ERROR
                    LPRM_CLI_ERROR
                    LPRM_CLI_BAD_FLAG
                    LPRM_CLI_BAD_OPERAND
                    LPRM_CLI_USER_ERROR
                    LPRM_CLI_NOT_FOUND
)]
); # end %EXPORT_TAGS


#--------------------------------------------------------------------#
# Return Code Definitions (constants)                                #
#--------------------------------------------------------------------#

use constant LPRM_CLI_SUCCESS           => 0;
use constant LPRM_CLI_RMC_ERROR         => 1;
use constant LPRM_CLI_ERROR             => 2;
use constant LPRM_CLI_BAD_FLAG          => 3;
use constant LPRM_CLI_BAD_OPERAND       => 4;
use constant LPRM_CLI_USER_ERROR        => 5;
use constant LPRM_CLI_NOT_FOUND         => 6;
